/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.util.HashMap;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.IOHandlerData;

class RequestCache {
    private HashMap<Integer, CacheNode> mIdMap = new HashMap();
    private CacheNode mHead;
    private CacheNode mTail;

    RequestCache() {
    }

    public synchronized void Insert(int id, IOHandlerData handler, DispatchHandler dh, long expire) {
        CacheNode node = new CacheNode();
        node.id = id;
        node.handler = handler;
        node.dh = dh;
        node.expire = expire;
        if (this.mHead == null) {
            node.prev = null;
            node.next = null;
            this.mHead = this.mTail = node;
        } else {
            node.next = this.mTail;
            node.next.prev = node;
            node.prev = null;
            this.mTail = node;
        }
        this.mIdMap.put(id, node);
    }

    public synchronized CacheNode Remove(int id) {
        CacheNode node = this.mIdMap.remove(id);
        if (node == null) {
            return null;
        }
        if (node.prev == null) {
            this.mTail = node.next;
        } else {
            node.prev.next = node.next;
        }
        if (node.next == null) {
            this.mHead = node.prev;
        } else {
            node.next.prev = node.prev;
        }
        if (node.handler != null) {
            return node;
        }
        return null;
    }

    public synchronized CacheNode GetNextTimeout(long now) {
        while (this.mHead != null && this.mHead.expire < now) {
            CacheNode node = this.mIdMap.remove(this.mHead.id);
            if (node != this.mHead) {
                throw new AssertionError((Object)"node != mHead");
            }
            node = this.mHead;
            if (this.mHead.prev != null) {
                this.mHead = this.mHead.prev;
                this.mHead.next = null;
            } else {
                this.mTail = null;
                this.mHead = null;
            }
            if (node.handler == null) continue;
            return node;
        }
        return null;
    }

    public synchronized void PurgeRequests(IOHandlerData handler) {
        CacheNode node = this.mTail;
        while (node != null) {
            if (node.handler == handler) {
                node.handler = null;
            }
            node = node.next;
        }
    }

    public static class CacheNode {
        CacheNode prev;
        CacheNode next;
        long expire;
        int id;
        IOHandlerData handler;
        DispatchHandler dh;
    }
}

