/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.hypertable.AsyncComm.ConnectionHandlerFactory;
import org.hypertable.AsyncComm.ConnectionMap;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.IOHandler;
import org.hypertable.AsyncComm.IOHandlerData;

class IOHandlerAccept
extends IOHandler {
    private ServerSocketChannel mServerSocketChannel;
    private ConnectionHandlerFactory mHandlerFactory;

    public IOHandlerAccept(ServerSocketChannel chan, DispatchHandler dh, ConnectionMap cm, ConnectionHandlerFactory chf) {
        super(chan, dh, cm);
        this.mServerSocketChannel = chan;
        this.mHandlerFactory = chf;
    }

    @Override
    public void run(SelectionKey selkey) {
        try {
            if (selkey.isAcceptable()) {
                SocketChannel newChannel = this.mServerSocketChannel.accept();
                newChannel.configureBlocking(false);
                IOHandlerData handler = new IOHandlerData(newChannel, this.mHandlerFactory.newInstance(), this.mConnMap);
                Socket socket = newChannel.socket();
                InetSocketAddress addr = new InetSocketAddress(socket.getInetAddress(), socket.getPort());
                handler.SetRemoteAddress(addr);
                handler.SetInterest(1);
                this.mConnMap.Put(addr, handler);
                this.DeliverEvent(new Event(Event.Type.CONNECTION_ESTABLISHED, addr, 0));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

