/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.Event;
import org.hypertable.Common.Error;

public class ConnectionManager
implements Runnable,
DispatchHandler {
    static final Logger log = Logger.getLogger("org.hypertable.AsyncComm");
    private Comm mComm;
    private HashMap<InetSocketAddress, ConnectionState> mConnMap;
    private PriorityQueue<ConnectionState> mRetryQueue;
    private boolean mQuietMode = false;
    private Thread mThread;

    public ConnectionManager(Comm comm) {
        this.mComm = comm;
        this.mConnMap = new HashMap();
        this.mRetryQueue = new PriorityQueue<ConnectionState>(11, new ConnectionStateComparator());
        this.mThread = new Thread((Runnable)this, "Connection Manager");
        this.mThread.start();
    }

    public synchronized void Add(InetSocketAddress addr, long timeout, String serviceName) {
        if (this.mConnMap.containsKey(addr)) {
            return;
        }
        ConnectionState connState = new ConnectionState();
        connState.connected = false;
        connState.addr = addr;
        connState.timeout = timeout * 1000L;
        connState.serviceName = serviceName;
        connState.nextRetry = System.currentTimeMillis();
        this.mConnMap.put(addr, connState);
        this.SendConnectRequest(connState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SendConnectRequest(ConnectionState connState) {
        int error = this.mComm.Connect(connState.addr, connState.timeout, this);
        if (error == 65540) {
            ConnectionState connectionState = connState;
            synchronized (connectionState) {
                connState.connected = true;
                connState.notifyAll();
            }
        } else if (error != 0) {
            log.severe("Connection attempt to " + connState.serviceName + " at " + connState.addr + " failed - " + Error.GetText(error) + ".  Will retry again in %d seconds...");
            connState.nextRetry = System.currentTimeMillis() + connState.timeout;
            this.mRetryQueue.add(connState);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Event event) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            ConnectionState connState = this.mConnMap.get(event.addr);
            if (connState != null) {
                ConnectionState connectionState = connState;
                synchronized (connectionState) {
                    if (event.type == Event.Type.CONNECTION_ESTABLISHED) {
                        connState.connected = true;
                        connState.notifyAll();
                    } else {
                        if (!this.mQuietMode) {
                            log.info(event.toString() + "; will retry in " + connState.timeout / 1000L + " seconds...");
                        }
                        connState.connected = false;
                        connState.nextRetry = System.currentTimeMillis() + connState.timeout;
                        this.mRetryQueue.add(connState);
                        this.notify();
                    }
                }
            } else {
                log.severe("Unable to find connection for " + event.addr + " in map.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            while (!Thread.interrupted()) {
                try {
                    while (this.mRetryQueue.isEmpty()) {
                        this.wait();
                    }
                    ConnectionState connState = this.mRetryQueue.peek();
                    if (!connState.connected) {
                        ConnectionState connectionState = connState;
                        synchronized (connectionState) {
                            long diffTime = connState.nextRetry - System.currentTimeMillis();
                            if (diffTime <= 0L) {
                                this.mRetryQueue.remove(connState);
                                this.SendConnectRequest(connState);
                            } else {
                                this.wait(diffTime);
                            }
                            continue;
                        }
                    }
                    this.mRetryQueue.remove(connState);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean WaitForConnection(InetSocketAddress addr, long maxWaitSecs) throws InterruptedException {
        ConnectionState connState;
        Object object = this;
        synchronized (object) {
            connState = this.mConnMap.get(addr);
        }
        object = connState;
        synchronized (object) {
            long elapsed = 0L;
            long starttime = System.currentTimeMillis();
            long maxWaitMs = maxWaitSecs * 1000L;
            try {
                while (!connState.connected) {
                    elapsed = System.currentTimeMillis() - starttime;
                    if (elapsed >= maxWaitMs) {
                        return false;
                    }
                    connState.wait(maxWaitMs - elapsed);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static class ConnectionStateComparator
    implements Comparator<ConnectionState> {
        private ConnectionStateComparator() {
        }

        @Override
        public int compare(ConnectionState cs1, ConnectionState cs2) {
            if (cs1.nextRetry < cs2.nextRetry) {
                return 1;
            }
            if (cs1.nextRetry == cs2.nextRetry) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean equals(Object obj) {
            return this.equals(obj);
        }
    }

    private static class ConnectionState {
        public boolean connected;
        public InetSocketAddress addr;
        public long timeout;
        public long nextRetry;
        public String serviceName;

        private ConnectionState() {
        }
    }
}

