/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.io.File;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.logging.Logger;
import junit.framework.JUnit4TestAdapter;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.CommTestThreadFunction;
import org.hypertable.AsyncComm.ConnectionManager;
import org.hypertable.AsyncComm.ReactorFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class CommTest {
    static final Logger log = Logger.getLogger("org.hypertable.AsyncComm.CommTest");
    static final int DEFAULT_PORT = 32998;
    static final String DEFAULT_PORT_ARG = "--port=32998";
    private Comm mComm;
    private ConnectionManager mConnectionManager;
    private ServerLauncher slauncher;
    private InetSocketAddress mAddr;
    protected static boolean msShutdown = false;
    Thread mThread1;
    Thread mThread2;

    @Before
    public void setUp() {
        try {
            ReactorFactory.Initialize((short)1);
            this.slauncher = new ServerLauncher();
            this.mAddr = new InetSocketAddress("localhost", 32998);
            this.mComm = new Comm(0);
            this.mConnectionManager = new ConnectionManager(this.mComm);
            this.mConnectionManager.Add(this.mAddr, 5L, "SampleServer");
            if (!this.mConnectionManager.WaitForConnection(this.mAddr, 30L)) {
                log.fine("Connect error");
                msShutdown = true;
                return;
            }
            new File("/tmp/CommTest.output.1").delete();
            new File("/tmp/CommTest.output.2").delete();
            CommTestThreadFunction threadFunc1 = new CommTestThreadFunction(this.mComm, this.mAddr, "/usr/share/dict/words");
            threadFunc1.SetOutputFile("/tmp/CommTest.output.1");
            this.mThread1 = new Thread((Runnable)threadFunc1, "CommTest thread 1");
            this.mThread1.start();
            CommTestThreadFunction threadFunc2 = new CommTestThreadFunction(this.mComm, this.mAddr, "/usr/share/dict/words");
            threadFunc2.SetOutputFile("/tmp/CommTest.output.2");
            this.mThread2 = new Thread((Runnable)threadFunc2, "CommTest thread 2");
            this.mThread2.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            msShutdown = true;
        }
    }

    @Test
    public void testComm() {
        if (msShutdown) {
            Assert.assertTrue((boolean)false);
        }
        try {
            int nread;
            this.mThread1.join();
            this.mThread2.join();
            byte[] buf = new byte[128];
            boolean rval = false;
            ProcessBuilder pbuilder = new ProcessBuilder("diff", "/usr/share/dict/words", "/tmp/CommTest.output.1");
            pbuilder.redirectErrorStream(true);
            Process proc = pbuilder.start();
            InputStream istream = proc.getInputStream();
            while ((nread = istream.read(buf)) > 0) {
                System.out.print(new String(buf, 0, nread));
            }
            Assert.assertTrue((proc.waitFor() == 0 ? 1 : 0) != 0);
            pbuilder = new ProcessBuilder("diff", "/tmp/CommTest.output.1", "/tmp/CommTest.output.2");
            pbuilder.redirectErrorStream(true);
            proc = pbuilder.start();
            istream = proc.getInputStream();
            while ((nread = istream.read(buf)) > 0) {
                System.out.print(new String(buf, 0, nread));
            }
            Assert.assertTrue((proc.waitFor() == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @After
    public void tearDown() {
        this.slauncher.Kill();
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(CommTest.class);
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{"org.hypertable.AsyncComm.CommTest"});
    }

    private static class ServerLauncher {
        private Process mProc;
        private Thread mOutputRedirectorThread;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServerLauncher() {
            try {
                Integer intObj;
                ProcessBuilder pbuilder = new ProcessBuilder("java", "-classpath", System.getProperty("java.class.path"), "org.hypertable.AsyncComm.SampleServer", CommTest.DEFAULT_PORT_ARG);
                pbuilder.redirectErrorStream(true);
                this.mProc = pbuilder.start();
                Integer n = intObj = new Integer(0);
                synchronized (n) {
                    intObj.wait(2000L);
                }
                this.mOutputRedirectorThread = new Thread((Runnable)new OutputRedirector(this.mProc), "CommTest Output Redirector");
                this.mOutputRedirectorThread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                msShutdown = true;
            }
        }

        public void Kill() {
            this.mProc.destroy();
        }

        private static class OutputRedirector
        implements Runnable {
            private Process mProc;

            public OutputRedirector(Process proc) {
                this.mProc = proc;
            }

            @Override
            public void run() {
                byte[] buf = new byte[128];
                int rval = 0;
                InputStream istream = this.mProc.getInputStream();
                try {
                    int nread;
                    while ((nread = istream.read(buf)) > 0) {
                        System.out.print(new String(buf, 0, nread));
                    }
                    rval = this.mProc.waitFor();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

