/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.nio.ByteBuffer;
import org.hypertable.Common.Checksum;
import org.hypertable.Common.HypertableException;

public class CommHeader {
    public static byte VERSION = 1;
    public static byte FIXED_LENGTH = (byte)38;
    public static short FLAGS_BIT_REQUEST = 1;
    public static short FLAGS_BIT_IGNORE_RESPONSE = (short)2;
    public static short FLAGS_BIT_URGENT = (short)4;
    public static short FLAGS_BIT_PAYLOAD_CHECKSUM = Short.MIN_VALUE;
    public static short FLAGS_MASK_REQUEST = (short)-2;
    public static short FLAGS_MASK_IGNORE_RESPONSE = (short)-3;
    public static short FLAGS_MASK_URGENT = (short)-5;
    public static short FLAGS_MASK_PAYLOAD_CHECKSUM = Short.MAX_VALUE;
    public byte version = VERSION;
    public byte header_len = FIXED_LENGTH;
    public short alignment;
    public short flags;
    public int header_checksum;
    public int id;
    public int gid;
    public int total_len;
    public int timeout_ms;
    public int payload_checksum;
    public long command;

    public CommHeader() {
    }

    public CommHeader(long cmd, int timeout) {
        this.command = cmd;
        this.timeout_ms = timeout;
    }

    public CommHeader(long cmd) {
        this.command = cmd;
    }

    public int fixed_length() {
        return FIXED_LENGTH;
    }

    public int encoded_length() {
        return FIXED_LENGTH;
    }

    public void encode(ByteBuffer buf) {
        int saved_position = buf.position();
        buf.put(this.version);
        buf.put(this.header_len);
        buf.putShort(this.alignment);
        buf.putShort(this.flags);
        int checksum_position = buf.position();
        buf.putInt(0);
        buf.putInt(this.id);
        buf.putInt(this.gid);
        buf.putInt(this.total_len);
        buf.putInt(this.timeout_ms);
        buf.putInt(this.payload_checksum);
        buf.putLong(this.command);
        int header_length = buf.position() - saved_position;
        byte[] header_buffer = new byte[header_length];
        buf.position(saved_position);
        buf.get(header_buffer, 0, header_length);
        this.header_checksum = Checksum.fletcher32(header_buffer, 0, header_length);
        buf.position(checksum_position);
        buf.putInt(this.header_checksum);
        buf.position(saved_position + header_length);
    }

    public void decode(ByteBuffer buf) throws HypertableException {
        int saved_position = buf.position();
        this.version = buf.get();
        this.header_len = buf.get();
        this.alignment = buf.getShort();
        this.flags = buf.getShort();
        buf.mark();
        this.header_checksum = buf.getInt();
        this.id = buf.getInt();
        this.gid = buf.getInt();
        this.total_len = buf.getInt();
        this.timeout_ms = buf.getInt();
        this.payload_checksum = buf.getInt();
        this.command = buf.getLong();
        int header_length = buf.position() - saved_position;
        buf.reset();
        buf.putInt(0);
        byte[] header_buffer = new byte[header_length];
        buf.position(saved_position);
        buf.get(header_buffer, 0, header_length);
        int computed_checksum = Checksum.fletcher32(header_buffer, 0, header_length);
        if (computed_checksum != this.header_checksum) {
            throw new HypertableException(65549);
        }
        buf.position(saved_position + header_length);
    }

    public void set_total_length(int len) {
        this.total_len = len;
    }

    public void initialize_from_request_header(CommHeader req_header) {
        this.flags = req_header.flags;
        this.id = req_header.id;
        this.gid = req_header.gid;
        this.command = req_header.command;
        this.total_len = 0;
    }
}

