/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.AsyncComm;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.hypertable.AsyncComm.CommHeader;
import org.hypertable.AsyncComm.Serialization;

public class CommBuf {
    public ByteBuffer data;
    public ByteBuffer ext;
    public CommHeader header;

    public CommBuf(CommHeader hdr, int len) {
        this.header = hdr;
        this.data = ByteBuffer.allocate(len += this.header.encoded_length());
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.header.set_total_length(len);
        this.data.position(this.header.encoded_length());
    }

    public CommBuf(CommHeader hdr, int len, ByteBuffer buffer) {
        this.header = hdr;
        this.ext = buffer;
        this.data = ByteBuffer.allocate(len += this.header.encoded_length());
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        if (this.ext.position() > 0) {
            this.ext.flip();
        }
        this.header.set_total_length(len + this.ext.remaining());
        this.data.position(this.header.encoded_length());
    }

    public CommBuf(CommHeader hdr, int len, byte[] ext_bytes, int ext_len) {
        this.header = hdr;
        this.data = ByteBuffer.allocate(len += this.header.encoded_length());
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.ext = ByteBuffer.wrap(ext_bytes, 0, ext_len);
        this.header.set_total_length(len + ext_len);
        this.data.position(this.header.encoded_length());
    }

    void write_header_and_reset() {
        assert (!this.data.hasRemaining());
        this.data.position(0);
        this.header.encode(this.data);
        this.data.position(0);
    }

    public void AppendBool(boolean bval) {
        this.data.put(bval ? (byte)1 : 0);
    }

    public void AppendByte(byte bval) {
        this.data.put(bval);
    }

    public void AppendBytes(ByteBuffer buf) {
        this.data.put(buf);
    }

    public void AppendShort(short sval) {
        this.data.putShort(sval);
    }

    public void AppendInt(int ival) {
        this.data.putInt(ival);
    }

    public void AppendLong(long lval) {
        this.data.putLong(lval);
    }

    public void AppendByteArray(byte[] bytes, int len) {
        Serialization.EncodeByteArray(this.data, bytes, len);
    }

    public void AppendString(String str) {
        Serialization.EncodeString(this.data, str);
    }
}

