/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.ByteArrayByteIterator;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.db.ZKProducerConsumer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.CleanUp;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;

public class AccumuloClient
extends DB {
    public static final int Ok = 0;
    public static final int ServerError = -1;
    public static final int HttpError = -2;
    public static final int NoMatchingRecord = -3;
    private ZooKeeperInstance _inst;
    private Connector _connector;
    private String _table = "";
    private BatchWriter _bw = null;
    private Text _colFam = new Text("");
    private Scanner _singleScanner = null;
    private Scanner _scanScanner = null;
    private static final String PC_PRODUCER = "producer";
    private static final String PC_CONSUMER = "consumer";
    private String _PC_FLAG = "";
    private ZKProducerConsumer.Queue q = null;
    private static Hashtable<String, Long> hmKeyReads = null;
    private static Hashtable<String, Integer> hmKeyNumReads = null;
    private Random r = null;

    public void init() throws DBException {
        this._colFam = new Text(this.getProperties().getProperty("accumulo.columnFamily"));
        this._inst = new ZooKeeperInstance(this.getProperties().getProperty("accumulo.instanceName"), this.getProperties().getProperty("accumulo.zooKeepers"));
        try {
            String principal = this.getProperties().getProperty("accumulo.username");
            PasswordToken token = new PasswordToken((CharSequence)this.getProperties().getProperty("accumulo.password"));
            this._connector = this._inst.getConnector(principal, (AuthenticationToken)token);
        }
        catch (AccumuloException e) {
            throw new DBException((Throwable)e);
        }
        catch (AccumuloSecurityException e) {
            throw new DBException((Throwable)e);
        }
        this._PC_FLAG = this.getProperties().getProperty("accumulo.PC_FLAG", "none");
        if (this._PC_FLAG.equals(PC_PRODUCER) || this._PC_FLAG.equals(PC_CONSUMER)) {
            System.out.println("*** YCSB Client is " + this._PC_FLAG);
            String address = this.getProperties().getProperty("accumulo.PC_SERVER");
            String root = this.getProperties().getProperty("accumulo.PC_ROOT_IN_ZK");
            System.out.println("*** PC_INFO(server:" + address + ";root=" + root + ")");
            this.q = new ZKProducerConsumer.Queue(address, root);
            this.r = new Random();
        }
        if (this._PC_FLAG.equals(PC_CONSUMER)) {
            hmKeyReads = new Hashtable();
            hmKeyNumReads = new Hashtable();
            this.keyNotification(null);
        }
    }

    public void cleanup() throws DBException {
        try {
            if (this._bw != null) {
                this._bw.close();
            }
        }
        catch (MutationsRejectedException e) {
            throw new DBException((Throwable)e);
        }
        CleanUp.shutdownNow();
    }

    public void checkTable(String table) throws TableNotFoundException {
        if (!this._table.equals(table)) {
            this.getTable(table);
        }
    }

    public void getTable(String table) throws TableNotFoundException {
        if (this._bw != null) {
            try {
                this._bw.close();
            }
            catch (MutationsRejectedException e) {
                // empty catch block
            }
        }
        BatchWriterConfig bwc = new BatchWriterConfig();
        bwc.setMaxLatency(Long.parseLong(this.getProperties().getProperty("accumulo.batchWriterMaxLatency", "30000")), TimeUnit.MILLISECONDS);
        bwc.setMaxMemory(Long.parseLong(this.getProperties().getProperty("accumulo.batchWriterSize", "100000")));
        bwc.setMaxWriteThreads(Integer.parseInt(this.getProperties().getProperty("accumulo.batchWriterThreads", "1")));
        this._bw = this._connector.createBatchWriter(table, bwc);
        this._singleScanner = this._connector.createScanner(table, Authorizations.EMPTY);
        this._scanScanner = this._connector.createScanner(table, Authorizations.EMPTY);
        this._table = table;
    }

    private Scanner getRow(Text row, Set<String> fields) {
        this._singleScanner.clearColumns();
        this._singleScanner.setRange(new Range(row));
        if (fields != null) {
            for (String field : fields) {
                this._singleScanner.fetchColumn(this._colFam, new Text(field));
            }
        }
        return this._singleScanner;
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        try {
            this.checkTable(table);
        }
        catch (TableNotFoundException e) {
            System.err.println("Error trying to connect to Accumulo table." + (Object)((Object)e));
            return -1;
        }
        try {
            for (Map.Entry entry : this.getRow(new Text(key), null)) {
                Value v = (Value)entry.getValue();
                byte[] buf = v.get();
                result.put(((Key)entry.getKey()).getColumnQualifier().toString(), (ByteIterator)new ByteArrayByteIterator(buf));
            }
        }
        catch (Exception e) {
            System.err.println("Error trying to reading Accumulo table" + key + e);
            return -1;
        }
        return 0;
    }

    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        try {
            this.checkTable(table);
        }
        catch (TableNotFoundException e) {
            System.err.println("Error trying to connect to Accumulo table." + (Object)((Object)e));
            return -1;
        }
        this._scanScanner.clearColumns();
        this._scanScanner.setRange(new Range(new Text(startkey), null));
        if (fields != null) {
            for (String field : fields) {
                this._scanScanner.fetchColumn(this._colFam, new Text(field));
            }
        }
        String rowKey = "";
        HashMap<String, Object> currentHM = null;
        int count = 0;
        for (Map.Entry entry : this._scanScanner) {
            if (!rowKey.equals(((Key)entry.getKey()).getRow().toString())) {
                if (count++ == recordcount) break;
                rowKey = ((Key)entry.getKey()).getRow().toString();
                currentHM = fields != null ? new HashMap(fields.size()) : new HashMap<String, ByteArrayByteIterator>();
                result.add(currentHM);
            }
            Value v = (Value)entry.getValue();
            byte[] buf = v.get();
            currentHM.put(((Key)entry.getKey()).getColumnQualifier().toString(), new ByteArrayByteIterator(buf));
        }
        return 0;
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        try {
            this.checkTable(table);
        }
        catch (TableNotFoundException e) {
            System.err.println("Error trying to connect to Accumulo table." + (Object)((Object)e));
            return -1;
        }
        Mutation mutInsert = new Mutation(new Text(key));
        for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
            mutInsert.put(this._colFam, new Text(entry.getKey()), System.currentTimeMillis(), new Value(entry.getValue().toArray()));
        }
        try {
            this._bw.addMutation(mutInsert);
            if (this._PC_FLAG.equals(PC_PRODUCER) && (double)this.r.nextFloat() < 0.01) {
                this.keyNotification(key);
            }
        }
        catch (MutationsRejectedException e) {
            System.err.println("Error performing update.");
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        return this.update(table, key, values);
    }

    public int delete(String table, String key) {
        try {
            this.checkTable(table);
        }
        catch (TableNotFoundException e) {
            System.err.println("Error trying to connect to Accumulo table." + (Object)((Object)e));
            return -1;
        }
        try {
            this.deleteRow(new Text(key));
        }
        catch (RuntimeException e) {
            System.err.println("Error performing delete.");
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private void deleteRow(Text row) {
        this.deleteRow(this.getRow(row, null));
    }

    private void deleteRow(Scanner scanner) {
        Mutation deleter = null;
        for (Map.Entry entry : scanner) {
            if (deleter == null) {
                deleter = new Mutation(((Key)entry.getKey()).getRow());
            }
            deleter.putDelete(((Key)entry.getKey()).getColumnFamily(), ((Key)entry.getKey()).getColumnQualifier());
        }
        try {
            this._bw.addMutation(deleter);
        }
        catch (MutationsRejectedException e) {
            e.printStackTrace();
        }
    }

    private void keyNotification(String key) {
        if (this._PC_FLAG.equals(PC_PRODUCER)) {
            try {
                this.q.produce(key);
            }
            catch (KeeperException e) {
            }
            catch (InterruptedException e) {}
        } else {
            for (int i = 0; i < 10000000; ++i) {
                try {
                    String strKey = this.q.consume();
                    if (!hmKeyReads.containsKey(strKey) && !hmKeyNumReads.containsKey(strKey)) {
                        hmKeyReads.put(strKey, new Long(System.currentTimeMillis()));
                        hmKeyNumReads.put(strKey, new Integer(1));
                    }
                    String table = "usertable";
                    HashSet<String> fields = new HashSet<String>();
                    for (int j = 0; j < 9; ++j) {
                        fields.add("field" + j);
                    }
                    HashMap<String, ByteIterator> result = new HashMap<String, ByteIterator>();
                    int retval = this.read(table, strKey, fields, result);
                    if (result.size() == 0) {
                        this.q.produce(strKey);
                        int count = hmKeyNumReads.get(strKey);
                        hmKeyNumReads.put(strKey, new Integer(count + 1));
                        continue;
                    }
                    if (hmKeyNumReads.get(strKey) <= 1) continue;
                    long currTime = System.currentTimeMillis();
                    long writeTime = hmKeyReads.get(strKey);
                    System.out.println("Key=" + strKey + ";TimeLag=" + (currTime - writeTime));
                    continue;
                }
                catch (KeeperException e) {
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public int presplit(String table, String[] keys) {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 0; i < keys.length; ++i) {
            splits.add(new Text(keys[i]));
        }
        try {
            this._connector.tableOperations().addSplits(table, splits);
        }
        catch (TableNotFoundException e) {
            e.printStackTrace();
        }
        catch (AccumuloException e) {
            e.printStackTrace();
        }
        catch (AccumuloSecurityException e) {
            e.printStackTrace();
        }
        return 0;
    }
}

