/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.measurements;

import com.yahoo.ycsb.measurements.OneMeasurement;
import com.yahoo.ycsb.measurements.exporter.MeasurementsExporter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Properties;

public class OneMeasurementHistogram
extends OneMeasurement {
    public static final String BUCKETS = "histogram.buckets";
    public static final String BUCKETS_DEFAULT = "1000";
    int _buckets;
    int[] histogram;
    int histogramoverflow;
    int operations;
    long totallatency;
    int windowoperations;
    long windowtotallatency;
    int min;
    int max;

    public OneMeasurementHistogram(String name, Properties props) {
        super(name);
        this._buckets = Integer.parseInt(props.getProperty(BUCKETS, BUCKETS_DEFAULT));
        this.histogram = new int[this._buckets];
        this.histogramoverflow = 0;
        this.operations = 0;
        this.totallatency = 0L;
        this.windowoperations = 0;
        this.windowtotallatency = 0L;
        this.min = -1;
        this.max = -1;
    }

    @Override
    public synchronized void measure(int latency) {
        if (latency / 1000 >= this._buckets) {
            ++this.histogramoverflow;
        } else {
            int n = latency / 1000;
            this.histogram[n] = this.histogram[n] + 1;
        }
        ++this.operations;
        this.totallatency += (long)latency;
        ++this.windowoperations;
        this.windowtotallatency += (long)latency;
        if (this.min < 0 || latency < this.min) {
            this.min = latency;
        }
        if (this.max < 0 || latency > this.max) {
            this.max = latency;
        }
    }

    @Override
    public void exportMeasurements(MeasurementsExporter exporter) throws IOException {
        int i;
        exporter.write(this.getName(), "Operations", this.operations);
        exporter.write(this.getName(), "AverageLatency(us)", (double)this.totallatency / (double)this.operations);
        exporter.write(this.getName(), "MinLatency(us)", this.min);
        exporter.write(this.getName(), "MaxLatency(us)", this.max);
        int opcounter = 0;
        boolean done95th = false;
        for (i = 0; i < this._buckets; ++i) {
            opcounter += this.histogram[i];
            if (!done95th && (double)opcounter / (double)this.operations >= 0.95) {
                exporter.write(this.getName(), "95thPercentileLatency(us)", i * 1000);
                done95th = true;
            }
            if (!((double)opcounter / (double)this.operations >= 0.99)) continue;
            exporter.write(this.getName(), "99thPercentileLatency(us)", i * 1000);
            break;
        }
        this.exportReturnCodes(exporter);
        for (i = 0; i < this._buckets; ++i) {
            exporter.write(this.getName(), Integer.toString(i), this.histogram[i]);
        }
        exporter.write(this.getName(), ">" + this._buckets, this.histogramoverflow);
    }

    @Override
    public String getSummary() {
        if (this.windowoperations == 0) {
            return "";
        }
        DecimalFormat d = new DecimalFormat("#.##");
        double report = (double)this.windowtotallatency / (double)this.windowoperations;
        this.windowtotallatency = 0L;
        this.windowoperations = 0;
        return "[" + this.getName() + " AverageLatency(us)=" + d.format(report) + "]";
    }
}

