/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.measurements;

import com.yahoo.ycsb.measurements.OneMeasurement;
import com.yahoo.ycsb.measurements.exporter.MeasurementsExporter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Properties;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogWriter;
import org.HdrHistogram.Recorder;

public class OneMeasurementHdrHistogram
extends OneMeasurement {
    final PrintStream log;
    final HistogramLogWriter histogramLogWriter;
    final Recorder histogram;
    Histogram totalHistogram;

    public OneMeasurementHdrHistogram(String name, Properties props) {
        super(name);
        boolean shouldLog = Boolean.parseBoolean(props.getProperty("hdrhistogram.fileoutput", "false"));
        if (!shouldLog) {
            this.log = null;
            this.histogramLogWriter = null;
        } else {
            try {
                String hdrOutputFilename = props.getProperty("hdrhistogram.output.path", "") + name + ".hdr";
                this.log = new PrintStream(new FileOutputStream(hdrOutputFilename), false);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Failed to open hdr histogram output file", e);
            }
            this.histogramLogWriter = new HistogramLogWriter(this.log);
            this.histogramLogWriter.outputComment("[Logging for: " + name + "]");
            this.histogramLogWriter.outputLogFormatVersion();
            long now = System.currentTimeMillis();
            this.histogramLogWriter.outputStartTime(now);
            this.histogramLogWriter.setBaseTime(now);
            this.histogramLogWriter.outputLegend();
        }
        this.histogram = new Recorder(3);
    }

    @Override
    public void measure(int latencyInMicros) {
        this.histogram.recordValue(latencyInMicros);
    }

    @Override
    public void exportMeasurements(MeasurementsExporter exporter) throws IOException {
        Histogram intervalHistogram = this.getIntervalHistogramAndAccumulate();
        if (this.histogramLogWriter != null) {
            this.histogramLogWriter.outputIntervalHistogram(intervalHistogram);
            this.log.close();
        }
        exporter.write(this.getName(), "Operations", this.totalHistogram.getTotalCount());
        exporter.write(this.getName(), "AverageLatency(us)", this.totalHistogram.getMean());
        exporter.write(this.getName(), "MinLatency(us)", this.totalHistogram.getMinValue());
        exporter.write(this.getName(), "MaxLatency(us)", this.totalHistogram.getMaxValue());
        exporter.write(this.getName(), "95thPercentileLatency(us)", this.totalHistogram.getValueAtPercentile(95.0));
        exporter.write(this.getName(), "99thPercentileLatency(us)", this.totalHistogram.getValueAtPercentile(99.0));
        this.exportReturnCodes(exporter);
    }

    @Override
    public String getSummary() {
        Histogram intervalHistogram = this.getIntervalHistogramAndAccumulate();
        if (this.histogramLogWriter != null) {
            this.histogramLogWriter.outputIntervalHistogram(intervalHistogram);
        }
        DecimalFormat d = new DecimalFormat("#.##");
        return "[" + this.getName() + ": Count=" + intervalHistogram.getTotalCount() + ", Max=" + intervalHistogram.getMaxValue() + ", Min=" + intervalHistogram.getMinValue() + ", Avg=" + d.format(intervalHistogram.getMean()) + ", 90=" + d.format(intervalHistogram.getValueAtPercentile(90.0)) + ", 99=" + d.format(intervalHistogram.getValueAtPercentile(99.0)) + ", 99.9=" + d.format(intervalHistogram.getValueAtPercentile(99.9)) + ", 99.99=" + d.format(intervalHistogram.getValueAtPercentile(99.99)) + "]";
    }

    private Histogram getIntervalHistogramAndAccumulate() {
        Histogram intervalHistogram = this.histogram.getIntervalHistogram();
        if (this.totalHistogram == null) {
            this.totalHistogram = intervalHistogram;
        } else {
            this.totalHistogram.add(intervalHistogram);
        }
        return intervalHistogram;
    }
}

