/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.generator;

import com.yahoo.ycsb.Utils;
import com.yahoo.ycsb.WorkloadException;
import com.yahoo.ycsb.generator.Generator;
import java.util.Vector;

public class DiscreteGenerator
extends Generator {
    Vector<Pair> _values = new Vector();
    String _lastvalue = null;

    @Override
    public String nextString() {
        double sum = 0.0;
        for (Pair p : this._values) {
            sum += p._weight;
        }
        double val = Utils.random().nextDouble();
        for (Pair p : this._values) {
            if (val < p._weight / sum) {
                return p._value;
            }
            val -= p._weight / sum;
        }
        System.out.println("oops. should not get here.");
        System.exit(0);
        return null;
    }

    public int nextInt() throws WorkloadException {
        throw new WorkloadException("DiscreteGenerator does not support nextInt()");
    }

    @Override
    public String lastString() {
        if (this._lastvalue == null) {
            this._lastvalue = this.nextString();
        }
        return this._lastvalue;
    }

    public void addValue(double weight, String value) {
        this._values.add(new Pair(weight, value));
    }

    class Pair {
        public double _weight;
        public String _value;

        Pair(double weight, String value) {
            this._weight = weight;
            this._value = value;
        }
    }
}

