/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb;

import com.yahoo.ycsb.ClientThread;
import com.yahoo.ycsb.RemainingFormatter;
import com.yahoo.ycsb.measurements.Measurements;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class StatusThread
extends Thread {
    private final CountDownLatch _completeLatch;
    private final List<ClientThread> _clients;
    private final String _label;
    private final boolean _standardstatus;
    private long _sleeptimeNs;

    public StatusThread(CountDownLatch completeLatch, List<ClientThread> clients, String label, boolean standardstatus, int statusIntervalSeconds) {
        this._completeLatch = completeLatch;
        this._clients = clients;
        this._label = label;
        this._standardstatus = standardstatus;
        this._sleeptimeNs = TimeUnit.SECONDS.toNanos(statusIntervalSeconds);
    }

    @Override
    public void run() {
        boolean alldone;
        long startTimeMs = System.currentTimeMillis();
        long startTimeNanos = System.nanoTime();
        long deadline = startTimeNanos + this._sleeptimeNs;
        long startIntervalMs = startTimeMs;
        long lastTotalOps = 0L;
        do {
            long nowMs = System.currentTimeMillis();
            lastTotalOps = this.computeStats(startTimeMs, startIntervalMs, nowMs, lastTotalOps);
            alldone = this.waitForClientsUntil(deadline);
            startIntervalMs = nowMs;
            deadline += this._sleeptimeNs;
        } while (!alldone);
        this.computeStats(startTimeMs, startIntervalMs, System.currentTimeMillis(), lastTotalOps);
    }

    private long computeStats(long startTimeMs, long startIntervalMs, long endIntervalMs, long lastTotalOps) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        long totalops = 0L;
        long todoops = 0L;
        for (ClientThread t : this._clients) {
            totalops += (long)t.getOpsDone();
            todoops += (long)t.getOpsTodo();
        }
        long interval = endIntervalMs - startTimeMs;
        double throughput = 1000.0 * ((double)totalops / (double)interval);
        double curthroughput = 1000.0 * ((double)(totalops - lastTotalOps) / (double)(endIntervalMs - startIntervalMs));
        long estremaining = (long)Math.ceil((double)todoops / throughput);
        DecimalFormat d = new DecimalFormat("#.##");
        String label = this._label + format.format(new Date());
        StringBuilder msg = new StringBuilder(label).append(" ").append(interval / 1000L).append(" sec: ");
        msg.append(totalops).append(" operations; ");
        if (totalops != 0L) {
            msg.append(d.format(curthroughput)).append(" current ops/sec; ");
        }
        if (todoops != 0L) {
            msg.append("est completion in ").append((CharSequence)RemainingFormatter.format(estremaining));
        }
        msg.append(Measurements.getMeasurements().getSummary());
        System.err.println(msg);
        if (this._standardstatus) {
            System.out.println(msg);
        }
        return totalops;
    }

    private boolean waitForClientsUntil(long deadline) {
        boolean alldone = false;
        long now = System.nanoTime();
        while (!alldone && now < deadline) {
            try {
                alldone = this._completeLatch.await(deadline - now, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                alldone = true;
            }
            now = System.nanoTime();
        }
        return alldone;
    }
}

