/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb;

import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.Utils;
import com.yahoo.ycsb.Workload;
import com.yahoo.ycsb.WorkloadException;
import com.yahoo.ycsb.measurements.Measurements;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.LockSupport;

class ClientThread
extends Thread {
    private final CountDownLatch _completeLatch;
    private static boolean _spinSleep;
    DB _db;
    boolean _dotransactions;
    Workload _workload;
    int _opcount;
    double _targetOpsPerMs;
    int _opsdone;
    int _threadid;
    int _threadcount;
    Object _workloadstate;
    Properties _props;
    long _targetOpsTickNs;
    final Measurements _measurements;

    public ClientThread(DB db, boolean dotransactions, Workload workload, Properties props, int opcount, double targetperthreadperms, CountDownLatch completeLatch) {
        this._db = db;
        this._dotransactions = dotransactions;
        this._workload = workload;
        this._opcount = opcount;
        this._opsdone = 0;
        if (targetperthreadperms > 0.0) {
            this._targetOpsPerMs = targetperthreadperms;
            this._targetOpsTickNs = (long)(1000000.0 / this._targetOpsPerMs);
        }
        this._props = props;
        this._measurements = Measurements.getMeasurements();
        _spinSleep = Boolean.valueOf(this._props.getProperty("spin.sleep", "false"));
        this._completeLatch = completeLatch;
    }

    public int getOpsDone() {
        return this._opsdone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._db.init();
        }
        catch (DBException e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            return;
        }
        try {
            this._workloadstate = this._workload.initThread(this._props, this._threadid, this._threadcount);
        }
        catch (WorkloadException e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            return;
        }
        if (this._targetOpsPerMs > 0.0 && this._targetOpsPerMs <= 1.0) {
            long randomMinorDelay = Utils.random().nextInt((int)this._targetOpsTickNs);
            ClientThread.sleepUntil(System.nanoTime() + randomMinorDelay);
        }
        try {
            long startTimeNanos;
            if (this._dotransactions) {
                startTimeNanos = System.nanoTime();
                while ((this._opcount == 0 || this._opsdone < this._opcount) && !this._workload.isStopRequested() && this._workload.doTransaction(this._db, this._workloadstate)) {
                    ++this._opsdone;
                    this.throttleNanos(startTimeNanos);
                }
            } else {
                startTimeNanos = System.nanoTime();
                while ((this._opcount == 0 || this._opsdone < this._opcount) && !this._workload.isStopRequested() && this._workload.doInsert(this._db, this._workloadstate)) {
                    ++this._opsdone;
                    this.throttleNanos(startTimeNanos);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            System.exit(0);
        }
        try {
            this._measurements.setIntendedStartTimeNs(0L);
            this._db.cleanup();
        }
        catch (DBException e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            return;
        }
        finally {
            this._completeLatch.countDown();
        }
    }

    static void sleepUntil(long deadline) {
        long now = System.nanoTime();
        while ((now = System.nanoTime()) < deadline) {
            if (_spinSleep) continue;
            LockSupport.parkNanos(deadline - now);
        }
    }

    private void throttleNanos(long startTimeNanos) {
        if (this._targetOpsPerMs > 0.0) {
            long deadline = startTimeNanos + (long)this._opsdone * this._targetOpsTickNs;
            ClientThread.sleepUntil(deadline);
            this._measurements.setIntendedStartTimeNs(deadline);
        }
    }

    public int getOpsTodo() {
        int todo = this._opcount - this._opsdone;
        return todo < 0 ? 0 : todo;
    }
}

