/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb;

import com.yahoo.ycsb.ClientThread;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBFactory;
import com.yahoo.ycsb.StatusThread;
import com.yahoo.ycsb.TerminatorThread;
import com.yahoo.ycsb.UnknownDBException;
import com.yahoo.ycsb.Workload;
import com.yahoo.ycsb.WorkloadException;
import com.yahoo.ycsb.measurements.Measurements;
import com.yahoo.ycsb.measurements.exporter.MeasurementsExporter;
import com.yahoo.ycsb.measurements.exporter.TextMeasurementsExporter;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;

public class Client {
    public static final String DEFAULT_RECORD_COUNT = "0";
    public static final String OPERATION_COUNT_PROPERTY = "operationcount";
    public static final String RECORD_COUNT_PROPERTY = "recordcount";
    public static final String WORKLOAD_PROPERTY = "workload";
    public static final String DB_PROPERTY = "db";
    public static final String EXPORTER_PROPERTY = "exporter";
    public static final String EXPORT_FILE_PROPERTY = "exportfile";
    public static final String THREAD_COUNT_PROPERTY = "threadcount";
    public static final String INSERT_COUNT_PROPERTY = "insertcount";
    public static final String TARGET_PROPERTY = "target";
    public static final String MAX_EXECUTION_TIME = "maxexecutiontime";

    public static void usageMessage() {
        System.out.println("Usage: java com.yahoo.ycsb.Client [options]");
        System.out.println("Options:");
        System.out.println("  -threads n: execute using n threads (default: 1) - can also be specified as the \n        \"threadcount\" property using -p");
        System.out.println("  -target n: attempt to do n operations per second (default: unlimited) - can also\n       be specified as the \"target\" property using -p");
        System.out.println("  -load:  run the loading phase of the workload");
        System.out.println("  -t:  run the transactions phase of the workload (default)");
        System.out.println("  -db dbname: specify the name of the DB to use (default: com.yahoo.ycsb.BasicDB) - \n        can also be specified as the \"db\" property using -p");
        System.out.println("  -P propertyfile: load properties from the given file. Multiple files can");
        System.out.println("           be specified, and will be processed in the order specified");
        System.out.println("  -p name=value:  specify a property to be passed to the DB and workloads;");
        System.out.println("          multiple properties can be specified, and override any");
        System.out.println("          values in the propertyfile");
        System.out.println("  -s:  show status during run (default: no status)");
        System.out.println("  -l label:  use label for status (e.g. to label one experiment out of a whole batch)");
        System.out.println("");
        System.out.println("Required properties:");
        System.out.println("  workload: the name of the workload class to use (e.g. com.yahoo.ycsb.workloads.CoreWorkload)");
        System.out.println("");
        System.out.println("To run the transaction phase from multiple servers, start a separate client on each.");
        System.out.println("To run the load phase from multiple servers, start a separate client on each; additionally,");
        System.out.println("use the \"insertcount\" and \"insertstart\" properties to divide up the records to be inserted");
    }

    public static boolean checkRequiredProperties(Properties props) {
        if (props.getProperty(WORKLOAD_PROPERTY) == null) {
            System.out.println("Missing property: workload");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportMeasurements(Properties props, int opcount, long runtime) throws IOException {
        Closeable exporter = null;
        try {
            String exportFile = props.getProperty(EXPORT_FILE_PROPERTY);
            OutputStream out = exportFile == null ? System.out : new FileOutputStream(exportFile);
            String exporterStr = props.getProperty(EXPORTER_PROPERTY, "com.yahoo.ycsb.measurements.exporter.TextMeasurementsExporter");
            try {
                exporter = (MeasurementsExporter)Class.forName(exporterStr).getConstructor(OutputStream.class).newInstance(out);
            }
            catch (Exception e) {
                System.err.println("Could not find exporter " + exporterStr + ", will use default text reporter.");
                e.printStackTrace();
                exporter = new TextMeasurementsExporter(out);
            }
            exporter.write("OVERALL", "RunTime(ms)", runtime);
            double throughput = 1000.0 * (double)opcount / (double)runtime;
            exporter.write("OVERALL", "Throughput(ops/sec)", throughput);
            Measurements.getMeasurements().exportMeasurements((MeasurementsExporter)exporter);
        }
        finally {
            if (exporter != null) {
                exporter.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        Properties props = new Properties();
        Properties fileprops = new Properties();
        boolean dotransactions = true;
        int threadcount = 1;
        int target = 0;
        boolean status = false;
        String label = "";
        int argindex = 0;
        if (args.length == 0) {
            Client.usageMessage();
            System.exit(0);
        }
        while (args[argindex].startsWith("-")) {
            if (args[argindex].compareTo("-threads") == 0) {
                if (++argindex >= args.length) {
                    Client.usageMessage();
                    System.exit(0);
                }
                int tcount = Integer.parseInt(args[argindex]);
                props.setProperty(THREAD_COUNT_PROPERTY, tcount + "");
                ++argindex;
            } else if (args[argindex].compareTo("-target") == 0) {
                if (++argindex >= args.length) {
                    Client.usageMessage();
                    System.exit(0);
                }
                int ttarget = Integer.parseInt(args[argindex]);
                props.setProperty(TARGET_PROPERTY, ttarget + "");
                ++argindex;
            } else if (args[argindex].compareTo("-load") == 0) {
                dotransactions = false;
                ++argindex;
            } else if (args[argindex].compareTo("-t") == 0) {
                dotransactions = true;
                ++argindex;
            } else if (args[argindex].compareTo("-s") == 0) {
                status = true;
                ++argindex;
            } else if (args[argindex].compareTo("-db") == 0) {
                if (++argindex >= args.length) {
                    Client.usageMessage();
                    System.exit(0);
                }
                props.setProperty(DB_PROPERTY, args[argindex]);
                ++argindex;
            } else if (args[argindex].compareTo("-l") == 0) {
                if (++argindex >= args.length) {
                    Client.usageMessage();
                    System.exit(0);
                }
                label = args[argindex];
                ++argindex;
            } else if (args[argindex].compareTo("-P") == 0) {
                if (++argindex >= args.length) {
                    Client.usageMessage();
                    System.exit(0);
                }
                String propfile = args[argindex];
                ++argindex;
                Properties myfileprops = new Properties();
                try {
                    myfileprops.load(new FileInputStream(propfile));
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    System.exit(0);
                }
                Enumeration<?> e = myfileprops.propertyNames();
                while (e.hasMoreElements()) {
                    String prop = (String)e.nextElement();
                    fileprops.setProperty(prop, myfileprops.getProperty(prop));
                }
            } else if (args[argindex].compareTo("-p") == 0) {
                int eq;
                if (++argindex >= args.length) {
                    Client.usageMessage();
                    System.exit(0);
                }
                if ((eq = args[argindex].indexOf(61)) < 0) {
                    Client.usageMessage();
                    System.exit(0);
                }
                String name = args[argindex].substring(0, eq);
                String value = args[argindex].substring(eq + 1);
                props.put(name, value);
                ++argindex;
            } else {
                System.out.println("Unknown option " + args[argindex]);
                Client.usageMessage();
                System.exit(0);
            }
            if (argindex < args.length) continue;
        }
        if (argindex != args.length) {
            Client.usageMessage();
            System.exit(0);
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            fileprops.setProperty(prop, props.getProperty(prop));
        }
        props = fileprops;
        if (!Client.checkRequiredProperties(props)) {
            System.exit(0);
        }
        long maxExecutionTime = Integer.parseInt(props.getProperty(MAX_EXECUTION_TIME, DEFAULT_RECORD_COUNT));
        threadcount = Integer.parseInt(props.getProperty(THREAD_COUNT_PROPERTY, "1"));
        String dbname = props.getProperty(DB_PROPERTY, "com.yahoo.ycsb.BasicDB");
        target = Integer.parseInt(props.getProperty(TARGET_PROPERTY, DEFAULT_RECORD_COUNT));
        double targetperthreadperms = -1.0;
        if (target > 0) {
            double targetperthread = (double)target / (double)threadcount;
            targetperthreadperms = targetperthread / 1000.0;
        }
        System.out.println("YCSB Client 0.1");
        System.out.print("Command line:");
        for (int i = 0; i < args.length; ++i) {
            System.out.print(" " + args[i]);
        }
        System.out.println();
        System.err.println("Loading workload...");
        Thread warningthread = new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(2000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                System.err.println(" (might take a few minutes for large data sets)");
            }
        };
        warningthread.start();
        Measurements.setProperties(props);
        ClassLoader classLoader = Client.class.getClassLoader();
        Workload workload = null;
        try {
            Class<?> workloadclass = classLoader.loadClass(props.getProperty(WORKLOAD_PROPERTY));
            workload = (Workload)workloadclass.newInstance();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            e2.printStackTrace(System.out);
            System.exit(0);
        }
        try {
            workload.init(props);
        }
        catch (WorkloadException e3) {
            e3.printStackTrace();
            e3.printStackTrace(System.out);
            System.exit(0);
        }
        warningthread.interrupt();
        System.err.println("Starting test.");
        int opcount = dotransactions ? Integer.parseInt(props.getProperty(OPERATION_COUNT_PROPERTY, DEFAULT_RECORD_COUNT)) : (props.containsKey(INSERT_COUNT_PROPERTY) ? Integer.parseInt(props.getProperty(INSERT_COUNT_PROPERTY, DEFAULT_RECORD_COUNT)) : Integer.parseInt(props.getProperty(RECORD_COUNT_PROPERTY, DEFAULT_RECORD_COUNT)));
        CountDownLatch completeLatch = new CountDownLatch(threadcount);
        ArrayList<ClientThread> clients = new ArrayList<ClientThread>(threadcount);
        for (int threadid = 0; threadid < threadcount; ++threadid) {
            DB db = null;
            try {
                db = DBFactory.newDB(dbname, props);
            }
            catch (UnknownDBException e4) {
                System.out.println("Unknown DB " + dbname);
                System.exit(0);
            }
            int threadopcount = opcount / threadcount;
            if (threadid < opcount % threadcount) {
                ++threadopcount;
            }
            ClientThread t = new ClientThread(db, dotransactions, workload, props, threadopcount, targetperthreadperms, completeLatch);
            clients.add(t);
        }
        StatusThread statusthread = null;
        if (status) {
            boolean standardstatus = false;
            if (props.getProperty("measurementtype", "").compareTo("timeseries") == 0) {
                standardstatus = true;
            }
            int statusIntervalSeconds = Integer.parseInt(props.getProperty("status.interval", "10"));
            statusthread = new StatusThread(completeLatch, clients, label, standardstatus, statusIntervalSeconds);
            statusthread.start();
        }
        long st = System.currentTimeMillis();
        for (Thread thread : clients) {
            thread.start();
        }
        TerminatorThread terminator = null;
        if (maxExecutionTime > 0L) {
            terminator = new TerminatorThread(maxExecutionTime, clients, workload);
            terminator.start();
        }
        boolean bl = false;
        for (Thread thread : clients) {
            try {
                thread.join();
                var24_41 += ((ClientThread)thread).getOpsDone();
            }
            catch (InterruptedException e5) {}
        }
        long en = System.currentTimeMillis();
        if (terminator != null && !terminator.isInterrupted()) {
            terminator.interrupt();
        }
        if (status) {
            statusthread.interrupt();
            try {
                statusthread.join();
            }
            catch (InterruptedException e6) {
                // empty catch block
            }
        }
        try {
            workload.cleanup();
        }
        catch (WorkloadException e7) {
            e7.printStackTrace();
            e7.printStackTrace(System.out);
            System.exit(0);
        }
        try {
            void var24_41;
            Client.exportMeasurements(props, (int)var24_41, en - st);
        }
        catch (IOException e8) {
            System.err.println("Could not export measurements, error: " + e8.getMessage());
            e8.printStackTrace();
            System.exit(-1);
        }
        System.exit(0);
    }
}

