/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.Utils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public class BasicDB
extends DB {
    public static final String VERBOSE = "basicdb.verbose";
    public static final String VERBOSE_DEFAULT = "true";
    public static final String SIMULATE_DELAY = "basicdb.simulatedelay";
    public static final String SIMULATE_DELAY_DEFAULT = "0";
    public static final String RANDOMIZE_DELAY = "basicdb.randomizedelay";
    public static final String RANDOMIZE_DELAY_DEFAULT = "true";
    boolean verbose;
    boolean randomizedelay;
    int todelay = 0;

    void delay() {
        if (this.todelay > 0) {
            long delayNs;
            if (this.randomizedelay) {
                delayNs = TimeUnit.MILLISECONDS.toNanos(Utils.random().nextInt(this.todelay));
                if (delayNs == 0L) {
                    return;
                }
            } else {
                delayNs = TimeUnit.MILLISECONDS.toNanos(this.todelay);
            }
            long now = System.nanoTime();
            long deadline = now + delayNs;
            do {
                LockSupport.parkNanos(deadline - now);
            } while ((now = System.nanoTime()) < deadline && !Thread.interrupted());
        }
    }

    @Override
    public void init() {
        this.verbose = Boolean.parseBoolean(this.getProperties().getProperty(VERBOSE, "true"));
        this.todelay = Integer.parseInt(this.getProperties().getProperty(SIMULATE_DELAY, SIMULATE_DELAY_DEFAULT));
        this.randomizedelay = Boolean.parseBoolean(this.getProperties().getProperty(RANDOMIZE_DELAY, "true"));
        if (this.verbose) {
            System.out.println("***************** properties *****************");
            Properties p = this.getProperties();
            if (p != null) {
                Enumeration<?> e = p.propertyNames();
                while (e.hasMoreElements()) {
                    String k = (String)e.nextElement();
                    System.out.println("\"" + k + "\"=\"" + p.getProperty(k) + "\"");
                }
            }
            System.out.println("**********************************************");
        }
    }

    @Override
    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        this.delay();
        if (this.verbose) {
            System.out.print("READ " + table + " " + key + " [ ");
            if (fields != null) {
                for (String f : fields) {
                    System.out.print(f + " ");
                }
            } else {
                System.out.print("<all fields>");
            }
            System.out.println("]");
        }
        return 0;
    }

    @Override
    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        this.delay();
        if (this.verbose) {
            System.out.print("SCAN " + table + " " + startkey + " " + recordcount + " [ ");
            if (fields != null) {
                for (String f : fields) {
                    System.out.print(f + " ");
                }
            } else {
                System.out.print("<all fields>");
            }
            System.out.println("]");
        }
        return 0;
    }

    @Override
    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        this.delay();
        if (this.verbose) {
            System.out.print("UPDATE " + table + " " + key + " [ ");
            if (values != null) {
                for (String k : values.keySet()) {
                    System.out.print(k + "=" + values.get(k) + " ");
                }
            }
            System.out.println("]");
        }
        return 0;
    }

    @Override
    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        this.delay();
        if (this.verbose) {
            System.out.print("INSERT " + table + " " + key + " [ ");
            if (values != null) {
                for (String k : values.keySet()) {
                    System.out.print(k + "=" + values.get(k) + " ");
                }
            }
            System.out.println("]");
        }
        return 0;
    }

    @Override
    public int delete(String table, String key) {
        this.delay();
        if (this.verbose) {
            System.out.println("DELETE " + table + " " + key);
        }
        return 0;
    }
}

