/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.yahoo.ycsb.ByteArrayByteIterator;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.measurements.Measurements;
import com.yahoo.ycsb.workloads.CoreWorkload;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseClient10
extends DB {
    private Configuration config = HBaseConfiguration.create();
    public boolean _debug = false;
    public String _tableName = "";
    public Connection _connection = null;
    public Table _table = null;
    public BufferedMutator _bufferedMutator = null;
    public String _columnFamily = "";
    public byte[] _columnFamilyBytes;
    public Durability _durability = Durability.USE_DEFAULT;
    public boolean _clientSideBuffering = false;
    public long _writeBufferSize = 0xC00000L;
    public static final int Ok = 0;
    public static final int ServerError = -1;
    public static final int HttpError = -2;
    public static final int NoMatchingRecord = -3;

    public void init() throws DBException {
        if ("true".equals(this.getProperties().getProperty("clientbuffering", "false"))) {
            this._clientSideBuffering = true;
        }
        if (this.getProperties().containsKey("writebuffersize")) {
            this._writeBufferSize = Long.parseLong(this.getProperties().getProperty("writebuffersize"));
        }
        if (this.getProperties().getProperty("durability") != null) {
            this._durability = Durability.valueOf((String)this.getProperties().getProperty("durability"));
        }
        try {
            this._connection = ConnectionFactory.createConnection((Configuration)this.config);
        }
        catch (IOException e) {
            throw new DBException((Throwable)e);
        }
        if (this.getProperties().getProperty("debug") != null && this.getProperties().getProperty("debug").compareTo("true") == 0) {
            this._debug = true;
        }
        this._columnFamily = this.getProperties().getProperty("columnfamily");
        if (this._columnFamily == null) {
            System.err.println("Error, must specify a columnfamily for HBase table");
            throw new DBException("No columnfamily specified");
        }
        this._columnFamilyBytes = Bytes.toBytes((String)this._columnFamily);
        String table = CoreWorkload.table;
        try {
            TableName tableName = TableName.valueOf((String)table);
            HTableDescriptor hTableDescriptor = this._connection.getTable(tableName).getTableDescriptor();
        }
        catch (IOException e) {
            throw new DBException((Throwable)e);
        }
    }

    public void cleanup() throws DBException {
        Measurements _measurements = Measurements.getMeasurements();
        try {
            long st = System.nanoTime();
            if (this._bufferedMutator != null) {
                this._bufferedMutator.close();
            }
            if (this._table != null) {
                this._table.close();
            }
            long en = System.nanoTime();
            String type = this._clientSideBuffering ? "UPDATE" : "CLEANUP";
            _measurements.measure(type, (int)((en - st) / 1000L));
            this._connection.close();
        }
        catch (IOException e) {
            throw new DBException((Throwable)e);
        }
    }

    public void getHTable(String table) throws IOException {
        TableName tableName = TableName.valueOf((String)table);
        this._table = this._connection.getTable(tableName);
        if (this._clientSideBuffering) {
            BufferedMutatorParams p = new BufferedMutatorParams(tableName);
            p.writeBufferSize(this._writeBufferSize);
            this._bufferedMutator = this._connection.getBufferedMutator(p);
        }
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        if (!this._tableName.equals(table)) {
            this._table = null;
            try {
                this.getHTable(table);
                this._tableName = table;
            }
            catch (IOException e) {
                System.err.println("Error accessing HBase table: " + e);
                return -1;
            }
        }
        Result r = null;
        try {
            if (this._debug) {
                System.out.println("Doing read from HBase columnfamily " + this._columnFamily);
                System.out.println("Doing read for key: " + key);
            }
            Get g = new Get(Bytes.toBytes((String)key));
            if (fields == null) {
                g.addFamily(this._columnFamilyBytes);
            } else {
                for (String field : fields) {
                    g.addColumn(this._columnFamilyBytes, Bytes.toBytes((String)field));
                }
            }
            r = this._table.get(g);
        }
        catch (IOException e) {
            if (this._debug) {
                System.err.println("Error doing get: " + e);
            }
            return -1;
        }
        catch (ConcurrentModificationException e) {
            return -1;
        }
        if (r.isEmpty()) {
            return -3;
        }
        while (r.advance()) {
            Cell c = r.current();
            result.put(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)c)), (ByteIterator)new ByteArrayByteIterator(CellUtil.cloneValue((Cell)c)));
            if (!this._debug) continue;
            System.out.println("Result for field: " + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)c)) + " is: " + Bytes.toString((byte[])CellUtil.cloneValue((Cell)c)));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        if (!this._tableName.equals(table)) {
            this._table = null;
            try {
                this.getHTable(table);
                this._tableName = table;
            }
            catch (IOException e) {
                System.err.println("Error accessing HBase table: " + e);
                return -1;
            }
        }
        Scan s = new Scan(Bytes.toBytes((String)startkey));
        s.setCaching(recordcount);
        if (fields == null) {
            s.addFamily(this._columnFamilyBytes);
        } else {
            for (String field : fields) {
                s.addColumn(this._columnFamilyBytes, Bytes.toBytes((String)field));
            }
        }
        ResultScanner scanner = null;
        try {
            scanner = this._table.getScanner(s);
            int numResults = 0;
            Result rr = scanner.next();
            while (rr != null) {
                String key = Bytes.toString((byte[])rr.getRow());
                if (this._debug) {
                    System.out.println("Got scan result for key: " + key);
                }
                HashMap<String, ByteArrayByteIterator> rowResult = new HashMap<String, ByteArrayByteIterator>();
                while (rr.advance()) {
                    Cell cell = rr.current();
                    rowResult.put(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell)), new ByteArrayByteIterator(CellUtil.cloneValue((Cell)cell)));
                }
                result.add(rowResult);
                if (++numResults >= recordcount) {
                    break;
                }
                rr = scanner.next();
            }
        }
        catch (IOException e) {
            if (this._debug) {
                System.out.println("Error in getting/parsing scan result: " + e);
            }
            int n = -1;
            return n;
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return 0;
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        if (!this._tableName.equals(table)) {
            this._table = null;
            try {
                this.getHTable(table);
                this._tableName = table;
            }
            catch (IOException e) {
                System.err.println("Error accessing HBase table: " + e);
                return -1;
            }
        }
        if (this._debug) {
            System.out.println("Setting up put for key: " + key);
        }
        Put p = new Put(Bytes.toBytes((String)key));
        p.setDurability(this._durability);
        for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
            byte[] value = entry.getValue().toArray();
            if (this._debug) {
                System.out.println("Adding field/value " + entry.getKey() + "/" + Bytes.toStringBinary((byte[])value) + " to put request");
            }
            p.addColumn(this._columnFamilyBytes, Bytes.toBytes((String)entry.getKey()), value);
        }
        try {
            if (this._clientSideBuffering) {
                Preconditions.checkNotNull((Object)this._bufferedMutator);
                this._bufferedMutator.mutate((Mutation)p);
            } else {
                this._table.put(p);
            }
        }
        catch (IOException e) {
            if (this._debug) {
                System.err.println("Error doing put: " + e);
            }
            return -1;
        }
        catch (ConcurrentModificationException e) {
            return -1;
        }
        return 0;
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        return this.update(table, key, values);
    }

    public int delete(String table, String key) {
        if (!this._tableName.equals(table)) {
            this._table = null;
            try {
                this.getHTable(table);
                this._tableName = table;
            }
            catch (IOException e) {
                System.err.println("Error accessing HBase table: " + e);
                return -1;
            }
        }
        if (this._debug) {
            System.out.println("Doing delete for key: " + key);
        }
        Delete d = new Delete(Bytes.toBytes((String)key));
        d.setDurability(this._durability);
        try {
            if (this._clientSideBuffering) {
                Preconditions.checkNotNull((Object)this._bufferedMutator);
                this._bufferedMutator.mutate((Mutation)d);
            } else {
                this._table.delete(d);
            }
        }
        catch (IOException e) {
            if (this._debug) {
                System.err.println("Error doing delete: " + e);
            }
            return -1;
        }
        return 0;
    }

    @VisibleForTesting
    void setConfiguration(Configuration config) {
        this.config = config;
    }
}

