/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.tarantool.Base64;
import org.tarantool.Code;
import org.tarantool.CommunicationException;
import org.tarantool.ConnectionState;
import org.tarantool.Key;
import org.tarantool.TarantoolException;

public abstract class TarantoolConnection16Base {
    protected final SocketChannel channel;
    protected final ConnectionState state;
    protected final String salt;

    protected SocketChannel getChannel() {
        return this.channel;
    }

    protected ConnectionState getState() {
        return this.state;
    }

    public TarantoolConnection16Base(SocketChannel channel) {
        try {
            this.channel = channel;
            this.state = new ConnectionState();
            ByteBuffer welcome = this.state.getWelcomeBuffer();
            this.readFully(welcome);
            String firstLine = new String(welcome.array(), 0, welcome.position());
            if (!firstLine.startsWith("Tarantool")) {
                channel.close();
                throw new CommunicationException("Welcome message should starts with tarantool but starts with '" + firstLine + "'");
            }
            welcome = this.state.getWelcomeBuffer();
            this.readFully(welcome);
            this.salt = new String(welcome.array(), 0, welcome.position());
        }
        catch (IOException e) {
            throw new CommunicationException("Can't connect with tarantool", e);
        }
    }

    protected int readFully(ByteBuffer buffer) {
        try {
            int code;
            while ((code = this.channel.read(buffer)) > -1 && buffer.remaining() > 0) {
            }
            if (code < 0) {
                throw new CommunicationException("Can't read bytes");
            }
            return code;
        }
        catch (IOException e) {
            throw new CommunicationException("Can't read bytes", e);
        }
    }

    protected Object read() {
        this.readPacket();
        return this.state.getBody().get(Key.DATA);
    }

    protected void readPacket() {
        this.readFully(this.state.getLengthReadBuffer());
        this.readFully(this.state.getPacketReadBuffer());
        this.state.unpack();
        long code = (Long)this.state.getHeader().get(Key.CODE);
        if (code != 0L) {
            Object error = this.state.getBody().get(Key.ERROR);
            throw new TarantoolException((int)code, error instanceof String ? (String)error : new String((byte[])error));
        }
    }

    protected int write(ByteBuffer buffer) {
        try {
            int code;
            while ((code = this.channel.write(buffer)) > -1 && buffer.remaining() > 0) {
            }
            if (code < 0) {
                throw new CommunicationException("Can't read bytes");
            }
            return code;
        }
        catch (IOException e) {
            throw new CommunicationException("Can't write bytes", e);
        }
    }

    public List select(int space, int index, Object key, int offset, int limit, int iterator) {
        return this.exec(Code.SELECT, Key.SPACE, space, Key.INDEX, index, Key.KEY, key, Key.ITERATOR, iterator, Key.LIMIT, limit, Key.OFFSET, offset);
    }

    public List insert(int space, Object tuple) {
        return this.exec(Code.INSERT, Key.SPACE, space, Key.TUPLE, tuple);
    }

    public List replace(int space, Object tuple) {
        return this.exec(Code.REPLACE, Key.SPACE, space, Key.TUPLE, tuple);
    }

    public List update(int space, Object key, Object ... args) {
        return this.exec(Code.UPDATE, Key.SPACE, space, Key.KEY, key, Key.TUPLE, args);
    }

    public List delete(int space, Object key) {
        return this.exec(Code.DELETE, Key.SPACE, space, Key.KEY, key);
    }

    public List call(String function, Object ... args) {
        return this.exec(Code.CALL, Key.FUNCTION, function, Key.TUPLE, args);
    }

    public List eval(String expression, Object ... args) {
        return this.exec(Code.EVAL, Key.EXPRESSION, expression, Key.TUPLE, args);
    }

    public void auth(String username, String password) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            ArrayList<Object> auth = new ArrayList<Object>(2);
            auth.add("chap-sha1");
            byte[] p = sha1.digest(password.getBytes());
            sha1.reset();
            byte[] p2 = sha1.digest(p);
            sha1.reset();
            sha1.update(Base64.decode(this.salt), 0, 20);
            sha1.update(p2);
            byte[] scramble = sha1.digest();
            int e = 20;
            for (int i = 0; i < e; ++i) {
                int n = i;
                p[n] = (byte)(p[n] ^ scramble[i]);
            }
            auth.add(p);
            this.exec(Code.AUTH, Key.USER_NAME, username, Key.TUPLE, auth);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CommunicationException("Can't use sha-1", e);
        }
    }

    public boolean ping() {
        this.exec(Code.PING, new Object[0]);
        return true;
    }

    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract List exec(Code var1, Object ... var2);
}

