/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.tarantool.Code;

public class AsyncQuery<V>
implements Future<V> {
    protected Long id;
    protected Code code;
    protected Object[] args;
    protected V value;
    protected Exception error;
    protected CountDownLatch latch = new CountDownLatch(1);

    public AsyncQuery(Long id, Code code, Object[] args) {
        this.id = id;
        this.code = code;
        this.args = args;
    }

    protected AsyncQuery() {
    }

    public void setError(Exception e) {
        this.error = e;
        this.latch.countDown();
    }

    public void setValue(V v) {
        this.value = v;
        this.latch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.latch.await();
        if (this.error != null) {
            throw new ExecutionException(this.error);
        }
        return this.value;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.latch.await(timeout, unit);
        if (this.error != null) {
            throw new ExecutionException(this.error);
        }
        return this.value;
    }
}

