/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.security.auth.Subject;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.OsgiClassLoader;
import org.infinispan.commons.util.SecurityActions;
import org.osgi.framework.BundleReference;

public final class Util {
    private static final boolean IS_ARRAYS_DEBUG = Boolean.getBoolean("infinispan.arrays.debug");
    private static final boolean IS_OSGI_CONTEXT;
    public static final Object[] EMPTY_OBJECT_ARRAY;
    public static final byte[] EMPTY_BYTE_ARRAY;
    private static final Log log;
    private static final String javaVendor;
    private static String INDENT;
    static final String HEX_VALUES = "0123456789ABCDEF";

    public static <T> Class<T> loadClass(String classname, ClassLoader cl) {
        try {
            return Util.loadClassStrict(classname, cl);
        }
        catch (ClassNotFoundException e) {
            throw new CacheConfigurationException("Unable to instantiate class " + classname, e);
        }
    }

    public static boolean isOSGiContext() {
        return IS_OSGI_CONTEXT;
    }

    public static ClassLoader[] getClassLoaders(ClassLoader appClassLoader) {
        if (Util.isOSGiContext()) {
            return new ClassLoader[]{appClassLoader, OsgiClassLoader.getInstance(), Util.class.getClassLoader(), ClassLoader.getSystemClassLoader(), Thread.currentThread().getContextClassLoader()};
        }
        return new ClassLoader[]{appClassLoader, Util.class.getClassLoader(), ClassLoader.getSystemClassLoader(), Thread.currentThread().getContextClassLoader()};
    }

    public static <T> Class<T> loadClassStrict(String classname, ClassLoader userClassLoader) throws ClassNotFoundException {
        Object[] cls = Util.getClassLoaders(userClassLoader);
        ClassNotFoundException e = null;
        NoClassDefFoundError ne = null;
        for (ClassLoader classLoader : cls) {
            if (classLoader == null) continue;
            try {
                return Class.forName(classname, true, classLoader);
            }
            catch (ClassNotFoundException ce) {
                e = ce;
            }
            catch (NoClassDefFoundError ce) {
                ne = ce;
            }
        }
        if (e != null) {
            throw e;
        }
        if (ne != null) {
            log.unableToLoadClass(classname, Arrays.toString(cls), ne);
            throw new ClassNotFoundException(classname, ne);
        }
        throw new IllegalStateException();
    }

    public static InputStream getResourceAsStream(String resourcePath, ClassLoader userClassLoader) {
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        InputStream is = null;
        for (ClassLoader cl : Util.getClassLoaders(userClassLoader)) {
            if (cl != null && (is = cl.getResourceAsStream(resourcePath)) != null) break;
        }
        return is;
    }

    private static Method getFactoryMethod(Class<?> c) {
        for (Method m : c.getMethods()) {
            if (!m.getName().equals("getInstance") || m.getParameterTypes().length != 0 || !Modifier.isStatic(m.getModifiers())) continue;
            return m;
        }
        return null;
    }

    public static <T> T getInstance(Class<T> clazz) {
        try {
            return Util.getInstanceStrict(clazz);
        }
        catch (IllegalAccessException iae) {
            throw new CacheConfigurationException("Unable to instantiate class " + clazz.getName(), iae);
        }
        catch (InstantiationException ie) {
            throw new CacheConfigurationException("Unable to instantiate class " + clazz.getName(), ie);
        }
    }

    public static <T> T getInstanceStrict(Class<T> clazz) throws IllegalAccessException, InstantiationException {
        Object instance = null;
        try {
            Method factoryMethod = Util.getFactoryMethod(clazz);
            if (factoryMethod != null) {
                instance = factoryMethod.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            instance = null;
        }
        if (instance == null) {
            instance = clazz.newInstance();
        }
        return (T)instance;
    }

    public static <T> T getInstance(String classname, ClassLoader cl) {
        if (classname == null) {
            throw new IllegalArgumentException("Cannot load null class!");
        }
        Class<T> clazz = Util.loadClass(classname, cl);
        return Util.getInstance(clazz);
    }

    public static <T> T getInstanceStrict(String classname, ClassLoader cl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (classname == null) {
            throw new IllegalArgumentException("Cannot load null class!");
        }
        Class<T> clazz = Util.loadClassStrict(classname, cl);
        return Util.getInstanceStrict(clazz);
    }

    public static <T> T cloneWithMarshaller(Marshaller marshaller, T x) {
        if (marshaller == null) {
            throw new IllegalArgumentException("Cannot use null Marshaller for clone");
        }
        try {
            byte[] byteBuffer = marshaller.objectToByteBuffer(x);
            return (T)marshaller.objectFromByteBuffer(byteBuffer);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException(e);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    private Util() {
    }

    public static boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static String prettyPrintTime(long time, TimeUnit unit) {
        return Util.prettyPrintTime(unit.toMillis(time));
    }

    public static final long currentMillisFromNanotime() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    public static String prettyPrintTime(long millis) {
        if (millis < 1000L) {
            return millis + " milliseconds";
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        double toPrint = (double)millis / 1000.0;
        if (toPrint < 300.0) {
            return nf.format(toPrint) + " seconds";
        }
        if ((toPrint /= 60.0) < 120.0) {
            return nf.format(toPrint) + " minutes";
        }
        return nf.format(toPrint /= 60.0) + " hours";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readStream(InputStream is) throws IOException {
        try {
            int len;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream is) throws IOException {
        try {
            int len;
            InputStreamReader reader = new InputStreamReader(is, "UTF-8");
            StringWriter writer = new StringWriter();
            char[] buf = new char[1024];
            while ((len = reader.read(buf)) != -1) {
                writer.write(buf, 0, len);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            is.close();
        }
    }

    public static void close(Closeable cl) {
        if (cl == null) {
            return;
        }
        try {
            cl.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Socket s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Closeable ... cls) {
        for (Closeable cl : cls) {
            Util.close(cl);
        }
    }

    public static void close(Context ctx) {
        if (ctx == null) {
            return;
        }
        try {
            ctx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flushAndCloseStream(OutputStream o) {
        if (o == null) {
            return;
        }
        try {
            o.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flushAndCloseOutput(ObjectOutput o) {
        if (o == null) {
            return;
        }
        try {
            o.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String formatString(Object message, Object ... params) {
        if (params.length == 0) {
            return message == null ? "null" : message.toString();
        }
        return String.format(message.toString(), params);
    }

    public static String toStr(Object o) {
        if (o instanceof byte[]) {
            return Util.printArray((byte[])o, false);
        }
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    public static <E> String toStr(Collection<E> collection) {
        if (collection == null) {
            return "[]";
        }
        Iterator<E> i = collection.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E e;
            sb.append((e = i.next()) == collection ? "(this Collection)" : Util.toStr(e));
            if (!i.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    public static String printArray(byte[] array) {
        return Util.printArray(array, false);
    }

    public static String printArray(byte[] array, boolean withHash) {
        if (array == null) {
            return "null";
        }
        int limit = 8;
        StringBuilder sb = new StringBuilder();
        sb.append("[B0x");
        if (array.length <= limit || IS_ARRAYS_DEBUG) {
            sb.append(Util.toHexString(array));
            if (withHash) {
                sb.append(",h=");
                sb.append(Integer.toHexString(Arrays.hashCode(array)));
                sb.append(']');
            }
        } else {
            sb.append(Util.toHexString(array, limit));
            sb.append("..[");
            sb.append(array.length);
            if (withHash) {
                sb.append("],h=");
                sb.append(Integer.toHexString(Arrays.hashCode(array)));
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public static String toHexString(byte[] input) {
        return Util.toHexString(input, input.length);
    }

    public static String toHexString(byte[] input, int limit) {
        if (input == null || input.length <= 0) {
            return null;
        }
        char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] result = new char[(input.length < limit ? input.length : limit) * 2];
        for (int i = 0; i < limit && i < input.length; ++i) {
            result[2 * i] = lookup[input[i] >> 4 & 0xF];
            result[2 * i + 1] = lookup[input[i] & 0xF];
        }
        return String.valueOf(result);
    }

    public static String padString(String s, int minWidth) {
        if (s.length() < minWidth) {
            StringBuilder sb = new StringBuilder(s);
            while (sb.length() < minWidth) {
                sb.append(" ");
            }
            return sb.toString();
        }
        return s;
    }

    public static String threadDump() {
        StringBuilder threadDump = new StringBuilder();
        ThreadMXBean threadMx = ManagementFactory.getThreadMXBean();
        if (threadMx.isObjectMonitorUsageSupported() && threadMx.isSynchronizerUsageSupported()) {
            Util.dumpThreadInfo(threadDump, true, threadMx);
        } else {
            Util.dumpThreadInfo(threadDump, false, threadMx);
        }
        return threadDump.toString();
    }

    private static void dumpThreadInfo(StringBuilder threadDump, boolean withLocks, ThreadMXBean threadMx) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = dateFormat.format(new Date());
        threadDump.append(timestamp);
        threadDump.append("\nFull thread dump ");
        threadDump.append("\n");
        if (withLocks) {
            ThreadInfo[] threadInfos;
            for (ThreadInfo threadInfo : threadInfos = threadMx.dumpAllThreads(true, true)) {
                Util.printThreadInfo(threadInfo, threadDump);
                LockInfo[] syncs = threadInfo.getLockedSynchronizers();
                Util.printLockInfo(syncs, threadDump);
            }
            threadDump.append("\n");
        } else {
            ThreadInfo[] threadInfos;
            long[] threadIds = threadMx.getAllThreadIds();
            for (ThreadInfo threadInfo : threadInfos = threadMx.getThreadInfo(threadIds, Integer.MAX_VALUE)) {
                Util.printThreadInfo(threadInfo, threadDump);
            }
        }
    }

    private static void printThreadInfo(ThreadInfo threadInfo, StringBuilder threadDump) {
        Util.printThread(threadInfo, threadDump);
        StackTraceElement[] stacktrace = threadInfo.getStackTrace();
        MonitorInfo[] monitors = threadInfo.getLockedMonitors();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            threadDump.append(INDENT + "at " + ste.toString());
            threadDump.append("\n");
            for (int j = 1; j < monitors.length; ++j) {
                MonitorInfo mi = monitors[j];
                if (mi.getLockedStackDepth() != i) continue;
                threadDump.append(INDENT + "  - locked " + mi);
                threadDump.append("\n");
            }
        }
        threadDump.append("\n");
    }

    private static void printLockInfo(LockInfo[] locks, StringBuilder threadDump) {
        threadDump.append(INDENT + "Locked synchronizers: count = " + locks.length);
        threadDump.append("\n");
        for (LockInfo li : locks) {
            threadDump.append(INDENT + "  - " + li);
            threadDump.append("\n");
        }
        threadDump.append("\n");
    }

    private static void printThread(ThreadInfo threadInfo, StringBuilder threadDump) {
        StringBuilder sb = new StringBuilder("\"" + threadInfo.getThreadName() + "\"" + " nid=" + threadInfo.getThreadId() + " state=" + (Object)((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null && threadInfo.getThreadState() != Thread.State.BLOCKED) {
            String[] lockInfo = threadInfo.getLockName().split("@");
            sb.append("\n" + INDENT + "- waiting on <0x" + lockInfo[1] + "> (a " + lockInfo[0] + ")");
            sb.append("\n" + INDENT + "- locked <0x" + lockInfo[1] + "> (a " + lockInfo[0] + ")");
        } else if (threadInfo.getLockName() != null && threadInfo.getThreadState() == Thread.State.BLOCKED) {
            String[] lockInfo = threadInfo.getLockName().split("@");
            sb.append("\n" + INDENT + "- waiting to lock <0x" + lockInfo[1] + "> (a " + lockInfo[0] + ")");
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (running in native)");
        }
        threadDump.append(sb.toString());
        threadDump.append("\n");
        if (threadInfo.getLockOwnerName() != null) {
            threadDump.append(INDENT + " owned by " + threadInfo.getLockOwnerName() + " id=" + threadInfo.getLockOwnerId());
            threadDump.append("\n");
        }
    }

    public static CacheException rewrapAsCacheException(Throwable t) {
        if (t instanceof CacheException) {
            return (CacheException)t;
        }
        return new CacheException(t);
    }

    public static <T> Set<T> asSet(T ... a) {
        if (a.length > 1) {
            return new HashSet<T>(Arrays.asList(a));
        }
        return Collections.singleton(a[0]);
    }

    public static String hexIdHashCode(Object o) {
        return Integer.toHexString(System.identityHashCode(o));
    }

    public static String hexDump(byte[] buffer) {
        StringBuilder buf = new StringBuilder(buffer.length << 1);
        for (byte b : buffer) {
            Util.addHexByte(buf, b);
        }
        return buf.toString();
    }

    public static String hexDump(ByteBuffer buffer) {
        byte[] data = new byte[buffer.remaining()];
        int pos = buffer.position();
        buffer.get(data);
        buffer.position(pos);
        StringBuilder buf = new StringBuilder(buffer.remaining() + 22);
        for (byte b : data) {
            Util.addHexByte(buf, b);
        }
        return buf.toString();
    }

    private static void addHexByte(StringBuilder buf, byte b) {
        buf.append(HEX_VALUES.charAt((b & 0xF0) >> 4)).append(HEX_VALUES.charAt(b & 0xF));
    }

    public static Double constructDouble(Class<?> type, Object o) {
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (double)((Long)o);
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (Double)o;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (double)((Integer)o);
        }
        if (type.equals(String.class)) {
            return Double.valueOf((String)o);
        }
        throw new IllegalStateException(String.format("Expected a value that can be converted into a double: type=%s, value=%s", type, o));
    }

    public static int getNormalizedHash(Object object, Hash hashFct) {
        return hashFct.hash(object) & Integer.MAX_VALUE;
    }

    public static int getSegmentSize(int numSegments) {
        return (int)Math.ceil(2.147483648E9 / (double)numSegments);
    }

    public static boolean isIBMJavaVendor() {
        return javaVendor.toLowerCase().contains("ibm");
    }

    public static String join(List<String> strings, String separator) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String string : strings) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            sb.append(string);
        }
        return sb.toString();
    }

    public static int findNextHighestPowerOfTwo(int num) {
        if (num <= 0) {
            return 1;
        }
        int highestBit = Integer.highestOneBit(num);
        return num <= highestBit ? highestBit : highestBit << 1;
    }

    public static int hashCode(byte[] bytes, int size) {
        int contentLimit = size;
        if (size > bytes.length) {
            contentLimit = bytes.length;
        }
        int hashCode = 1;
        for (int i = 0; i < contentLimit; ++i) {
            hashCode = 31 * hashCode + bytes[i];
        }
        return hashCode;
    }

    public static String prettyPrintSubject(Subject subject) {
        return subject == null ? "null" : "Subject with principal(s): " + Util.toStr(subject.getPrincipals());
    }

    @SafeVarargs
    public static <T> T[] arrayConcat(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    static {
        EMPTY_OBJECT_ARRAY = new Object[0];
        EMPTY_BYTE_ARRAY = new byte[0];
        log = LogFactory.getLog(Util.class);
        javaVendor = SecurityActions.getProperty("java.vendor", "");
        boolean osgi = false;
        try {
            osgi = Util.class.getClassLoader() instanceof BundleReference;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        IS_OSGI_CONTEXT = osgi;
        INDENT = "    ";
    }
}

