/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

final class SecurityActions {
    SecurityActions() {
    }

    static String getProperty(String name, String defaultValue) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEGED.getProperty(name, defaultValue);
        }
        return SysProps.PRIVILEGED.getProperty(name, defaultValue);
    }

    static String getProperty(String name) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEGED.getProperty(name);
        }
        return SysProps.PRIVILEGED.getProperty(name);
    }

    static interface SysProps {
        public static final SysProps NON_PRIVILEGED = new SysProps(){

            @Override
            public String getProperty(String name, String defaultValue) {
                return System.getProperty(name, defaultValue);
            }

            @Override
            public String getProperty(String name) {
                return System.getProperty(name);
            }
        };
        public static final SysProps PRIVILEGED = new SysProps(){

            @Override
            public String getProperty(final String name, final String defaultValue) {
                PrivilegedAction<String> action = new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(name, defaultValue);
                    }
                };
                return AccessController.doPrivileged(action);
            }

            @Override
            public String getProperty(final String name) {
                PrivilegedAction<String> action = new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(name);
                    }
                };
                return AccessController.doPrivileged(action);
            }
        };

        public String getProperty(String var1, String var2);

        public String getProperty(String var1);
    }
}

