/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.services.identitymanagement.model.SigningCertificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSigningCertificatesResult {
    private List<SigningCertificate> certificates;
    private Boolean isTruncated;
    private String marker;

    public List<SigningCertificate> getCertificates() {
        if (this.certificates == null) {
            this.certificates = new ArrayList<SigningCertificate>();
        }
        return this.certificates;
    }

    public void setCertificates(Collection<SigningCertificate> certificates) {
        if (certificates == null) {
            this.certificates = null;
            return;
        }
        ArrayList<SigningCertificate> certificatesCopy = new ArrayList<SigningCertificate>(certificates.size());
        certificatesCopy.addAll(certificates);
        this.certificates = certificatesCopy;
    }

    public ListSigningCertificatesResult withCertificates(SigningCertificate ... certificates) {
        if (this.getCertificates() == null) {
            this.setCertificates(new ArrayList<SigningCertificate>(certificates.length));
        }
        for (SigningCertificate value : certificates) {
            this.getCertificates().add(value);
        }
        return this;
    }

    public ListSigningCertificatesResult withCertificates(Collection<SigningCertificate> certificates) {
        if (certificates == null) {
            this.certificates = null;
        } else {
            ArrayList<SigningCertificate> certificatesCopy = new ArrayList<SigningCertificate>(certificates.size());
            certificatesCopy.addAll(certificates);
            this.certificates = certificatesCopy;
        }
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public ListSigningCertificatesResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListSigningCertificatesResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificates != null) {
            sb.append("Certificates: " + this.certificates + ", ");
        }
        if (this.isTruncated != null) {
            sb.append("IsTruncated: " + this.isTruncated + ", ");
        }
        if (this.marker != null) {
            sb.append("Marker: " + this.marker + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificates() == null ? 0 : ((Object)this.getCertificates()).hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSigningCertificatesResult)) {
            return false;
        }
        ListSigningCertificatesResult other = (ListSigningCertificatesResult)obj;
        if (other.getCertificates() == null ^ this.getCertificates() == null) {
            return false;
        }
        if (other.getCertificates() != null && !((Object)other.getCertificates()).equals(this.getCertificates())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }
}

