/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.version;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.util.OHostInfo;
import com.orientechnologies.orient.core.version.ODistributedVersion;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OSimpleVersion;

public class OVersionFactory {
    private static final OVersionFactory instance = new OVersionFactory();
    private static final boolean useDistributed = OGlobalConfiguration.DB_USE_DISTRIBUTED_VERSION.getValueAsBoolean();
    private static final long macAddress = useDistributed ? OVersionFactory.convertMacToLong(OHostInfo.getMac()) : 0L;

    private static long convertMacToLong(byte[] mac) {
        long result = 0L;
        for (int i = mac.length - 1; i >= 0; --i) {
            result = result << 8 | (long)(mac[i] & 0xFF);
        }
        return result;
    }

    public ORecordVersion createVersion() {
        if (useDistributed) {
            return new ODistributedVersion(0);
        }
        return new OSimpleVersion();
    }

    public ORecordVersion createTombstone() {
        if (useDistributed) {
            return new ODistributedVersion(-1);
        }
        return new OSimpleVersion(-1);
    }

    public ORecordVersion createUntrackedVersion() {
        if (useDistributed) {
            return new ODistributedVersion(-1);
        }
        return new OSimpleVersion(-1);
    }

    public static OVersionFactory instance() {
        return instance;
    }

    long getMacAddress() {
        return macAddress;
    }

    public boolean isDistributed() {
        return useDistributed;
    }

    public int getVersionSize() {
        if (useDistributed) {
            return 20;
        }
        return 4;
    }

    public ODistributedVersion createDistributedVersion(int recordVersion, long timestamp, long macAddress) {
        return new ODistributedVersion(recordVersion, timestamp, macAddress);
    }
}

