/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.util;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ODateHelper {
    public static final String DEF_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEF_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";

    public static Calendar getDatabaseCalendar() {
        return Calendar.getInstance(ODateHelper.getDatabaseTimeZone());
    }

    public static TimeZone getDatabaseTimeZone() {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && !db.isClosed()) {
            return ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().getTimeZone();
        }
        return TimeZone.getDefault();
    }

    public static DateFormat getDateFormatInstance() {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && !db.isClosed()) {
            return db.getStorage().getConfiguration().getDateFormatInstance();
        }
        return new SimpleDateFormat(DEF_DATE_FORMAT);
    }

    public static String getDateFormat() {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && !db.isClosed()) {
            return db.getStorage().getConfiguration().getDateFormat();
        }
        return DEF_DATE_FORMAT;
    }

    public static DateFormat getDateTimeFormatInstance() {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && !db.isClosed()) {
            return db.getStorage().getConfiguration().getDateTimeFormatInstance();
        }
        return new SimpleDateFormat(DEF_DATETIME_FORMAT);
    }

    public static String getDateTimeFormat() {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && !db.isClosed()) {
            return db.getStorage().getConfiguration().getDateTimeFormat();
        }
        return DEF_DATETIME_FORMAT;
    }

    public static Date now() {
        return ODateHelper.getDatabaseCalendar().getTime();
    }
}

