/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree.provider;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProvider;
import com.orientechnologies.orient.core.version.OVersionFactory;

public abstract class OMVRBTreeProviderAbstract<K, V>
implements OMVRBTreeProvider<K, V>,
OSerializableStream {
    private static final long serialVersionUID = 1L;
    protected final String clusterName;
    protected final int clusterId;
    protected final ORecordInternal<?> record;
    protected final OStorage storage;
    protected int size;
    protected int pageSize;
    protected ORecordId root;
    protected int keySize = 1;

    public OMVRBTreeProviderAbstract(ORecordInternal<?> iRecord, OStorage iStorage, String iClusterName) {
        this.storage = iStorage;
        this.clusterName = iClusterName;
        this.clusterId = this.storage != null ? (this.clusterName != null ? this.storage.getClusterIdByName(iClusterName) : this.storage.getClusterIdByName("index")) : -1;
        this.record = iRecord;
        this.record.setIdentity(new ORecordId());
        this.updateConfig();
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getDefaultPageSize() {
        return this.pageSize;
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    public ORID getRoot() {
        return this.root;
    }

    @Override
    public boolean setSize(int iSize) {
        if (iSize != this.size) {
            this.size = iSize;
            return this.setDirty();
        }
        return false;
    }

    @Override
    public boolean setRoot(ORID iRid) {
        if (this.root == null) {
            this.root = new ORecordId();
        }
        if (iRid == null) {
            this.root.reset();
        } else if (!iRid.equals(this.root)) {
            this.root.copyFrom(iRid);
        }
        return this.setDirty();
    }

    @Override
    public boolean isDirty() {
        return this.record.isDirty();
    }

    @Override
    public boolean setDirty() {
        if (this.record.isDirty()) {
            return false;
        }
        this.record.setDirty();
        return true;
    }

    @Override
    public boolean updateConfig() {
        boolean isChanged = false;
        int newSize = OGlobalConfiguration.MVRBTREE_NODE_PAGE_SIZE.getValueAsInteger();
        if (newSize != this.pageSize) {
            this.pageSize = newSize;
            isChanged = true;
        }
        return isChanged ? this.setDirty() : false;
    }

    @Override
    public void load() {
        if (this.storage == null) {
            this.load(OMVRBTreeProviderAbstract.getDatabase());
        } else {
            this.load(this.storage);
        }
    }

    protected void load(ODatabaseRecord iDb) {
        if (!this.record.getIdentity().isValid()) {
            return;
        }
        this.record.reload();
        this.fromStream(this.record.toStream());
    }

    protected void load(OStorage iSt) {
        if (!this.record.getIdentity().isValid()) {
            return;
        }
        ORawBuffer raw = iSt.readRecord((ORecordId)this.record.getIdentity(), null, false, null, false, OStorage.LOCKING_STRATEGY.DEFAULT).getResult();
        if (raw == null) {
            throw new OConfigurationException("Cannot load map with id " + this.record.getIdentity());
        }
        this.record.getRecordVersion().copyFrom(raw.version);
        this.fromStream(raw.buffer);
    }

    protected void save(ODatabaseRecord iDb) {
        for (int i = 0; i < 3; ++i) {
            try {
                this.record.fromStream(this.toStream());
                this.record.setDirty();
                this.record.save(this.clusterName);
                break;
            }
            catch (OConcurrentModificationException e) {
                this.record.reload();
                continue;
            }
        }
    }

    @Override
    public void save() {
        if (this.storage == null) {
            this.save(OMVRBTreeProviderAbstract.getDatabase());
        } else {
            this.save(this.storage);
        }
    }

    protected void save(OStorage iSt) {
        this.record.fromStream(this.toStream());
        if (this.record.getIdentity().isValid()) {
            this.record.getRecordVersion().copyFrom(iSt.updateRecord((ORecordId)this.record.getIdentity(), this.record.toStream(), OVersionFactory.instance().createUntrackedVersion(), this.record.getRecordType(), 0, null).getResult());
        } else {
            if (this.record.getIdentity().getClusterId() == -1) {
                ((ORecordId)this.record.getIdentity()).clusterId = this.clusterId;
            }
            OPhysicalPosition ppos = iSt.createRecord(0, (ORecordId)this.record.getIdentity(), this.record.toStream(), OVersionFactory.instance().createVersion(), this.record.getRecordType(), 0, null).getResult();
            this.record.getRecordVersion().copyFrom(ppos.recordVersion);
        }
        this.record.unsetDirty();
    }

    @Override
    public void delete() {
        if (this.storage == null) {
            this.delete(OMVRBTreeProviderAbstract.getDatabase());
        } else {
            this.delete(this.storage);
        }
        this.root = null;
    }

    protected void delete(ODatabaseRecord iDb) {
        for (int i = 0; i < 3; ++i) {
            try {
                iDb.delete(this.record);
                break;
            }
            catch (OConcurrentModificationException e) {
                this.record.reload();
                continue;
            }
        }
    }

    protected void delete(OStorage iSt) {
        iSt.deleteRecord((ORecordId)this.record.getIdentity(), this.record.getRecordVersion(), 0, null);
    }

    public String toString() {
        return "index " + this.record.getIdentity();
    }

    public int hashCode() {
        ORID rid = this.record.getIdentity();
        return rid == null ? 0 : rid.hashCode();
    }

    public ORecord<?> getRecord() {
        return this.record;
    }

    protected static ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }
}

