/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree.provider;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OBooleanSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeEntryDataProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeEntryDataProviderAbstract;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeMapProvider;
import java.io.IOException;
import java.util.Arrays;

public class OMVRBTreeMapEntryProvider<K, V>
extends OMVRBTreeEntryDataProviderAbstract<K, V> {
    private static final int CURRENT_VERSION = -1;
    private static final OProfilerMBean PROFILER = Orient.instance().getProfiler();
    private static final long serialVersionUID = 1L;
    protected K[] keys;
    protected V[] values;
    protected int[] serializedKeys;
    protected int[] serializedValues;
    private byte[] buffer;

    public OMVRBTreeMapEntryProvider(OMVRBTreeMapProvider<K, V> iTreeDataProvider) {
        super(iTreeDataProvider, 1024);
        this.keys = new Object[this.pageSize];
        this.values = new Object[this.pageSize];
        this.serializedKeys = new int[this.pageSize];
        this.serializedValues = new int[this.pageSize];
    }

    public OMVRBTreeMapEntryProvider(OMVRBTreeMapProvider<K, V> iTreeDataProvider, ORID iRID) {
        super(iTreeDataProvider, iRID);
    }

    @Override
    public K getKeyAt(int iIndex) {
        Object k = this.keys[iIndex];
        if (k == null) {
            try {
                PROFILER.updateCounter(PROFILER.getProcessMetric("mvrbtree.entry.unserializeKey"), "Deserialize a MVRBTree entry key", 1L);
                k = this.keyFromStream(iIndex);
                if (iIndex == 0 || iIndex == this.size || ((OMVRBTreeMapProvider)this.treeDataProvider).keepKeysInMemory) {
                    this.keys[iIndex] = k;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Cannot lazy load the key #" + iIndex + " in tree node " + this, (Throwable)e, OSerializationException.class, new Object[0]);
            }
        }
        return k;
    }

    @Override
    public V getValueAt(int iIndex) {
        Object v = this.values[iIndex];
        if (v == null) {
            try {
                PROFILER.updateCounter(PROFILER.getProcessMetric("mvrbtree.entry.unserializeValue"), "Deserialize a MVRBTree entry value", 1L);
                v = this.valueFromStream(iIndex);
                if (((OMVRBTreeMapProvider)this.treeDataProvider).keepValuesInMemory) {
                    this.values[iIndex] = v;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Cannot lazy load the value #" + iIndex + " in tree node " + this, (Throwable)e, OSerializationException.class, new Object[0]);
            }
        }
        return v;
    }

    @Override
    public boolean setValueAt(int iIndex, V iValue) {
        this.values[iIndex] = iValue;
        this.serializedValues[iIndex] = 0;
        return this.setDirty();
    }

    @Override
    public boolean insertAt(int iIndex, K iKey, V iValue) {
        if (iIndex < this.size) {
            System.arraycopy(this.keys, iIndex, this.keys, iIndex + 1, this.size - iIndex);
            System.arraycopy(this.values, iIndex, this.values, iIndex + 1, this.size - iIndex);
            System.arraycopy(this.serializedKeys, iIndex, this.serializedKeys, iIndex + 1, this.size - iIndex);
            System.arraycopy(this.serializedValues, iIndex, this.serializedValues, iIndex + 1, this.size - iIndex);
        }
        this.keys[iIndex] = iKey;
        this.values[iIndex] = iValue;
        this.serializedKeys[iIndex] = 0;
        this.serializedValues[iIndex] = 0;
        ++this.size;
        return this.setDirty();
    }

    @Override
    public boolean removeAt(int iIndex) {
        if (iIndex != this.size - 1 && iIndex > -1) {
            System.arraycopy(this.keys, iIndex + 1, this.keys, iIndex, this.size - iIndex - 1);
            System.arraycopy(this.values, iIndex + 1, this.values, iIndex, this.size - iIndex - 1);
            System.arraycopy(this.serializedKeys, iIndex + 1, this.serializedKeys, iIndex, this.size - iIndex - 1);
            System.arraycopy(this.serializedValues, iIndex + 1, this.serializedValues, iIndex, this.size - iIndex - 1);
        }
        --this.size;
        this.serializedKeys[this.size] = 0;
        this.serializedValues[this.size] = 0;
        this.keys[this.size] = null;
        this.values[this.size] = null;
        return this.setDirty();
    }

    @Override
    public boolean copyDataFrom(OMVRBTreeEntryDataProvider<K, V> iFrom, int iStartPosition) {
        OMVRBTreeMapEntryProvider parent = (OMVRBTreeMapEntryProvider)iFrom;
        this.size = iFrom.getSize() - iStartPosition;
        System.arraycopy(parent.serializedKeys, iStartPosition, this.serializedKeys, 0, this.size);
        System.arraycopy(parent.serializedValues, iStartPosition, this.serializedValues, 0, this.size);
        System.arraycopy(parent.keys, iStartPosition, this.keys, 0, this.size);
        System.arraycopy(parent.values, iStartPosition, this.values, 0, this.size);
        if (this.buffer == null && parent.buffer == null) {
            this.stream = null;
            return this.setDirty();
        }
        if (parent.buffer == null) {
            this.buffer = null;
            this.stream = null;
            return this.setDirty();
        }
        if (this.buffer == null || this.buffer.length < parent.buffer.length) {
            this.buffer = new byte[parent.buffer.length];
        }
        System.arraycopy(parent.buffer, 0, this.buffer, 0, parent.buffer.length);
        if (this.buffer == null) {
            this.stream = null;
        } else if (this.stream != null) {
            this.stream.setSource(this.buffer);
        } else {
            this.stream = new OMemoryStream(this.buffer);
        }
        return this.setDirty();
    }

    @Override
    public boolean truncate(int iNewSize) {
        Arrays.fill(this.serializedKeys, iNewSize, this.pageSize, 0);
        Arrays.fill(this.serializedValues, iNewSize, this.pageSize, 0);
        Arrays.fill(this.keys, iNewSize, this.size, null);
        Arrays.fill(this.values, iNewSize, this.size, null);
        this.size = iNewSize;
        return this.setDirty();
    }

    @Override
    public boolean copyFrom(OMVRBTreeEntryDataProvider<K, V> iSource) {
        OMVRBTreeMapEntryProvider source = (OMVRBTreeMapEntryProvider)iSource;
        this.serializedKeys = new int[source.serializedKeys.length];
        System.arraycopy(source.serializedKeys, 0, this.serializedKeys, 0, source.serializedKeys.length);
        this.serializedValues = new int[source.serializedValues.length];
        System.arraycopy(source.serializedValues, 0, this.serializedValues, 0, source.serializedValues.length);
        this.keys = new Object[source.keys.length];
        System.arraycopy(source.keys, 0, this.keys, 0, source.keys.length);
        this.values = new Object[source.values.length];
        System.arraycopy(source.values, 0, this.values, 0, source.values.length);
        this.size = source.size;
        if (this.buffer == null && source.buffer == null) {
            this.stream = null;
            return this.setDirty();
        }
        if (source.buffer == null) {
            this.buffer = null;
            this.stream = null;
            return this.setDirty();
        }
        if (this.buffer == null || this.buffer.length < source.buffer.length) {
            this.buffer = new byte[source.buffer.length];
        }
        System.arraycopy(source.buffer, 0, this.buffer, 0, source.buffer.length);
        if (this.buffer == null) {
            this.stream = null;
        } else if (this.stream != null) {
            this.stream.setSource(this.buffer);
        } else {
            this.stream = new OMemoryStream(this.buffer);
        }
        return this.setDirty();
    }

    @Override
    public void delete() {
        super.delete();
        this.keys = null;
        this.values = null;
        this.serializedKeys = null;
        this.serializedValues = null;
    }

    @Override
    public void clear() {
        super.clear();
        this.buffer = null;
        this.keys = null;
        this.values = null;
        this.serializedKeys = null;
        this.serializedValues = null;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        long timer = PROFILER.startChrono();
        try {
            if (OIntegerSerializer.INSTANCE.deserialize(iStream, 0) >= 0) {
                OLogManager.instance().warn((Object)this, "Previous version of serialization format was found for node with id " + this.record.getIdentity() + " conversion to new format will be performed." + " It will take some time. If this message is shown constantly please recreate indexes.", new Object[0]);
                iStream = this.convertIntoNewSerializationFormat(iStream);
                OLogManager.instance().warn((Object)this, "Conversion of data to new serialization format for node " + this.record.getIdentity() + " was finished. ", new Object[0]);
            }
            if (((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer instanceof OBinarySerializer) {
                this.fromStreamUsingBinarySerializer(iStream);
            } else {
                this.fromStreamUsingBinaryStreamSerializer(iStream);
            }
            OMVRBTreeMapEntryProvider oMVRBTreeMapEntryProvider = this;
            return oMVRBTreeMapEntryProvider;
        }
        catch (IOException e) {
            throw new OSerializationException("Can not unmarshall tree node with id ", e);
        }
        finally {
            PROFILER.stopChrono(PROFILER.getProcessMetric("mvrbtree.entry.fromStream"), "Deserialize a MVRBTree entry", timer);
        }
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        long timer = PROFILER.startChrono();
        try {
            if (((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer instanceof OBinarySerializer) {
                this.toStreamUsingBinarySerializer();
            } else {
                this.toStreamUsingBinaryStreamSerializer();
            }
            this.record.fromStream(this.buffer);
            byte[] byArray = this.buffer;
            return byArray;
        }
        catch (IOException e) {
            throw new OSerializationException("Cannot marshall RB+Tree node", e);
        }
        finally {
            PROFILER.stopChrono(PROFILER.getProcessMetric("mvrbtree.entry.toStream"), "Serialize a MVRBTree entry", timer);
        }
    }

    private void toStreamUsingBinarySerializer() {
        int i;
        int i2;
        int bufferSize = 8;
        bufferSize += OLinkSerializer.INSTANCE.getObjectSize(this.parentRid, new Object[0]) * 3;
        ++bufferSize;
        bufferSize += 4;
        for (i2 = 0; i2 < this.size; ++i2) {
            bufferSize += this.getKeySize(i2);
        }
        for (i2 = 0; i2 < this.size; ++i2) {
            bufferSize += this.getBinaryValueSize(i2);
        }
        byte[] outBuffer = new byte[bufferSize];
        int offset = this.serializeMetadata(outBuffer, this.size, this.pageSize, this.parentRid, this.leftRid, this.rightRid, this.color);
        for (i = 0; i < this.size; ++i) {
            offset = this.serializeKey(outBuffer, offset, i);
        }
        for (i = 0; i < this.size; ++i) {
            offset = this.serializeBinaryValue(outBuffer, offset, i);
        }
        this.buffer = outBuffer;
    }

    private int serializeMetadata(byte[] newBuffer, int iSize, int iPageSize, ORID iParentId, ORID iLeftRid, ORID iRightRid, boolean iColor) {
        int offset = 0;
        OIntegerSerializer.INSTANCE.serialize(Integer.valueOf(-1), newBuffer, offset, new Object[0]);
        OIntegerSerializer.INSTANCE.serialize(Integer.valueOf(iPageSize), newBuffer, offset += 4, new Object[0]);
        OLinkSerializer.INSTANCE.serialize(iParentId, newBuffer, offset += 4, new Object[0]);
        OLinkSerializer.INSTANCE.serialize(iLeftRid, newBuffer, offset += OLinkSerializer.INSTANCE.getObjectSize(iParentId, new Object[0]), new Object[0]);
        OLinkSerializer.INSTANCE.serialize(iRightRid, newBuffer, offset += OLinkSerializer.INSTANCE.getObjectSize(iLeftRid, new Object[0]), new Object[0]);
        OBooleanSerializer.INSTANCE.serialize(Boolean.valueOf(iColor), newBuffer, offset += OLinkSerializer.INSTANCE.getObjectSize(iRightRid, new Object[0]), new Object[0]);
        OIntegerSerializer.INSTANCE.serialize(Integer.valueOf(iSize), newBuffer, ++offset, new Object[0]);
        return offset += 4;
    }

    private int deserializeMetadata(byte[] inBuffer) {
        int offset = 0;
        int currentVersion = OIntegerSerializer.INSTANCE.deserialize(inBuffer, offset);
        offset += 4;
        if (currentVersion != -1) {
            throw new OSerializationException("MVRBTree node is stored using " + currentVersion + " version of serialization format but current version is " + -1 + ".");
        }
        this.pageSize = OIntegerSerializer.INSTANCE.deserialize(inBuffer, offset);
        this.parentRid = OLinkSerializer.INSTANCE.deserialize(inBuffer, offset += 4);
        this.leftRid = OLinkSerializer.INSTANCE.deserialize(inBuffer, offset += OLinkSerializer.INSTANCE.getObjectSize(this.parentRid, new Object[0]));
        this.rightRid = OLinkSerializer.INSTANCE.deserialize(inBuffer, offset += OLinkSerializer.INSTANCE.getObjectSize(this.leftRid, new Object[0]));
        this.color = OBooleanSerializer.INSTANCE.deserialize(inBuffer, offset += OLinkSerializer.INSTANCE.getObjectSize(this.rightRid, new Object[0]));
        this.size = OIntegerSerializer.INSTANCE.deserialize(inBuffer, ++offset);
        offset += 4;
        if (this.size > this.pageSize) {
            throw new OConfigurationException("Loaded index with page size set to " + this.pageSize + " while the loaded was built with: " + this.size);
        }
        return offset;
    }

    private int serializeBinaryValue(byte[] newBuffer, int offset, int i) {
        OBinarySerializer valueSerializer = (OBinarySerializer)((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer;
        if (this.serializedValues[i] <= 0) {
            PROFILER.updateCounter(PROFILER.getProcessMetric("mvrbtree.entry.serializeValue"), "Serialize a MVRBTree entry value", 1L);
            valueSerializer.serialize(this.values[i], newBuffer, offset, new Object[0]);
            offset += valueSerializer.getObjectSize(this.values[i], new Object[0]);
        } else {
            int size = valueSerializer.getObjectSize(this.buffer, this.serializedValues[i]);
            System.arraycopy(this.buffer, this.serializedValues[i], newBuffer, offset, size);
            this.serializedValues[i] = offset;
            offset += size;
        }
        return offset;
    }

    private int serializeKey(byte[] newBuffer, int offset, int i) {
        OBinarySerializer keySerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer;
        if (this.serializedKeys[i] <= 0) {
            PROFILER.updateCounter(PROFILER.getProcessMetric("mvrbtree.entry.serializeKey"), "Serialize a MVRBTree entry key", 1L);
            keySerializer.serialize(this.keys[i], newBuffer, offset, new Object[0]);
            offset += keySerializer.getObjectSize(this.keys[i], new Object[0]);
        } else {
            int size = keySerializer.getObjectSize(this.buffer, this.serializedKeys[i]);
            System.arraycopy(this.buffer, this.serializedKeys[i], newBuffer, offset, size);
            this.serializedKeys[i] = offset;
            offset += size;
        }
        return offset;
    }

    private int getKeySize(int iIndex) {
        OBinarySerializer serializer = ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer;
        if (this.serializedKeys[iIndex] <= 0) {
            return serializer.getObjectSize(this.keys[iIndex], new Object[0]);
        }
        return serializer.getObjectSize(this.buffer, this.serializedKeys[iIndex]);
    }

    private int getBinaryValueSize(int iIndex) {
        OBinarySerializer serializer = (OBinarySerializer)((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer;
        if (this.serializedValues[iIndex] <= 0) {
            return serializer.getObjectSize(this.values[iIndex], new Object[0]);
        }
        return serializer.getObjectSize(this.buffer, this.serializedValues[iIndex]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toStreamUsingBinaryStreamSerializer() throws IOException {
        int bufferSize = 8;
        bufferSize += OLinkSerializer.INSTANCE.getObjectSize(this.parentRid, new Object[0]) * 3;
        ++bufferSize;
        bufferSize += 4;
        for (int i = 0; i < this.size; ++i) {
            bufferSize += this.getKeySize(i);
        }
        byte[] outBuffer = new byte[bufferSize * 2];
        int offset = this.serializeMetadata(outBuffer, this.size, this.pageSize, this.parentRid, this.leftRid, this.rightRid, this.color);
        for (int i = 0; i < this.size; ++i) {
            offset = this.serializeKey(outBuffer, offset, i);
        }
        OMemoryStream outStream = new OMemoryStream(outBuffer);
        try {
            outStream.jump(offset);
            for (int i = 0; i < this.size; ++i) {
                this.serializedValues[i] = outStream.set(this.serializeStreamValue(i));
            }
            this.buffer = outStream.toByteArray();
        }
        finally {
            outStream.close();
        }
        if (this.stream == null) {
            this.stream = new OMemoryStream(this.buffer);
        } else {
            this.stream.setSource(this.buffer);
        }
    }

    private void fromStreamUsingBinarySerializer(byte[] inBuffer) {
        int offset = this.deserializeMetadata(inBuffer);
        this.serializedKeys = new int[this.pageSize];
        this.keys = new Object[this.pageSize];
        OBinarySerializer keySerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer;
        if (keySerializer == null) {
            throw new IllegalStateException("key serializer wasn't found");
        }
        for (int i = 0; i < this.size; ++i) {
            this.serializedKeys[i] = offset;
            offset += keySerializer.getObjectSize(inBuffer, offset);
        }
        this.serializedValues = new int[this.pageSize];
        this.values = new Object[this.pageSize];
        OBinarySerializer valueSerializer = (OBinarySerializer)((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer;
        if (valueSerializer == null) {
            throw new IllegalStateException("value serializer wasn't found");
        }
        for (int i = 0; i < this.size; ++i) {
            this.serializedValues[i] = offset;
            offset += valueSerializer.getObjectSize(inBuffer, offset);
        }
        this.buffer = inBuffer;
    }

    private void fromStreamUsingBinaryStreamSerializer(byte[] inBuffer) {
        int i;
        int offset = this.deserializeMetadata(inBuffer);
        this.serializedKeys = new int[this.pageSize];
        this.keys = new Object[this.pageSize];
        OBinarySerializer keySerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer;
        for (i = 0; i < this.size; ++i) {
            this.serializedKeys[i] = offset;
            offset += keySerializer.getObjectSize(inBuffer, offset);
        }
        this.serializedValues = new int[this.pageSize];
        this.values = new Object[this.pageSize];
        if (this.stream == null) {
            this.stream = new OMemoryStream(inBuffer);
        } else {
            this.stream.setSource(inBuffer);
        }
        this.stream.jump(offset);
        for (i = 0; i < this.size; ++i) {
            this.serializedValues[i] = this.stream.getAsByteArrayOffset();
        }
        this.buffer = inBuffer;
    }

    protected byte[] serializeStreamValue(int iIndex) throws IOException {
        if (this.serializedValues[iIndex] <= 0) {
            PROFILER.updateCounter(PROFILER.getProcessMetric("mvrbtree.entry.serializeValue"), "Serialize a MVRBTree entry value", 1L);
            return ((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer.toStream(this.values[iIndex]);
        }
        return this.stream.getAsByteArray(this.serializedValues[iIndex]);
    }

    protected Object keyFromStream(int iIndex) throws IOException {
        return ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer.deserialize(this.buffer, this.serializedKeys[iIndex]);
    }

    protected Object valueFromStream(int iIndex) throws IOException {
        OStreamSerializer valueSerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer;
        if (valueSerializer instanceof OBinarySerializer) {
            return ((OBinarySerializer)valueSerializer).deserialize(this.buffer, this.serializedValues[iIndex]);
        }
        return valueSerializer.fromStream(this.stream.getAsByteArray(this.serializedValues[iIndex]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] convertIntoNewSerializationFormat(byte[] stream) throws IOException {
        OMemoryStream oldStream = new OMemoryStream(stream);
        try {
            int oldPageSize = oldStream.getAsInteger();
            ORecordId oldParentRid = new ORecordId().fromStream(oldStream.getAsByteArrayFixed(ORecordId.PERSISTENT_SIZE));
            ORecordId oldLeftRid = new ORecordId().fromStream(oldStream.getAsByteArrayFixed(ORecordId.PERSISTENT_SIZE));
            ORecordId oldRightRid = new ORecordId().fromStream(oldStream.getAsByteArrayFixed(ORecordId.PERSISTENT_SIZE));
            boolean oldColor = oldStream.getAsBoolean();
            int oldSize = oldStream.getAsInteger();
            if (oldSize > oldPageSize) {
                throw new OConfigurationException("Loaded index with page size set to " + oldPageSize + " while the loaded was built with: " + oldSize);
            }
            Object[] oldKeys = new Object[oldPageSize];
            for (int i = 0; i < oldSize; ++i) {
                oldKeys[i] = ((OMVRBTreeMapProvider)this.treeDataProvider).streamKeySerializer.fromStream(oldStream.getAsByteArray());
            }
            Object[] oldValues = new Object[oldPageSize];
            for (int i = 0; i < oldSize; ++i) {
                oldValues[i] = ((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer.fromStream(oldStream.getAsByteArray());
            }
            byte[] result = ((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer instanceof OBinarySerializer ? this.convertNewSerializationFormatBinarySerializer(oldSize, oldPageSize, oldParentRid, oldLeftRid, oldRightRid, oldColor, oldKeys, oldValues) : this.convertNewSerializationFormatStreamSerializer(oldSize, oldPageSize, oldParentRid, oldLeftRid, oldRightRid, oldColor, oldKeys, oldValues);
            byte[] byArray = result;
            return byArray;
        }
        finally {
            oldStream.close();
        }
    }

    private byte[] convertNewSerializationFormatBinarySerializer(int oldSize, int oldPageSize, ORecordId oldParentRid, ORecordId oldLeftRid, ORecordId oldRightRid, boolean oldColor, K[] oldKeys, V[] oldValues) {
        int i;
        int i2;
        int bufferSize = 8;
        bufferSize += OLinkSerializer.INSTANCE.getObjectSize(oldParentRid, new Object[0]) * 3;
        ++bufferSize;
        bufferSize += 4;
        OBinarySerializer keySerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer;
        OBinarySerializer valueSerializer = (OBinarySerializer)((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer;
        for (i2 = 0; i2 < oldSize; ++i2) {
            bufferSize += keySerializer.getObjectSize(oldKeys[i2], new Object[0]);
        }
        for (i2 = 0; i2 < oldSize; ++i2) {
            bufferSize += valueSerializer.getObjectSize(oldValues[i2], new Object[0]);
        }
        byte[] outBuffer = new byte[bufferSize];
        int offset = this.serializeMetadata(outBuffer, oldSize, oldPageSize, oldParentRid, oldLeftRid, oldRightRid, oldColor);
        for (i = 0; i < oldSize; ++i) {
            keySerializer.serialize(oldKeys[i], outBuffer, offset, new Object[0]);
            offset += keySerializer.getObjectSize(oldKeys[i], new Object[0]);
        }
        for (i = 0; i < oldSize; ++i) {
            valueSerializer.serialize(oldValues[i], outBuffer, offset, new Object[0]);
            offset += valueSerializer.getObjectSize(oldValues[i], new Object[0]);
        }
        return outBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] convertNewSerializationFormatStreamSerializer(int oldSize, int oldPageSize, ORecordId oldParentRid, ORecordId oldLeftRid, ORecordId oldRightRid, boolean oldColor, K[] oldKeys, V[] oldValues) throws IOException {
        int bufferSize = 8;
        bufferSize += OLinkSerializer.INSTANCE.getObjectSize(oldParentRid, new Object[0]) * 3;
        ++bufferSize;
        bufferSize += 4;
        OBinarySerializer keySerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer;
        OStreamSerializer valueSerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer;
        for (int i = 0; i < oldSize; ++i) {
            bufferSize += keySerializer.getObjectSize(oldKeys[i], new Object[0]);
        }
        byte[] outBuffer = new byte[bufferSize * 2];
        int offset = this.serializeMetadata(outBuffer, oldSize, oldPageSize, oldParentRid, oldLeftRid, oldRightRid, oldColor);
        for (int i = 0; i < oldSize; ++i) {
            keySerializer.serialize(oldKeys[i], outBuffer, offset, new Object[0]);
            offset += keySerializer.getObjectSize(oldKeys[i], new Object[0]);
        }
        OMemoryStream outStream = new OMemoryStream(outBuffer);
        try {
            outStream.jump(offset);
            for (int i = 0; i < oldSize; ++i) {
                outStream.set(valueSerializer.toStream(oldValues[i]));
            }
            byte[] byArray = outStream.toByteArray();
            return byArray;
        }
        finally {
            outStream.close();
        }
    }
}

