/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordFlat;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class OTransactionRealAbstract
extends OTransactionAbstract {
    public static final ORecordFlat DELETED_RECORD = new ORecordFlat();
    private final OOperationUnitId operationUnitId;
    protected Map<ORID, ORecord<?>> temp2persistent = new HashMap();
    protected Map<ORID, ORecordOperation> allEntries = new HashMap<ORID, ORecordOperation>();
    protected Map<ORID, ORecordOperation> recordEntries = new LinkedHashMap<ORID, ORecordOperation>();
    protected Map<String, OTransactionIndexChanges> indexEntries = new LinkedHashMap<String, OTransactionIndexChanges>();
    protected Map<ORID, List<OTransactionRecordIndexOperation>> recordIndexOperations = new HashMap<ORID, List<OTransactionRecordIndexOperation>>();
    protected int id;
    protected int newObjectCounter = -2;

    protected OTransactionRealAbstract(ODatabaseRecordTx database, int id) {
        super(database);
        this.id = id;
        this.operationUnitId = OOperationUnitId.generateId();
    }

    @Override
    public void close() {
        super.close();
        this.temp2persistent.clear();
        this.allEntries.clear();
        this.recordEntries.clear();
        this.indexEntries.clear();
        this.recordIndexOperations.clear();
        this.newObjectCounter = -2;
        this.status = OTransaction.TXSTATUS.INVALID;
        this.database.setDefaultTransactionMode();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void clearRecordEntries() {
        for (Map.Entry<ORID, ORecordOperation> entry : this.recordEntries.entrySet()) {
            ORID key = entry.getKey();
            this.allEntries.put(key.isNew() ? key.copy() : key, entry.getValue());
        }
        this.recordEntries.clear();
    }

    @Override
    public int getEntryCount() {
        return this.recordEntries.size();
    }

    public Collection<ORecordOperation> getCurrentRecordEntries() {
        return this.recordEntries.values();
    }

    public Collection<ORecordOperation> getAllRecordEntries() {
        return this.allEntries.values();
    }

    @Override
    public ORecordOperation getRecordEntry(ORID rid) {
        ORecord<?> record;
        ORecordOperation e = this.allEntries.get(rid);
        if (e != null) {
            return e;
        }
        if (rid.isTemporary() && (record = this.temp2persistent.get(rid)) != null && !record.getIdentity().equals(rid)) {
            rid = record.getIdentity();
        }
        if ((e = this.recordEntries.get(rid)) != null) {
            return e;
        }
        e = this.allEntries.get(rid);
        if (e != null) {
            return e;
        }
        return null;
    }

    @Override
    public ORecordInternal<?> getRecord(ORID rid) {
        ORecordOperation e = this.getRecordEntry(rid);
        if (e != null) {
            if (e.type == 2) {
                return DELETED_RECORD;
            }
            return e.getRecord();
        }
        return null;
    }

    @Override
    public List<ORecordOperation> getRecordEntriesByClass(String iClassName) {
        ArrayList<ORecordOperation> result = new ArrayList<ORecordOperation>();
        if (iClassName == null || iClassName.length() == 0) {
            for (ORecordOperation entry : this.recordEntries.values()) {
                result.add(entry);
            }
        } else {
            for (ORecordOperation entry : this.recordEntries.values()) {
                if (entry.getRecord() == null || !(entry.getRecord() instanceof ODocument) || !iClassName.equals(((ODocument)entry.getRecord()).getClassName())) continue;
                result.add(entry);
            }
        }
        return result;
    }

    @Override
    public List<ORecordOperation> getNewRecordEntriesByClusterIds(int[] iIds) {
        ArrayList<ORecordOperation> result = new ArrayList<ORecordOperation>();
        if (iIds == null) {
            for (ORecordOperation entry : this.recordEntries.values()) {
                if (entry.type != 3) continue;
                result.add(entry);
            }
        } else {
            block1: for (ORecordOperation entry : this.recordEntries.values()) {
                for (int id : iIds) {
                    if (entry.getRecord() == null || entry.getRecord().getIdentity().getClusterId() != id || entry.type != 3) continue;
                    result.add(entry);
                    continue block1;
                }
            }
        }
        return result;
    }

    @Override
    public void clearIndexEntries() {
        this.indexEntries.clear();
        this.recordIndexOperations.clear();
    }

    @Override
    public List<String> getInvolvedIndexes() {
        ArrayList<String> list = null;
        for (String indexName : this.indexEntries.keySet()) {
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(indexName);
        }
        return list;
    }

    @Override
    public ODocument getIndexChanges() {
        ODocument result = new ODocument().setAllowChainedAccess(false);
        for (Map.Entry<String, OTransactionIndexChanges> indexEntry : this.indexEntries.entrySet()) {
            ODocument indexDoc = new ODocument().addOwner(result);
            result.field(indexEntry.getKey(), indexDoc, OType.EMBEDDED);
            if (indexEntry.getValue().cleared) {
                indexDoc.field("clear", Boolean.TRUE);
            }
            ArrayList<ODocument> entries = new ArrayList<ODocument>();
            indexDoc.field("entries", entries, OType.EMBEDDEDLIST);
            for (OTransactionIndexChangesPerKey entry : indexEntry.getValue().changesPerKey.values()) {
                entries.add(this.serializeIndexChangeEntry(entry, indexDoc));
            }
            indexDoc.field("nullEntries", this.serializeIndexChangeEntry(indexEntry.getValue().nullKeyChanges, indexDoc));
        }
        this.indexEntries.clear();
        return result;
    }

    @Override
    public OTransactionIndexChanges getIndexChanges(String iIndexName) {
        return this.indexEntries.get(iIndexName);
    }

    @Override
    public void addIndexEntry(OIndex<?> delegate, String iIndexName, OTransactionIndexChanges.OPERATION iOperation, Object key, OIdentifiable iValue) {
        OTransactionIndexChanges indexEntry = this.indexEntries.get(iIndexName);
        if (indexEntry == null) {
            indexEntry = new OTransactionIndexChanges();
            this.indexEntries.put(iIndexName, indexEntry);
        }
        if (iOperation == OTransactionIndexChanges.OPERATION.CLEAR) {
            indexEntry.setCleared();
        } else {
            if (iOperation == OTransactionIndexChanges.OPERATION.REMOVE && iValue != null && iValue.getIdentity().isTemporary()) {
                block0: for (OTransactionIndexChangesPerKey changes : indexEntry.changesPerKey.values()) {
                    for (int i = 0; i < changes.entries.size(); ++i) {
                        if (!changes.entries.get((int)i).value.equals(iValue)) continue;
                        changes.entries.remove(i);
                        continue block0;
                    }
                }
            }
            OTransactionIndexChangesPerKey changes = indexEntry.getChangesPerKey(key);
            changes.add(iValue, iOperation);
            if (iValue == null) {
                return;
            }
            List<OTransactionRecordIndexOperation> transactionIndexOperations = this.recordIndexOperations.get(iValue.getIdentity());
            if (transactionIndexOperations == null) {
                transactionIndexOperations = new ArrayList<OTransactionRecordIndexOperation>();
                this.recordIndexOperations.put(iValue.getIdentity().copy(), transactionIndexOperations);
            }
            transactionIndexOperations.add(new OTransactionRecordIndexOperation(iIndexName, key, iOperation));
        }
    }

    @Override
    public void updateIdentityAfterCommit(ORID oldRid, ORID newRid) {
        List<OTransactionRecordIndexOperation> transactionIndexOperations;
        if (oldRid.equals(newRid)) {
            return;
        }
        ORecordOperation rec = this.getRecordEntry(oldRid);
        if (rec != null) {
            if (this.allEntries.remove(oldRid) != null) {
                this.allEntries.put(newRid, rec);
            }
            if (this.recordEntries.remove(oldRid) != null) {
                this.recordEntries.put(newRid, rec);
            }
            if (!rec.getRecord().getIdentity().equals(newRid)) {
                rec.getRecord().onBeforeIdentityChanged(oldRid);
                ORecordId recordId = (ORecordId)rec.getRecord().getIdentity();
                if (recordId == null) {
                    rec.getRecord().setIdentity(new ORecordId(newRid));
                } else {
                    recordId.clusterPosition = newRid.getClusterPosition();
                    recordId.clusterId = newRid.getClusterId();
                }
                rec.getRecord().onAfterIdentityChanged(rec.getRecord());
            }
        }
        if ((transactionIndexOperations = this.recordIndexOperations.get(oldRid)) != null) {
            for (OTransactionRecordIndexOperation indexOperation : transactionIndexOperations) {
                OTransactionIndexChanges indexEntryChanges = this.indexEntries.get(indexOperation.index);
                if (indexEntryChanges == null) continue;
                OTransactionIndexChangesPerKey changesPerKey = indexEntryChanges.getChangesPerKey(indexOperation.key);
                this.updateChangesIdentity(oldRid, newRid, changesPerKey);
            }
        }
    }

    protected void checkTransaction() {
        if (this.status == OTransaction.TXSTATUS.INVALID) {
            throw new OTransactionException("Invalid state of the transaction. The transaction must be begun.");
        }
    }

    protected ODocument serializeIndexChangeEntry(OTransactionIndexChangesPerKey entry, ODocument indexDoc) {
        String key;
        ODocument keyContainer = new ODocument();
        try {
            if (entry.key != null) {
                if (entry.key instanceof OCompositeKey) {
                    List<Object> keys = ((OCompositeKey)entry.key).getKeys();
                    keyContainer.field("key", keys, OType.EMBEDDEDLIST);
                    keyContainer.field("binary", false);
                } else if (!(entry.key instanceof ORecordElement) && entry.key instanceof OSerializableStream) {
                    keyContainer.field("key", OStreamSerializerAnyStreamable.INSTANCE.toStream(entry.key), OType.BINARY);
                    keyContainer.field("binary", true);
                } else {
                    keyContainer.field("key", entry.key);
                    keyContainer.field("binary", false);
                }
                key = ORecordSerializerSchemaAware2CSV.INSTANCE.toString(keyContainer, null, false).toString();
            } else {
                key = null;
            }
        }
        catch (IOException ioe) {
            throw new OTransactionException("Error during index changes serialization. ", ioe);
        }
        ArrayList<ODocument> operations = new ArrayList<ODocument>();
        if (entry.entries != null && !entry.entries.isEmpty()) {
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry e : entry.entries) {
                ODocument changeDoc = new ODocument().addOwner(indexDoc).setAllowChainedAccess(false);
                changeDoc.field("o", e.operation.ordinal());
                if (e.value instanceof ORecord && e.value.getIdentity().isNew()) {
                    ORecord<?> saved = this.temp2persistent.get(e.value.getIdentity());
                    if (saved != null) {
                        e.value = saved;
                    } else {
                        ((ORecord)e.value).save();
                    }
                }
                changeDoc.field("v", e.value != null ? e.value.getIdentity() : null);
                operations.add(changeDoc);
            }
        }
        return new ODocument().addOwner(indexDoc).setAllowChainedAccess(false).field("k", key != null ? OStringSerializerHelper.encode(key) : null).field("ops", operations, OType.EMBEDDEDLIST);
    }

    private void updateChangesIdentity(ORID oldRid, ORID newRid, OTransactionIndexChangesPerKey changesPerKey) {
        if (changesPerKey == null) {
            return;
        }
        for (OTransactionIndexChangesPerKey.OTransactionIndexEntry indexEntry : changesPerKey.entries) {
            if (!indexEntry.value.getIdentity().equals(oldRid)) continue;
            indexEntry.value = newRid;
        }
    }

    public static final class OTransactionRecordIndexOperation {
        public String index;
        public Object key;
        public OTransactionIndexChanges.OPERATION operation;

        public OTransactionRecordIndexOperation(String index, Object key, OTransactionIndexChanges.OPERATION operation) {
            this.index = index;
            this.key = key;
            this.operation = operation;
        }
    }
}

