/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAwareAbstract;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.tx.ORollbackException;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class OTransactionOptimistic
extends OTransactionRealAbstract {
    private static final boolean useSBTree = OGlobalConfiguration.INDEX_USE_SBTREE_BY_DEFAULT.getValueAsBoolean();
    private static AtomicInteger txSerial = new AtomicInteger();
    private boolean usingLog = true;
    private int txStartCounter;

    public OTransactionOptimistic(ODatabaseRecordTx iDatabase) {
        super(iDatabase, txSerial.incrementAndGet());
    }

    @Override
    public void begin() {
        if (this.txStartCounter == 0) {
            this.status = OTransaction.TXSTATUS.BEGUN;
        }
        ++this.txStartCounter;
        if (this.txStartCounter > 1) {
            OLogManager.instance().debug((Object)this, "Transaction was already started and will be reused.", new Object[0]);
        }
    }

    @Override
    public void commit() {
        this.commit(false);
    }

    @Override
    public void commit(boolean force) {
        this.checkTransaction();
        this.txStartCounter = force ? 0 : --this.txStartCounter;
        if (this.txStartCounter == 0) {
            this.doCommit();
        } else if (this.txStartCounter > 0) {
            OLogManager.instance().debug((Object)this, "Nested transaction was closed but transaction itself was not committed.", new Object[0]);
        } else {
            throw new OTransactionException("Transaction was committed more times than it is started.");
        }
    }

    @Override
    public int amountOfNestedTxs() {
        return this.txStartCounter;
    }

    @Override
    public void rollback() {
        this.rollback(false, -1);
    }

    @Override
    public void rollback(boolean force, int commitLevelDiff) {
        this.checkTransaction();
        this.txStartCounter += commitLevelDiff;
        this.status = OTransaction.TXSTATUS.ROLLBACKING;
        if (!force && this.txStartCounter > 0) {
            OLogManager.instance().debug((Object)this, "Nested transaction was closed but transaction itself was scheduled for rollback.", new Object[0]);
            return;
        }
        if (this.txStartCounter < 0) {
            throw new OTransactionException("Transaction was rolled back more times than it was started.");
        }
        this.database.getStorage().callInLock(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                OTransactionOptimistic.this.database.getStorage().rollback(OTransactionOptimistic.this);
                return null;
            }
        }, true);
        this.database.getLevel1Cache().clear();
        for (ORecordOperation v : this.recordEntries.values()) {
            v.getRecord().unload();
        }
        for (ORecordOperation v : this.allEntries.values()) {
            v.getRecord().unload();
        }
        this.close();
        this.status = OTransaction.TXSTATUS.ROLLED_BACK;
    }

    @Override
    public ORecordInternal<?> loadRecord(ORID iRid, ORecordInternal<?> iRecord, String iFetchPlan, boolean ignoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkTransaction();
        ORecordInternal<?> txRecord = this.getRecord(iRid);
        if (txRecord == OTransactionRealAbstract.DELETED_RECORD) {
            return null;
        }
        if (txRecord != null) {
            if (iRecord != null && txRecord != iRecord) {
                OLogManager.instance().warn((Object)this, "Found record in transaction with the same RID %s but different instance. Probably the record has been loaded from another transaction and reused on the current one: reload it from current transaction before to update or delete it", new Object[]{iRecord.getIdentity()});
            }
            return txRecord;
        }
        if (iRid.isTemporary()) {
            return null;
        }
        Object record = this.database.executeReadRecord((ORecordId)iRid, iRecord, iFetchPlan, ignoreCache, false, iLockingStrategy);
        if (record != null) {
            this.addRecord((ORecordInternal<?>)record, (byte)0, null);
        }
        return record;
    }

    @Override
    public void deleteRecord(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode) {
        if (!iRecord.getIdentity().isValid()) {
            return;
        }
        this.addRecord(iRecord, (byte)2, null);
    }

    @Override
    public void saveRecord(ORecordInternal<?> iRecord, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        if (iRecord == null) {
            return;
        }
        byte operation = iForceCreate ? (byte)3 : (iRecord.getIdentity().isValid() ? (byte)1 : 3);
        this.addRecord(iRecord, operation, iClusterName);
    }

    @Override
    public boolean updateReplica(ORecordInternal<?> iRecord) {
        throw new UnsupportedOperationException("updateReplica()");
    }

    public String toString() {
        return "OTransactionOptimistic [id=" + this.id + ", status=" + (Object)((Object)this.status) + ", recEntries=" + this.recordEntries.size() + ", idxEntries=" + this.indexEntries.size() + ']';
    }

    @Override
    public boolean isUsingLog() {
        return this.usingLog;
    }

    @Override
    public void setUsingLog(boolean useLog) {
        this.usingLog = useLog;
    }

    public void setStatus(OTransaction.TXSTATUS iStatus) {
        this.status = iStatus;
    }

    protected void addRecord(ORecordInternal<?> iRecord, byte iStatus, String iClusterName) {
        this.checkTransaction();
        switch (iStatus) {
            case 3: {
                this.database.checkSecurity("database.cluster", ORole.PERMISSION_CREATE, (Object)iClusterName);
                this.database.callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, iRecord);
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                this.database.checkSecurity("database.cluster", ORole.PERMISSION_UPDATE, (Object)iClusterName);
                this.database.callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, iRecord);
                break;
            }
            case 2: {
                this.database.checkSecurity("database.cluster", ORole.PERMISSION_DELETE, (Object)iClusterName);
                this.database.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, iRecord);
            }
        }
        try {
            if (iRecord.getIdentity().isTemporary()) {
                this.temp2persistent.put(iRecord.getIdentity().copy(), iRecord);
            }
            if (this.status == OTransaction.TXSTATUS.COMMITTING && this.database.getStorage().getUnderlying() instanceof OStorageEmbedded) {
                switch (iStatus) {
                    case 1: 
                    case 3: {
                        ORID oldRid = iRecord.getIdentity().copy();
                        this.database.executeSaveRecord(iRecord, iClusterName, iRecord.getRecordVersion(), false, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false, null, null);
                        this.updateIdentityAfterCommit(oldRid, iRecord.getIdentity());
                        break;
                    }
                    case 2: {
                        this.database.executeDeleteRecord(iRecord, iRecord.getRecordVersion(), false, false, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false);
                    }
                }
                ORecordOperation txRecord = this.getRecordEntry(iRecord.getIdentity());
                if (txRecord == null) {
                    this.allEntries.put(iRecord.getIdentity(), new ORecordOperation(iRecord, iStatus));
                } else if (txRecord.record != iRecord) {
                    String clusterName = this.getDatabase().getClusterNameById(iRecord.getIdentity().getClusterId());
                    if (!clusterName.equals("manindex") && !clusterName.equals("index")) {
                        OLogManager.instance().warn((Object)this, "Found record in transaction with the same RID %s but different instance. Probably the record has been loaded from another transaction and reused on the current one: reload it from current transaction before to update or delete it", new Object[]{iRecord.getIdentity()});
                    }
                    txRecord.record = iRecord;
                    txRecord.type = iStatus;
                }
            } else {
                ORecordId rid = (ORecordId)iRecord.getIdentity();
                if (!rid.isValid()) {
                    iRecord.onBeforeIdentityChanged(rid);
                    if (rid.clusterId == -1) {
                        int n = rid.clusterId = iClusterName != null ? this.database.getClusterIdByName(iClusterName) : this.database.getDefaultClusterId();
                    }
                    if (this.database.getStorageVersions().classesAreDetectedByClusterId() && iRecord instanceof ORecordSchemaAwareAbstract) {
                        ORecordSchemaAwareAbstract recordSchemaAware = (ORecordSchemaAwareAbstract)iRecord;
                        OClass recordClass = recordSchemaAware.getSchemaClass();
                        OClass clusterIdClass = this.database.getMetadata().getSchema().getClassByClusterId(rid.clusterId);
                        if (recordClass == null && clusterIdClass != null || clusterIdClass == null && recordClass != null || recordClass != null && !recordClass.equals(clusterIdClass)) {
                            throw new OSchemaException("Record saved into cluster " + iClusterName + " should be saved with class " + clusterIdClass + " but saved with class " + recordClass);
                        }
                    }
                    rid.clusterPosition = OClusterPositionFactory.INSTANCE.valueOf(this.newObjectCounter--);
                    iRecord.onAfterIdentityChanged(iRecord);
                } else {
                    this.database.getLevel1Cache().freeRecord(rid);
                }
                ORecordOperation txEntry = this.getRecordEntry(rid);
                if (txEntry == null) {
                    if (!rid.isTemporary() || iStatus == 3) {
                        txEntry = new ORecordOperation(iRecord, iStatus);
                        this.recordEntries.put(rid, txEntry);
                    }
                } else {
                    txEntry.record = iRecord;
                    switch (txEntry.type) {
                        case 0: {
                            switch (iStatus) {
                                case 1: {
                                    txEntry.type = 1;
                                    break;
                                }
                                case 2: {
                                    txEntry.type = (byte)2;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (iStatus) {
                                case 2: {
                                    txEntry.type = (byte)2;
                                }
                            }
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            switch (iStatus) {
                                case 2: {
                                    this.recordEntries.remove(rid);
                                }
                            }
                        }
                    }
                }
            }
            switch (iStatus) {
                case 3: {
                    this.database.callbackHooks(ORecordHook.TYPE.AFTER_CREATE, iRecord);
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    this.database.callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, iRecord);
                    break;
                }
                case 2: {
                    this.database.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, iRecord);
                }
            }
        }
        catch (Throwable t) {
            switch (iStatus) {
                case 3: {
                    this.database.callbackHooks(ORecordHook.TYPE.CREATE_FAILED, iRecord);
                    break;
                }
                case 1: {
                    this.database.callbackHooks(ORecordHook.TYPE.UPDATE_FAILED, iRecord);
                    break;
                }
                case 2: {
                    this.database.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, iRecord);
                }
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ODatabaseException("Error on saving record " + iRecord.getIdentity(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit() {
        if (this.status == OTransaction.TXSTATUS.ROLLED_BACK || this.status == OTransaction.TXSTATUS.ROLLBACKING) {
            throw new ORollbackException("Given transaction was rolled back and can not be used.");
        }
        this.status = OTransaction.TXSTATUS.COMMITTING;
        if (OScenarioThreadLocal.INSTANCE.get() != OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED && !(this.database.getStorage().getUnderlying() instanceof OStorageEmbedded)) {
            this.database.getStorage().commit(this, null);
        } else {
            List<OIndexAbstract<?>> lockedIndexes = this.acquireIndexLocks();
            try {
                HashMap indexes = new HashMap();
                for (OIndex<?> index : this.database.getMetadata().getIndexManager().getIndexes()) {
                    indexes.put(index.getName(), index);
                }
                final CommitIndexesCallback callback = new CommitIndexesCallback(indexes);
                String storageType = this.database.getStorage().getUnderlying().getType();
                if (storageType.equals("local") || storageType.equals("plocal")) {
                    this.database.getStorage().commit(this, callback);
                } else if (storageType.equals("memory")) {
                    this.database.getStorage().commit(this, null);
                    callback.run();
                } else {
                    this.database.getStorage().callInLock(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            OTransactionOptimistic.this.database.getStorage().commit(OTransactionOptimistic.this, callback);
                            return null;
                        }
                    }, true);
                }
            }
            finally {
                this.releaseIndexLocks(lockedIndexes);
            }
        }
        this.close();
        this.status = OTransaction.TXSTATUS.COMPLETED;
    }

    private List<OIndexAbstract<?>> acquireIndexLocks() {
        ArrayList<OIndexAbstract> lockedIndexes = null;
        List<String> involvedIndexes = this.getInvolvedIndexes();
        if (involvedIndexes != null) {
            Collections.sort(involvedIndexes);
        }
        try {
            if (involvedIndexes != null) {
                for (String indexName : involvedIndexes) {
                    OIndexAbstract index = (OIndexAbstract)this.database.getMetadata().getIndexManager().getIndexInternal(indexName);
                    if (lockedIndexes == null) {
                        lockedIndexes = new ArrayList();
                    }
                    index.acquireModificationLock();
                    lockedIndexes.add(index);
                }
            }
            if (!useSBTree) {
                Collection<? extends OIndex<?>> indexes = this.database.getMetadata().getIndexManager().getIndexes();
                ArrayList indexesToLock = null;
                if (indexes != null) {
                    indexesToLock = new ArrayList(indexes);
                    Collections.sort(indexesToLock, new Comparator<OIndex<?>>(){

                        @Override
                        public int compare(OIndex<?> indexOne, OIndex<?> indexTwo) {
                            return indexOne.getName().compareTo(indexTwo.getName());
                        }
                    });
                }
                if (indexesToLock != null && !indexesToLock.isEmpty()) {
                    if (lockedIndexes == null) {
                        lockedIndexes = new ArrayList<OIndexAbstract>();
                    }
                    for (OIndex oIndex : indexesToLock) {
                        for (Map.Entry entry : this.recordEntries.entrySet()) {
                            Object record = ((ORecordOperation)entry.getValue()).record.getRecord();
                            if (!(record instanceof ODocument)) continue;
                            ODocument doc = (ODocument)record;
                            if (lockedIndexes.contains(oIndex.getInternal()) || doc.getSchemaClass() == null || oIndex.getDefinition() == null || !doc.getSchemaClass().isSubClassOf(oIndex.getDefinition().getClassName())) continue;
                            oIndex.getInternal().acquireModificationLock();
                            lockedIndexes.add((OIndexAbstract)oIndex.getInternal());
                        }
                    }
                    for (OIndexAbstract oIndexAbstract : lockedIndexes) {
                        oIndexAbstract.acquireExclusiveLock();
                    }
                }
            }
            return lockedIndexes;
        }
        catch (RuntimeException e) {
            this.releaseIndexLocks(lockedIndexes);
            throw e;
        }
    }

    private void releaseIndexLocks(List<OIndexAbstract<?>> lockedIndexes) {
        if (lockedIndexes != null) {
            if (!useSBTree) {
                for (OIndexAbstract<?> index : lockedIndexes) {
                    index.releaseExclusiveLock();
                }
            }
            for (OIndexAbstract<?> index : lockedIndexes) {
                index.releaseModificationLock();
            }
        }
    }

    private class CommitIndexesCallback
    implements Runnable {
        private final Map<String, OIndex> indexes;

        private CommitIndexesCallback(Map<String, OIndex> indexes) {
            this.indexes = indexes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ODocument indexEntries = OTransactionOptimistic.this.getIndexChanges();
            if (indexEntries != null) {
                OIndexInternal index;
                HashMap indexesToCommit = new HashMap();
                for (Map.Entry<String, Object> indexEntry : indexEntries) {
                    index = this.indexes.get(indexEntry.getKey()).getInternal();
                    indexesToCommit.put(index.getName(), index.getInternal());
                }
                for (OIndexInternal indexInternal : indexesToCommit.values()) {
                    indexInternal.preCommit();
                }
                for (Map.Entry<String, Object> indexEntry : indexEntries) {
                    index = ((OIndexInternal)indexesToCommit.get(indexEntry.getKey())).getInternal();
                    if (index == null) {
                        OLogManager.instance().error((Object)this, "Index with name " + indexEntry.getKey() + " was not found.", new Object[0]);
                        throw new OIndexException("Index with name " + indexEntry.getKey() + " was not found.");
                    }
                    index.addTxOperation((ODocument)indexEntry.getValue());
                }
                try {
                    for (OIndexInternal indexInternal : indexesToCommit.values()) {
                        indexInternal.commit();
                    }
                }
                finally {
                    for (OIndexInternal indexInternal : indexesToCommit.values()) {
                        indexInternal.postCommit();
                    }
                }
            }
        }
    }
}

