/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ODataSegment;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.impl.memory.OClusterMemory;
import com.orientechnologies.orient.core.storage.impl.memory.ODataSegmentMemory;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTxListener;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;

public class OStorageMemory
extends OStorageEmbedded {
    private final List<ODataSegmentMemory> dataSegments = new ArrayList<ODataSegmentMemory>();
    private final List<OClusterMemory> clusters = new ArrayList<OClusterMemory>();
    private final Map<String, OClusterMemory> clusterMap = new HashMap<String, OClusterMemory>();
    private int defaultClusterId = 0;
    private long positionGenerator = 0L;

    public OStorageMemory(String iURL) {
        super(iURL, iURL, "rw");
        this.configuration = new OStorageConfiguration(this);
    }

    @Override
    public void create(Map<String, Object> iOptions) {
        this.addUser();
        this.lock.acquireExclusiveLock();
        try {
            this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
            this.addDataSegment("default");
            this.addDataSegment("index");
            this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "internal", null, null, true, new Object[0]);
            this.configuration.create();
            this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "index", null, "index", true, new Object[0]);
            this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "manindex", null, null, true, new Object[0]);
            this.defaultClusterId = this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "default", null, null, false, new Object[0]);
            this.status = OStorage.STATUS.OPEN;
        }
        catch (OStorageException e) {
            this.close();
            throw e;
        }
        catch (IOException e) {
            this.close();
            throw new OStorageException("Error on creation of storage: " + this.name, e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.addUser();
        if (this.status == OStorage.STATUS.OPEN) {
            return;
        }
        this.lock.acquireExclusiveLock();
        try {
            if (!this.exists()) {
                throw new OStorageException("Cannot open the storage '" + this.name + "' because it does not exist in path: " + this.url);
            }
            this.status = OStorage.STATUS.OPEN;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean iForce, boolean onDelete) {
        if (!this.checkForClose(iForce)) {
            return;
        }
        long timer = Orient.instance().getProfiler().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            this.status = OStorage.STATUS.CLOSING;
            super.close(iForce, onDelete);
            for (OClusterMemory c : this.clusters) {
                if (c == null) continue;
                c.close();
            }
            this.clusters.clear();
            this.clusterMap.clear();
            for (ODataSegmentMemory d : this.dataSegments) {
                if (d == null) continue;
                d.close();
            }
            this.dataSegments.clear();
            this.level2Cache.shutdown();
            this.status = OStorage.STATUS.CLOSED;
        }
        finally {
            this.lock.releaseExclusiveLock();
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".close", "Close a database", timer, "db.*.close");
        }
    }

    @Override
    public void delete() {
        this.close(true, false);
    }

    @Override
    public void backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        throw new UnsupportedOperationException("backup");
    }

    @Override
    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        throw new UnsupportedOperationException("restore");
    }

    @Override
    public void reload() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addCluster(String iClusterType, String iClusterName, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iParameters) {
        iClusterName = iClusterName.toLowerCase();
        this.lock.acquireExclusiveLock();
        try {
            int clusterId = this.clusters.size();
            for (int i = 0; i < this.clusters.size(); ++i) {
                if (this.clusters.get(i) != null) continue;
                clusterId = i;
                break;
            }
            OClusterMemory cluster = (OClusterMemory)Orient.instance().getClusterFactory().createCluster("MEMORY");
            cluster.configure(this, clusterId, iClusterName, iLocation, this.getDataSegmentIdByName(iDataSegmentName), iParameters);
            if (clusterId == this.clusters.size()) {
                this.clusters.add(cluster);
            } else {
                this.clusters.set(clusterId, cluster);
            }
            this.clusterMap.put(iClusterName, cluster);
            int n = clusterId;
            return n;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public int addCluster(String iClusterType, String iClusterName, int iRequestedId, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iParameters) {
        throw new UnsupportedOperationException("This operation is unsupported for " + this.getType() + " storage. If you are doing import please use parameter -preserveClusterIDs=false .");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        this.lock.acquireExclusiveLock();
        try {
            OCluster c = this.clusters.get(iClusterId);
            if (c != null) {
                if (iTruncate) {
                    c.truncate();
                }
                c.delete();
                this.clusters.set(iClusterId, null);
                this.getLevel2Cache().freeCluster(iClusterId);
                this.clusterMap.remove(c.getName());
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return false;
    }

    @Override
    public boolean dropDataSegment(String name) {
        this.lock.acquireExclusiveLock();
        try {
            int id = this.getDataSegmentIdByName(name);
            ODataSegment data = this.dataSegments.get(id);
            if (data == null) {
                boolean bl = false;
                return bl;
            }
            data.drop();
            this.dataSegments.set(id, null);
            this.configuration.dropCluster(id);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new OStorageException("Error while removing data segment '" + name + '\'', e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addDataSegment(String iDataSegmentName) {
        this.lock.acquireExclusiveLock();
        try {
            int pos = -1;
            for (int i = 0; i < this.dataSegments.size(); ++i) {
                if (this.dataSegments.get(i) != null) continue;
                pos = i;
                break;
            }
            if (pos == -1) {
                pos = this.dataSegments.size();
            }
            ODataSegmentMemory dataSegment = new ODataSegmentMemory(iDataSegmentName, pos);
            if (pos == this.dataSegments.size()) {
                this.dataSegments.add(dataSegment);
            } else {
                this.dataSegments.set(pos, dataSegment);
            }
            int n = pos;
            return n;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public int addDataSegment(String iSegmentName, String iLocation) {
        return this.addDataSegment(iSegmentName);
    }

    @Override
    public OStorageOperationResult<OPhysicalPosition> createRecord(int iDataSegmentId, ORecordId iRid, byte[] iContent, ORecordVersion iRecordVersion, byte iRecordType, int iMode, ORecordCallback<OClusterPosition> iCallback) {
        long timer = Orient.instance().getProfiler().startChrono();
        this.lock.acquireSharedLock();
        try {
            ODataSegmentMemory data = this.getDataSegmentById(iDataSegmentId);
            long offset = data.createRecord(iContent);
            OCluster cluster = this.getClusterById(iRid.clusterId);
            OPhysicalPosition ppos = new OPhysicalPosition(iDataSegmentId, offset, iRecordType);
            if (cluster.isHashBased()) {
                ppos.clusterPosition = iRid.isNew() ? (OGlobalConfiguration.USE_NODE_ID_CLUSTER_POSITION.getValueAsBoolean() ? OClusterPositionFactory.INSTANCE.generateUniqueClusterPosition() : OClusterPositionFactory.INSTANCE.valueOf(this.positionGenerator++)) : iRid.clusterPosition;
            }
            if (!cluster.addPhysicalPosition(ppos)) {
                data.readRecord(ppos.dataSegmentPos);
                throw new OStorageException("Record with given id " + iRid + " has already exists.");
            }
            iRid.clusterPosition = ppos.clusterPosition;
            if (iCallback != null) {
                iCallback.call(iRid, iRid.clusterPosition);
            }
            if (iRecordVersion.getCounter() > 0 && iRecordVersion.compareTo(ppos.recordVersion) != 0) {
                cluster.updateVersion(iRid.clusterPosition, iRecordVersion);
                ppos.recordVersion = iRecordVersion;
            }
            OStorageOperationResult<OPhysicalPosition> oStorageOperationResult = new OStorageOperationResult<OPhysicalPosition>(ppos);
            return oStorageOperationResult;
        }
        catch (IOException e) {
            throw new OStorageException("Error on create record in cluster: " + iRid.clusterId, e);
        }
        finally {
            this.lock.releaseSharedLock();
            Orient.instance().getProfiler().stopChrono(this.PROFILER_CREATE_RECORD, "Create a record in database", timer, "db.*.data.updateHole");
        }
    }

    @Override
    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback, boolean loadTombstones, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        return new OStorageOperationResult<ORawBuffer>(this.readRecord(this.getClusterById(iRid.clusterId), iRid, true, loadTombstones, iLockingStrategy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OStorageOperationResult<ORecordVersion> updateRecord(ORecordId iRid, byte[] iContent, ORecordVersion iVersion, byte iRecordType, int iMode, ORecordCallback<ORecordVersion> iCallback) {
        long timer = Orient.instance().getProfiler().startChrono();
        OCluster cluster = this.getClusterById(iRid.clusterId);
        this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
        try {
            OPhysicalPosition ppos;
            block20: {
                OStorageOperationResult<ORecordVersion> oStorageOperationResult;
                this.lock.acquireSharedLock();
                try {
                    ppos = cluster.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                    if (ppos != null && !ppos.recordVersion.isTombstone()) break block20;
                    ORecordVersion v = OVersionFactory.instance().createUntrackedVersion();
                    if (iCallback != null) {
                        iCallback.call(iRid, v);
                    }
                    oStorageOperationResult = new OStorageOperationResult<ORecordVersion>(v);
                }
                catch (Throwable throwable) {
                    try {
                        this.lock.releaseSharedLock();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new OStorageException("Error on update record " + iRid, e);
                    }
                }
                this.lock.releaseSharedLock();
                return oStorageOperationResult;
            }
            switch (iVersion.getCounter()) {
                case -1: {
                    ppos.recordVersion.increment();
                    cluster.updateVersion(iRid.clusterPosition, ppos.recordVersion);
                    break;
                }
                case -2: {
                    break;
                }
                default: {
                    if (iVersion.getCounter() > -1) {
                        if (!iVersion.equals(ppos.recordVersion)) {
                            if (OFastConcurrentModificationException.enabled()) {
                                throw OFastConcurrentModificationException.instance();
                            }
                            throw new OConcurrentModificationException(iRid, ppos.recordVersion, iVersion, 1);
                        }
                        ppos.recordVersion.increment();
                        cluster.updateVersion(iRid.clusterPosition, ppos.recordVersion);
                        break;
                    }
                    iVersion.clearRollbackMode();
                    ppos.recordVersion.copyFrom(iVersion);
                    cluster.updateVersion(iRid.clusterPosition, ppos.recordVersion);
                }
            }
            if (ppos.recordType != iRecordType) {
                cluster.updateRecordType(iRid.clusterPosition, iRecordType);
            }
            ODataSegmentMemory dataSegment = this.getDataSegmentById(ppos.dataSegmentId);
            dataSegment.updateRecord(ppos.dataSegmentPos, iContent);
            if (iCallback != null) {
                iCallback.call(null, ppos.recordVersion);
            }
            OStorageOperationResult<ORecordVersion> oStorageOperationResult = new OStorageOperationResult<ORecordVersion>(ppos.recordVersion);
            this.lock.releaseSharedLock();
            return oStorageOperationResult;
        }
        finally {
            this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
            Orient.instance().getProfiler().stopChrono(this.PROFILER_UPDATE_RECORD, "Update a record to database", timer, "db.*.updateRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateReplica(int dataSegmentId, ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        block19: {
            if (rid.isNew()) {
                throw new OStorageException("Passed record with id " + rid + " is new and can not be treated as replica.");
            }
            this.checkOpeness();
            OCluster cluster = this.getClusterById(rid.clusterId);
            ODataSegmentMemory data = this.getDataSegmentById(dataSegmentId);
            this.lockManager.acquireLock(Thread.currentThread(), rid, OLockManager.LOCK.EXCLUSIVE);
            try {
                this.lock.acquireSharedLock();
                OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.clusterPosition));
                if (ppos == null) {
                    if (!cluster.isHashBased()) {
                        throw new OStorageException("Cluster with LH support is required.");
                    }
                    ppos = new OPhysicalPosition(rid.clusterPosition, recordVersion);
                    ppos.recordType = recordType;
                    ppos.dataSegmentId = data.getId();
                    if (!recordVersion.isTombstone()) {
                        ppos.dataSegmentPos = data.createRecord(content);
                    }
                    cluster.addPhysicalPosition(ppos);
                    boolean bl = true;
                    return bl;
                }
                if (ppos.recordType != recordType) {
                    throw new OStorageException("Record types of provided and stored replicas are different " + recordType + ":" + ppos.recordType + ".");
                }
                if (ppos.recordVersion.compareTo(recordVersion) >= 0) break block19;
                if (!recordVersion.isTombstone() && !ppos.recordVersion.isTombstone()) {
                    data.updateRecord(ppos.dataSegmentPos, content);
                } else if (recordVersion.isTombstone() && !ppos.recordVersion.isTombstone()) {
                    data.deleteRecord(ppos.dataSegmentPos);
                } else if (!recordVersion.isTombstone() && ppos.recordVersion.isTombstone()) {
                    ppos.dataSegmentPos = data.createRecord(content);
                    cluster.updateDataSegmentPosition(ppos.clusterPosition, dataSegmentId, ppos.dataSegmentPos);
                }
                cluster.updateVersion(ppos.clusterPosition, recordVersion);
                boolean bl = true;
                return bl;
                finally {
                    this.lock.releaseSharedLock();
                }
            }
            finally {
                this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.EXCLUSIVE);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public <V> V callInRecordLock(Callable<V> callable, ORID rid, boolean exclusiveLock) {
        this.lockManager.acquireLock(Thread.currentThread(), rid, exclusiveLock ? OLockManager.LOCK.EXCLUSIVE : OLockManager.LOCK.SHARED);
        this.lock.acquireSharedLock();
        V v = callable.call();
        this.lock.releaseSharedLock();
        this.lockManager.releaseLock(Thread.currentThread(), rid, exclusiveLock ? OLockManager.LOCK.EXCLUSIVE : OLockManager.LOCK.SHARED);
        return v;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        this.lock.releaseSharedLock();
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new OException("Error on nested call in lock", (Throwable)e);
                    }
                }
                catch (Throwable throwable2) {
                    this.lockManager.releaseLock(Thread.currentThread(), rid, exclusiveLock ? OLockManager.LOCK.EXCLUSIVE : OLockManager.LOCK.SHARED);
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRid, ORecordVersion iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        return new OStorageOperationResult<Boolean>(this.deleteRecord(iRid, iVersion, OGlobalConfiguration.STORAGE_USE_TOMBSTONES.getValueAsBoolean(), iCallback));
    }

    @Override
    public OStorageOperationResult<Boolean> hideRecord(ORecordId recordId, int mode, ORecordCallback<Boolean> callback) {
        throw new UnsupportedOperationException("Given operation is not supported in current version.");
    }

    @Override
    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        return this.deleteRecord(recordId, recordVersion, false, callback);
    }

    @Override
    public long count(int iClusterId) {
        return this.count(iClusterId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int iClusterId, boolean countTombstones) {
        OCluster cluster = this.getClusterById(iClusterId);
        this.lock.acquireSharedLock();
        try {
            long l = cluster.getEntries() - (countTombstones ? 0L : cluster.getTombstonesCount());
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OClusterPosition[] getClusterDataRange(int iClusterId) {
        OCluster cluster = this.getClusterById(iClusterId);
        this.lock.acquireSharedLock();
        try {
            OClusterPosition[] oClusterPositionArray = new OClusterPosition[]{cluster.getFirstPosition(), cluster.getLastPosition()};
            return oClusterPositionArray;
        }
        catch (IOException ioe) {
            throw new OStorageException("Can not retrieve information about data range", ioe);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public long count(int[] iClusterIds) {
        return this.count(iClusterIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int[] iClusterIds, boolean countTombstones) {
        this.lock.acquireSharedLock();
        try {
            long tot = 0L;
            for (int iClusterId : iClusterIds) {
                OCluster cluster;
                if (iClusterId <= -1 || (cluster = (OCluster)this.clusters.get(iClusterId)) == null) continue;
                tot += cluster.getEntries() - (countTombstones ? 0L : cluster.getTombstonesCount());
            }
            long l = tot;
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OCluster getClusterByName(String iClusterName) {
        this.lock.acquireSharedLock();
        try {
            OCluster oCluster = this.clusterMap.get(iClusterName.toLowerCase());
            return oCluster;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClusterIdByName(String iClusterName) {
        iClusterName = iClusterName.toLowerCase();
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
            if (cluster == null) {
                int n = -1;
                return n;
            }
            int n = cluster.getId();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public String getClusterTypeByName(String iClusterName) {
        return "MEMORY";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        this.lock.acquireSharedLock();
        try {
            for (OClusterMemory cluster : this.clusters) {
                if (cluster == null || cluster.getId() != iClusterId) continue;
                String string = cluster.getName();
                return string;
            }
            Iterator<OClusterMemory> iterator = null;
            return iterator;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public Set<String> getClusterNames() {
        this.lock.acquireSharedLock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.clusterMap.keySet());
            return hashSet;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(OTransaction iTx, Runnable callback) {
        TreeSet allToLock = new TreeSet();
        try {
            for (ORecordOperation oRecordOperation : iTx.getCurrentRecordEntries()) {
                allToLock.add(oRecordOperation.getRecord());
            }
            for (ORecord oRecord : allToLock) {
                if (oRecord.getIdentity().isNew()) continue;
                this.lockManager.acquireLock(Thread.currentThread(), oRecord.getIdentity(), OLockManager.LOCK.EXCLUSIVE);
            }
            this.lock.acquireExclusiveLock();
            try {
                ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
                while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                    for (ORecordOperation oRecordOperation : iTx.getCurrentRecordEntries()) {
                        tmpEntries.add(oRecordOperation);
                    }
                    iTx.clearRecordEntries();
                    for (ORecordOperation oRecordOperation : tmpEntries) {
                        this.commitEntry(iTx, oRecordOperation);
                    }
                    tmpEntries.clear();
                }
                OTransactionAbstract.updateCacheFromEntries(iTx, iTx.getAllRecordEntries(), true);
            }
            catch (IOException e) {
                this.rollback(iTx);
            }
            finally {
                this.lock.releaseExclusiveLock();
            }
        }
        finally {
            for (ORecord oRecord : allToLock) {
                try {
                    this.lockManager.releaseLock(Thread.currentThread(), oRecord.getIdentity(), OLockManager.LOCK.EXCLUSIVE);
                }
                catch (Exception exception) {
                    OLogManager.instance().debug((Object)this, "Error on record unlock", (Throwable)exception, new Object[0]);
                }
            }
        }
    }

    @Override
    public void rollback(OTransaction iTx) {
    }

    @Override
    public void synch() {
    }

    @Override
    public boolean exists() {
        this.lock.acquireSharedLock();
        try {
            boolean bl = !this.clusters.isEmpty();
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public ODataSegmentMemory getDataSegmentById(int iDataId) {
        this.lock.acquireSharedLock();
        try {
            if (iDataId < 0 || iDataId > this.dataSegments.size() - 1) {
                throw new IllegalArgumentException("Invalid data segment id " + iDataId + ". Range is 0-" + (this.dataSegments.size() - 1));
            }
            ODataSegmentMemory oDataSegmentMemory = this.dataSegments.get(iDataId);
            return oDataSegmentMemory;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int getDataSegmentIdByName(String iDataSegmentName) {
        if (iDataSegmentName == null) {
            return 0;
        }
        this.lock.acquireSharedLock();
        try {
            for (ODataSegmentMemory d : this.dataSegments) {
                if (d == null || !d.getName().equalsIgnoreCase(iDataSegmentName)) continue;
                int n = d.getId();
                return n;
            }
            throw new IllegalArgumentException("Data segment '" + iDataSegmentName + "' does not exist in storage '" + this.name + "'");
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OCluster getClusterById(int iClusterId) {
        this.lock.acquireSharedLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            this.checkClusterSegmentIndexRange(iClusterId);
            OCluster oCluster = this.clusters.get(iClusterId);
            return oCluster;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int getClusters() {
        this.lock.acquireSharedLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public Collection<? extends OCluster> getClusterInstances() {
        this.lock.acquireSharedLock();
        try {
            Collection<OClusterMemory> collection = Collections.unmodifiableCollection(this.clusters);
            return collection;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    @Override
    public void setDefaultClusterId(int defaultClusterId) {
        this.defaultClusterId = defaultClusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        long size = 0L;
        this.lock.acquireSharedLock();
        try {
            for (ODataSegmentMemory d : this.dataSegments) {
                if (d == null) continue;
                size += d.getSize();
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        if (ppos.dataSegmentId > 0) {
            return false;
        }
        this.lock.acquireSharedLock();
        try {
            ODataSegmentMemory dataSegment = this.getDataSegmentById(ppos.dataSegmentId);
            if (ppos.dataSegmentPos >= (long)dataSegment.count()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return true;
    }

    @Override
    public String getURL() {
        return "memory:" + this.url;
    }

    public void renameCluster(String iOldName, String iNewName) {
        OClusterMemory cluster = (OClusterMemory)this.getClusterByName(iOldName);
        if (cluster != null) {
            try {
                cluster.set(OCluster.ATTRIBUTES.NAME, iNewName);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    @Override
    public String getType() {
        return "memory";
    }

    @Override
    public Class<? extends OSBTreeCollectionManager> getCollectionManagerClass() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ORawBuffer readRecord(OCluster iClusterSegment, ORecordId iRid, boolean iAtomicLock, boolean loadTombstones, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        long timer = Orient.instance().getProfiler().startChrono();
        switch (iLockingStrategy) {
            case DEFAULT: 
            case KEEP_SHARED_LOCK: {
                iRid.lock(false);
                break;
            }
            case NONE: {
                break;
            }
            case KEEP_EXCLUSIVE_LOCK: {
                iRid.lock(true);
            }
        }
        try {
            OPhysicalPosition ppos;
            block36: {
                block35: {
                    block34: {
                        ORawBuffer oRawBuffer;
                        this.lock.acquireSharedLock();
                        try {
                            OClusterPosition lastPos = iClusterSegment.getLastPosition();
                            if (iClusterSegment.isHashBased() || iRid.clusterPosition.compareTo(lastPos) <= 0) break block34;
                            oRawBuffer = null;
                        }
                        catch (Throwable throwable) {
                            try {
                                this.lock.releaseSharedLock();
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new OStorageException("Error on read record in cluster: " + iClusterSegment.getId(), e);
                            }
                        }
                        this.lock.releaseSharedLock();
                        return oRawBuffer;
                    }
                    ppos = iClusterSegment.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                    if (ppos == null || !loadTombstones || !ppos.recordVersion.isTombstone()) break block35;
                    ORawBuffer oRawBuffer = new ORawBuffer(null, ppos.recordVersion, ppos.recordType);
                    this.lock.releaseSharedLock();
                    return oRawBuffer;
                }
                if (ppos != null && !ppos.recordVersion.isTombstone()) break block36;
                ORawBuffer oRawBuffer = null;
                this.lock.releaseSharedLock();
                return oRawBuffer;
            }
            ODataSegmentMemory dataSegment = this.getDataSegmentById(ppos.dataSegmentId);
            ORawBuffer oRawBuffer = new ORawBuffer(dataSegment.readRecord(ppos.dataSegmentPos), ppos.recordVersion, ppos.recordType);
            this.lock.releaseSharedLock();
            return oRawBuffer;
        }
        finally {
            switch (iLockingStrategy) {
                case DEFAULT: {
                    iRid.unlock();
                    break;
                }
            }
            Orient.instance().getProfiler().stopChrono(this.PROFILER_READ_RECORD, "Read a record from database", timer, "db.*.readRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteRecord(ORecordId iRid, ORecordVersion iVersion, boolean useTombstones, ORecordCallback<Boolean> iCallback) {
        long timer = Orient.instance().getProfiler().startChrono();
        OCluster cluster = this.getClusterById(iRid.clusterId);
        this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
        try {
            OPhysicalPosition ppos;
            block17: {
                boolean bl;
                this.lock.acquireSharedLock();
                try {
                    ppos = cluster.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                    if (ppos != null && (!ppos.recordVersion.isTombstone() || !useTombstones)) break block17;
                    if (iCallback != null) {
                        iCallback.call(iRid, false);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        this.lock.releaseSharedLock();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new OStorageException("Error on delete record " + iRid, e);
                    }
                }
                this.lock.releaseSharedLock();
                return bl;
            }
            if (iVersion.getCounter() > -1 && !ppos.recordVersion.equals(iVersion)) {
                if (OFastConcurrentModificationException.enabled()) {
                    throw OFastConcurrentModificationException.instance();
                }
                throw new OConcurrentModificationException(iRid, ppos.recordVersion, iVersion, 2);
            }
            if (!ppos.recordVersion.isTombstone()) {
                ODataSegmentMemory dataSegment = this.getDataSegmentById(ppos.dataSegmentId);
                dataSegment.deleteRecord(ppos.dataSegmentPos);
                ppos.dataSegmentPos = -1L;
            }
            if (useTombstones && cluster.hasTombstonesSupport()) {
                cluster.convertToTombstone(iRid.clusterPosition);
            } else {
                cluster.removePhysicalPosition(iRid.clusterPosition);
            }
            if (iCallback != null) {
                iCallback.call(null, true);
            }
            boolean bl = true;
            this.lock.releaseSharedLock();
            return bl;
        }
        finally {
            this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
            Orient.instance().getProfiler().stopChrono(this.PROFILER_DELETE_RECORD, "Delete a record from database", timer, "db.*.deleteRecord");
        }
    }

    private void commitEntry(OTransaction iTx, ORecordOperation txEntry) throws IOException {
        ORecordId rid = (ORecordId)txEntry.getRecord().getIdentity();
        OCluster cluster = this.getClusterById(rid.clusterId);
        rid.clusterId = cluster.getId();
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.BEFORE_COMMIT);
        }
        switch (txEntry.type) {
            case 0: {
                break;
            }
            case 3: {
                if (!rid.isNew()) break;
                byte[] stream = txEntry.getRecord().toStream();
                if (stream == null) {
                    OLogManager.instance().warn((Object)this, "Null serialization on committing new record %s in transaction", new Object[]{rid});
                    break;
                }
                if (rid.isNew()) {
                    ORecordId oldRID = rid.copy();
                    OPhysicalPosition ppos = this.createRecord(txEntry.dataSegmentId, rid, stream, OVersionFactory.instance().createVersion(), txEntry.getRecord().getRecordType(), 0, null).getResult();
                    txEntry.getRecord().getRecordVersion().copyFrom(ppos.recordVersion);
                    iTx.updateIdentityAfterCommit(oldRID, rid);
                    break;
                }
                txEntry.getRecord().getRecordVersion().copyFrom(this.updateRecord(rid, stream, txEntry.getRecord().getRecordVersion(), txEntry.getRecord().getRecordType(), 0, null).getResult());
                break;
            }
            case 1: {
                byte[] stream = txEntry.getRecord().toStream();
                if (stream == null) {
                    OLogManager.instance().warn((Object)this, "Null serialization on committing updated record %s in transaction", new Object[]{rid});
                    break;
                }
                txEntry.getRecord().getRecordVersion().copyFrom(this.updateRecord(rid, stream, txEntry.getRecord().getRecordVersion(), txEntry.getRecord().getRecordType(), 0, null).getResult());
                break;
            }
            case 2: {
                this.deleteRecord(rid, txEntry.getRecord().getRecordVersion(), 0, null);
            }
        }
        txEntry.getRecord().unsetDirty();
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.AFTER_COMMIT);
        }
    }

    private void checkClusterSegmentIndexRange(int iClusterId) {
        if (iClusterId > this.clusters.size() - 1) {
            throw new IllegalArgumentException("Cluster segment #" + iClusterId + " does not exist in database '" + this.name + "'");
        }
    }
}

