/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPagesRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileCreatedCreatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFullCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OUpdatePageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import java.util.HashMap;
import java.util.Map;

public class OWALRecordsFactory {
    private Map<Byte, Class> idToTypeMap = new HashMap<Byte, Class>();
    private Map<Class, Byte> typeToIdMap = new HashMap<Class, Byte>();
    public static final OWALRecordsFactory INSTANCE = new OWALRecordsFactory();

    public byte[] toStream(OWALRecord walRecord) {
        int contentSize = walRecord.serializedSize() + 1;
        byte[] content = new byte[contentSize];
        if (walRecord instanceof OUpdatePageRecord) {
            content[0] = 0;
        } else if (walRecord instanceof OFuzzyCheckpointStartRecord) {
            content[0] = 1;
        } else if (walRecord instanceof OFuzzyCheckpointEndRecord) {
            content[0] = 2;
        } else if (walRecord instanceof ODirtyPagesRecord) {
            content[0] = 3;
        } else if (walRecord instanceof OFullCheckpointStartRecord) {
            content[0] = 4;
        } else if (walRecord instanceof OCheckpointEndRecord) {
            content[0] = 5;
        } else if (walRecord instanceof OAtomicUnitStartRecord) {
            content[0] = 8;
        } else if (walRecord instanceof OAtomicUnitEndRecord) {
            content[0] = 9;
        } else if (walRecord instanceof OFileCreatedCreatedWALRecord) {
            content[0] = 10;
        } else if (this.typeToIdMap.containsKey(walRecord.getClass())) {
            content[0] = this.typeToIdMap.get(walRecord.getClass());
        } else {
            throw new IllegalArgumentException(walRecord.getClass().getName() + " class can not be serialized.");
        }
        walRecord.toStream(content, 1);
        return content;
    }

    public OWALRecord fromStream(byte[] content) {
        OWALRecord walRecord;
        switch (content[0]) {
            case 0: {
                walRecord = new OUpdatePageRecord();
                break;
            }
            case 1: {
                walRecord = new OFuzzyCheckpointStartRecord();
                break;
            }
            case 2: {
                walRecord = new OFuzzyCheckpointEndRecord();
                break;
            }
            case 3: {
                walRecord = new ODirtyPagesRecord();
                break;
            }
            case 4: {
                walRecord = new OFullCheckpointStartRecord();
                break;
            }
            case 5: {
                walRecord = new OCheckpointEndRecord();
                break;
            }
            case 8: {
                walRecord = new OAtomicUnitStartRecord();
                break;
            }
            case 9: {
                walRecord = new OAtomicUnitEndRecord();
                break;
            }
            case 10: {
                walRecord = new OFileCreatedCreatedWALRecord();
                break;
            }
            default: {
                if (this.idToTypeMap.containsKey(content[0])) {
                    try {
                        walRecord = (OWALRecord)this.idToTypeMap.get(content[0]).newInstance();
                        break;
                    }
                    catch (InstantiationException e) {
                        throw new IllegalStateException("Can not deserialize passed in record", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Can not deserialize passed in record", e);
                    }
                }
                throw new IllegalStateException("Can not deserialize passed in wal record.");
            }
        }
        walRecord.fromStream(content, 1);
        return walRecord;
    }

    public void registerNewRecord(byte id, Class<? extends OWALRecord> type) {
        this.typeToIdMap.put(type, id);
        this.idToTypeMap.put(id, type);
    }
}

