/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractPageWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OPageChanges;

public class OUpdatePageRecord
extends OAbstractPageWALRecord {
    private OPageChanges pageChanges;

    public OUpdatePageRecord() {
    }

    public OUpdatePageRecord(long pageIndex, long fileId, OOperationUnitId operationUnitId, OPageChanges pageChanges, OLogSequenceNumber prevLsn) {
        super(pageIndex, fileId, operationUnitId);
        this.pageChanges = pageChanges;
        this.lsn = prevLsn;
        assert (prevLsn != null);
    }

    public OPageChanges getChanges() {
        return this.pageChanges;
    }

    @Override
    public int serializedSize() {
        int serializedSize = super.serializedSize();
        serializedSize += 16;
        return serializedSize += this.pageChanges.serializedSize();
    }

    @Override
    public int toStream(byte[] content, int offset) {
        offset = super.toStream(content, offset);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(this.lsn.getPosition()), content, offset, new Object[0]);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(this.lsn.getSegment()), content, offset += 8, new Object[0]);
        offset += 8;
        offset = this.pageChanges.toStream(content, offset);
        return offset;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        offset = super.fromStream(content, offset);
        long position = OLongSerializer.INSTANCE.deserializeNative(content, offset);
        long segment = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
        offset += 8;
        this.lsn = new OLogSequenceNumber(segment, position);
        this.pageChanges = new OPageChanges();
        offset = this.pageChanges.fromStream(content, offset);
        return offset;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OUpdatePageRecord that = (OUpdatePageRecord)o;
        return this.lsn.equals(that.lsn);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.lsn.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return this.toString("pageChanges=" + this.pageChanges);
    }
}

