/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class OPageChanges {
    private List<ChangeUnit> changeUnits = new ArrayList<ChangeUnit>();
    private int serializedSize = 4;

    public void addChanges(int pageOffset, byte[] newValues, byte[] oldValues) {
        assert (newValues == null || newValues.length == oldValues.length);
        this.changeUnits.add(new ChangeUnit(pageOffset, oldValues, newValues));
        this.serializedSize += this.compressedIntegerSize(pageOffset) + this.compressedIntegerSize(oldValues.length) + (newValues == null ? 0 : newValues.length) + oldValues.length + 1;
    }

    public boolean isEmpty() {
        return this.changeUnits.isEmpty();
    }

    public void applyChanges(ODirectMemoryPointer pointer) {
        for (ChangeUnit changeUnit : this.changeUnits) {
            if (changeUnit.newValues == null) continue;
            pointer.set((long)(changeUnit.pageOffset + 8), changeUnit.newValues, 0, changeUnit.newValues.length);
        }
    }

    public void revertChanges(ODirectMemoryPointer pointer) {
        ListIterator<ChangeUnit> iterator = this.changeUnits.listIterator(this.changeUnits.size());
        while (iterator.hasPrevious()) {
            ChangeUnit changeUnit = iterator.previous();
            pointer.set((long)(changeUnit.pageOffset + 8), changeUnit.oldValues, 0, changeUnit.oldValues.length);
        }
    }

    public int serializedSize() {
        return this.serializedSize;
    }

    public int toStream(byte[] content, int offset) {
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(this.changeUnits.size()), content, offset, new Object[0]);
        offset += 4;
        for (ChangeUnit changeUnit : this.changeUnits) {
            offset = this.serializeCompressedInteger(content, offset, changeUnit.pageOffset);
            offset = this.serializeCompressedInteger(content, offset, changeUnit.oldValues.length);
            if (changeUnit.newValues != null) {
                content[offset] = 1;
                System.arraycopy(changeUnit.newValues, 0, content, ++offset, changeUnit.newValues.length);
                offset += changeUnit.newValues.length;
            } else {
                ++offset;
            }
            System.arraycopy(changeUnit.oldValues, 0, content, offset, changeUnit.oldValues.length);
            offset += changeUnit.oldValues.length;
        }
        return offset;
    }

    public int fromStream(byte[] content, int offset) {
        int changesSize = OIntegerSerializer.INSTANCE.deserializeNative(content, offset);
        offset += 4;
        this.changeUnits = new ArrayList<ChangeUnit>(changesSize);
        for (int i = 0; i < changesSize; ++i) {
            byte[] newValues;
            boolean newValuesIsPresent;
            int[] decompressResult = this.deserializeCompressedInteger(content, offset);
            int pageOffset = decompressResult[0];
            offset = decompressResult[1];
            decompressResult = this.deserializeCompressedInteger(content, offset);
            int dataLength = decompressResult[0];
            offset = decompressResult[1];
            boolean bl = newValuesIsPresent = content[offset++] > 0;
            if (newValuesIsPresent) {
                newValues = new byte[dataLength];
                System.arraycopy(content, offset, newValues, 0, dataLength);
                offset += dataLength;
            } else {
                newValues = null;
            }
            byte[] oldValues = new byte[dataLength];
            System.arraycopy(content, offset, oldValues, 0, dataLength);
            offset += dataLength;
            this.changeUnits.add(new ChangeUnit(pageOffset, oldValues, newValues));
        }
        return offset;
    }

    private int compressedIntegerSize(int value) {
        if (value <= 127) {
            return 1;
        }
        if (value <= 16383) {
            return 2;
        }
        if (value <= 0x1FFFFF) {
            return 3;
        }
        throw new IllegalArgumentException("Values more than 2097151 are not supported.");
    }

    private int serializeCompressedInteger(byte[] content, int offset, int value) {
        if (value <= 127) {
            content[offset] = (byte)value;
            return offset + 1;
        }
        if (value <= 16383) {
            content[offset + 1] = (byte)(0xFF & value);
            content[offset] = (byte)(0x80 | (value >>>= 8));
            return offset + 2;
        }
        if (value <= 0x1FFFFF) {
            content[offset + 2] = (byte)(0xFF & value);
            content[offset + 1] = (byte)(0xFF & (value >>>= 8));
            content[offset] = (byte)(0xC0 | (value >>>= 8));
            return offset + 3;
        }
        throw new IllegalArgumentException("Values more than 2097151 are not supported.");
    }

    private int[] deserializeCompressedInteger(byte[] content, int offset) {
        if ((content[offset] & 0x80) == 0) {
            return new int[]{content[offset], offset + 1};
        }
        if ((content[offset] & 0xC0) == 128) {
            int value = 0xFF & content[offset + 1] | (content[offset] & 0x3F) << 8;
            return new int[]{value, offset + 2};
        }
        if ((content[offset] & 0xE0) == 192) {
            int value = 0xFF & content[offset + 2] | (0xFF & content[offset + 1]) << 8 | (content[offset] & 0x1F) << 16;
            return new int[]{value, offset + 3};
        }
        throw new IllegalArgumentException("Invalid integer format.");
    }

    private static final class ChangeUnit {
        private final int pageOffset;
        private final byte[] oldValues;
        private final byte[] newValues;

        private ChangeUnit(int pageOffset, byte[] oldValues, byte[] newValues) {
            this.pageOffset = pageOffset;
            this.oldValues = oldValues;
            this.newValues = newValues;
        }
    }
}

