/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.base;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileCreatedCreatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OPageChanges;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OUpdatePageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import java.io.IOException;

public abstract class ODurableComponent
extends OSharedResourceAdaptive {
    private OWriteAheadLog writeAheadLog;
    private OAtomicOperationsManager atomicOperationsManager;
    private OStorageLocalAbstract storage;

    public ODurableComponent() {
    }

    public ODurableComponent(int iTimeout) {
        super(iTimeout);
    }

    public ODurableComponent(boolean iConcurrent) {
        super(iConcurrent);
    }

    public ODurableComponent(boolean iConcurrent, int iTimeout, boolean ignoreThreadInterruption) {
        super(iConcurrent, iTimeout, ignoreThreadInterruption);
    }

    protected void init(OStorageLocalAbstract storage) {
        this.storage = storage;
        this.atomicOperationsManager = storage.getAtomicOperationsManager();
        this.writeAheadLog = storage.getWALInstance();
    }

    protected void endAtomicOperation(boolean rollback) throws IOException {
        this.atomicOperationsManager.endAtomicOperation(rollback);
    }

    protected void startAtomicOperation() throws IOException {
        this.atomicOperationsManager.startAtomicOperation();
    }

    protected void logPageChanges(ODurablePage localPage, long fileId, long pageIndex, boolean isNewPage) throws IOException {
        if (this.writeAheadLog != null) {
            OPageChanges pageChanges = localPage.getPageChanges();
            if (pageChanges.isEmpty()) {
                return;
            }
            OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
            assert (atomicOperation != null);
            OOperationUnitId unitId = atomicOperation.getOperationUnitId();
            OLogSequenceNumber prevLsn = isNewPage ? atomicOperation.getStartLSN() : localPage.getLsn();
            OLogSequenceNumber lsn = this.writeAheadLog.log(new OUpdatePageRecord(pageIndex, fileId, unitId, pageChanges, prevLsn));
            localPage.setLsn(lsn);
        }
    }

    protected void logFileCreation(String fileName, long fileId) throws IOException {
        if (this.writeAheadLog != null) {
            OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
            assert (atomicOperation != null);
            OOperationUnitId unitId = atomicOperation.getOperationUnitId();
            this.writeAheadLog.log(new OFileCreatedCreatedWALRecord(unitId, fileName, fileId));
        }
    }

    protected void lockTillAtomicOperationCompletes() {
        this.atomicOperationsManager.lockTillOperationComplete((Object)this);
    }

    protected ODurablePage.TrackMode getTrackMode() {
        OStorageTransaction transaction = this.storage.getStorageTransaction();
        OTransaction clientTx = transaction != null ? transaction.getClientTx() : null;
        ODurablePage.TrackMode trackMode = clientTx instanceof OTransactionOptimistic && !clientTx.isUsingLog() ? ODurablePage.TrackMode.NONE : (this.writeAheadLog == null ? ODurablePage.TrackMode.NONE : ODurablePage.TrackMode.FULL);
        return trackMode;
    }
}

