/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations;

import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import java.util.HashSet;
import java.util.Set;

public class OAtomicOperation {
    private final OLogSequenceNumber startLSN;
    private final OOperationUnitId operationUnitId;
    private int startCounter;
    private boolean rollback;
    private Set<Object> lockedObjects = new HashSet<Object>();

    public OAtomicOperation(OLogSequenceNumber startLSN, OOperationUnitId operationUnitId) {
        this.startLSN = startLSN;
        this.operationUnitId = operationUnitId;
        this.startCounter = 1;
    }

    public OLogSequenceNumber getStartLSN() {
        return this.startLSN;
    }

    public OOperationUnitId getOperationUnitId() {
        return this.operationUnitId;
    }

    void incrementCounter() {
        ++this.startCounter;
    }

    int decrementCounter() {
        --this.startCounter;
        return this.startCounter;
    }

    void rollback() {
        this.rollback = true;
    }

    boolean isRollback() {
        return this.rollback;
    }

    void addLockedObject(Object lockedObject) {
        this.lockedObjects.add(lockedObject);
    }

    boolean containsInLockedObjects(Object objectToLock) {
        return this.lockedObjects.contains(objectToLock);
    }

    Iterable<Object> lockedObjects() {
        return this.lockedObjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAtomicOperation operation = (OAtomicOperation)o;
        return this.operationUnitId.equals(operation.operationUnitId);
    }

    public int hashCode() {
        return this.operationUnitId.hashCode();
    }
}

