/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.concur.lock.OModificationLock;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.compression.OCompression;
import com.orientechnologies.orient.core.compression.OCompressionFactory;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPositionMap;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedClusterState;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.CRC32;

public class OPaginatedCluster
extends ODurableComponent
implements OCluster {
    public static final String DEF_EXTENSION = ".pcl";
    private static final int DISK_PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger();
    private static final int LOWEST_FREELIST_BOUNDARY = OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger();
    private static final int FREE_LIST_SIZE = DISK_PAGE_SIZE - LOWEST_FREELIST_BOUNDARY;
    private volatile OCompression compression;
    public static final String TYPE = "PHYSICAL";
    private static final int PAGE_INDEX_OFFSET = 16;
    private static final int RECORD_POSITION_MASK = 65535;
    private static final int ONE_KB = 1024;
    private ODiskCache diskCache;
    private OClusterPositionMap clusterPositionMap;
    private String name;
    private OLocalPaginatedStorage storageLocal;
    private volatile int id;
    private long fileId;
    private OStoragePaginatedClusterConfiguration config;
    private final OModificationLock externalModificationLock = new OModificationLock();
    private OCacheEntry pinnedStateEntry;
    private boolean useCRC32 = OGlobalConfiguration.STORAGE_USE_CRC32_FOR_EACH_RECORD.getValueAsBoolean();

    public OPaginatedCluster() {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(OStorage storage, int id, String clusterName, String location, int dataSegmentId, Object ... parameters) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.config = new OStoragePaginatedClusterConfiguration(storage.getConfiguration(), id, clusterName, null, true, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.getValueAsString());
                this.config.name = clusterName;
                this.init((OLocalPaginatedStorage)storage, this.config);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(OStorage storage, OStorageClusterConfiguration config) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.init((OLocalPaginatedStorage)storage, config);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    private void init(OLocalPaginatedStorage storage, OStorageClusterConfiguration config) throws IOException {
        OFileUtils.checkValidName((String)config.getName());
        this.config = (OStoragePaginatedClusterConfiguration)config;
        this.compression = OCompressionFactory.INSTANCE.getCompression(this.config.compression);
        this.storageLocal = storage;
        OAtomicOperationsManager atomicOperationsManager = storage.getAtomicOperationsManager();
        OWriteAheadLog writeAheadLog = storage.getWALInstance();
        this.init(storage);
        this.diskCache = this.storageLocal.getDiskCache();
        this.name = config.getName();
        this.id = config.getId();
        this.clusterPositionMap = new OClusterPositionMap(storage, this.diskCache, this.name, this.config.useWal);
    }

    @Override
    public boolean exists() {
        return this.diskCache.exists(this.name + DEF_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(int startSize) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.fileId = this.diskCache.openFile(this.name + DEF_EXTENSION);
                this.startAtomicOperation();
                this.initCusterState();
                this.endAtomicOperation(false);
                if (this.config.root.clusters.size() <= this.config.id) {
                    this.config.root.clusters.add(this.config);
                } else {
                    this.config.root.clusters.set(this.config.id, this.config);
                }
                this.clusterPositionMap.create();
            }
            catch (Throwable e) {
                this.endAtomicOperation(true);
                throw new OStorageException(null, e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public void open() throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.fileId = this.diskCache.openFile(this.name + DEF_EXTENSION);
                this.pinnedStateEntry = this.diskCache.load(this.fileId, 0L, false);
                try {
                    this.diskCache.pinPage(this.pinnedStateEntry);
                }
                finally {
                    this.diskCache.release(this.pinnedStateEntry);
                }
                this.clusterPositionMap.open();
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Override
    public void close(boolean flush) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                if (flush) {
                    this.synch();
                }
                this.diskCache.closeFile(this.fileId, flush);
                this.clusterPositionMap.close(flush);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public void delete() throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.diskCache.deleteFile(this.fileId);
                this.clusterPositionMap.delete();
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(OCluster.ATTRIBUTES attribute, Object value) throws IOException {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = value != null ? value.toString() : null;
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                switch (attribute) {
                    case NAME: {
                        this.setNameInternal(stringValue);
                        return;
                    }
                    case USE_WAL: {
                        this.setUseWalInternal(stringValue);
                        return;
                    }
                    case RECORD_GROW_FACTOR: {
                        this.setRecordGrowFactorInternal(stringValue);
                        return;
                    }
                    case RECORD_OVERFLOW_GROW_FACTOR: {
                        this.setRecordOverflowGrowFactorInternal(stringValue);
                        return;
                    }
                    case COMPRESSION: {
                        if (this.getEntries() > 0L) {
                            throw new IllegalArgumentException("Cannot change compression setting on cluster '" + this.getName() + "' because it is not empty");
                        }
                        this.setCompressionInternal(stringValue);
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("Runtime change of attribute '" + (Object)((Object)attribute) + " is not supported");
                    }
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    private void setCompressionInternal(String stringValue) {
        try {
            this.compression = OCompressionFactory.INSTANCE.getCompression(stringValue);
            this.config.compression = stringValue;
            this.storageLocal.getConfiguration().update();
        }
        catch (IllegalArgumentException e) {
            throw new OStorageException("Invalid value for " + (Object)((Object)OCluster.ATTRIBUTES.COMPRESSION) + " attribute. ", e);
        }
    }

    private void setRecordOverflowGrowFactorInternal(String stringValue) {
        try {
            float growFactor = Float.parseFloat(stringValue);
            if (growFactor < 1.0f) {
                throw new OStorageException((Object)((Object)OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR) + " can not be less than 1");
            }
            this.config.recordOverflowGrowFactor = growFactor;
            this.storageLocal.getConfiguration().update();
        }
        catch (NumberFormatException nfe) {
            throw new OStorageException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR) + " was passed [" + stringValue + "].", nfe);
        }
    }

    private void setRecordGrowFactorInternal(String stringValue) {
        try {
            float growFactor = Float.parseFloat(stringValue);
            if (growFactor < 1.0f) {
                throw new OStorageException((Object)((Object)OCluster.ATTRIBUTES.RECORD_GROW_FACTOR) + " can not be less than 1");
            }
            this.config.recordGrowFactor = growFactor;
            this.storageLocal.getConfiguration().update();
        }
        catch (NumberFormatException nfe) {
            throw new OStorageException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.RECORD_GROW_FACTOR) + " was passed [" + stringValue + "].", nfe);
        }
    }

    private void setUseWalInternal(String stringValue) {
        if (!stringValue.equals("true") && !stringValue.equals("false")) {
            throw new OStorageException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.USE_WAL) + " was passed [" + stringValue + "].");
        }
        this.config.useWal = Boolean.valueOf(stringValue);
        this.clusterPositionMap.setUseWal(this.config.useWal);
        this.storageLocal.getConfiguration().update();
    }

    private void setNameInternal(String newName) throws IOException {
        this.diskCache.renameFile(this.fileId, this.name + DEF_EXTENSION, newName + DEF_EXTENSION);
        this.clusterPositionMap.rename(newName);
        this.config.name = newName;
        this.storageLocal.renameCluster(this.name, newName);
        this.name = newName;
        this.storageLocal.getConfiguration().update();
    }

    @Override
    public boolean useWal() {
        this.acquireSharedLock();
        try {
            boolean bl = this.config.useWal;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public float recordGrowFactor() {
        this.acquireSharedLock();
        try {
            float f = this.config.recordGrowFactor;
            return f;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public float recordOverflowGrowFactor() {
        this.acquireSharedLock();
        try {
            float f = this.config.recordOverflowGrowFactor;
            return f;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String compression() {
        this.acquireSharedLock();
        try {
            String string = this.config.compression;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void convertToTombstone(OClusterPosition iPosition) throws IOException {
        throw new UnsupportedOperationException("convertToTombstone");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OPhysicalPosition createRecord(byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        content = this.compression.compress(content);
        this.externalModificationLock.requestModificationLock();
        this.acquireExclusiveLock();
        int grownContentSize = (int)(this.config.recordGrowFactor * (float)content.length);
        int entryContentLength = grownContentSize + 2 + 4 + 8;
        if (this.useCRC32) {
            entryContentLength += 4;
        }
        if (entryContentLength < OClusterPage.MAX_RECORD_SIZE) {
            this.startAtomicOperation();
            try {
                this.lockTillAtomicOperationCompletes();
                byte[] entryContent = new byte[entryContentLength];
                int entryPosition = 0;
                entryContent[entryPosition] = recordType;
                OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(content.length), entryContent, ++entryPosition, new Object[0]);
                System.arraycopy(content, 0, entryContent, entryPosition += 4, content.length);
                entryPosition += grownContentSize;
                if (this.useCRC32) {
                    CRC32 crc32 = new CRC32();
                    crc32.update(entryContent, 0, entryPosition);
                    OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf((int)crc32.getValue()), entryContent, entryPosition, new Object[0]);
                    entryPosition += 4;
                }
                entryContent[entryPosition] = 1;
                OLongSerializer.INSTANCE.serializeNative(Long.valueOf(-1L), entryContent, ++entryPosition, new Object[0]);
                ODurablePage.TrackMode trackMode = this.getTrackMode();
                AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, trackMode);
                this.updateClusterState(trackMode, 1L, addEntryResult.recordsSizeDiff);
                OClusterPosition clusterPosition = this.clusterPositionMap.add(addEntryResult.pageIndex, addEntryResult.pagePosition);
                this.endAtomicOperation(false);
                OPhysicalPosition oPhysicalPosition = this.createPhysicalPosition(recordType, clusterPosition, addEntryResult.recordVersion);
                return oPhysicalPosition;
            }
            catch (Throwable e) {
                this.endAtomicOperation(true);
                throw new OStorageException(null, e);
            }
        }
        this.startAtomicOperation();
        try {
            this.lockTillAtomicOperationCompletes();
            ODurablePage.TrackMode trackMode = this.getTrackMode();
            int entrySize = grownContentSize + 4 + 1;
            if (this.useCRC32) {
                entrySize += 4;
            }
            int fullEntryPosition = 0;
            byte[] fullEntry = new byte[entrySize];
            fullEntry[fullEntryPosition] = recordType;
            OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(content.length), fullEntry, ++fullEntryPosition, new Object[0]);
            System.arraycopy(content, 0, fullEntry, fullEntryPosition += 4, content.length);
            fullEntryPosition += grownContentSize;
            if (this.useCRC32) {
                CRC32 crc32 = new CRC32();
                crc32.update(fullEntry, 0, fullEntryPosition);
                OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf((int)crc32.getValue()), fullEntry, fullEntryPosition, new Object[0]);
            }
            long prevPageRecordPointer = -1L;
            long firstPageIndex = -1L;
            int firstPagePosition = -1;
            ORecordVersion version = null;
            int from = 0;
            int to = from + (OClusterPage.MAX_RECORD_SIZE - 1 - 8);
            int recordsSizeDiff = 0;
            do {
                byte[] entryContent = new byte[to - from + 1 + 8];
                System.arraycopy(fullEntry, from, entryContent, 0, to - from);
                entryContent[entryContent.length - 8 - 1] = from > 0 ? (byte)0 : 1;
                OLongSerializer.INSTANCE.serializeNative(Long.valueOf(-1L), entryContent, entryContent.length - 8, new Object[0]);
                AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, trackMode);
                recordsSizeDiff += addEntryResult.recordsSizeDiff;
                if (firstPageIndex == -1L) {
                    firstPageIndex = addEntryResult.pageIndex;
                    firstPagePosition = addEntryResult.pagePosition;
                    version = addEntryResult.recordVersion;
                }
                long addedPagePointer = this.createPagePointer(addEntryResult.pageIndex, addEntryResult.pagePosition);
                if (prevPageRecordPointer >= 0L) {
                    long prevPageIndex = prevPageRecordPointer >>> 16;
                    int prevPageRecordPosition = (int)(prevPageRecordPointer & 0xFFFFL);
                    OCacheEntry prevPageCacheEntry = this.diskCache.load(this.fileId, prevPageIndex, false);
                    prevPageCacheEntry.acquireExclusiveLock();
                    try {
                        OClusterPage prevPage = new OClusterPage(prevPageCacheEntry, false, ODurablePage.TrackMode.FULL);
                        prevPage.setRecordLongValue(prevPageRecordPosition, -8, addedPagePointer);
                        this.logPageChanges(prevPage, this.fileId, prevPageIndex, false);
                        prevPageCacheEntry.markDirty();
                    }
                    finally {
                        prevPageCacheEntry.releaseExclusiveLock();
                        this.diskCache.release(prevPageCacheEntry);
                    }
                }
                prevPageRecordPointer = addedPagePointer;
                from = to;
                if ((to += OClusterPage.MAX_RECORD_SIZE - 8 - 1) <= fullEntry.length) continue;
                to = fullEntry.length;
            } while (from < to);
            this.updateClusterState(trackMode, 1L, recordsSizeDiff);
            OClusterPosition clusterPosition = this.clusterPositionMap.add(firstPageIndex, firstPagePosition);
            this.endAtomicOperation(false);
            return this.createPhysicalPosition(recordType, clusterPosition, version);
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    private long createPagePointer(long pageIndex, int pagePosition) {
        return pageIndex << 16 | (long)pagePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClusterState(ODurablePage.TrackMode trackMode, long sizeDiff, long recordsSizeDiff) throws IOException {
        this.diskCache.loadPinnedPage(this.pinnedStateEntry);
        this.pinnedStateEntry.acquireExclusiveLock();
        try {
            OPaginatedClusterState paginatedClusterState = new OPaginatedClusterState(this.pinnedStateEntry, trackMode);
            paginatedClusterState.setSize(paginatedClusterState.getSize() + sizeDiff);
            paginatedClusterState.setRecordsSize(paginatedClusterState.getRecordsSize() + recordsSizeDiff);
            this.logPageChanges(paginatedClusterState, this.fileId, this.pinnedStateEntry.getPageIndex(), false);
            this.pinnedStateEntry.markDirty();
        }
        finally {
            this.pinnedStateEntry.releaseExclusiveLock();
            this.diskCache.release(this.pinnedStateEntry);
        }
    }

    private OPhysicalPosition createPhysicalPosition(byte recordType, OClusterPosition clusterPosition, ORecordVersion version) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        physicalPosition.recordType = recordType;
        physicalPosition.recordSize = -1;
        physicalPosition.dataSegmentId = -1;
        physicalPosition.dataSegmentPos = -1L;
        physicalPosition.clusterPosition = clusterPosition;
        physicalPosition.recordVersion = version;
        return physicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORawBuffer readRecord(OClusterPosition clusterPosition) throws IOException {
        this.acquireSharedLock();
        try {
            OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition);
            if (positionEntry == null) {
                ORawBuffer oRawBuffer = null;
                return oRawBuffer;
            }
            int recordPosition = positionEntry.getRecordPosition();
            long pageIndex = positionEntry.getPageIndex();
            if (this.diskCache.getFilledUpTo(this.fileId) <= pageIndex) {
                ORawBuffer oRawBuffer = null;
                return oRawBuffer;
            }
            ORecordVersion recordVersion = null;
            OCacheEntry cacheEntry = this.diskCache.load(this.fileId, pageIndex, false);
            try {
                OClusterPage localPage = new OClusterPage(cacheEntry, false, ODurablePage.TrackMode.NONE);
                if (localPage.isDeleted(recordPosition)) {
                    ORawBuffer oRawBuffer = null;
                    return oRawBuffer;
                }
                recordVersion = localPage.getRecordVersion(recordPosition);
            }
            finally {
                this.diskCache.release(cacheEntry);
            }
            byte[] fullContent = this.readFullEntry(clusterPosition, pageIndex, recordPosition);
            if (fullContent == null) {
                ORawBuffer oRawBuffer = null;
                return oRawBuffer;
            }
            if (this.useCRC32) {
                CRC32 crc32 = new CRC32();
                int crcPosition = fullContent.length - 8 - 1 - 4;
                crc32.update(fullContent, 0, crcPosition);
                int crc = OIntegerSerializer.INSTANCE.deserializeNative(fullContent, crcPosition);
                if (crc != (int)crc32.getValue()) {
                    throw new OStorageException("Content of record for cluster with id " + this.id + " and position " + clusterPosition + " is broken.");
                }
            }
            int fullContentPosition = 0;
            byte recordType = fullContent[fullContentPosition];
            int readContentSize = OIntegerSerializer.INSTANCE.deserializeNative(fullContent, ++fullContentPosition);
            byte[] recordContent = this.compression.uncompress(fullContent, fullContentPosition += 4, readContentSize);
            ORawBuffer oRawBuffer = new ORawBuffer(recordContent, recordVersion, recordType);
            return oRawBuffer;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFullEntry(OClusterPosition clusterPosition, long pageIndex, int recordPosition) throws IOException {
        byte[] fullContent;
        if (this.diskCache.getFilledUpTo(this.fileId) <= pageIndex) {
            return null;
        }
        ArrayList<byte[]> recordChunks = new ArrayList<byte[]>();
        int contentSize = 0;
        long nextPagePointer = -1L;
        boolean firstEntry = true;
        do {
            OCacheEntry cacheEntry = this.diskCache.load(this.fileId, pageIndex, false);
            try {
                OClusterPage localPage = new OClusterPage(cacheEntry, false, ODurablePage.TrackMode.NONE);
                if (localPage.isDeleted(recordPosition)) {
                    if (recordChunks.isEmpty()) {
                        Iterator iterator = null;
                        return iterator;
                    }
                    throw new OStorageException("Content of record " + new ORecordId(this.id, clusterPosition) + " was broken.");
                }
                byte[] content = localPage.getRecordBinaryValue(recordPosition, 0, localPage.getRecordSize(recordPosition));
                if (firstEntry && content[content.length - 8 - 1] == 0) {
                    byte[] byArray = null;
                    return byArray;
                }
                recordChunks.add(content);
                nextPagePointer = OLongSerializer.INSTANCE.deserializeNative(content, content.length - 8);
                contentSize += content.length - 8 - 1;
                firstEntry = false;
            }
            finally {
                this.diskCache.release(cacheEntry);
            }
            pageIndex = nextPagePointer >>> 16;
            recordPosition = (int)(nextPagePointer & 0xFFFFL);
        } while (nextPagePointer >= 0L);
        if (recordChunks.size() == 1) {
            fullContent = (byte[])recordChunks.get(0);
        } else {
            fullContent = new byte[contentSize + 8 + 1];
            int fullContentPosition = 0;
            for (byte[] recordChuck : recordChunks) {
                System.arraycopy(recordChuck, 0, fullContent, fullContentPosition, recordChuck.length - 8 - 1);
                fullContentPosition += recordChuck.length - 8 - 1;
            }
        }
        return fullContent;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean deleteRecord(OClusterPosition clusterPosition) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 24[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean hideRecord(OClusterPosition position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(OClusterPosition clusterPosition, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        content = this.compression.compress(content);
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                byte[] recordEntry;
                OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition);
                if (positionEntry == null) {
                    return;
                }
                int recordPosition = positionEntry.getRecordPosition();
                long pageIndex = positionEntry.getPageIndex();
                long pagePointer = this.createPagePointer(pageIndex, recordPosition);
                byte[] fullEntryContent = this.readFullEntry(clusterPosition, pageIndex, recordPosition);
                if (fullEntryContent == null) {
                    return;
                }
                if (this.useCRC32) {
                    CRC32 crc32 = new CRC32();
                    int crcPosition = fullEntryContent.length - 8 - 1 - 4;
                    crc32.update(fullEntryContent, 0, crcPosition);
                    int crc = OIntegerSerializer.INSTANCE.deserializeNative(fullEntryContent, crcPosition);
                    if (crc != (int)crc32.getValue()) {
                        throw new OStorageException("Content of record for cluster with id " + this.id + " and position " + clusterPosition + " is broken.");
                    }
                }
                int updatedContentLength = content.length + 2 + 4 + 8;
                if (this.useCRC32) {
                    updatedContentLength += 4;
                }
                if (updatedContentLength <= fullEntryContent.length) {
                    recordEntry = new byte[fullEntryContent.length - 8 - 1];
                } else {
                    int grownContent = (int)((float)content.length * this.config.recordOverflowGrowFactor);
                    recordEntry = !this.useCRC32 ? new byte[grownContent + 1 + 4] : new byte[grownContent + 1 + 8];
                }
                ODurablePage.TrackMode trackMode = this.getTrackMode();
                this.startAtomicOperation();
                try {
                    this.lockTillAtomicOperationCompletes();
                    int entryPosition = 0;
                    recordEntry[entryPosition] = recordType;
                    OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(content.length), recordEntry, ++entryPosition, new Object[0]);
                    System.arraycopy(content, 0, recordEntry, entryPosition += 4, content.length);
                    if (this.useCRC32) {
                        CRC32 crc32 = new CRC32();
                        int crcPosition = recordEntry.length - 4;
                        crc32.update(recordEntry, 0, crcPosition);
                        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf((int)crc32.getValue()), recordEntry, crcPosition, new Object[0]);
                    }
                    int recordsSizeDiff = 0;
                    long prevPageRecordPointer = -1L;
                    int currentPos = 0;
                    while (pagePointer >= 0L && currentPos < recordEntry.length) {
                        int freePageIndex;
                        recordPosition = (int)(pagePointer & 0xFFFFL);
                        pageIndex = pagePointer >>> 16;
                        OCacheEntry cacheEntry = this.diskCache.load(this.fileId, pageIndex, false);
                        cacheEntry.acquireExclusiveLock();
                        try {
                            OClusterPage localPage = new OClusterPage(cacheEntry, false, trackMode);
                            int freeSpace = localPage.getFreeSpace();
                            freePageIndex = this.calculateFreePageIndex(localPage);
                            int chunkSize = localPage.getRecordSize(recordPosition);
                            long nextPagePointer = localPage.getRecordLongValue(recordPosition, -8);
                            int newChunkLen = Math.min(recordEntry.length - currentPos + 8 + 1, chunkSize);
                            int dataLen = newChunkLen - 8 - 1;
                            byte[] newRecordChunk = new byte[newChunkLen];
                            System.arraycopy(recordEntry, currentPos, newRecordChunk, 0, dataLen);
                            newRecordChunk[newRecordChunk.length - 8 - 1] = currentPos > 0 ? (byte)0 : 1;
                            OLongSerializer.INSTANCE.serializeNative(Long.valueOf(-1L), newRecordChunk, newRecordChunk.length - 8, new Object[0]);
                            if (prevPageRecordPointer >= 0L) {
                                long prevPageIndex = prevPageRecordPointer >>> 16;
                                int prevPageRecordPosition = (int)(prevPageRecordPointer & 0xFFFFL);
                                OCacheEntry prevPageCacheEntry = this.diskCache.load(this.fileId, prevPageIndex, false);
                                prevPageCacheEntry.acquireExclusiveLock();
                                try {
                                    OClusterPage prevPage = new OClusterPage(prevPageCacheEntry, false, trackMode);
                                    prevPage.setRecordLongValue(prevPageRecordPosition, -8, pagePointer);
                                    this.logPageChanges(prevPage, this.fileId, prevPageIndex, false);
                                    prevPageCacheEntry.markDirty();
                                }
                                finally {
                                    prevPageCacheEntry.releaseExclusiveLock();
                                    this.diskCache.release(prevPageCacheEntry);
                                }
                            }
                            localPage.replaceRecord(recordPosition, newRecordChunk, recordVersion.getCounter() != -2 ? recordVersion : null);
                            currentPos += dataLen;
                            recordsSizeDiff += freeSpace - localPage.getFreeSpace();
                            prevPageRecordPointer = pagePointer;
                            pagePointer = nextPagePointer;
                            this.logPageChanges(localPage, this.fileId, pageIndex, false);
                        }
                        finally {
                            cacheEntry.releaseExclusiveLock();
                            this.diskCache.release(cacheEntry);
                        }
                        this.updateFreePagesIndex(freePageIndex, pageIndex, trackMode);
                    }
                    int from = currentPos;
                    int to = from + (OClusterPage.MAX_RECORD_SIZE - 1 - 8);
                    if (to > recordEntry.length) {
                        to = recordEntry.length;
                    }
                    while (from < to) {
                        byte[] entryContent = new byte[to - from + 1 + 8];
                        System.arraycopy(recordEntry, from, entryContent, 0, to - from);
                        entryContent[entryContent.length - 8 - 1] = from > 0 ? (byte)0 : 1;
                        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(-1L), entryContent, entryContent.length - 8, new Object[0]);
                        AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, trackMode);
                        recordsSizeDiff += addEntryResult.recordsSizeDiff;
                        long addedPagePointer = this.createPagePointer(addEntryResult.pageIndex, addEntryResult.pagePosition);
                        if (prevPageRecordPointer >= 0L) {
                            long prevPageIndex = prevPageRecordPointer >>> 16;
                            int prevPageRecordPosition = (int)(prevPageRecordPointer & 0xFFFFL);
                            OCacheEntry prevPageCacheEntry = this.diskCache.load(this.fileId, prevPageIndex, false);
                            prevPageCacheEntry.acquireExclusiveLock();
                            try {
                                OClusterPage prevPage = new OClusterPage(prevPageCacheEntry, false, trackMode);
                                prevPage.setRecordLongValue(prevPageRecordPosition, -8, addedPagePointer);
                                this.logPageChanges(prevPage, this.fileId, prevPageIndex, false);
                                prevPageCacheEntry.markDirty();
                            }
                            finally {
                                prevPageCacheEntry.releaseExclusiveLock();
                                this.diskCache.release(prevPageCacheEntry);
                            }
                        }
                        prevPageRecordPointer = addedPagePointer;
                        from = to;
                        if ((to += OClusterPage.MAX_RECORD_SIZE - 8 - 1) <= recordEntry.length) continue;
                        to = recordEntry.length;
                    }
                    this.updateClusterState(trackMode, 0L, recordsSizeDiff);
                    this.endAtomicOperation(false);
                }
                catch (Throwable e) {
                    this.endAtomicOperation(true);
                    throw new OStorageException(null, e);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddEntryResult addEntry(ORecordVersion recordVersion, byte[] entryContent, ODurablePage.TrackMode trackMode) throws IOException {
        int recordSizesDiff;
        ORecordVersion finalVersion;
        int position;
        FindFreePageResult findFreePageResult = this.findFreePage(entryContent.length, trackMode);
        int freePageIndex = findFreePageResult.freePageIndex;
        long pageIndex = findFreePageResult.pageIndex;
        boolean newRecord = freePageIndex >= FREE_LIST_SIZE;
        OCacheEntry cacheEntry = this.diskCache.load(this.fileId, pageIndex, false);
        cacheEntry.acquireExclusiveLock();
        try {
            OClusterPage localPage = new OClusterPage(cacheEntry, newRecord, trackMode);
            assert (newRecord || freePageIndex == this.calculateFreePageIndex(localPage));
            int initialFreeSpace = localPage.getFreeSpace();
            position = localPage.appendRecord(recordVersion, entryContent, false);
            assert (position >= 0);
            finalVersion = localPage.getRecordVersion(position);
            int freeSpace = localPage.getFreeSpace();
            recordSizesDiff = initialFreeSpace - freeSpace;
            this.logPageChanges(localPage, this.fileId, pageIndex, newRecord);
        }
        finally {
            cacheEntry.releaseExclusiveLock();
            this.diskCache.release(cacheEntry);
        }
        this.updateFreePagesIndex(freePageIndex, pageIndex, trackMode);
        return new AddEntryResult(pageIndex, position, finalVersion, recordSizesDiff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindFreePageResult findFreePage(int contentSize, ODurablePage.TrackMode trackMode) throws IOException {
        this.diskCache.loadPinnedPage(this.pinnedStateEntry);
        try {
            long pageIndex;
            int freePageIndex;
            while (true) {
                int realFreePageIndex;
                freePageIndex = contentSize / 1024;
                if ((freePageIndex -= OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger()) < 0) {
                    freePageIndex = 0;
                }
                OPaginatedClusterState freePageLists = new OPaginatedClusterState(this.pinnedStateEntry, ODurablePage.TrackMode.NONE);
                while ((pageIndex = freePageLists.getFreeListPage(freePageIndex)) < 0L && ++freePageIndex < FREE_LIST_SIZE) {
                }
                if (pageIndex < 0L) {
                    pageIndex = this.diskCache.getFilledUpTo(this.fileId);
                } else {
                    --freePageIndex;
                }
                if (freePageIndex >= FREE_LIST_SIZE) break;
                OCacheEntry cacheEntry = this.diskCache.load(this.fileId, pageIndex, false);
                try {
                    OClusterPage localPage = new OClusterPage(cacheEntry, false, ODurablePage.TrackMode.NONE);
                    realFreePageIndex = this.calculateFreePageIndex(localPage);
                }
                finally {
                    this.diskCache.release(cacheEntry);
                }
                if (realFreePageIndex == freePageIndex) break;
                OLogManager.instance().warn((Object)this, "Page in file %s with index %d was placed in wrong free list, this error will be fixed automatically.", new Object[]{this.name + DEF_EXTENSION, pageIndex});
                this.updateFreePagesIndex(freePageIndex, pageIndex, trackMode);
            }
            FindFreePageResult findFreePageResult = new FindFreePageResult(pageIndex, freePageIndex);
            return findFreePageResult;
        }
        finally {
            this.diskCache.release(this.pinnedStateEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFreePagesIndex(int prevFreePageIndex, long pageIndex, ODurablePage.TrackMode trackMode) throws IOException {
        OCacheEntry cacheEntry = this.diskCache.load(this.fileId, pageIndex, false);
        cacheEntry.acquireExclusiveLock();
        try {
            OClusterPage localPage = new OClusterPage(cacheEntry, false, trackMode);
            int newFreePageIndex = this.calculateFreePageIndex(localPage);
            if (prevFreePageIndex == newFreePageIndex) {
                return;
            }
            long nextPageIndex = localPage.getNextPage();
            long prevPageIndex = localPage.getPrevPage();
            if (prevPageIndex >= 0L) {
                OCacheEntry prevPageCacheEntry = this.diskCache.load(this.fileId, prevPageIndex, false);
                prevPageCacheEntry.acquireExclusiveLock();
                try {
                    OClusterPage prevPage = new OClusterPage(prevPageCacheEntry, false, trackMode);
                    assert (this.calculateFreePageIndex(prevPage) == prevFreePageIndex);
                    prevPage.setNextPage(nextPageIndex);
                    this.logPageChanges(prevPage, this.fileId, prevPageIndex, false);
                    prevPageCacheEntry.markDirty();
                }
                finally {
                    prevPageCacheEntry.releaseExclusiveLock();
                    this.diskCache.release(prevPageCacheEntry);
                }
            }
            if (nextPageIndex >= 0L) {
                OCacheEntry nextPageCacheEntry = this.diskCache.load(this.fileId, nextPageIndex, false);
                nextPageCacheEntry.acquireExclusiveLock();
                try {
                    OClusterPage nextPage = new OClusterPage(nextPageCacheEntry, false, trackMode);
                    if (this.calculateFreePageIndex(nextPage) != prevFreePageIndex) {
                        this.calculateFreePageIndex(nextPage);
                    }
                    assert (this.calculateFreePageIndex(nextPage) == prevFreePageIndex);
                    nextPage.setPrevPage(prevPageIndex);
                    this.logPageChanges(nextPage, this.fileId, nextPageIndex, false);
                }
                finally {
                    nextPageCacheEntry.releaseExclusiveLock();
                    this.diskCache.release(nextPageCacheEntry);
                }
            }
            localPage.setNextPage(-1L);
            localPage.setPrevPage(-1L);
            if (prevFreePageIndex < 0 && newFreePageIndex < 0) {
                return;
            }
            if (prevFreePageIndex >= 0 && prevFreePageIndex < FREE_LIST_SIZE && prevPageIndex < 0L) {
                this.updateFreePagesList(prevFreePageIndex, nextPageIndex);
            }
            if (newFreePageIndex >= 0) {
                long oldFreePage;
                this.diskCache.loadPinnedPage(this.pinnedStateEntry);
                try {
                    OPaginatedClusterState clusterFreeList = new OPaginatedClusterState(this.pinnedStateEntry, ODurablePage.TrackMode.NONE);
                    oldFreePage = clusterFreeList.getFreeListPage(newFreePageIndex);
                }
                finally {
                    this.diskCache.release(this.pinnedStateEntry);
                }
                if (oldFreePage >= 0L) {
                    OCacheEntry oldFreePageCacheEntry = this.diskCache.load(this.fileId, oldFreePage, false);
                    oldFreePageCacheEntry.acquireExclusiveLock();
                    try {
                        OClusterPage oldFreeLocalPage = new OClusterPage(oldFreePageCacheEntry, false, trackMode);
                        assert (this.calculateFreePageIndex(oldFreeLocalPage) == newFreePageIndex);
                        oldFreeLocalPage.setPrevPage(pageIndex);
                        this.logPageChanges(oldFreeLocalPage, this.fileId, oldFreePage, false);
                        oldFreePageCacheEntry.markDirty();
                    }
                    finally {
                        oldFreePageCacheEntry.releaseExclusiveLock();
                        this.diskCache.release(oldFreePageCacheEntry);
                    }
                    localPage.setNextPage(oldFreePage);
                    localPage.setPrevPage(-1L);
                }
                this.updateFreePagesList(newFreePageIndex, pageIndex);
            }
            this.logPageChanges(localPage, this.fileId, pageIndex, false);
        }
        finally {
            cacheEntry.releaseExclusiveLock();
            this.diskCache.release(cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFreePagesList(int freeListIndex, long pageIndex) throws IOException {
        ODurablePage.TrackMode trackMode = this.getTrackMode();
        this.diskCache.loadPinnedPage(this.pinnedStateEntry);
        this.pinnedStateEntry.acquireExclusiveLock();
        try {
            OPaginatedClusterState paginatedClusterState = new OPaginatedClusterState(this.pinnedStateEntry, trackMode);
            paginatedClusterState.setFreeListPage(freeListIndex, pageIndex);
            this.logPageChanges(paginatedClusterState, this.fileId, this.pinnedStateEntry.getPageIndex(), false);
            this.pinnedStateEntry.markDirty();
        }
        finally {
            this.pinnedStateEntry.releaseExclusiveLock();
            this.diskCache.release(this.pinnedStateEntry);
        }
    }

    private int calculateFreePageIndex(OClusterPage localPage) {
        int newFreePageIndex;
        if (localPage.isEmpty()) {
            newFreePageIndex = FREE_LIST_SIZE - 1;
        } else {
            newFreePageIndex = (localPage.getMaxRecordSize() - 1023) / 1024;
            newFreePageIndex -= LOWEST_FREELIST_BOUNDARY;
        }
        return newFreePageIndex;
    }

    @Override
    public long getTombstonesCount() {
        return 0L;
    }

    @Override
    public boolean hasTombstonesSupport() {
        return false;
    }

    @Override
    public void truncate() throws IOException {
        this.storageLocal.checkForClusterPermissions(this.getName());
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                if (this.config.useWal) {
                    this.startAtomicOperation();
                }
                this.diskCache.truncateFile(this.fileId);
                this.clusterPositionMap.truncate();
                this.initCusterState();
                if (this.config.useWal) {
                    this.endAtomicOperation(false);
                }
            }
            catch (Throwable e) {
                if (this.config.useWal) {
                    this.endAtomicOperation(true);
                }
                throw new OStorageException(null, e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
        this.storageLocal.scheduleFullCheckpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCusterState() throws IOException {
        ODurablePage.TrackMode trackMode = this.getTrackMode();
        this.pinnedStateEntry = this.diskCache.allocateNewPage(this.fileId);
        this.pinnedStateEntry.acquireExclusiveLock();
        try {
            OPaginatedClusterState paginatedClusterState = new OPaginatedClusterState(this.pinnedStateEntry, trackMode);
            this.diskCache.pinPage(this.pinnedStateEntry);
            paginatedClusterState.setSize(0L);
            paginatedClusterState.setRecordsSize(0L);
            for (int i = 0; i < FREE_LIST_SIZE; ++i) {
                paginatedClusterState.setFreeListPage(i, -1L);
            }
            this.logPageChanges(paginatedClusterState, this.fileId, this.pinnedStateEntry.getPageIndex(), true);
            this.pinnedStateEntry.markDirty();
        }
        finally {
            this.pinnedStateEntry.releaseExclusiveLock();
            this.diskCache.release(this.pinnedStateEntry);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public int getDataSegmentId() {
        return -1;
    }

    @Override
    public boolean addPhysicalPosition(OPhysicalPosition iPPosition) throws IOException {
        throw new UnsupportedOperationException("addPhysicalPosition");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            OClusterPage localPage;
            OCacheEntry cacheEntry;
            int recordPosition;
            block15: {
                block14: {
                    OClusterPosition clusterPosition = position.clusterPosition;
                    OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition);
                    if (positionEntry == null) {
                        OPhysicalPosition oPhysicalPosition = null;
                        return oPhysicalPosition;
                    }
                    long pageIndex = positionEntry.getPageIndex();
                    recordPosition = positionEntry.getRecordPosition();
                    long pagesCount = this.diskCache.getFilledUpTo(this.fileId);
                    if (pageIndex >= pagesCount) {
                        OPhysicalPosition oPhysicalPosition = null;
                        return oPhysicalPosition;
                    }
                    cacheEntry = this.diskCache.load(this.fileId, pageIndex, false);
                    try {
                        localPage = new OClusterPage(cacheEntry, false, ODurablePage.TrackMode.NONE);
                        if (!localPage.isDeleted(recordPosition)) break block14;
                        OPhysicalPosition oPhysicalPosition = null;
                        this.diskCache.release(cacheEntry);
                        return oPhysicalPosition;
                    }
                    catch (Throwable throwable) {
                        this.diskCache.release(cacheEntry);
                        throw throwable;
                    }
                }
                if (localPage.getRecordByteValue(recordPosition, -9) != 0) break block15;
                OPhysicalPosition oPhysicalPosition = null;
                this.diskCache.release(cacheEntry);
                return oPhysicalPosition;
            }
            OPhysicalPosition physicalPosition = new OPhysicalPosition();
            physicalPosition.dataSegmentId = -1;
            physicalPosition.dataSegmentPos = -1L;
            physicalPosition.recordSize = -1;
            physicalPosition.recordType = localPage.getRecordByteValue(recordPosition, 0);
            physicalPosition.recordVersion = localPage.getRecordVersion(recordPosition);
            physicalPosition.clusterPosition = position.clusterPosition;
            OPhysicalPosition oPhysicalPosition = physicalPosition;
            this.diskCache.release(cacheEntry);
            return oPhysicalPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void updateDataSegmentPosition(OClusterPosition iPosition, int iDataSegmentId, long iDataPosition) throws IOException {
        throw new UnsupportedOperationException("updateDataSegmentPosition");
    }

    @Override
    public void removePhysicalPosition(OClusterPosition iPosition) throws IOException {
        throw new UnsupportedOperationException("updateDataSegmentPosition");
    }

    @Override
    public void updateRecordType(OClusterPosition iPosition, byte iRecordType) throws IOException {
        throw new UnsupportedOperationException("updateRecordType");
    }

    @Override
    public void updateVersion(OClusterPosition iPosition, ORecordVersion iVersion) throws IOException {
        throw new UnsupportedOperationException("updateVersion");
    }

    @Override
    public long getEntries() {
        this.acquireSharedLock();
        try {
            this.diskCache.loadPinnedPage(this.pinnedStateEntry);
            try {
                long l = new OPaginatedClusterState(this.pinnedStateEntry, ODurablePage.TrackMode.NONE).getSize();
                this.diskCache.release(this.pinnedStateEntry);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.diskCache.release(this.pinnedStateEntry);
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new OStorageException("Error during retrieval of size of " + this.name + " cluster.");
                }
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OClusterPosition getFirstPosition() throws IOException {
        this.acquireSharedLock();
        try {
            OClusterPosition oClusterPosition = this.clusterPositionMap.getFirstPosition();
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OClusterPosition getLastPosition() throws IOException {
        this.acquireSharedLock();
        try {
            OClusterPosition oClusterPosition = this.clusterPositionMap.getLastPosition();
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void synch() throws IOException {
        this.acquireSharedLock();
        try {
            this.diskCache.flushFile(this.fileId);
            this.clusterPositionMap.flush();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.diskCache.setSoftlyClosed(this.fileId, softlyClosed);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean wasSoftlyClosed() throws IOException {
        this.acquireSharedLock();
        try {
            boolean bl = this.diskCache.wasSoftlyClosed(this.fileId) || this.clusterPositionMap.wasSoftlyClosed();
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String getName() {
        this.acquireSharedLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getRecordsSize() throws IOException {
        this.acquireSharedLock();
        try {
            this.diskCache.loadPinnedPage(this.pinnedStateEntry);
            try {
                long l = new OPaginatedClusterState(this.pinnedStateEntry, ODurablePage.TrackMode.NONE).getRecordsSize();
                this.diskCache.release(this.pinnedStateEntry);
                return l;
            }
            catch (Throwable throwable) {
                this.diskCache.release(this.pinnedStateEntry);
                throw throwable;
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean isHashBased() {
        return false;
    }

    @Override
    public OClusterEntryIterator absoluteIterator() {
        this.acquireSharedLock();
        try {
            OClusterEntryIterator oClusterEntryIterator = new OClusterEntryIterator(this);
            return oClusterEntryIterator;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] higherPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            OClusterPosition[] clusterPositions = this.clusterPositionMap.higherPositions(position.clusterPosition);
            OPhysicalPosition[] oPhysicalPositionArray = this.convertToPhysicalPositions(clusterPositions);
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private OPhysicalPosition[] convertToPhysicalPositions(OClusterPosition[] clusterPositions) {
        OPhysicalPosition[] positions = new OPhysicalPosition[clusterPositions.length];
        for (int i = 0; i < positions.length; ++i) {
            OPhysicalPosition physicalPosition = new OPhysicalPosition();
            physicalPosition.clusterPosition = clusterPositions[i];
            positions[i] = physicalPosition;
        }
        return positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            OClusterPosition[] clusterPositions = this.clusterPositionMap.ceilingPositions(position.clusterPosition);
            OPhysicalPosition[] oPhysicalPositionArray = this.convertToPhysicalPositions(clusterPositions);
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] lowerPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            OClusterPosition[] clusterPositions = this.clusterPositionMap.lowerPositions(position.clusterPosition);
            OPhysicalPosition[] oPhysicalPositionArray = this.convertToPhysicalPositions(clusterPositions);
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] floorPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            OClusterPosition[] clusterPositions = this.clusterPositionMap.floorPositions(position.clusterPosition);
            OPhysicalPosition[] oPhysicalPositionArray = this.convertToPhysicalPositions(clusterPositions);
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    protected void endAtomicOperation(boolean rollback) throws IOException {
        if (!this.config.useWal) {
            return;
        }
        super.endAtomicOperation(rollback);
    }

    @Override
    protected void startAtomicOperation() throws IOException {
        if (!this.config.useWal) {
            return;
        }
        super.startAtomicOperation();
    }

    @Override
    protected void logPageChanges(ODurablePage localPage, long fileId, long pageIndex, boolean isNewPage) throws IOException {
        if (!this.config.useWal) {
            return;
        }
        super.logPageChanges(localPage, fileId, pageIndex, isNewPage);
    }

    @Override
    protected ODurablePage.TrackMode getTrackMode() {
        if (!this.config.useWal) {
            return ODurablePage.TrackMode.NONE;
        }
        return super.getTrackMode();
    }

    @Override
    public OModificationLock getExternalModificationLock() {
        return this.externalModificationLock;
    }

    private static final class FindFreePageResult {
        private final long pageIndex;
        private final int freePageIndex;

        private FindFreePageResult(long pageIndex, int freePageIndex) {
            this.pageIndex = pageIndex;
            this.freePageIndex = freePageIndex;
        }
    }

    private static final class AddEntryResult {
        private final long pageIndex;
        private final int pagePosition;
        private final ORecordVersion recordVersion;
        private final int recordsSizeDiff;

        public AddEntryResult(long pageIndex, int pagePosition, ORecordVersion recordVersion, int recordsSizeDiff) {
            this.pageIndex = pageIndex;
            this.pagePosition = pagePosition;
            this.recordVersion = recordVersion;
            this.recordsSizeDiff = recordsSizeDiff;
        }
    }
}

