/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OModificationLock;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManagerShared;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OReadWriteDiskCache;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageConfigurationSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.OStorageVariableParser;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedStorageDirtyFlag;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractCheckPointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPagesRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileCreatedCreatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFullCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OPaginatedClusterFactory;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OUpdatePageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageBrokenException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTxListener;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class OLocalPaginatedStorage
extends OStorageLocalAbstract {
    private static final int ONE_KB = 1024;
    private static String[] ALL_FILE_EXTENSIONS = new String[]{".ocf", ".pls", ".pcl", ".oda", ".odh", ".otx", ".ocs", ".oef", ".oem", ".oet", ".wal", ".wmr", ".hib", ".him", ".hit", ".hnb", ".cpm", ".sbt", ".cm", ".irs", ".sbc", ".nbt"};
    private final int DELETE_MAX_RETRIES;
    private final int DELETE_WAIT_TIME;
    private final ConcurrentMap<String, OCluster> clusterMap = new ConcurrentHashMap<String, OCluster>();
    private CopyOnWriteArrayList<OCluster> clusters = new CopyOnWriteArrayList();
    private final OStorageVariableParser variableParser;
    private String storagePath;
    private volatile int defaultClusterId = -1;
    private final OModificationLock modificationLock = new OModificationLock();
    private final OPaginatedStorageDirtyFlag dirtyFlag;
    private volatile ExecutorService checkpointExecutor;
    private volatile boolean wereDataRestoredAfterOpen = false;
    private boolean makeFullCheckPointAfterClusterCreate = OGlobalConfiguration.STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CLUSTER_CREATE.getValueAsBoolean();

    public OLocalPaginatedStorage(String name, String filePath, String mode) throws IOException {
        super(name, filePath, mode);
        File f = new File(this.url);
        this.storagePath = f.exists() || !this.exists(f.getParent()) ? OSystemVariableResolver.resolveSystemVariables((String)OFileUtils.getPath((String)new File(this.url).getPath())) : OSystemVariableResolver.resolveSystemVariables((String)OFileUtils.getPath((String)new File(this.url).getParent()));
        this.storagePath = OIOUtils.getPathFromDatabaseName((String)this.storagePath);
        this.variableParser = new OStorageVariableParser(this.storagePath);
        this.configuration = new OStorageConfigurationSegment(this);
        this.DELETE_MAX_RETRIES = OGlobalConfiguration.FILE_MMAP_FORCE_RETRY.getValueAsInteger();
        this.DELETE_WAIT_TIME = OGlobalConfiguration.FILE_MMAP_FORCE_DELAY.getValueAsInteger();
        this.dirtyFlag = new OPaginatedStorageDirtyFlag(this.storagePath + File.separator + "dirty.fl");
    }

    @Override
    public void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        this.addUser();
        if (this.status == OStorage.STATUS.OPEN) {
            return;
        }
        this.lock.acquireExclusiveLock();
        try {
            if (this.status == OStorage.STATUS.OPEN) {
                return;
            }
            this.status = OStorage.STATUS.OPENING;
            if (!this.exists()) {
                throw new OStorageException("Cannot open the storage '" + this.name + "' because it does not exist in path: " + this.url);
            }
            this.configuration.load();
            this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
            this.initWal();
            if (this.configuration.binaryFormatVersion >= 11) {
                if (this.dirtyFlag.exits()) {
                    this.dirtyFlag.open();
                } else {
                    this.dirtyFlag.create();
                    this.dirtyFlag.makeDirty();
                }
            } else if (this.dirtyFlag.exits()) {
                this.dirtyFlag.open();
            } else {
                this.dirtyFlag.create();
                this.dirtyFlag.clearDirty();
            }
            this.addDefaultClusters();
            for (int i = 0; i < this.configuration.clusters.size(); ++i) {
                OStorageClusterConfiguration clusterConfig = this.configuration.clusters.get(i);
                if (clusterConfig != null) {
                    int pos = this.createClusterFromConfig(clusterConfig);
                    try {
                        if (pos == -1) {
                            this.clusters.get(i).open();
                            continue;
                        }
                        if (clusterConfig.getName().equals("default")) {
                            this.defaultClusterId = pos;
                        }
                        this.clusters.get(pos).open();
                    }
                    catch (FileNotFoundException e) {
                        OLogManager.instance().warn((Object)this, "Error on loading cluster '" + this.clusters.get(i).getName() + "' (" + i + "): file not found. It will be excluded from current database '" + this.getName() + "'.", new Object[0]);
                        this.clusterMap.remove(this.clusters.get(i).getName().toLowerCase());
                        this.setCluster(i, null);
                    }
                    continue;
                }
                this.setCluster(i, null);
            }
            this.restoreIfNeeded();
            this.dirtyFlag.clearDirty();
            this.status = OStorage.STATUS.OPEN;
        }
        catch (Exception e) {
            this.status = OStorage.STATUS.CLOSED;
            throw new OStorageException("Cannot open local storage '" + this.url + "' with mode=" + this.mode, e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    private void setCluster(int id, OCluster cluster) {
        if (this.clusters.size() <= id) {
            while (this.clusters.size() < id) {
                this.clusters.add(null);
            }
            this.clusters.add(cluster);
        } else {
            this.clusters.set(id, cluster);
        }
    }

    public boolean wereDataRestoredAfterOpen() {
        return this.wereDataRestoredAfterOpen;
    }

    @Override
    public void create(Map<String, Object> iProperties) {
        this.lock.acquireExclusiveLock();
        try {
            if (this.status != OStorage.STATUS.CLOSED) {
                throw new OStorageException("Cannot create new storage '" + this.name + "' because it is not closed");
            }
            this.addUser();
            File storageFolder = new File(this.storagePath);
            if (!storageFolder.exists()) {
                storageFolder.mkdirs();
            }
            if (this.exists()) {
                throw new OStorageException("Cannot create new storage '" + this.name + "' because it already exists");
            }
            this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
            this.initWal();
            this.dirtyFlag.create();
            this.status = OStorage.STATUS.OPEN;
            this.doAddCluster("internal", null, false, null);
            this.configuration.create();
            this.doAddCluster("index", null, false, null);
            this.doAddCluster("manindex", null, false, null);
            this.defaultClusterId = this.doAddCluster("default", null, false, null);
            this.dirtyFlag.makeDirty();
            if (OGlobalConfiguration.STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CREATE.getValueAsBoolean()) {
                this.makeFullCheckpoint();
            }
        }
        catch (OStorageException e) {
            this.close();
            throw e;
        }
        catch (IOException e) {
            this.close();
            throw new OStorageException("Error on creation of storage '" + this.name + "'", e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public void reload() {
    }

    @Override
    public boolean exists() {
        return this.exists(this.storagePath);
    }

    @Override
    public void close(boolean force, boolean onDelete) {
        this.doClose(force, onDelete);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void delete() {
        long timer = Orient.instance().getProfiler().startChrono();
        File dbDir = null;
        this.lock.acquireExclusiveLock();
        try {
            if (this.status != OStorage.STATUS.CLOSED && this.getUsers() > 0) {
                while (this.removeUser() > 0) {
                }
            }
            this.doClose(true, true);
            try {
                Orient.instance().unregisterStorage(this);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Cannot unregister storage", (Throwable)e, new Object[0]);
            }
            dbDir = new File(OIOUtils.getPathFromDatabaseName((String)OSystemVariableResolver.resolveSystemVariables((String)this.url)));
            if (!dbDir.exists() || !dbDir.isDirectory()) {
                dbDir = dbDir.getParentFile();
            }
            if (this.writeAheadLog != null) {
                this.writeAheadLog.delete();
            }
            if (this.diskCache != null) {
                this.diskCache.delete();
            }
            this.dirtyFlag.delete();
            int i = 0;
            block10: while (true) {
                if (i >= this.DELETE_MAX_RETRIES) throw new OStorageException("Cannot delete database '" + this.name + "' located in: " + dbDir + ". Database files seem locked");
                if (dbDir == null) return;
                if (!dbDir.exists()) return;
                if (!dbDir.isDirectory()) return;
                int notDeletedFiles = 0;
                File[] fileArray = dbDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (true) {
                    int n3;
                    String[] stringArray;
                    File f;
                    if (n2 < n) {
                        f = fileArray[n2];
                        stringArray = ALL_FILE_EXTENSIONS;
                        n3 = stringArray.length;
                    } else {
                        if (notDeletedFiles == 0) {
                            dbDir.delete();
                            return;
                        }
                        OLogManager.instance().debug((Object)this, "Cannot delete database files because they are still locked by the OrientDB process: waiting %d ms and retrying %d/%d...", new Object[]{this.DELETE_WAIT_TIME, i, this.DELETE_MAX_RETRIES});
                        OMemoryWatchDog.freeMemoryForResourceCleanup(this.DELETE_WAIT_TIME);
                        ++i;
                        continue block10;
                    }
                    for (int j = 0; j < n3; ++j) {
                        String ext = stringArray[j];
                        if (!f.getPath().endsWith(ext)) continue;
                        if (f.delete()) break;
                        ++notDeletedFiles;
                        break;
                    }
                    ++n2;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new OStorageException("Cannot delete database '" + this.name + "' located in: " + dbDir + ".", e);
        }
        finally {
            this.lock.releaseExclusiveLock();
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".drop", "Drop a database", timer, "db.*.drop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(boolean verbose, OCommandOutputListener listener) {
        this.lock.acquireExclusiveLock();
        try {
            long start = System.currentTimeMillis();
            OPageDataVerificationError[] pageErrors = this.diskCache.checkStoredPages(verbose ? listener : null);
            listener.onMessage("Check of storage completed in " + (System.currentTimeMillis() - start) + "ms. " + (pageErrors.length > 0 ? pageErrors.length + " with errors." : " without errors."));
            boolean bl = pageErrors.length == 0;
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public ODataLocal getDataSegmentById(int dataSegmentId) {
        OLogManager.instance().error((Object)this, "getDataSegmentById: Local paginated storage does not support data segments. null will be returned for data segment %d.", new Object[]{dataSegmentId});
        return null;
    }

    @Override
    public int getDataSegmentIdByName(String dataSegmentName) {
        OLogManager.instance().debug((Object)this, "getDataSegmentIdByName: Local paginated storage does not support data segments. -1 will be returned for data segment %s.", new Object[]{dataSegmentName});
        return -1;
    }

    @Override
    public int addDataSegment(String iDataSegmentName) {
        return this.addDataSegment(iDataSegmentName, null);
    }

    public void enableFullCheckPointAfterClusterCreate() {
        this.checkOpeness();
        this.lock.acquireExclusiveLock();
        try {
            this.makeFullCheckPointAfterClusterCreate = true;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void disableFullCheckPointAfterClusterCreate() {
        this.checkOpeness();
        this.lock.acquireExclusiveLock();
        try {
            this.makeFullCheckPointAfterClusterCreate = false;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public boolean isMakeFullCheckPointAfterClusterCreate() {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            boolean bl = this.makeFullCheckPointAfterClusterCreate;
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int addDataSegment(String segmentName, String directory) {
        OLogManager.instance().debug((Object)this, "addDataSegment: Local paginated storage does not support data segments, segment %s will not be added in directory %s.", new Object[]{segmentName, directory});
        return -1;
    }

    @Override
    public int addCluster(String clusterType, String clusterName, String location, String dataSegmentName, boolean forceListBased, Object ... parameters) {
        this.checkOpeness();
        this.lock.acquireExclusiveLock();
        try {
            this.dirtyFlag.makeDirty();
            int n = this.doAddCluster(clusterName, location, true, parameters);
            return n;
        }
        catch (Exception e) {
            throw new OStorageException("Error in creation of new cluster '" + clusterName + "' of type: " + clusterType, e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public int addCluster(String clusterType, String clusterName, int requestedId, String location, String dataSegmentName, boolean forceListBased, Object ... parameters) {
        this.lock.acquireExclusiveLock();
        try {
            if (requestedId < 0) {
                throw new OConfigurationException("Cluster id must be positive!");
            }
            if (requestedId < this.clusters.size() && this.clusters.get(requestedId) != null) {
                throw new OConfigurationException("Requested cluster ID [" + requestedId + "] is occupied by cluster with name [" + this.clusters.get(requestedId).getName() + "]");
            }
            this.dirtyFlag.makeDirty();
            int n = this.addClusterInternal(clusterName, requestedId, location, true, parameters);
            return n;
        }
        catch (Exception e) {
            throw new OStorageException("Error in creation of new cluster '" + clusterName + "' of type: " + clusterType, e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public boolean dropCluster(int clusterId, boolean iTruncate) {
        this.lock.acquireExclusiveLock();
        try {
            if (clusterId < 0 || clusterId >= this.clusters.size()) {
                throw new IllegalArgumentException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
            }
            OCluster cluster = this.clusters.get(clusterId);
            if (cluster == null) {
                boolean bl = false;
                return bl;
            }
            this.getLevel2Cache().freeCluster(clusterId);
            if (iTruncate) {
                cluster.truncate();
            }
            cluster.delete();
            this.dirtyFlag.makeDirty();
            this.clusterMap.remove(cluster.getName().toLowerCase());
            this.clusters.set(clusterId, null);
            this.configuration.dropCluster(clusterId);
            this.makeFullCheckpoint();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new OStorageException("Error while removing cluster '" + clusterId + "'", e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public boolean dropDataSegment(String iName) {
        throw new UnsupportedOperationException("dropDataSegment");
    }

    @Override
    public long count(int iClusterId) {
        return this.count(iClusterId, false);
    }

    @Override
    public long count(int clusterId, boolean countTombstones) {
        if (clusterId == -1) {
            throw new OStorageException("Cluster Id " + clusterId + " is invalid in database '" + this.name + "'");
        }
        this.checkOpeness();
        OCluster cluster = this.clusters.get(clusterId);
        if (cluster == null) {
            return 0L;
        }
        if (countTombstones) {
            return cluster.getEntries();
        }
        return cluster.getEntries() - cluster.getTombstonesCount();
    }

    @Override
    public OClusterPosition[] getClusterDataRange(int iClusterId) {
        if (iClusterId == -1) {
            return new OClusterPosition[]{OClusterPosition.INVALID_POSITION, OClusterPosition.INVALID_POSITION};
        }
        this.checkOpeness();
        try {
            OClusterPosition[] oClusterPositionArray;
            if (this.clusters.get(iClusterId) != null) {
                OClusterPosition[] oClusterPositionArray2 = new OClusterPosition[2];
                oClusterPositionArray2[0] = this.clusters.get(iClusterId).getFirstPosition();
                oClusterPositionArray = oClusterPositionArray2;
                oClusterPositionArray2[1] = this.clusters.get(iClusterId).getLastPosition();
            } else {
                oClusterPositionArray = new OClusterPosition[]{};
            }
            return oClusterPositionArray;
        }
        catch (IOException ioe) {
            throw new OStorageException("Can not retrieve information about data range", ioe);
        }
    }

    @Override
    public long count(int[] iClusterIds) {
        return this.count(iClusterIds, false);
    }

    @Override
    public long count(int[] iClusterIds, boolean countTombstones) {
        this.checkOpeness();
        long tot = 0L;
        for (int iClusterId : iClusterIds) {
            OCluster c;
            if (iClusterId >= this.clusters.size()) {
                throw new OConfigurationException("Cluster id " + iClusterId + " was not found in database '" + this.name + "'");
            }
            if (iClusterId <= -1 || (c = this.clusters.get(iClusterId)) == null) continue;
            tot += c.getEntries() - (countTombstones ? 0L : c.getTombstonesCount());
        }
        return tot;
    }

    /*
     * Exception decompiling
     */
    @Override
    public OStorageOperationResult<OPhysicalPosition> createRecord(int dataSegmentId, ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType, int mode, ORecordCallback<OClusterPosition> callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordMetadata getRecordMetadata(ORID rid) {
        block12: {
            if (rid.isNew()) {
                throw new OStorageException("Passed record with id " + rid + " is new and can not be stored.");
            }
            this.checkOpeness();
            OCluster cluster = this.getClusterById(rid.getClusterId());
            this.lockManager.acquireLock(Thread.currentThread(), rid, OLockManager.LOCK.SHARED);
            try {
                OPhysicalPosition ppos;
                block11: {
                    ORecordMetadata oRecordMetadata;
                    this.lock.acquireSharedLock();
                    try {
                        ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
                        if (ppos != null) break block11;
                        oRecordMetadata = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.lock.releaseSharedLock();
                            throw throwable;
                        }
                        catch (IOException ioe) {
                            OLogManager.instance().error((Object)this, "Retrieval of record  '" + rid + "' cause: " + ioe.getMessage(), (Throwable)ioe, new Object[0]);
                            break block12;
                        }
                    }
                    this.lock.releaseSharedLock();
                    return oRecordMetadata;
                }
                ORecordMetadata oRecordMetadata = new ORecordMetadata(rid, ppos.recordVersion);
                this.lock.releaseSharedLock();
                return oRecordMetadata;
            }
            finally {
                this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.SHARED);
            }
        }
        return null;
    }

    @Override
    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback, boolean loadTombstones, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkOpeness();
        return new OStorageOperationResult<ORawBuffer>(this.readRecord(this.getClusterById(iRid.clusterId), iRid, true, loadTombstones, iLockingStrategy));
    }

    /*
     * Exception decompiling
     */
    @Override
    public OStorageOperationResult<ORecordVersion> updateRecord(ORecordId rid, byte[] content, ORecordVersion version, byte recordType, int mode, ORecordCallback<ORecordVersion> callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OStorageOperationResult<Boolean> deleteRecord(ORecordId rid, ORecordVersion version, int mode, ORecordCallback<Boolean> callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OStorageOperationResult<Boolean> hideRecord(ORecordId rid, int mode, ORecordCallback<Boolean> callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean updateReplica(int dataSegmentId, ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        throw new OStorageException("Support of hash based clusters is required.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        if (iExclusiveLock) {
            this.modificationLock.requestModificationLock();
            try {
                V v = super.callInLock(iCallable, true);
                return v;
            }
            finally {
                this.modificationLock.releaseModificationLock();
            }
        }
        return super.callInLock(iCallable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public <V> V callInRecordLock(Callable<V> callable, ORID rid, boolean exclusiveLock) {
        if (exclusiveLock) {
            this.modificationLock.requestModificationLock();
        }
        try {
            V v;
            block19: {
                block18: {
                    this.lockManager.acquireLock(Thread.currentThread(), rid, exclusiveLock ? OLockManager.LOCK.EXCLUSIVE : OLockManager.LOCK.SHARED);
                    if (exclusiveLock) {
                        this.lock.acquireExclusiveLock();
                    } else {
                        this.lock.acquireSharedLock();
                    }
                    v = callable.call();
                    if (!exclusiveLock) break block18;
                    this.lock.releaseExclusiveLock();
                    break block19;
                }
                this.lock.releaseSharedLock();
            }
            this.lockManager.releaseLock(Thread.currentThread(), rid, exclusiveLock ? OLockManager.LOCK.EXCLUSIVE : OLockManager.LOCK.SHARED);
            return v;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            if (exclusiveLock) {
                                this.lock.releaseExclusiveLock();
                            } else {
                                this.lock.releaseSharedLock();
                            }
                            throw throwable;
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new OException("Error on nested call in lock", (Throwable)e);
                        }
                    }
                    catch (Throwable throwable2) {
                        this.lockManager.releaseLock(Thread.currentThread(), rid, exclusiveLock ? OLockManager.LOCK.EXCLUSIVE : OLockManager.LOCK.SHARED);
                        throw throwable2;
                    }
                }
            }
        }
        finally {
            if (exclusiveLock) {
                this.modificationLock.releaseModificationLock();
            }
        }
    }

    @Override
    public Set<String> getClusterNames() {
        this.checkOpeness();
        return new HashSet<String>(this.clusterMap.keySet());
    }

    @Override
    public int getClusterIdByName(String \u0441lusterName) {
        this.checkOpeness();
        if (\u0441lusterName == null) {
            throw new IllegalArgumentException("Cluster name is null");
        }
        if (\u0441lusterName.length() == 0) {
            throw new IllegalArgumentException("Cluster name is empty");
        }
        if (Character.isDigit(\u0441lusterName.charAt(0))) {
            return Integer.parseInt(\u0441lusterName);
        }
        OCluster segment = (OCluster)this.clusterMap.get(\u0441lusterName.toLowerCase());
        if (segment != null) {
            return segment.getId();
        }
        return -1;
    }

    @Override
    public String getClusterTypeByName(String clusterName) {
        this.checkOpeness();
        if (clusterName == null) {
            throw new IllegalArgumentException("Cluster name is null");
        }
        OCluster segment = (OCluster)this.clusterMap.get(clusterName.toLowerCase());
        if (segment != null) {
            return segment.getType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(OTransaction clientTx, Runnable callback) {
        this.modificationLock.requestModificationLock();
        TreeSet allToLock = new TreeSet();
        try {
            for (ORecordOperation oRecordOperation : clientTx.getCurrentRecordEntries()) {
                allToLock.add(oRecordOperation.getRecord());
            }
            for (ORecord oRecord : allToLock) {
                if (oRecord.getIdentity().isNew()) continue;
                this.lockManager.acquireLock(Thread.currentThread(), oRecord.getIdentity(), OLockManager.LOCK.EXCLUSIVE);
            }
            try {
                this.lock.acquireExclusiveLock();
                try {
                    if (this.writeAheadLog == null) {
                        throw new OStorageException("WAL mode is not active. Transactions are not supported in given mode");
                    }
                    this.dirtyFlag.makeDirty();
                    this.startStorageTx(clientTx);
                    ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
                    while (clientTx.getCurrentRecordEntries().iterator().hasNext()) {
                        for (ORecordOperation oRecordOperation : clientTx.getCurrentRecordEntries()) {
                            tmpEntries.add(oRecordOperation);
                        }
                        clientTx.clearRecordEntries();
                        for (ORecordOperation oRecordOperation : tmpEntries) {
                            this.commitEntry(clientTx, oRecordOperation);
                        }
                    }
                    if (callback != null) {
                        callback.run();
                    }
                    this.endStorageTx();
                    OTransactionAbstract.updateCacheFromEntries(clientTx, clientTx.getAllRecordEntries(), true);
                }
                catch (Exception e) {
                    OLogManager.instance().debug((Object)this, "Error during transaction commit, transaction will be rolled back (tx-id=%d)", (Throwable)e, new Object[]{clientTx.getId()});
                    this.rollback(clientTx);
                    if (e instanceof OException) {
                        throw (OException)((Object)e);
                    }
                    throw new OStorageException("Error during transaction commit.", e);
                }
                finally {
                    this.transaction.set(null);
                    this.lock.releaseExclusiveLock();
                }
            }
            finally {
                this.modificationLock.releaseModificationLock();
            }
        }
        finally {
            for (ORecord oRecord : allToLock) {
                try {
                    this.lockManager.releaseLock(Thread.currentThread(), oRecord.getIdentity(), OLockManager.LOCK.EXCLUSIVE);
                }
                catch (Exception exception) {
                    OLogManager.instance().debug((Object)this, "Error on record unlock", (Throwable)exception, new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(OTransaction clientTx) {
        this.checkOpeness();
        this.modificationLock.requestModificationLock();
        try {
            this.lock.acquireExclusiveLock();
            try {
                if (this.transaction.get() == null) {
                    return;
                }
                if (this.writeAheadLog == null) {
                    throw new OStorageException("WAL mode is not active. Transactions are not supported in given mode");
                }
                if (((OStorageTransaction)this.transaction.get()).getClientTx().getId() != clientTx.getId()) {
                    throw new OStorageException("Passed in and active transaction are different transactions. Passed in transaction can not be rolled back.");
                }
                this.dirtyFlag.makeDirty();
                this.rollbackStorageTx();
                OTransactionAbstract.updateCacheFromEntries(clientTx, clientTx.getAllRecordEntries(), false);
            }
            catch (IOException e) {
                throw new OStorageException("Error during transaction rollback.", e);
            }
            finally {
                this.transaction.set(null);
                this.lock.releaseExclusiveLock();
            }
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return ppos != null && !ppos.recordVersion.isTombstone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synch() {
        this.checkOpeness();
        long timer = Orient.instance().getProfiler().startChrono();
        this.modificationLock.prohibitModifications();
        try {
            this.lock.acquireSharedLock();
            try {
                if (this.writeAheadLog != null) {
                    this.makeFullCheckpoint();
                    return;
                }
                this.diskCache.flushBuffer();
                if (this.configuration != null) {
                    this.configuration.synch();
                }
                this.dirtyFlag.clearDirty();
            }
            catch (IOException e) {
                throw new OStorageException("Error on synch storage '" + this.name + "'", e);
            }
            finally {
                this.lock.releaseSharedLock();
                Orient.instance().getProfiler().stopChrono("db." + this.name + ".synch", "Synch a database", timer, "db.*.synch");
            }
        }
        finally {
            this.modificationLock.allowModifications();
        }
    }

    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        this.checkOpeness();
        if (iClusterId >= this.clusters.size()) {
            return null;
        }
        return this.clusters.get(iClusterId) != null ? this.clusters.get(iClusterId).getName() : null;
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    @Override
    public void setDefaultClusterId(int defaultClusterId) {
        this.defaultClusterId = defaultClusterId;
    }

    @Override
    public OCluster getClusterById(int iClusterId) {
        if (iClusterId == -1) {
            iClusterId = this.defaultClusterId;
        }
        this.checkClusterSegmentIndexRange(iClusterId);
        OCluster cluster = this.clusters.get(iClusterId);
        if (cluster == null) {
            throw new IllegalArgumentException("Cluster " + iClusterId + " is null");
        }
        return cluster;
    }

    @Override
    public OCluster getClusterByName(String \u0441lusterName) {
        OCluster cluster = (OCluster)this.clusterMap.get(\u0441lusterName.toLowerCase());
        if (cluster == null) {
            throw new IllegalArgumentException("Cluster " + \u0441lusterName + " does not exist in database '" + this.name + "'");
        }
        return cluster;
    }

    @Override
    public String getURL() {
        return "plocal:" + this.url;
    }

    @Override
    public long getSize() {
        try {
            long size = 0L;
            for (OCluster c : this.clusters) {
                if (c == null) continue;
                size += c.getRecordsSize();
            }
            return size;
        }
        catch (IOException ioe) {
            throw new OStorageException("Can not calculate records size");
        }
    }

    @Override
    public String getStoragePath() {
        return this.storagePath;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public OStorageVariableParser getVariableParser() {
        return this.variableParser;
    }

    @Override
    public int getClusters() {
        return this.clusterMap.size();
    }

    public Set<OCluster> getClusterInstances() {
        HashSet<OCluster> result = new HashSet<OCluster>();
        for (OCluster c : this.clusters) {
            if (c == null) continue;
            result.add(c);
        }
        return result;
    }

    public void renameCluster(String oldName, String newName) {
        this.clusterMap.put(newName.toLowerCase(), (OCluster)this.clusterMap.remove(oldName.toLowerCase()));
    }

    @Override
    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        return this.deleteRecord(recordId, recordVersion, iMode, callback).getResult();
    }

    @Override
    public void freeze(boolean throwException) {
        this.modificationLock.prohibitModifications(throwException);
        this.synch();
        try {
            this.unlock();
            this.diskCache.setSoftlyClosed(true);
            if (this.configuration != null) {
                this.configuration.setSoftlyClosed(true);
            }
        }
        catch (IOException e) {
            this.modificationLock.allowModifications();
            try {
                this.lock();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new OStorageException("Error on freeze of storage '" + this.name + "'", e);
        }
    }

    @Override
    public void release() {
        try {
            this.lock();
            this.diskCache.setSoftlyClosed(false);
            if (this.configuration != null) {
                this.configuration.setSoftlyClosed(false);
            }
        }
        catch (IOException e) {
            throw new OStorageException("Error on release of storage '" + this.name + "'", e);
        }
        this.modificationLock.allowModifications();
    }

    private void makeFullCheckpoint() {
        if (this.writeAheadLog == null) {
            return;
        }
        try {
            this.writeAheadLog.flush();
            if (this.configuration != null) {
                this.configuration.synch();
            }
            OLogSequenceNumber lastLSN = this.writeAheadLog.logFullCheckpointStart();
            this.diskCache.flushBuffer();
            this.writeAheadLog.logFullCheckpointEnd();
            this.writeAheadLog.flush();
            this.writeAheadLog.cutTill(lastLSN);
            this.dirtyFlag.clearDirty();
        }
        catch (IOException ioe) {
            throw new OStorageException("Error during checkpoint creation for storage " + this.name, ioe);
        }
    }

    public void scheduleFullCheckpoint() {
        ExecutorService executor = this.checkpointExecutor;
        if (executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    block8: {
                        OLocalPaginatedStorage.this.modificationLock.prohibitModifications();
                        try {
                            OLocalPaginatedStorage.this.lock.acquireSharedLock();
                            try {
                                OLocalPaginatedStorage.this.makeFullCheckpoint();
                            }
                            catch (Throwable t) {
                                try {
                                    OLogManager.instance().error((Object)this, "Error during background checkpoint creation for storage " + OLocalPaginatedStorage.this.name, t, new Object[0]);
                                    break block8;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    OLocalPaginatedStorage.this.lock.releaseSharedLock();
                                }
                            }
                            OLocalPaginatedStorage.this.lock.releaseSharedLock();
                        }
                        finally {
                            OLocalPaginatedStorage.this.modificationLock.allowModifications();
                        }
                    }
                }
            });
        }
    }

    @Override
    public String getType() {
        return "plocal";
    }

    public Class<OSBTreeCollectionManagerShared> getCollectionManagerClass() {
        return OSBTreeCollectionManagerShared.class;
    }

    @Override
    public ODiskCache getDiskCache() {
        return this.diskCache;
    }

    public void freeze(boolean throwException, int clusterId) {
        OCluster cluster = this.getClusterById(clusterId);
        String name = cluster.getName();
        if ("index".equals(name) || "manindex".equals(name)) {
            throw new IllegalArgumentException("It is impossible to freeze and release index or manual index cluster!");
        }
        cluster.getExternalModificationLock().prohibitModifications(throwException);
        try {
            cluster.synch();
            cluster.setSoftlyClosed(true);
        }
        catch (IOException e) {
            throw new OStorageException("Error on synch cluster '" + name + "'", e);
        }
    }

    public void release(int clusterId) {
        OCluster cluster = this.getClusterById(clusterId);
        String name = cluster.getName();
        if ("index".equals(name) || "manindex".equals(name)) {
            throw new IllegalArgumentException("It is impossible to freeze and release index or manualindex cluster!");
        }
        try {
            cluster.setSoftlyClosed(false);
        }
        catch (IOException e) {
            throw new OStorageException("Error on unfreeze storage '" + name + "'", e);
        }
        cluster.getExternalModificationLock().allowModifications();
    }

    protected void lock() throws IOException {
        OLogManager.instance().debug((Object)this, "Locking storage %s...", new Object[]{this.name});
        this.configuration.lock();
        this.diskCache.lock();
    }

    protected void unlock() throws IOException {
        OLogManager.instance().debug((Object)this, "Unlocking storage %s...", new Object[]{this.name});
        this.configuration.unlock();
        this.diskCache.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected ORawBuffer readRecord(OCluster clusterSegment, ORecordId rid, boolean atomicLock, boolean loadTombstones, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkOpeness();
        if (!rid.isPersistent()) {
            throw new IllegalArgumentException("Cannot read record " + rid + " since the position is invalid in database '" + this.name + '\'');
        }
        timer = Orient.instance().getProfiler().startChrono();
        clusterSegment.getExternalModificationLock().requestModificationLock();
        try {
            block29: {
                switch (5.$SwitchMap$com$orientechnologies$orient$core$storage$OStorage$LOCKING_STRATEGY[iLockingStrategy.ordinal()]) {
                    case 1: 
                    case 2: {
                        rid.lock(false);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        rid.lock(true);
                    }
                }
                if (atomicLock) {
                    this.lock.acquireSharedLock();
                }
                var8_7 = clusterSegment.readRecord(rid.clusterPosition);
                if (!atomicLock) break block29;
                this.lock.releaseSharedLock();
            }
            switch (5.$SwitchMap$com$orientechnologies$orient$core$storage$OStorage$LOCKING_STRATEGY[iLockingStrategy.ordinal()]) {
                case 1: {
                    rid.unlock();
                    ** break;
lbl27:
                    // 1 sources

                    break;
                }
            }
            return var8_7;
            {
                catch (Throwable var9_9) {
                    try {
                        try {
                            if (atomicLock) {
                                this.lock.releaseSharedLock();
                            }
                            throw var9_9;
                        }
                        catch (IOException e) {
                            OLogManager.instance().error((Object)this, "Error on reading record " + rid + " (cluster: " + clusterSegment + ')', (Throwable)e, new Object[0]);
                            var9_10 = null;
                            switch (5.$SwitchMap$com$orientechnologies$orient$core$storage$OStorage$LOCKING_STRATEGY[iLockingStrategy.ordinal()]) {
                                case 1: {
                                    rid.unlock();
                                    break;
                                }
                            }
                            clusterSegment.getExternalModificationLock().releaseModificationLock();
                            Orient.instance().getProfiler().stopChrono(this.PROFILER_READ_RECORD, "Read a record from database", timer, "db.*.readRecord");
                            return var9_10;
                        }
                    }
                    catch (Throwable var10_11) {
                        switch (5.$SwitchMap$com$orientechnologies$orient$core$storage$OStorage$LOCKING_STRATEGY[iLockingStrategy.ordinal()]) {
                            case 1: {
                                rid.unlock();
                                break;
                            }
                        }
                        throw var10_11;
                    }
                }
            }
        }
        finally {
            clusterSegment.getExternalModificationLock().releaseModificationLock();
            Orient.instance().getProfiler().stopChrono(this.PROFILER_READ_RECORD, "Read a record from database", timer, "db.*.readRecord");
        }
    }

    @Override
    protected OPhysicalPosition updateRecord(OCluster cluster, ORecordId rid, byte[] recordContent, ORecordVersion recordVersion, byte recordType) {
        throw new UnsupportedOperationException("updateRecord");
    }

    @Override
    protected OPhysicalPosition createRecord(ODataLocal dataSegment, OCluster cluster, byte[] recordContent, byte recordType, ORecordId rid, ORecordVersion recordVersion) {
        throw new UnsupportedOperationException("createRecord");
    }

    private void initWal() throws IOException {
        if (OGlobalConfiguration.USE_WAL.getValueAsBoolean()) {
            this.checkpointExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.writeAheadLog = new OWriteAheadLog(this);
        } else {
            this.writeAheadLog = null;
        }
        long diskCacheSize = OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L;
        long writeCacheSize = (long)Math.floor((double)OGlobalConfiguration.DISK_WRITE_CACHE_PART.getValueAsInteger() / 100.0 * (double)diskCacheSize);
        long readCacheSize = diskCacheSize - writeCacheSize;
        this.diskCache = new OReadWriteDiskCache(this.name, readCacheSize, writeCacheSize, OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024, OGlobalConfiguration.DISK_WRITE_CACHE_PAGE_TTL.getValueAsLong() * 1000L, OGlobalConfiguration.DISK_WRITE_CACHE_PAGE_FLUSH_INTERVAL.getValueAsInteger(), this, this.writeAheadLog, false, true);
        this.atomicOperationsManager = new OAtomicOperationsManager(this.writeAheadLog);
    }

    private void restoreIfNeeded() throws Exception {
        if (this.dirtyFlag.isDirty()) {
            OLogManager.instance().warn((Object)this, "Storage " + this.name + " was not closed properly. Will try to restore from write ahead log.", new Object[0]);
            try {
                this.restoreFromWAL();
                this.makeFullCheckpoint();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Exception during storage data restore.", (Throwable)e, new Object[0]);
                throw e;
            }
            OLogManager.instance().info((Object)this, "Storage data restore was completed", new Object[0]);
        }
    }

    private void restoreFromWAL() throws IOException {
        OWALRecord checkPointRecord;
        OLogSequenceNumber lastCheckPoint;
        if (this.writeAheadLog == null) {
            OLogManager.instance().error((Object)this, "Restore is not possible because write ahead logging is switched off.", new Object[0]);
            return;
        }
        if (this.writeAheadLog.begin() == null) {
            OLogManager.instance().error((Object)this, "Restore is not possible because write ahead log is empty.", new Object[0]);
            return;
        }
        OLogManager.instance().info((Object)this, "Looking for last checkpoint...", new Object[0]);
        try {
            lastCheckPoint = this.writeAheadLog.getLastCheckpoint();
        }
        catch (OWALPageBrokenException e) {
            lastCheckPoint = null;
        }
        if (lastCheckPoint == null) {
            OLogManager.instance().info((Object)this, "Checkpoints are absent, the restore will start from the beginning.", new Object[0]);
            this.restoreFromBegging();
            return;
        }
        try {
            checkPointRecord = this.writeAheadLog.read(lastCheckPoint);
        }
        catch (OWALPageBrokenException e) {
            checkPointRecord = null;
        }
        if (checkPointRecord == null) {
            OLogManager.instance().info((Object)this, "Checkpoints are absent, the restore will start from the beginning.", new Object[0]);
            this.restoreFromBegging();
            return;
        }
        if (checkPointRecord instanceof OFuzzyCheckpointStartRecord) {
            OLogManager.instance().info((Object)this, "Found FUZZY checkpoint.", new Object[0]);
            boolean fuzzyCheckPointIsComplete = this.checkFuzzyCheckPointIsComplete(lastCheckPoint);
            if (!fuzzyCheckPointIsComplete) {
                OLogManager.instance().warn((Object)this, "FUZZY checkpoint is not complete.", new Object[0]);
                OLogSequenceNumber previousCheckpoint = ((OFuzzyCheckpointStartRecord)checkPointRecord).getPreviousCheckpoint();
                checkPointRecord = null;
                if (previousCheckpoint != null) {
                    checkPointRecord = this.writeAheadLog.read(previousCheckpoint);
                }
                if (checkPointRecord != null) {
                    OLogManager.instance().warn((Object)this, "Restore will start from the previous checkpoint.", new Object[0]);
                    this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
                } else {
                    OLogManager.instance().warn((Object)this, "Restore will start from the beginning.", new Object[0]);
                    this.restoreFromBegging();
                }
            } else {
                this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
            }
            return;
        }
        if (checkPointRecord instanceof OFullCheckpointStartRecord) {
            OLogManager.instance().info((Object)this, "FULL checkpoint found.", new Object[0]);
            boolean fullCheckPointIsComplete = this.checkFullCheckPointIsComplete(lastCheckPoint);
            if (!fullCheckPointIsComplete) {
                OLogManager.instance().warn((Object)this, "FULL checkpoint has not completed.", new Object[0]);
                OLogSequenceNumber previousCheckpoint = ((OFullCheckpointStartRecord)checkPointRecord).getPreviousCheckpoint();
                checkPointRecord = null;
                if (previousCheckpoint != null) {
                    checkPointRecord = this.writeAheadLog.read(previousCheckpoint);
                }
                if (checkPointRecord != null) {
                    OLogManager.instance().warn((Object)this, "Restore will start from the previous checkpoint.", new Object[0]);
                } else {
                    OLogManager.instance().warn((Object)this, "Restore will start from the beginning.", new Object[0]);
                    this.restoreFromBegging();
                }
            } else {
                this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
            }
            return;
        }
        throw new OStorageException("Unknown checkpoint record type " + checkPointRecord.getClass().getName());
    }

    private boolean checkFullCheckPointIsComplete(OLogSequenceNumber lastCheckPoint) throws IOException {
        try {
            OLogSequenceNumber lsn = this.writeAheadLog.next(lastCheckPoint);
            while (lsn != null) {
                OWALRecord walRecord = this.writeAheadLog.read(lsn);
                if (walRecord instanceof OCheckpointEndRecord) {
                    return true;
                }
                lsn = this.writeAheadLog.next(lsn);
            }
        }
        catch (OWALPageBrokenException e) {
            return false;
        }
        return false;
    }

    private boolean checkFuzzyCheckPointIsComplete(OLogSequenceNumber lastCheckPoint) throws IOException {
        try {
            OLogSequenceNumber lsn = this.writeAheadLog.next(lastCheckPoint);
            while (lsn != null) {
                OWALRecord walRecord = this.writeAheadLog.read(lsn);
                if (walRecord instanceof OFuzzyCheckpointEndRecord) {
                    return true;
                }
                lsn = this.writeAheadLog.next(lsn);
            }
        }
        catch (OWALPageBrokenException e) {
            return false;
        }
        return false;
    }

    private void restoreFromCheckPoint(OAbstractCheckPointStartRecord checkPointRecord) throws IOException {
        if (checkPointRecord instanceof OFuzzyCheckpointStartRecord) {
            this.restoreFromFuzzyCheckPoint((OFuzzyCheckpointStartRecord)checkPointRecord);
            return;
        }
        if (checkPointRecord instanceof OFullCheckpointStartRecord) {
            this.restoreFromFullCheckPoint((OFullCheckpointStartRecord)checkPointRecord);
            return;
        }
        throw new OStorageException("Unknown checkpoint record type " + checkPointRecord.getClass().getName());
    }

    private void restoreFromFullCheckPoint(OFullCheckpointStartRecord checkPointRecord) throws IOException {
        OLogManager.instance().info((Object)this, "Data restore procedure from full checkpoint is started. Restore is performed from LSN %s", new Object[]{checkPointRecord.getLsn()});
        OLogSequenceNumber lsn = this.writeAheadLog.next(checkPointRecord.getLsn());
        this.restoreFrom(lsn);
    }

    private void restoreFromFuzzyCheckPoint(OFuzzyCheckpointStartRecord checkPointRecord) throws IOException {
        OLogSequenceNumber startLSN;
        OLogManager.instance().info((Object)this, "Data restore procedure from FUZZY checkpoint is started.", new Object[0]);
        OLogSequenceNumber dirtyPagesLSN = this.writeAheadLog.next(checkPointRecord.getLsn());
        ODirtyPagesRecord dirtyPagesRecord = (ODirtyPagesRecord)this.writeAheadLog.read(dirtyPagesLSN);
        Set<ODirtyPage> dirtyPages = dirtyPagesRecord.getDirtyPages();
        if (dirtyPages.isEmpty()) {
            startLSN = dirtyPagesLSN;
        } else {
            ODirtyPage[] pages = dirtyPages.toArray(new ODirtyPage[dirtyPages.size()]);
            Arrays.sort(pages, new Comparator<ODirtyPage>(){

                @Override
                public int compare(ODirtyPage pageOne, ODirtyPage pageTwo) {
                    return pageOne.getLsn().compareTo(pageTwo.getLsn());
                }
            });
            startLSN = pages[0].getLsn();
        }
        if (startLSN.compareTo(this.writeAheadLog.begin()) < 0) {
            startLSN = this.writeAheadLog.begin();
        }
        this.restoreFrom(startLSN);
    }

    private void restoreFromBegging() throws IOException {
        OLogManager.instance().info((Object)this, "Data restore procedure is started.", new Object[0]);
        OLogSequenceNumber lsn = this.writeAheadLog.begin();
        this.restoreFrom(lsn);
    }

    private void restoreFrom(OLogSequenceNumber lsn) throws IOException {
        this.wereDataRestoredAfterOpen = true;
        long recordsProcessed = 0L;
        int reportInterval = OGlobalConfiguration.WAL_REPORT_AFTER_OPERATIONS_DURING_RESTORE.getValueAsInteger();
        final AtomicBoolean lowMemoryFlag = new AtomicBoolean(false);
        OMemoryWatchDog.Listener listener = new OMemoryWatchDog.Listener(){

            @Override
            public void lowMemory(long iFreeMemory, long iFreeMemoryPercentage) {
                lowMemoryFlag.set(true);
            }
        };
        listener = Orient.instance().getMemoryWatchDog().addListener(listener);
        HashMap<OOperationUnitId, List<OLogSequenceNumber>> operationUnits = new HashMap<OOperationUnitId, List<OLogSequenceNumber>>();
        ArrayList<OWALRecord> batch = new ArrayList<OWALRecord>();
        try {
            while (lsn != null) {
                OWALRecord walRecord = this.writeAheadLog.read(lsn);
                batch.add(walRecord);
                if (lowMemoryFlag.get()) {
                    OLogManager.instance().info((Object)this, "Heap memory is low apply batch of operations are read from WAL.", new Object[0]);
                    recordsProcessed = this.restoreWALBatch(batch, operationUnits, recordsProcessed, reportInterval);
                    batch = new ArrayList();
                    lowMemoryFlag.set(false);
                }
                lsn = this.writeAheadLog.next(lsn);
            }
            if (!batch.isEmpty()) {
                OLogManager.instance().info((Object)this, "Apply last batch of operations are read from WAL.", new Object[0]);
                this.restoreWALBatch(batch, operationUnits, recordsProcessed, reportInterval);
                batch = null;
            }
        }
        catch (OWALPageBrokenException e) {
            OLogManager.instance().error((Object)this, "Data restore was paused because broken WAL page was found. The rest of changes will be rolled back.", new Object[0]);
        }
        this.rollbackAllUnfinishedWALOperations(operationUnits);
        operationUnits.clear();
        Orient.instance().getMemoryWatchDog().removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long restoreWALBatch(List<OWALRecord> batch, Map<OOperationUnitId, List<OLogSequenceNumber>> operationUnits, long recordsProcessed, int reportInterval) throws IOException {
        for (OWALRecord walRecord : batch) {
            OLogSequenceNumber lsn = walRecord.getLsn();
            if (walRecord instanceof OAtomicUnitStartRecord) {
                ArrayList<OLogSequenceNumber> operationList = new ArrayList<OLogSequenceNumber>();
                operationUnits.put(((OAtomicUnitStartRecord)walRecord).getOperationUnitId(), operationList);
                operationList.add(lsn);
            } else if (walRecord instanceof OOperationUnitRecord) {
                OOperationUnitRecord operationUnitRecord = (OOperationUnitRecord)walRecord;
                OOperationUnitId unitId = operationUnitRecord.getOperationUnitId();
                List<OLogSequenceNumber> records = operationUnits.get(unitId);
                assert (records != null);
                if (records == null) {
                    OLogManager.instance().warn((Object)this, "Record with lsn %s  which indication of start of atomic operation was truncated will be skipped.", new Object[]{walRecord.getLsn()});
                    continue;
                }
                records.add(lsn);
                if (operationUnitRecord instanceof OUpdatePageRecord) {
                    OUpdatePageRecord updatePageRecord = (OUpdatePageRecord)operationUnitRecord;
                    long fileId = updatePageRecord.getFileId();
                    long pageIndex = updatePageRecord.getPageIndex();
                    if (!this.diskCache.exists(fileId)) {
                        OLogManager.instance().warn((Object)this, "Record %s will be skipped during data restore because file which it is related to was deleted.", new Object[]{walRecord});
                        continue;
                    }
                    if (!this.diskCache.isOpen(fileId)) {
                        this.diskCache.openFile(fileId);
                    }
                    OCacheEntry cacheEntry = this.diskCache.load(fileId, pageIndex, true);
                    OCachePointer cachePointer = cacheEntry.getCachePointer();
                    cachePointer.acquireExclusiveLock();
                    try {
                        ODurablePage durablePage = new ODurablePage(cacheEntry, ODurablePage.TrackMode.NONE);
                        durablePage.restoreChanges(updatePageRecord.getChanges());
                        durablePage.setLsn(lsn);
                        cacheEntry.markDirty();
                    }
                    finally {
                        cachePointer.releaseExclusiveLock();
                        this.diskCache.release(cacheEntry);
                    }
                } else if (operationUnitRecord instanceof OFileCreatedCreatedWALRecord) {
                    OFileCreatedCreatedWALRecord fileCreatedCreatedRecord = (OFileCreatedCreatedWALRecord)operationUnitRecord;
                    this.diskCache.openFile(fileCreatedCreatedRecord.getFileName(), fileCreatedCreatedRecord.getFileId());
                } else if (operationUnitRecord instanceof OAtomicUnitEndRecord) {
                    OAtomicUnitEndRecord atomicUnitEndRecord = (OAtomicUnitEndRecord)walRecord;
                    if (atomicUnitEndRecord.isRollback()) {
                        this.undoOperation(records);
                    }
                    operationUnits.remove(unitId);
                } else {
                    OLogManager.instance().error((Object)this, "Invalid WAL record type was passed %s. Given record will be skipped.", new Object[]{operationUnitRecord.getClass()});
                    assert (false) : "Invalid WAL record type was passed " + operationUnitRecord.getClass().getName();
                }
            } else {
                OLogManager.instance().warn((Object)this, "Record %s will be skipped during data restore.", new Object[]{walRecord});
            }
            if (reportInterval <= 0 || ++recordsProcessed % (long)reportInterval != 0L) continue;
            OLogManager.instance().info((Object)this, "%d operations were processed, current LSN is %s last LSN is %s", new Object[]{recordsProcessed, lsn, this.writeAheadLog.end()});
        }
        return recordsProcessed;
    }

    private void rollbackAllUnfinishedWALOperations(Map<OOperationUnitId, List<OLogSequenceNumber>> operationUnits) throws IOException {
        for (List<OLogSequenceNumber> operationUnit : operationUnits.values()) {
            OAtomicUnitStartRecord atomicUnitStartRecord;
            if (operationUnit.isEmpty() || !(atomicUnitStartRecord = (OAtomicUnitStartRecord)this.writeAheadLog.read(operationUnit.get(0))).isRollbackSupported()) continue;
            OAtomicUnitEndRecord atomicUnitEndRecord = new OAtomicUnitEndRecord(atomicUnitStartRecord.getOperationUnitId(), true);
            OLogSequenceNumber logSequenceNumber = this.writeAheadLog.log(atomicUnitEndRecord);
            operationUnit.add(logSequenceNumber);
            this.undoOperation(operationUnit);
        }
    }

    private boolean exists(String path) {
        return new File(path + "/" + "internal" + ".pcl").exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(boolean force, boolean onDelete) {
        if (this.status == OStorage.STATUS.CLOSED) {
            return;
        }
        long timer = Orient.instance().getProfiler().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            if (!this.checkForClose(force)) {
                return;
            }
            this.status = OStorage.STATUS.CLOSING;
            if (!onDelete) {
                this.makeFullCheckpoint();
            }
            if (this.writeAheadLog != null) {
                this.checkpointExecutor.shutdown();
                if (!this.checkpointExecutor.awaitTermination(OGlobalConfiguration.WAL_FULL_CHECKPOINT_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.SECONDS)) {
                    throw new OStorageException("Can not terminate full checkpoint task");
                }
            }
            for (OCluster cluster : this.clusters) {
                if (cluster == null) continue;
                cluster.close(!onDelete);
            }
            this.clusters.clear();
            this.clusterMap.clear();
            if (this.configuration != null) {
                this.configuration.close();
            }
            this.level2Cache.shutdown();
            super.close(force, onDelete);
            if (!onDelete) {
                this.diskCache.close();
            } else {
                this.diskCache.delete();
            }
            if (this.writeAheadLog != null) {
                this.writeAheadLog.close();
                if (onDelete) {
                    this.writeAheadLog.delete();
                }
            }
            if (onDelete) {
                this.dirtyFlag.delete();
            } else {
                this.dirtyFlag.clearDirty();
                this.dirtyFlag.close();
            }
            this.status = OStorage.STATUS.CLOSED;
        }
        catch (InterruptedException ie) {
            OLogManager.instance().error((Object)this, "Error on closing of storage '" + this.name, (Throwable)ie, OStorageException.class, new Object[0]);
            Thread.interrupted();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on closing of storage '" + this.name, (Throwable)e, OStorageException.class, new Object[0]);
        }
        finally {
            this.lock.releaseExclusiveLock();
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".close", "Close a database", timer, "db.*.close");
        }
    }

    private int doAddCluster(String clusterName, String location, boolean fullCheckPoint, Object[] parameters) throws IOException {
        int clusterPos = this.clusters.size();
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (this.clusters.get(i) != null) continue;
            clusterPos = i;
            break;
        }
        return this.addClusterInternal(clusterName, clusterPos, location, fullCheckPoint, parameters);
    }

    private int addClusterInternal(String clusterName, int clusterPos, String location, boolean fullCheckPoint, Object ... parameters) throws IOException {
        OCluster cluster;
        if (clusterName != null) {
            clusterName = clusterName.toLowerCase();
            cluster = OPaginatedClusterFactory.INSTANCE.createCluster(this.configuration.version);
            cluster.configure(this, clusterPos, clusterName, location, -1, parameters);
            if (clusterName.equals("ORIDs".toLowerCase())) {
                cluster.set(OCluster.ATTRIBUTES.USE_WAL, false);
                cluster.set(OCluster.ATTRIBUTES.RECORD_GROW_FACTOR, 5);
                cluster.set(OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR, 2);
            }
        } else {
            cluster = null;
        }
        int createdClusterId = this.registerCluster(cluster);
        if (cluster != null) {
            if (!cluster.exists()) {
                cluster.create(-1);
                if (this.makeFullCheckPointAfterClusterCreate && fullCheckPoint) {
                    this.makeFullCheckpoint();
                }
            } else {
                cluster.open();
            }
            this.configuration.update();
        }
        return createdClusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void commitEntry(OTransaction clientTx, ORecordOperation txEntry) throws IOException {
        if (txEntry.type != 2 && !txEntry.getRecord().isDirty()) {
            return;
        }
        rid = (ORecordId)txEntry.getRecord().getIdentity();
        ORecordSerializationContext.pushContext();
        try {
            if (rid.clusterId == -1 && txEntry.getRecord() instanceof ODocument && ((ODocument)txEntry.getRecord()).getSchemaClass() != null) {
                rid.clusterId = ((ODocument)txEntry.getRecord()).getSchemaClass().getDefaultClusterId();
            }
            if ((cluster = this.getClusterById(rid.clusterId)).getName().equals("index") || cluster.getName().equals("manindex")) {
                return;
            }
            if (txEntry.getRecord() instanceof OTxListener) {
                ((OTxListener)txEntry.getRecord()).onEvent(txEntry, OTxListener.EVENT.BEFORE_COMMIT);
            }
            switch (txEntry.type) {
                case 0: {
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 3: {
                    stream = txEntry.getRecord().toStream();
                    if (stream == null) {
                        OLogManager.instance().warn((Object)this, "Null serialization on committing new record %s in transaction", new Object[]{rid});
                        ** break;
lbl22:
                        // 1 sources

                    } else {
                        v0 = oldRID = rid.isNew() != false ? rid.copy() : rid;
                        if (rid.isNew()) {
                            rid.clusterId = cluster.getId();
                            ppos = this.createRecord(-1, rid, stream, txEntry.getRecord().getRecordVersion(), txEntry.getRecord().getRecordType(), -1, null).getResult();
                            rid.clusterPosition = ppos.clusterPosition;
                            txEntry.getRecord().getRecordVersion().copyFrom(ppos.recordVersion);
                            clientTx.updateIdentityAfterCommit(oldRID, rid);
                            ** break;
lbl31:
                            // 1 sources

                        } else {
                            txEntry.getRecord().getRecordVersion().copyFrom(this.updateRecord(rid, stream, txEntry.getRecord().getRecordVersion(), txEntry.getRecord().getRecordType(), -1, null).getResult());
                            ** break;
                        }
                    }
lbl34:
                    // 1 sources

                    break;
                }
                case 1: {
                    stream = txEntry.getRecord().toStream();
                    if (stream == null) {
                        OLogManager.instance().warn((Object)this, "Null serialization on committing updated record %s in transaction", new Object[]{rid});
                        ** break;
lbl40:
                        // 1 sources

                    } else {
                        txEntry.getRecord().getRecordVersion().copyFrom(this.updateRecord(rid, stream, txEntry.getRecord().getRecordVersion(), txEntry.getRecord().getRecordType(), -1, null).getResult());
                        ** break;
                    }
lbl43:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.deleteRecord(rid, txEntry.getRecord().getRecordVersion(), -1, null);
                    break;
                }
                ** default:
lbl49:
                // 1 sources

                break;
            }
        }
        finally {
            ORecordSerializationContext.pullContext();
        }
        txEntry.getRecord().unsetDirty();
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)txEntry.getRecord()).onEvent(txEntry, OTxListener.EVENT.AFTER_COMMIT);
        }
    }

    private void checkClusterSegmentIndexRange(int iClusterId) {
        if (iClusterId > this.clusters.size() - 1) {
            throw new IllegalArgumentException("Cluster segment #" + iClusterId + " does not exist in database '" + this.name + "'");
        }
    }

    private int createClusterFromConfig(OStorageClusterConfiguration config) throws IOException {
        OCluster cluster = (OCluster)this.clusterMap.get(config.getName().toLowerCase());
        if (cluster != null) {
            cluster.configure(this, config);
            return -1;
        }
        cluster = OPaginatedClusterFactory.INSTANCE.createCluster(this.configuration.version);
        cluster.configure(this, config);
        return this.registerCluster(cluster);
    }

    private int registerCluster(OCluster cluster) throws IOException {
        int id;
        if (cluster != null) {
            if (this.clusterMap.containsKey(cluster.getName().toLowerCase())) {
                throw new OConfigurationException("Cannot add segment '" + cluster.getName() + "' because it is already registered in database '" + this.name + "'");
            }
            this.clusterMap.put(cluster.getName().toLowerCase(), cluster);
            id = cluster.getId();
        } else {
            id = this.clusters.size();
        }
        this.setCluster(id, cluster);
        return id;
    }

    private void addDefaultClusters() throws IOException {
        String storageCompression = OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.getValueAsString();
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.size(), "internal", null, true, 20.0f, 4.0f, storageCompression));
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.size(), "index", null, false, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, storageCompression));
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.size(), "manindex", null, false, 1.0f, 1.0f, storageCompression));
        this.defaultClusterId = this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.size(), "default", null, true, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, storageCompression));
    }
}

