/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import java.io.IOException;
import java.util.Arrays;

public class OClusterPositionMap
extends ODurableComponent {
    public static final String DEF_EXTENSION = ".cpm";
    private final ODiskCache diskCache;
    private String name;
    private long fileId;
    private boolean useWal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPositionMap(OStorageLocalAbstract storage, ODiskCache diskCache, String name, boolean useWal) {
        this.acquireExclusiveLock();
        try {
            this.diskCache = diskCache;
            this.name = name;
            this.useWal = useWal;
            this.init(storage);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void setUseWal(boolean useWal) {
        this.acquireExclusiveLock();
        try {
            this.useWal = useWal;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void open() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.fileId = this.diskCache.openFile(this.name + DEF_EXTENSION);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void create() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.fileId = this.diskCache.openFile(this.name + DEF_EXTENSION);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void flush() throws IOException {
        this.acquireSharedLock();
        try {
            this.diskCache.flushFile(this.fileId);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void close(boolean flush) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.diskCache.closeFile(this.fileId, flush);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void truncate() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.diskCache.truncateFile(this.fileId);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void delete() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.diskCache.deleteFile(this.fileId);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void rename(String newName) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.diskCache.renameFile(this.fileId, this.name + DEF_EXTENSION, newName + DEF_EXTENSION);
            this.name = newName;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Loose catch block
     */
    public OClusterPosition add(long pageIndex, int recordPosition) throws IOException {
        this.acquireExclusiveLock();
        try {
            long lastPage = this.diskCache.getFilledUpTo(this.fileId) - 1L;
            boolean isNewPage = false;
            if (lastPage < 0L) {
                lastPage = 0L;
                isNewPage = true;
            }
            OCacheEntry cacheEntry = this.diskCache.load(this.fileId, lastPage, false);
            cacheEntry.acquireExclusiveLock();
            try {
                this.startAtomicOperation();
                ODurablePage.TrackMode trackMode = this.getTrackMode();
                OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, trackMode);
                if (bucket.isFull()) {
                    cacheEntry.releaseExclusiveLock();
                    this.diskCache.release(cacheEntry);
                    isNewPage = true;
                    cacheEntry = this.diskCache.allocateNewPage(this.fileId);
                    cacheEntry.acquireExclusiveLock();
                    bucket = new OClusterPositionMapBucket(cacheEntry, trackMode);
                }
                long index = bucket.add(pageIndex, recordPosition);
                OClusterPosition result = OClusterPositionFactory.INSTANCE.valueOf(index + cacheEntry.getPageIndex() * (long)OClusterPositionMapBucket.MAX_ENTRIES);
                this.logPageChanges(bucket, this.fileId, cacheEntry.getPageIndex(), isNewPage);
                cacheEntry.markDirty();
                this.endAtomicOperation(false);
                OClusterPosition oClusterPosition = result;
                return oClusterPosition;
            }
            catch (Throwable e) {
                this.endAtomicOperation(true);
                throw new OStorageException("Error during creation of mapping between logical adn physical record position.", e);
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                this.diskCache.release(cacheEntry);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPositionMapBucket.PositionEntry get(OClusterPosition clusterPosition) throws IOException {
        this.acquireSharedLock();
        try {
            long position = clusterPosition.longValue();
            long pageIndex = position / (long)OClusterPositionMapBucket.MAX_ENTRIES;
            int index = (int)(position % (long)OClusterPositionMapBucket.MAX_ENTRIES);
            if (pageIndex >= this.diskCache.getFilledUpTo(this.fileId)) {
                OClusterPositionMapBucket.PositionEntry positionEntry = null;
                return positionEntry;
            }
            OCacheEntry cacheEntry = this.diskCache.load(this.fileId, pageIndex, false);
            try {
                OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, ODurablePage.TrackMode.NONE);
                OClusterPositionMapBucket.PositionEntry positionEntry = bucket.get(index);
                this.diskCache.release(cacheEntry);
                return positionEntry;
            }
            catch (Throwable throwable) {
                this.diskCache.release(cacheEntry);
                throw throwable;
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * Loose catch block
     */
    public OClusterPositionMapBucket.PositionEntry remove(OClusterPosition clusterPosition) throws IOException {
        this.acquireExclusiveLock();
        try {
            OClusterPositionMapBucket.PositionEntry positionEntry;
            long position = clusterPosition.longValue();
            long pageIndex = position / (long)OClusterPositionMapBucket.MAX_ENTRIES;
            int index = (int)(position % (long)OClusterPositionMapBucket.MAX_ENTRIES);
            OCacheEntry cacheEntry = this.diskCache.load(this.fileId, pageIndex, false);
            cacheEntry.acquireExclusiveLock();
            try {
                this.startAtomicOperation();
                ODurablePage.TrackMode trackMode = this.getTrackMode();
                OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, trackMode);
                OClusterPositionMapBucket.PositionEntry positionEntry2 = bucket.remove(index);
                if (positionEntry2 == null) {
                    OClusterPositionMapBucket.PositionEntry positionEntry3 = null;
                    return positionEntry3;
                }
                cacheEntry.markDirty();
                this.logPageChanges(bucket, this.fileId, pageIndex, false);
                this.endAtomicOperation(false);
                positionEntry = positionEntry2;
            }
            catch (Throwable e) {
                this.endAtomicOperation(true);
                throw new OStorageException("Error during removal of mapping between logical and physical record position.", e);
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                this.diskCache.release(cacheEntry);
            }
            return positionEntry;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPosition[] higherPositions(OClusterPosition clusterPosition) throws IOException {
        this.acquireSharedLock();
        try {
            long position = clusterPosition.longValue();
            if (position == Long.MAX_VALUE) {
                OClusterPosition[] oClusterPositionArray = new OClusterPosition[]{};
                return oClusterPositionArray;
            }
            OClusterPosition[] oClusterPositionArray = this.ceilingPositions(OClusterPositionFactory.INSTANCE.valueOf(position + 1L));
            return oClusterPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPosition[] ceilingPositions(OClusterPosition clusterPosition) throws IOException {
        this.acquireSharedLock();
        try {
            long position = clusterPosition.longValue();
            if (position < 0L) {
                position = 0L;
            }
            long pageIndex = position / (long)OClusterPositionMapBucket.MAX_ENTRIES;
            int index = (int)(position % (long)OClusterPositionMapBucket.MAX_ENTRIES);
            long filledUpTo = this.diskCache.getFilledUpTo(this.fileId);
            if (pageIndex >= filledUpTo) {
                OClusterPosition[] oClusterPositionArray = new OClusterPosition[]{};
                return oClusterPositionArray;
            }
            OClusterPosition[] result = null;
            do {
                OCacheEntry cacheEntry;
                OClusterPositionMapBucket bucket;
                int resultSize;
                if ((resultSize = (bucket = new OClusterPositionMapBucket(cacheEntry = this.diskCache.load(this.fileId, pageIndex, false), ODurablePage.TrackMode.NONE)).getSize() - index) <= 0) {
                    this.diskCache.release(cacheEntry);
                    ++pageIndex;
                    index = 0;
                    continue;
                }
                int entriesCount = 0;
                long startIndex = cacheEntry.getPageIndex() * (long)OClusterPositionMapBucket.MAX_ENTRIES + (long)index;
                result = new OClusterPosition[resultSize];
                for (int i = 0; i < resultSize; ++i) {
                    if (!bucket.exists(i + index)) continue;
                    result[entriesCount] = OClusterPositionFactory.INSTANCE.valueOf(startIndex + (long)i);
                    ++entriesCount;
                }
                if (entriesCount == 0) {
                    result = null;
                    ++pageIndex;
                    index = 0;
                } else {
                    result = Arrays.copyOf(result, entriesCount);
                }
                this.diskCache.release(cacheEntry);
            } while (result == null && pageIndex < filledUpTo);
            if (result == null) {
                result = new OClusterPosition[]{};
            }
            OClusterPosition[] oClusterPositionArray = result;
            return oClusterPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPosition[] lowerPositions(OClusterPosition clusterPosition) throws IOException {
        this.acquireSharedLock();
        try {
            long position = clusterPosition.longValue();
            if (position == 0L) {
                OClusterPosition[] oClusterPositionArray = new OClusterPosition[]{};
                return oClusterPositionArray;
            }
            OClusterPosition[] oClusterPositionArray = this.floorPositions(OClusterPositionFactory.INSTANCE.valueOf(position - 1L));
            return oClusterPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPosition[] floorPositions(OClusterPosition clusterPosition) throws IOException {
        this.acquireSharedLock();
        try {
            OClusterPosition[] result;
            long position = clusterPosition.longValue();
            if (position < 0L) {
                OClusterPosition[] oClusterPositionArray = new OClusterPosition[]{};
                return oClusterPositionArray;
            }
            long pageIndex = position / (long)OClusterPositionMapBucket.MAX_ENTRIES;
            int index = (int)(position % (long)OClusterPositionMapBucket.MAX_ENTRIES);
            long filledUpTo = this.diskCache.getFilledUpTo(this.fileId);
            if (pageIndex >= filledUpTo) {
                pageIndex = filledUpTo - 1L;
                index = Integer.MIN_VALUE;
            }
            do {
                OCacheEntry cacheEntry = this.diskCache.load(this.fileId, pageIndex, false);
                OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, ODurablePage.TrackMode.NONE);
                if (index == Integer.MIN_VALUE) {
                    index = bucket.getSize() - 1;
                }
                int resultSize = index + 1;
                int entriesCount = 0;
                long startPosition = cacheEntry.getPageIndex() * (long)OClusterPositionMapBucket.MAX_ENTRIES;
                result = new OClusterPosition[resultSize];
                for (int i = 0; i < resultSize; ++i) {
                    if (!bucket.exists(i)) continue;
                    result[entriesCount] = OClusterPositionFactory.INSTANCE.valueOf(startPosition + (long)i);
                    ++entriesCount;
                }
                if (entriesCount == 0) {
                    result = null;
                    --pageIndex;
                    index = Integer.MIN_VALUE;
                } else {
                    result = Arrays.copyOf(result, entriesCount);
                }
                this.diskCache.release(cacheEntry);
            } while (result == null && pageIndex >= 0L);
            if (result == null) {
                result = new OClusterPosition[]{};
            }
            OClusterPosition[] oClusterPositionArray = result;
            return oClusterPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPosition getFirstPosition() throws IOException {
        this.acquireSharedLock();
        try {
            long filledUpTo = this.diskCache.getFilledUpTo(this.fileId);
            for (long pageIndex = 0L; pageIndex < filledUpTo; ++pageIndex) {
                OCacheEntry cacheEntry = this.diskCache.load(this.fileId, pageIndex, false);
                try {
                    OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, ODurablePage.TrackMode.NONE);
                    int bucketSize = bucket.getSize();
                    for (int index = 0; index < bucketSize; ++index) {
                        if (!bucket.exists(index)) continue;
                        OClusterPosition oClusterPosition = OClusterPositionFactory.INSTANCE.valueOf(pageIndex * (long)OClusterPositionMapBucket.MAX_ENTRIES + (long)index);
                        return oClusterPosition;
                    }
                    continue;
                }
                finally {
                    this.diskCache.release(cacheEntry);
                }
            }
            OClusterPosition oClusterPosition = OClusterPosition.INVALID_POSITION;
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPosition getLastPosition() throws IOException {
        this.acquireSharedLock();
        try {
            long filledUpTo = this.diskCache.getFilledUpTo(this.fileId);
            for (long pageIndex = filledUpTo - 1L; pageIndex >= 0L; --pageIndex) {
                OCacheEntry cacheEntry = this.diskCache.load(this.fileId, pageIndex, false);
                try {
                    OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, ODurablePage.TrackMode.NONE);
                    int bucketSize = bucket.getSize();
                    for (int index = bucketSize - 1; index >= 0; --index) {
                        if (!bucket.exists(index)) continue;
                        OClusterPosition oClusterPosition = OClusterPositionFactory.INSTANCE.valueOf(pageIndex * (long)OClusterPositionMapBucket.MAX_ENTRIES + (long)index);
                        return oClusterPosition;
                    }
                    continue;
                }
                finally {
                    this.diskCache.release(cacheEntry);
                }
            }
            OClusterPosition oClusterPosition = OClusterPosition.INVALID_POSITION;
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public boolean wasSoftlyClosed() throws IOException {
        this.acquireSharedLock();
        try {
            boolean bl = this.diskCache.wasSoftlyClosed(this.fileId);
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    protected ODurablePage.TrackMode getTrackMode() {
        if (!this.useWal) {
            return ODurablePage.TrackMode.NONE;
        }
        return super.getTrackMode();
    }

    @Override
    protected void endAtomicOperation(boolean rollback) throws IOException {
        if (this.useWal) {
            super.endAtomicOperation(rollback);
        }
    }

    @Override
    protected void startAtomicOperation() throws IOException {
        if (this.useWal) {
            super.startAtomicOperation();
        }
    }
}

