/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.lock.OModificationLock;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterHoleConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.config.OStoragePhysicalClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePhysicalClusterConfigurationLocal;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocalHole;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OMultiFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.File;
import java.io.IOException;

public class OClusterLocal
extends OSharedResourceAdaptive
implements OCluster {
    public static final int RECORD_SIZE = 11 + OVersionFactory.instance().getVersionSize();
    public static final String TYPE = "PHYSICAL";
    private static final int RECORD_TYPE_OFFSET = 10;
    private static final String DEF_EXTENSION = ".ocl";
    private static final int DEF_SIZE = 1000000;
    private static final byte RECORD_WAS_DELETED = -1;
    private OMultiFileSegment fileSegment;
    private int id;
    private long beginOffsetData = -1L;
    private long endOffsetData = -1L;
    protected OClusterLocalHole holeSegment;
    private OStoragePhysicalClusterConfigurationLocal config;
    private OStorageLocal storage;
    private String name;
    private long version;

    public OClusterLocal() {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());
    }

    @Override
    public void configure(OStorage iStorage, OStorageClusterConfiguration iConfig) throws IOException {
        this.config = (OStoragePhysicalClusterConfigurationLocal)iConfig;
        this.init(iStorage, this.config.getId(), this.config.getName(), this.config.getLocation(), this.config.getDataSegmentId(), new Object[0]);
    }

    @Override
    public void configure(OStorage iStorage, int iId, String iClusterName, String iLocation, int iDataSegmentId, Object ... iParameters) throws IOException {
        this.config = new OStoragePhysicalClusterConfigurationLocal(iStorage.getConfiguration(), iId, iDataSegmentId);
        this.config.name = iClusterName;
        this.init(iStorage, iId, iClusterName, iLocation, iDataSegmentId, new Object[0]);
    }

    @Override
    public void create(int iStartSize) throws IOException {
        this.acquireExclusiveLock();
        try {
            if (iStartSize == -1) {
                iStartSize = 1000000;
            }
            if (this.config.root.clusters.size() <= this.config.id) {
                this.config.root.clusters.add(this.config);
            } else {
                this.config.root.clusters.set(this.config.id, this.config);
            }
            this.fileSegment.create(iStartSize);
            this.holeSegment.create();
            this.fileSegment.files[0].writeHeaderLong(0, this.beginOffsetData);
            this.fileSegment.files[0].writeHeaderLong(8, this.beginOffsetData);
            this.fileSegment.files[0].writeHeaderLong(16, 2L);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.fileSegment.open();
            this.holeSegment.open();
            this.beginOffsetData = this.fileSegment.files[0].readHeaderLong(0);
            this.endOffsetData = this.fileSegment.files[0].readHeaderLong(8);
            this.version = this.fileSegment.files[0].readHeaderLong(16);
            if (this.version < 1L) {
                this.convertDeletedRecords();
            }
            if (this.version < 2L) {
                if (this.endOffsetData < 0L) {
                    this.endOffsetData = this.fileSegment.getFilledUpTo() / (long)RECORD_SIZE - 1L;
                    if (this.endOffsetData >= 0L) {
                        long[] fetchPos;
                        for (long currentPos = this.endOffsetData * (long)RECORD_SIZE; currentPos >= this.beginOffsetData && this.fileSegment.files[(int)(fetchPos = this.fileSegment.getRelativePosition(currentPos))[0]].readByte(fetchPos[1] + 10L) == -1; currentPos -= (long)RECORD_SIZE) {
                            --this.endOffsetData;
                        }
                    }
                    this.fileSegment.files[0].writeHeaderLong(8, this.endOffsetData);
                }
                this.fileSegment.files[0].writeHeaderLong(16, 2L);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void convertDeletedRecords() throws IOException {
        int holesCount = this.holeSegment.getHoles();
        OLogManager.instance().info((Object)this, "Please wait till %d holes will be converted to new format in cluster %s.", new Object[]{holesCount, this.name});
        for (int i = 0; i < holesCount; ++i) {
            long relativeHolePosition = this.holeSegment.getEntryPosition(i);
            if (relativeHolePosition > -1L) {
                long[] pos = this.fileSegment.getRelativePosition(relativeHolePosition);
                OFile f = this.fileSegment.files[(int)pos[0]];
                long p = pos[1] + 10L;
                f.writeByte(p, (byte)-1);
            }
            if (i % 1000 != 0) continue;
            OLogManager.instance().info((Object)this, "%d holes were converted in cluster %s ...", new Object[]{i, this.name});
        }
        OLogManager.instance().info((Object)this, "Conversion of holes to new format was finished for cluster %s.", new Object[]{holesCount, this.name});
    }

    @Override
    public void close() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.fileSegment.close();
            this.holeSegment.close();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void close(boolean flush) throws IOException {
        this.close();
    }

    @Override
    public OModificationLock getExternalModificationLock() {
        throw new UnsupportedOperationException("getExternalModificationLock");
    }

    @Override
    public OPhysicalPosition createRecord(byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        throw new UnsupportedOperationException("createRecord");
    }

    @Override
    public boolean deleteRecord(OClusterPosition clusterPosition) throws IOException {
        throw new UnsupportedOperationException("deleteRecord");
    }

    @Override
    public void updateRecord(OClusterPosition clusterPosition, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        throw new UnsupportedOperationException("updateRecord");
    }

    @Override
    public ORawBuffer readRecord(OClusterPosition clusterPosition) throws IOException {
        throw new UnsupportedOperationException("readRecord");
    }

    @Override
    public boolean exists() {
        throw new UnsupportedOperationException("exists");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws IOException {
        this.acquireExclusiveLock();
        try {
            for (OFile f : this.fileSegment.files) {
                f.delete();
            }
            this.fileSegment.files = null;
            this.holeSegment.delete();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate() throws IOException {
        this.storage.checkForClusterPermissions(this.getName());
        this.acquireExclusiveLock();
        try {
            OClusterPosition begin = this.getFirstPosition();
            if (begin.isPersistent()) {
                OClusterPosition end = this.getLastPosition();
                OPhysicalPosition ppos = new OPhysicalPosition();
                ppos.clusterPosition = begin;
                while (ppos.clusterPosition.compareTo(end) <= 0) {
                    ODataLocal data;
                    OPhysicalPosition pposToDelete = this.getPhysicalPosition(ppos);
                    if (pposToDelete != null && this.storage.checkForRecordValidity(pposToDelete) && (data = this.storage.getDataSegmentById(pposToDelete.dataSegmentId)) != null) {
                        data.deleteRecord(pposToDelete.dataSegmentPos);
                    }
                    ppos.clusterPosition = ppos.clusterPosition.inc();
                }
            }
            this.fileSegment.truncate();
            this.holeSegment.truncate();
            this.beginOffsetData = -1L;
            this.endOffsetData = -1L;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(OCluster.ATTRIBUTES iAttribute, Object iValue) throws IOException {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        this.acquireExclusiveLock();
        try {
            switch (iAttribute) {
                case NAME: {
                    this.setNameInternal(stringValue);
                    return;
                }
                case DATASEGMENT: {
                    this.setDataSegmentInternal(stringValue);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Runtime change of attribute '" + (Object)((Object)iAttribute) + " is not supported");
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition iPPosition) throws IOException {
        OClusterPosition position = iPPosition.clusterPosition;
        long filePosition = position.longValue() * (long)RECORD_SIZE;
        this.acquireSharedLock();
        try {
            if (position.isNew() || position.compareTo(this.getLastPosition()) > 0) {
                OPhysicalPosition oPhysicalPosition = null;
                return oPhysicalPosition;
            }
            long[] pos = this.fileSegment.getRelativePosition(filePosition);
            OFile f = this.fileSegment.files[(int)pos[0]];
            long p = pos[1];
            iPPosition.dataSegmentId = f.readShort(p);
            iPPosition.dataSegmentPos = f.readLong(p += 2L);
            iPPosition.recordType = f.readByte(p += 8L);
            if (iPPosition.recordType == -1) {
                OPhysicalPosition oPhysicalPosition = null;
                return oPhysicalPosition;
            }
            iPPosition.recordVersion.getSerializer().readFrom(f, ++p, iPPosition.recordVersion);
            OPhysicalPosition oPhysicalPosition = iPPosition;
            return oPhysicalPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean useWal() {
        return false;
    }

    @Override
    public float recordGrowFactor() {
        return 1.0f;
    }

    @Override
    public float recordOverflowGrowFactor() {
        return 1.0f;
    }

    @Override
    public String compression() {
        return "nothing";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDataSegmentPosition(OClusterPosition iPosition, int iDataSegmentId, long iDataSegmentPosition) throws IOException {
        long position = iPosition.longValue();
        position *= (long)RECORD_SIZE;
        this.acquireExclusiveLock();
        try {
            long[] pos = this.fileSegment.getRelativePosition(position);
            OFile f = this.fileSegment.files[(int)pos[0]];
            long p = pos[1];
            f.writeShort(p, (short)iDataSegmentId);
            f.writeLong(p += 2L, iDataSegmentPosition);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateVersion(OClusterPosition iPosition, ORecordVersion iVersion) throws IOException {
        long position = iPosition.longValue();
        position *= (long)RECORD_SIZE;
        this.acquireExclusiveLock();
        try {
            long[] pos = this.fileSegment.getRelativePosition(position);
            iVersion.getSerializer().writeTo(this.fileSegment.files[(int)pos[0]], pos[1] + 2L + 8L + 1L, iVersion);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecordType(OClusterPosition iPosition, byte iRecordType) throws IOException {
        long position = iPosition.longValue();
        position *= (long)RECORD_SIZE;
        this.acquireExclusiveLock();
        try {
            long[] pos = this.fileSegment.getRelativePosition(position);
            this.fileSegment.files[(int)pos[0]].writeByte(pos[1] + 2L + 8L, iRecordType);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePhysicalPosition(OClusterPosition iPosition) throws IOException {
        long position = iPosition.longValue() * (long)RECORD_SIZE;
        this.acquireExclusiveLock();
        try {
            long[] pos = this.fileSegment.getRelativePosition(position);
            OFile file = this.fileSegment.files[(int)pos[0]];
            long p = pos[1] + 10L;
            this.holeSegment.pushPosition(position);
            file.writeByte(p, (byte)-1);
            this.updateBoundsAfterDeletion(iPosition.longValue());
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHole(long iPosition) throws IOException {
        this.acquireExclusiveLock();
        try {
            boolean bl = this.holeSegment.removeEntryWithPosition(iPosition * (long)RECORD_SIZE);
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public int getDataSegmentId() {
        this.acquireSharedLock();
        try {
            int n = this.config.getDataSegmentId();
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPhysicalPosition(OPhysicalPosition iPPosition) throws IOException {
        this.acquireExclusiveLock();
        try {
            boolean recycled;
            long[] pos;
            long offset = this.holeSegment.popLastEntryPosition();
            if (offset > -1L) {
                pos = this.fileSegment.getRelativePosition(offset);
                recycled = true;
            } else {
                pos = this.allocateRecord();
                offset = this.fileSegment.getAbsolutePosition(pos);
                recycled = false;
            }
            OFile file = this.fileSegment.files[(int)pos[0]];
            long p = pos[1];
            file.writeShort(p, (short)iPPosition.dataSegmentId);
            file.writeLong(p += 2L, iPPosition.dataSegmentPos);
            file.writeByte(p += 8L, iPPosition.recordType);
            if (recycled) {
                iPPosition.recordVersion.getSerializer().readFrom(file, p + 1L, iPPosition.recordVersion);
                if (iPPosition.recordVersion.isTombstone()) {
                    iPPosition.recordVersion.revive();
                }
                iPPosition.recordVersion.increment();
            } else {
                iPPosition.recordVersion.reset();
            }
            iPPosition.recordVersion.getSerializer().writeTo(file, p + 1L, iPPosition.recordVersion);
            iPPosition.clusterPosition = OClusterPositionFactory.INSTANCE.valueOf(offset / (long)RECORD_SIZE);
            this.updateBoundsAfterInsertion(iPPosition.clusterPosition.longValue());
        }
        finally {
            this.releaseExclusiveLock();
        }
        return true;
    }

    protected long[] allocateRecord() throws IOException {
        return this.fileSegment.allocateSpace(RECORD_SIZE);
    }

    @Override
    public OClusterPosition getFirstPosition() {
        this.acquireSharedLock();
        try {
            OClusterPosition oClusterPosition = OClusterPositionFactory.INSTANCE.valueOf(this.beginOffsetData);
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OClusterPosition getLastPosition() {
        this.acquireSharedLock();
        try {
            OClusterPosition oClusterPosition = OClusterPositionFactory.INSTANCE.valueOf(this.endOffsetData);
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getEntries() {
        this.acquireSharedLock();
        try {
            long l = this.fileSegment.getFilledUpTo() / (long)RECORD_SIZE - (long)this.holeSegment.getHoles();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getTombstonesCount() {
        return 0L;
    }

    @Override
    public void convertToTombstone(OClusterPosition iPosition) throws IOException {
        throw new UnsupportedOperationException("convertToTombstone");
    }

    @Override
    public boolean hasTombstonesSupport() {
        return false;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public OClusterEntryIterator absoluteIterator() {
        return new OClusterEntryIterator(this);
    }

    public long getSize() {
        this.acquireSharedLock();
        try {
            long l = this.fileSegment.getSize();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public long getFilledUpTo() {
        this.acquireSharedLock();
        try {
            long l = this.fileSegment.getFilledUpTo();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public String toString() {
        return this.name + " (id=" + this.id + ")";
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isHashBased() {
        return false;
    }

    @Override
    public long getRecordsSize() {
        this.acquireSharedLock();
        try {
            long size = this.fileSegment.getFilledUpTo();
            OClusterEntryIterator it = this.absoluteIterator();
            while (it.hasNext()) {
                OPhysicalPosition pos = it.next();
                if (pos.dataSegmentPos <= -1L || pos.recordVersion.isTombstone()) continue;
                size += (long)this.storage.getDataSegmentById(pos.dataSegmentId).getRecordSize(pos.dataSegmentPos);
            }
            long l = size;
            return l;
        }
        catch (IOException e) {
            throw new OIOException("Error on calculating cluster size for: " + this.getName(), (Throwable)e);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void synch() throws IOException {
        this.acquireSharedLock();
        try {
            this.fileSegment.synch();
            this.holeSegment.synch();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.fileSegment.setSoftlyClosed(softlyClosed);
            this.holeSegment.setSoftlyClosed(softlyClosed);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean wasSoftlyClosed() throws IOException {
        this.acquireSharedLock();
        try {
            boolean wasSoftlyClosed = this.fileSegment.wasSoftlyClosedAtPreviousTime();
            boolean bl = wasSoftlyClosed = wasSoftlyClosed && this.holeSegment.wasSoftlyClosedAtPreviousTime();
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public OStoragePhysicalClusterConfiguration getConfig() {
        return this.config;
    }

    private void setNameInternal(String iNewName) {
        if (this.storage.getClusterIdByName(iNewName) > -1) {
            throw new IllegalArgumentException("Cluster with name '" + iNewName + "' already exists");
        }
        try {
            for (int i = 0; i < this.fileSegment.files.length; ++i) {
                String osFileName = this.fileSegment.files[i].getName();
                if (!osFileName.startsWith(this.name)) continue;
                File newFile = new File(this.storage.getStoragePath() + "/" + iNewName + osFileName.substring(osFileName.lastIndexOf(this.name) + this.name.length()));
                for (OStorageFileConfiguration conf : this.config.infoFiles) {
                    if (conf.parent.name.equals(this.name)) {
                        conf.parent.name = iNewName;
                    }
                    if (!conf.path.endsWith(osFileName)) continue;
                    conf.path = new String(conf.path.replace(osFileName, newFile.getName()));
                }
                boolean renamed = this.fileSegment.files[i].renameTo(newFile);
                while (!renamed) {
                    OMemoryWatchDog.freeMemoryForResourceCleanup(100L);
                    renamed = this.fileSegment.files[i].renameTo(newFile);
                }
            }
            this.config.name = iNewName;
            this.holeSegment.rename(this.name, iNewName);
            this.storage.renameCluster(this.name, iNewName);
            this.name = iNewName;
            this.storage.getConfiguration().update();
        }
        catch (IOException e) {
            throw new OStorageException("Error during cluster rename", e);
        }
    }

    private void setDataSegmentInternal(String iName) {
        int dataId = this.storage.getDataSegmentIdByName(iName);
        this.config.setDataSegmentId(dataId);
        this.storage.getConfiguration().update();
    }

    protected void updateBoundsAfterInsertion(long iPosition) throws IOException {
        if (iPosition < this.beginOffsetData || this.beginOffsetData == -1L) {
            this.beginOffsetData = iPosition;
            this.fileSegment.files[0].writeHeaderLong(0, this.beginOffsetData);
        }
        if (iPosition > this.endOffsetData) {
            this.endOffsetData = iPosition;
            this.fileSegment.files[0].writeHeaderLong(8, this.endOffsetData);
        }
    }

    protected void updateBoundsAfterDeletion(long iPosition) throws IOException {
        long[] fetchPos;
        long currentPos;
        long position = iPosition * (long)RECORD_SIZE;
        if (iPosition == this.beginOffsetData) {
            if (this.getEntries() == 0L) {
                this.beginOffsetData = -1L;
            } else {
                ++this.beginOffsetData;
                for (currentPos = position + (long)RECORD_SIZE; currentPos < this.fileSegment.getFilledUpTo() && this.fileSegment.files[(int)(fetchPos = this.fileSegment.getRelativePosition(currentPos))[0]].readByte(fetchPos[1] + 10L) == -1; currentPos += (long)RECORD_SIZE) {
                    ++this.beginOffsetData;
                }
            }
            this.fileSegment.files[0].writeHeaderLong(0, this.beginOffsetData);
        }
        if (iPosition == this.endOffsetData) {
            if (this.getEntries() == 0L) {
                this.endOffsetData = -1L;
            } else {
                --this.endOffsetData;
                for (currentPos = position - (long)RECORD_SIZE; currentPos >= this.beginOffsetData && this.fileSegment.files[(int)(fetchPos = this.fileSegment.getRelativePosition(currentPos))[0]].readByte(fetchPos[1] + 10L) == -1; currentPos -= (long)RECORD_SIZE) {
                    --this.endOffsetData;
                }
            }
            this.fileSegment.files[0].writeHeaderLong(8, this.endOffsetData);
        }
    }

    protected void init(OStorage iStorage, int iId, String iClusterName, String iLocation, int iDataSegmentId, Object ... iParameters) throws IOException {
        OFileUtils.checkValidName((String)iClusterName);
        this.storage = (OStorageLocal)iStorage;
        this.config.setDataSegmentId(iDataSegmentId);
        this.config.id = iId;
        this.config.name = iClusterName;
        this.name = iClusterName;
        this.id = iId;
        if (this.fileSegment == null) {
            this.fileSegment = new OMultiFileSegment(this.storage, this.config, DEF_EXTENSION, RECORD_SIZE);
            this.config.setHoleFile(new OStorageClusterHoleConfiguration(this.config, "${STORAGE_PATH}/" + this.config.name, this.config.fileType, this.config.fileMaxSize));
            this.holeSegment = new OClusterLocalHole(this, this.storage, this.config.getHoleFile());
        }
    }

    public boolean isSoftlyClosed() {
        if (!this.fileSegment.wasSoftlyClosedAtPreviousTime()) {
            return false;
        }
        if (!this.holeSegment.wasSoftlyClosedAtPreviousTime()) {
            return false;
        }
        ODataLocal dataSegment = this.storage.getDataSegmentById(this.config.getDataSegmentId());
        if (!dataSegment.wasSoftlyClosedAtPreviousTime()) {
            return false;
        }
        return dataSegment.holeSegment.wasSoftlyClosedAtPreviousTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] higherPositions(OPhysicalPosition position) throws IOException {
        long filePosition = position.clusterPosition.longValue() * (long)RECORD_SIZE;
        if (filePosition < 0L) {
            filePosition = 0L;
        }
        this.acquireSharedLock();
        try {
            long p2;
            long[] pos;
            OFile f;
            byte recordType;
            if (this.getFirstPosition().longValue() < 0L) {
                OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                return oPhysicalPositionArray;
            }
            long lastFilePosition = this.getLastPosition().longValue() * (long)RECORD_SIZE;
            if (filePosition >= lastFilePosition) {
                OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                return oPhysicalPositionArray;
            }
            while ((recordType = (f = this.fileSegment.files[(int)(pos = this.fileSegment.getRelativePosition(filePosition += (long)RECORD_SIZE))[0]]).readByte(p2 = pos[1] + 10L)) == -1 && filePosition < lastFilePosition) {
            }
            if (recordType == -1) {
                OPhysicalPosition[] p2 = new OPhysicalPosition[]{};
                return p2;
            }
            p2 = pos[1];
            OPhysicalPosition physicalPosition = this.readPhysicalPosition(f, p2);
            OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{physicalPosition};
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private OPhysicalPosition readPhysicalPosition(OFile f, long p) throws IOException {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        physicalPosition.clusterPosition = OClusterPositionFactory.INSTANCE.valueOf(p / (long)RECORD_SIZE);
        physicalPosition.dataSegmentId = f.readShort(p);
        physicalPosition.dataSegmentPos = f.readLong(p += 2L);
        physicalPosition.recordType = f.readByte(p += 8L);
        physicalPosition.recordVersion.getSerializer().readFrom(f, ++p, physicalPosition.recordVersion);
        return physicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition position) throws IOException {
        long filePosition = position.clusterPosition.longValue() * (long)RECORD_SIZE;
        if (filePosition < 0L) {
            filePosition = 0L;
        }
        this.acquireSharedLock();
        try {
            long p2;
            long[] pos;
            OFile f;
            byte recordType;
            if (this.getFirstPosition().longValue() < 0L) {
                OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                return oPhysicalPositionArray;
            }
            long lastFilePosition = this.getLastPosition().longValue() * (long)RECORD_SIZE;
            if (filePosition > lastFilePosition) {
                OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                return oPhysicalPositionArray;
            }
            while ((recordType = (f = this.fileSegment.files[(int)(pos = this.fileSegment.getRelativePosition(filePosition))[0]]).readByte(p2 = pos[1] + 10L)) == -1 && (filePosition += (long)RECORD_SIZE) <= lastFilePosition) {
            }
            if (recordType == -1) {
                OPhysicalPosition[] p2 = new OPhysicalPosition[]{};
                return p2;
            }
            p2 = pos[1];
            OPhysicalPosition physicalPosition = this.readPhysicalPosition(f, p2);
            OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{physicalPosition};
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] lowerPositions(OPhysicalPosition position) throws IOException {
        long filePosition = position.clusterPosition.longValue() * (long)RECORD_SIZE;
        this.acquireSharedLock();
        try {
            long p2;
            long[] pos;
            OFile f;
            byte recordType;
            long firstFilePosition = this.getFirstPosition().longValue() * (long)RECORD_SIZE;
            if (filePosition <= firstFilePosition) {
                OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                return oPhysicalPositionArray;
            }
            while ((recordType = (f = this.fileSegment.files[(int)(pos = this.fileSegment.getRelativePosition(filePosition -= (long)RECORD_SIZE))[0]]).readByte(p2 = pos[1] + 10L)) == -1 && filePosition > firstFilePosition) {
            }
            if (recordType == -1) {
                OPhysicalPosition[] p2 = new OPhysicalPosition[]{};
                return p2;
            }
            p2 = pos[1];
            OPhysicalPosition physicalPosition = this.readPhysicalPosition(f, p2);
            OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{physicalPosition};
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] floorPositions(OPhysicalPosition position) throws IOException {
        long filePosition = position.clusterPosition.longValue() * (long)RECORD_SIZE;
        this.acquireSharedLock();
        try {
            long p2;
            long[] pos;
            OFile f;
            byte recordType;
            long firstFilePosition = this.getFirstPosition().longValue() * (long)RECORD_SIZE;
            if (filePosition <= firstFilePosition) {
                OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
                return oPhysicalPositionArray;
            }
            while ((recordType = (f = this.fileSegment.files[(int)(pos = this.fileSegment.getRelativePosition(filePosition))[0]]).readByte(p2 = pos[1] + 10L)) == -1 && (filePosition -= (long)RECORD_SIZE) >= firstFilePosition) {
            }
            if (recordType == -1) {
                OPhysicalPosition[] p2 = new OPhysicalPosition[]{};
                return p2;
            }
            p2 = pos[1];
            OPhysicalPosition physicalPosition = this.readPhysicalPosition(f, p2);
            OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{physicalPosition};
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean hideRecord(OClusterPosition position) {
        throw new UnsupportedOperationException("Operation is not supported for given cluster implementation");
    }
}

