/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.common.util.OByteBufferUtils;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.fs.OAbstractFile;
import com.orientechnologies.orient.core.storage.fs.OMMapBufferEntry;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import com.orientechnologies.orient.core.storage.fs.OMMapManagerLocator;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class OFileMMap
extends OAbstractFile {
    public static final String NAME = "mmap";
    protected volatile long filledUpTo;
    protected volatile MappedByteBuffer headerBuffer;
    protected static final Queue<ByteBuffer> bufferPool = new ConcurrentLinkedQueue<ByteBuffer>();
    private static int BYTEBUFFER_POOLABLE_SIZE;
    private static OMMapManager.ALLOC_STRATEGY strategy;
    private static long metricPooledBufferCreated;
    private static long metricPooledBufferUsed;
    private static long metricNonPooledBufferUsed;

    @Override
    public void delete() throws IOException {
        this.acquireWriteLock();
        try {
            OMMapManagerLocator.getInstance().removeFile(this);
            super.delete();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public long getFileSize() {
        return this.size;
    }

    @Override
    public long getFilledUpTo() {
        return this.filledUpTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(long iOffset, byte[] iData, int iLength, int iArrayOffset) throws IOException {
        this.acquireReadLock();
        try {
            byte[] source = new byte[iLength];
            this.readInternal(iOffset, source, iLength);
            System.arraycopy(source, 0, iData, iArrayOffset, iLength);
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(long iOffset, byte[] iDestBuffer, int iLenght) throws IOException {
        this.acquireReadLock();
        try {
            this.readInternal(iOffset, iDestBuffer, iLenght);
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readInt(long iOffset) throws IOException {
        this.acquireReadLock();
        iOffset = this.checkRegions(iOffset, 4L);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 4, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entries != null) {
            if (entries.length == 1) {
                int n = entries[0].buffer.getInt((int)(iOffset - entries[0].beginOffset));
                return n;
            }
            entries[0].buffer.position((int)(iOffset - entries[0].beginOffset));
            entries[1].buffer.position(0);
            int n = OByteBufferUtils.mergeIntFromBuffers((ByteBuffer)entries[0].buffer, (ByteBuffer)entries[1].buffer);
            return n;
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.READ);
            }
        }
        ByteBuffer buffer = this.acquireByteBuffer(4);
        this.channel.read(buffer, iOffset + 1024L);
        buffer.rewind();
        int value = buffer.getInt();
        this.releaseByteBuffer(buffer);
        int n = value;
        return n;
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long readLong(long iOffset) throws IOException {
        this.acquireReadLock();
        iOffset = this.checkRegions(iOffset, 8L);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 8, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entries != null) {
            if (entries.length == 1) {
                long l = entries[0].buffer.getLong((int)(iOffset - entries[0].beginOffset));
                return l;
            }
            entries[0].buffer.position((int)(iOffset - entries[0].beginOffset));
            entries[1].buffer.position(0);
            long l = OByteBufferUtils.mergeLongFromBuffers((ByteBuffer)entries[0].buffer, (ByteBuffer)entries[1].buffer);
            return l;
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.READ);
            }
        }
        ByteBuffer buffer = this.acquireByteBuffer(8);
        this.channel.read(buffer, iOffset + 1024L);
        buffer.rewind();
        long value = buffer.getLong();
        this.releaseByteBuffer(buffer);
        long l = value;
        return l;
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short readShort(long iOffset) throws IOException {
        this.acquireReadLock();
        iOffset = this.checkRegions(iOffset, 2L);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 2, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entries != null) {
            if (entries.length == 1) {
                short s = entries[0].buffer.getShort((int)(iOffset - entries[0].beginOffset));
                return s;
            }
            entries[0].buffer.position((int)(iOffset - entries[0].beginOffset));
            entries[1].buffer.position(0);
            short s = OByteBufferUtils.mergeShortFromBuffers((ByteBuffer)entries[0].buffer, (ByteBuffer)entries[1].buffer);
            return s;
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.READ);
            }
        }
        ByteBuffer buffer = this.acquireByteBuffer(2);
        this.channel.read(buffer, iOffset + 1024L);
        buffer.rewind();
        short value = buffer.getShort();
        this.releaseByteBuffer(buffer);
        short s = value;
        return s;
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte readByte(long iOffset) throws IOException {
        this.acquireReadLock();
        iOffset = this.checkRegions(iOffset, 1L);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 1, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entries != null) {
            try {
                byte by = entries[0].buffer.get((int)(iOffset - entries[0].beginOffset));
                return by;
            }
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.READ);
            }
        }
        ByteBuffer buffer = this.acquireByteBuffer(1);
        this.channel.read(buffer, iOffset + 1024L);
        buffer.rewind();
        byte value = buffer.get();
        this.releaseByteBuffer(buffer);
        byte by = value;
        return by;
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInternal(long iOffset, byte[] iDestBuffer, int iLenght) throws IOException {
        iOffset = this.checkRegions(iOffset, iLenght);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, iLenght, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entries != null) {
            try {
                int position = (int)(iOffset - entries[0].beginOffset);
                int remainingLength = iLenght;
                for (OMMapBufferEntry entry : entries) {
                    entry.buffer.position(position);
                    int remaining = entry.buffer.remaining();
                    int toRead = Math.min(remaining, remainingLength);
                    entry.buffer.get(iDestBuffer, iLenght - remainingLength, toRead);
                    position = 0;
                    remainingLength -= toRead;
                }
            }
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.READ);
            }
        } else {
            ByteBuffer buffer = this.acquireByteBuffer(iLenght);
            this.channel.read(buffer, iOffset + 1024L);
            buffer.rewind();
            buffer.get(iDestBuffer);
            this.releaseByteBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeInt(long iOffset, int iValue) throws IOException {
        block9: {
            this.acquireWriteLock();
            try {
                iOffset = this.checkRegions(iOffset, 4L);
                OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 4, OMMapManager.OPERATION_TYPE.WRITE, strategy);
                if (entries != null) {
                    try {
                        if (entries.length == 1) {
                            entries[0].buffer.putInt((int)(iOffset - entries[0].beginOffset), iValue);
                        } else {
                            entries[0].buffer.position((int)(iOffset - entries[0].beginOffset));
                            entries[1].buffer.position(0);
                            OByteBufferUtils.splitIntToBuffers((ByteBuffer)entries[0].buffer, (ByteBuffer)entries[1].buffer, (int)iValue);
                        }
                        break block9;
                    }
                    finally {
                        OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.WRITE);
                    }
                }
                ByteBuffer buffer = this.acquireByteBuffer(4);
                buffer.putInt(iValue);
                buffer.rewind();
                this.channel.write(buffer, iOffset + 1024L);
                this.releaseByteBuffer(buffer);
            }
            finally {
                this.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLong(long iOffset, long iValue) throws IOException {
        block9: {
            this.acquireWriteLock();
            try {
                iOffset = this.checkRegions(iOffset, 8L);
                OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 8, OMMapManager.OPERATION_TYPE.WRITE, strategy);
                if (entries != null) {
                    try {
                        if (entries.length == 1) {
                            entries[0].buffer.putLong((int)(iOffset - entries[0].beginOffset), iValue);
                        } else {
                            entries[0].buffer.position((int)(iOffset - entries[0].beginOffset));
                            entries[1].buffer.position(0);
                            OByteBufferUtils.splitLongToBuffers((ByteBuffer)entries[0].buffer, (ByteBuffer)entries[1].buffer, (long)iValue);
                        }
                        break block9;
                    }
                    finally {
                        OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.WRITE);
                    }
                }
                ByteBuffer buffer = this.acquireByteBuffer(8);
                buffer.putLong(iValue);
                buffer.rewind();
                this.channel.write(buffer, iOffset + 1024L);
                this.releaseByteBuffer(buffer);
            }
            finally {
                this.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeShort(long iOffset, short iValue) throws IOException {
        block9: {
            this.acquireWriteLock();
            try {
                iOffset = this.checkRegions(iOffset, 2L);
                OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 2, OMMapManager.OPERATION_TYPE.WRITE, strategy);
                if (entries != null) {
                    try {
                        if (entries.length == 1) {
                            entries[0].buffer.putShort((int)(iOffset - entries[0].beginOffset), iValue);
                        } else {
                            entries[0].buffer.position((int)(iOffset - entries[0].beginOffset));
                            entries[1].buffer.position(0);
                            OByteBufferUtils.splitShortToBuffers((ByteBuffer)entries[0].buffer, (ByteBuffer)entries[1].buffer, (short)iValue);
                        }
                        break block9;
                    }
                    finally {
                        OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.WRITE);
                    }
                }
                ByteBuffer buffer = this.acquireByteBuffer(2);
                buffer.putShort(iValue);
                buffer.rewind();
                this.channel.write(buffer, iOffset + 1024L);
                this.releaseByteBuffer(buffer);
            }
            finally {
                this.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeByte(long iOffset, byte iValue) throws IOException {
        block7: {
            this.acquireWriteLock();
            try {
                iOffset = this.checkRegions(iOffset, 1L);
                OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 1, OMMapManager.OPERATION_TYPE.WRITE, strategy);
                if (entries != null) {
                    try {
                        entries[0].buffer.put((int)(iOffset - entries[0].beginOffset), iValue);
                        break block7;
                    }
                    finally {
                        OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.WRITE);
                    }
                }
                ByteBuffer buffer = this.acquireByteBuffer(1);
                buffer.put(iValue);
                buffer.rewind();
                this.channel.write(buffer, iOffset + 1024L);
                this.releaseByteBuffer(buffer);
            }
            finally {
                this.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(long iOffset, byte[] iSourceBuffer) throws IOException {
        block12: {
            this.acquireWriteLock();
            try {
                if (iSourceBuffer == null || iSourceBuffer.length == 0) {
                    return;
                }
                iOffset = this.checkRegions(iOffset, iSourceBuffer.length);
                try {
                    OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, iSourceBuffer.length, OMMapManager.OPERATION_TYPE.WRITE, strategy);
                    if (entries != null) {
                        try {
                            int iLenght;
                            int position = (int)(iOffset - entries[0].beginOffset);
                            int remainingLength = iLenght = iSourceBuffer.length;
                            for (OMMapBufferEntry entry : entries) {
                                entry.buffer.position(position);
                                int remaining = entry.buffer.remaining();
                                int toWrite = Math.min(remaining, remainingLength);
                                entry.buffer.put(iSourceBuffer, iLenght - remainingLength, toWrite);
                                position = 0;
                                remainingLength -= toWrite;
                            }
                            break block12;
                        }
                        finally {
                            OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.WRITE);
                        }
                    }
                    ByteBuffer buffer = this.acquireByteBuffer(iSourceBuffer.length);
                    buffer.put(iSourceBuffer);
                    buffer.rewind();
                    this.channel.write(buffer, iOffset + 1024L);
                    this.releaseByteBuffer(buffer);
                }
                catch (BufferOverflowException e) {
                    OLogManager.instance().error((Object)this, "Error on write in the range " + iOffset + "-" + (iOffset + (long)iSourceBuffer.length) + "." + this.toString(), (Throwable)e, OIOException.class, new Object[0]);
                }
            }
            finally {
                this.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(long iOffset, byte[] iData, int iSize, int iArrayOffset) throws IOException {
        block14: {
            this.acquireWriteLock();
            try {
                if (iData == null || iData.length == 0 || iSize == 0) {
                    return;
                }
                assert (iOffset > -1L);
                assert (iArrayOffset > -1);
                iOffset = this.checkRegions(iOffset, iSize);
                try {
                    OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, iSize, OMMapManager.OPERATION_TYPE.WRITE, strategy);
                    if (entries != null) {
                        try {
                            int iLength;
                            int position = (int)(iOffset - entries[0].beginOffset);
                            int remainingLength = iLength = iSize;
                            for (OMMapBufferEntry entry : entries) {
                                entry.buffer.position(position);
                                int remaining = entry.buffer.remaining();
                                int toWrite = Math.min(remaining, remainingLength);
                                entry.buffer.put(iData, iArrayOffset + iLength - remainingLength, toWrite);
                                position = 0;
                                remainingLength -= toWrite;
                            }
                            break block14;
                        }
                        finally {
                            OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.WRITE);
                        }
                    }
                    ByteBuffer buffer = this.acquireByteBuffer(iSize);
                    buffer.put(iData, iArrayOffset, iSize);
                    buffer.rewind();
                    this.channel.write(buffer, iOffset + 1024L);
                    this.releaseByteBuffer(buffer);
                }
                catch (BufferOverflowException e) {
                    OLogManager.instance().error((Object)this, "Error on write in the range " + iOffset + "-" + (iOffset + (long)iSize) + "." + this.toString(), (Throwable)e, OIOException.class, new Object[0]);
                }
            }
            finally {
                this.releaseWriteLock();
            }
        }
    }

    @Override
    public boolean synch() {
        this.acquireWriteLock();
        try {
            boolean allFlushed = OMMapManagerLocator.getInstance().flushFile(this);
            this.flushHeader();
            boolean bl = allFlushed;
            return bl;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeHeaderLong(int iPosition, long iValue) {
        this.acquireWriteLock();
        try {
            if (this.headerBuffer != null) {
                this.headerBuffer.putLong(128 + iPosition, iValue);
                this.setHeaderDirty();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long readHeaderLong(int iPosition) {
        this.acquireReadLock();
        try {
            long l = this.headerBuffer.getLong(128 + iPosition);
            return l;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public void close() throws IOException {
        this.acquireWriteLock();
        try {
            OMMapManagerLocator.getInstance().flushFile(this);
            super.close();
            this.headerBuffer = null;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void setSoftlyClosed(boolean value) {
        this.acquireWriteLock();
        try {
            if (this.headerBuffer == null) {
                return;
            }
            this.headerBuffer.put(16, (byte)(value ? 1 : 0));
            this.setHeaderDirty();
            this.flushHeader();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public boolean isSoftlyClosed() throws IOException {
        this.acquireReadLock();
        try {
            if (this.version == 0) {
                boolean bl = this.headerBuffer.get(8) > 0;
                return bl;
            }
            boolean bl = this.headerBuffer.get(16) > 0;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    MappedByteBuffer map(long iBeginOffset, int iSize) throws IOException {
        return this.channel.map(this.mode.equals("r") ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, iBeginOffset + 1024L, iSize);
    }

    @Override
    protected void openChannel(long newSize) throws IOException {
        super.openChannel(newSize);
        this.headerBuffer = this.channel.map(this.mode.equals("r") ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, 1024L);
    }

    public boolean isClosed() {
        return this.headerBuffer == null;
    }

    protected ByteBuffer acquireByteBuffer(int iSize) {
        if (iSize > BYTEBUFFER_POOLABLE_SIZE) {
            try {
                ++metricNonPooledBufferUsed;
                return ByteBuffer.allocate(iSize);
            }
            catch (OutOfMemoryError e) {
                OLogManager.instance().error((Object)this, "Error on allocating direct buffer of size %d bytes", (Throwable)e, new Object[]{iSize});
                throw e;
            }
        }
        ByteBuffer buffer = bufferPool.poll();
        if (buffer != null) {
            ++metricPooledBufferUsed;
        } else {
            ++metricPooledBufferCreated;
            buffer = ByteBuffer.allocateDirect(BYTEBUFFER_POOLABLE_SIZE);
        }
        buffer.limit(iSize);
        return buffer;
    }

    protected void releaseByteBuffer(ByteBuffer iBuffer) {
        if (iBuffer.limit() > BYTEBUFFER_POOLABLE_SIZE) {
            return;
        }
        iBuffer.rewind();
        bufferPool.add(iBuffer);
    }

    @Override
    protected void init() {
        this.acquireWriteLock();
        try {
            if (this.version == 0) {
                this.size = this.headerBuffer.getInt(0);
                this.filledUpTo = this.headerBuffer.getInt(4);
            } else {
                this.size = this.headerBuffer.getLong(0);
                this.filledUpTo = this.headerBuffer.getLong(8);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    protected void setFilledUpTo(long iHow) {
        this.setFilledUpTo(iHow, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setFilledUpTo(long iHow, boolean force) {
        this.acquireWriteLock();
        try {
            if (force || iHow != this.filledUpTo) {
                this.filledUpTo = iHow;
                this.headerBuffer.putLong(8, this.filledUpTo);
                this.setHeaderDirty();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    protected void setVersion(int version) throws IOException {
        this.acquireWriteLock();
        try {
            this.headerBuffer.put(48, (byte)version);
            this.setHeaderDirty();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void setSize(long iSize) throws IOException {
        this.setSize(iSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setSize(long size, boolean force) throws IOException {
        this.acquireWriteLock();
        try {
            if (this.maxSize > 0L && size > this.maxSize) {
                throw new IllegalArgumentException("Cannot extend the file to " + OFileUtils.getSizeAsString((long)size) + " because the max is " + OFileUtils.getSizeAsString((long)this.maxSize));
            }
            if (force || this.size != size) {
                this.checkSize(size);
                this.size = size;
                this.headerBuffer.putLong(0, size);
                this.setHeaderDirty();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    protected void flushHeader() {
        if (this.headerDirty) {
            this.headerBuffer.force();
            this.headerDirty = false;
        }
    }

    static {
        metricPooledBufferCreated = 0L;
        metricPooledBufferUsed = 0L;
        metricNonPooledBufferUsed = 0L;
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.pooledBufferCreated", "Number of file buffers created", OProfilerMBean.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return metricPooledBufferCreated;
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.pooledBufferUsed", "Number of times a file buffers has been reused", OProfilerMBean.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return metricPooledBufferUsed;
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.file.mmap.nonPooledBufferUsed", "Number of times a file buffers has not been reused", OProfilerMBean.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return metricNonPooledBufferUsed;
            }
        });
        BYTEBUFFER_POOLABLE_SIZE = OGlobalConfiguration.FILE_MMAP_BUFFER_SIZE.getValueAsInteger();
        strategy = OMMapManager.ALLOC_STRATEGY.values()[OGlobalConfiguration.FILE_MMAP_STRATEGY.getValueAsInteger()];
    }
}

