/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.fs.OFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class OAbstractFile
implements OFile {
    private FileLock fileLock;
    protected File osFile;
    protected RandomAccessFile accessFile;
    protected FileChannel channel;
    protected volatile boolean dirty = false;
    protected volatile boolean headerDirty = false;
    protected int version;
    protected int incrementSize = -50;
    protected long maxSize;
    protected byte[] securityCode = new byte[32];
    protected String mode;
    protected boolean failCheck = true;
    protected volatile long size;
    public static final int HEADER_SIZE = 1024;
    protected static final int HEADER_DATA_OFFSET = 128;
    protected static final int DEFAULT_SIZE = 1024000;
    protected static final int DEFAULT_INCREMENT_SIZE = -50;
    private static final int OPEN_RETRY_MAX = 10;
    private static final int OPEN_DELAY_RETRY = 100;
    private static final long LOCK_WAIT_TIME = 300L;
    private static final int LOCK_MAX_RETRIES = 10;
    protected static final int SIZE_OFFSET_V_0 = 0;
    protected static final int FILLEDUPTO_OFFSET_V_0 = 4;
    protected static final int SOFTLY_CLOSED_OFFSET_V_0 = 8;
    protected static final int SIZE_OFFSET = 0;
    protected static final int FILLEDUPTO_OFFSET = 8;
    protected static final int SOFTLY_CLOSED_OFFSET = 16;
    protected static final int VERSION_OFFSET = 48;
    protected static final int CURRENT_VERSION = 1;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean wasSoftlyClosed = true;

    @Override
    public abstract long getFileSize();

    @Override
    public abstract long getFilledUpTo();

    @Override
    public abstract void setSize(long var1) throws IOException;

    @Override
    public abstract void writeHeaderLong(int var1, long var2) throws IOException;

    @Override
    public abstract long readHeaderLong(int var1) throws IOException;

    @Override
    public abstract boolean synch() throws IOException;

    @Override
    public abstract void read(long var1, byte[] var3, int var4) throws IOException;

    @Override
    public abstract short readShort(long var1) throws IOException;

    @Override
    public abstract int readInt(long var1) throws IOException;

    @Override
    public abstract long readLong(long var1) throws IOException;

    @Override
    public abstract byte readByte(long var1) throws IOException;

    @Override
    public abstract void writeInt(long var1, int var3) throws IOException;

    @Override
    public abstract void writeLong(long var1, long var3) throws IOException;

    @Override
    public abstract void writeShort(long var1, short var3) throws IOException;

    @Override
    public abstract void writeByte(long var1, byte var3) throws IOException;

    @Override
    public abstract void write(long var1, byte[] var3) throws IOException;

    protected abstract void init() throws IOException;

    protected abstract void setFilledUpTo(long var1) throws IOException;

    protected abstract void flushHeader() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open() throws IOException {
        this.acquireWriteLock();
        try {
            long newFileSize;
            if (!this.osFile.exists()) {
                throw new FileNotFoundException("File: " + this.osFile.getAbsolutePath());
            }
            this.openChannel(this.osFile.length());
            OLogManager.instance().debug((Object)this, "Checking file integrity of " + this.osFile.getName() + "...", new Object[0]);
            this.init();
            long filledUpTo = this.getFilledUpTo();
            long fileSize = this.getFileSize();
            if (fileSize == 0L && (newFileSize = this.osFile.length() - 1024L) != fileSize) {
                OLogManager.instance().error((Object)this, "Invalid fileSize=%d for file %s. Resetting it to the os file size: %d. Probably the file was not closed correctly last time. The number of records has been set to the maximum value. It's strongly suggested to export and reimport the database before using it", new Object[]{fileSize, this.getOsFile().getAbsolutePath(), newFileSize});
                this.setFilledUpTo(newFileSize, true);
                this.setSize(newFileSize, true);
                fileSize = newFileSize;
            }
            if (filledUpTo > 0L && filledUpTo > fileSize) {
                OLogManager.instance().error((Object)this, "Invalid filledUp=%d for file %s. Resetting it to the os file size: %d. Probably the file was not closed correctly last time. The number of records has been set to the maximum value. It's strongly suggested to export and reimport the database before using it", new Object[]{filledUpTo, this.getOsFile().getAbsolutePath(), fileSize});
                this.setSize(fileSize);
                this.setFilledUpTo(fileSize);
                filledUpTo = this.getFilledUpTo();
            }
            if (filledUpTo > fileSize || filledUpTo < 0L) {
                OLogManager.instance().error((Object)this, "Invalid filledUp size (=" + filledUpTo + "). The file could be corrupted", null, OStorageException.class, new Object[0]);
            }
            if (this.failCheck) {
                this.wasSoftlyClosed = this.isSoftlyClosed();
                if (this.wasSoftlyClosed) {
                    this.setSoftlyClosed(false);
                }
            }
            if (this.version < 1) {
                this.setSize(fileSize, true);
                this.setFilledUpTo(filledUpTo, true);
                this.setVersion(1);
                this.version = 1;
                this.setSoftlyClosed(!this.failCheck);
            }
            if (this.failCheck) {
                boolean bl = this.wasSoftlyClosed;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public boolean wasSoftlyClosed() {
        this.acquireReadLock();
        try {
            boolean bl = this.wasSoftlyClosed;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public void create(int iStartSize) throws IOException {
        this.acquireWriteLock();
        try {
            if (iStartSize == -1) {
                iStartSize = 1024000;
            }
            this.openChannel(iStartSize);
            this.setFilledUpTo(0L, true);
            this.setSize(this.maxSize > 0L && (long)iStartSize > this.maxSize ? this.maxSize : (long)iStartSize, true);
            this.setVersion(1);
            this.version = 1;
            this.setSoftlyClosed(!this.failCheck);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void close() throws IOException {
        this.acquireWriteLock();
        try {
            try {
                this.setSoftlyClosed(true);
                if (OGlobalConfiguration.FILE_LOCK.getValueAsBoolean()) {
                    this.unlock();
                }
                if (this.channel != null && this.channel.isOpen()) {
                    this.channel.close();
                    this.channel = null;
                }
                if (this.accessFile != null) {
                    this.accessFile.close();
                    this.accessFile = null;
                }
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on closing file " + this.osFile.getAbsolutePath(), (Throwable)e, OIOException.class, new Object[0]);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void close(boolean softlyClosed) throws IOException {
        this.acquireWriteLock();
        try {
            try {
                this.setSoftlyClosed(softlyClosed);
                if (OGlobalConfiguration.FILE_LOCK.getValueAsBoolean()) {
                    this.unlock();
                }
                if (this.channel != null && this.channel.isOpen()) {
                    this.channel.close();
                    this.channel = null;
                }
                if (this.accessFile != null) {
                    this.accessFile.close();
                    this.accessFile = null;
                }
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on closing file " + this.osFile.getAbsolutePath(), (Throwable)e, OIOException.class, new Object[0]);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void delete() throws IOException {
        this.acquireWriteLock();
        try {
            this.close();
            if (this.osFile != null) {
                boolean deleted = OFileUtils.delete((File)this.osFile);
                int retryCount = 0;
                while (!deleted) {
                    OMemoryWatchDog.freeMemoryForResourceCleanup(100L);
                    deleted = OFileUtils.delete((File)this.osFile);
                    if (++retryCount <= 10) continue;
                    throw new IOException("Can not delete file. Retry limit exceeded.");
                }
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileLock lock(long iRangeFrom, long iRangeSize, boolean iShared) throws IOException {
        this.acquireWriteLock();
        try {
            FileLock fileLock = this.channel.lock(iRangeFrom, iRangeSize, iShared);
            return fileLock;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public OFile unlock(FileLock iLock) throws IOException {
        this.acquireWriteLock();
        try {
            if (iLock != null) {
                try {
                    iLock.release();
                }
                catch (ClosedChannelException closedChannelException) {
                    // empty catch block
                }
            }
            OAbstractFile oAbstractFile = this;
            return oAbstractFile;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void lock() throws IOException {
        if (this.channel == null) {
            return;
        }
        this.acquireWriteLock();
        try {
            for (int i = 0; i < 10; ++i) {
                block7: {
                    try {
                        this.fileLock = this.channel.tryLock();
                        if (this.fileLock == null) break block7;
                        break;
                    }
                    catch (OverlappingFileLockException e) {
                        OLogManager.instance().debug((Object)this, "Cannot open file '" + this.osFile.getAbsolutePath() + "' because it is locked. Waiting %d ms and retrying %d/%d...", new Object[]{300L, i, 10});
                        OMemoryWatchDog.freeMemoryForResourceCleanup(300L);
                    }
                }
                if (this.fileLock != null) continue;
                throw new OLockException("File '" + this.osFile.getPath() + "' is locked by another process, maybe the database is in use by another process. Use the remote mode with a OrientDB server to allow multiple access to the same database.");
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void unlock() throws IOException {
        block5: {
            this.acquireWriteLock();
            try {
                if (this.fileLock == null) break block5;
                try {
                    this.fileLock.release();
                }
                catch (ClosedChannelException closedChannelException) {
                    // empty catch block
                }
                this.fileLock = null;
            }
            finally {
                this.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSize(long iSize) throws IOException {
        this.acquireReadLock();
        try {
            long filledUpTo;
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Changing file size to " + iSize + " bytes. " + this.toString(), new Object[0]);
            }
            if (iSize < (filledUpTo = this.getFilledUpTo())) {
                OLogManager.instance().error((Object)this, "You cannot resize down the file to " + iSize + " bytes, since it is less than current space used: " + filledUpTo + " bytes", OIOException.class);
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTail(long iSizeToShrink) throws IOException {
        this.acquireWriteLock();
        try {
            long filledUpTo = this.getFilledUpTo();
            if (filledUpTo < iSizeToShrink) {
                iSizeToShrink = 0L;
            }
            this.setFilledUpTo(filledUpTo - iSizeToShrink);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shrink(long iSize) throws IOException {
        this.acquireWriteLock();
        try {
            long filledUpTo = this.getFilledUpTo();
            if (iSize >= filledUpTo) {
                return;
            }
            OLogManager.instance().debug((Object)this, "Shrinking filled file from " + filledUpTo + " to " + iSize + " bytes. " + this.toString(), new Object[0]);
            this.setFilledUpTo(iSize);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long allocateSpace(long iSize) throws IOException {
        this.acquireWriteLock();
        try {
            long offset = this.getFilledUpTo();
            long size = this.getFileSize();
            if (this.getFreeSpace() < iSize) {
                long stepSizeInBytes;
                if (this.maxSize > 0L && this.maxSize - size < iSize) {
                    throw new IllegalArgumentException("Cannot enlarge file since the configured max size (" + OFileUtils.getSizeAsString((long)this.maxSize) + ") was reached! " + this.toString());
                }
                long newFileSize = size;
                if (newFileSize == 0L) {
                    newFileSize = 1024000L;
                }
                long l = stepSizeInBytes = this.incrementSize > 0 ? (long)this.incrementSize : -1L * size / 100L * (long)this.incrementSize;
                while (newFileSize - offset <= iSize) {
                    if ((newFileSize += stepSizeInBytes) == 0L) {
                        newFileSize = iSize;
                    }
                    if (newFileSize <= this.maxSize || this.maxSize <= 0L) continue;
                    newFileSize = this.maxSize;
                }
                this.setSize(newFileSize);
            }
            this.setFilledUpTo(offset + iSize);
            long l = offset;
            return l;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long checkRegions(long iOffset, long iLength) {
        this.acquireReadLock();
        try {
            if (iOffset < 0L || iOffset + iLength > this.getFilledUpTo()) {
                throw new OIOException("You cannot access outside the file size (" + this.getFilledUpTo() + " bytes). You have requested portion " + iOffset + "-" + (iOffset + iLength) + " bytes. File: " + this.toString());
            }
            long l = iOffset;
            return l;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public long getFreeSpace() {
        this.acquireReadLock();
        try {
            long l = this.getFileSize() - this.getFilledUpTo();
            return l;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public boolean canOversize(int iRecordSize) {
        this.acquireReadLock();
        try {
            boolean bl = this.maxSize - this.getFileSize() > (long)iRecordSize;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("File: ");
        builder.append(this.osFile.getName());
        if (this.accessFile != null) {
            builder.append(" os-size=");
            try {
                builder.append(this.accessFile.length());
            }
            catch (IOException e) {
                builder.append("?");
            }
        }
        builder.append(", stored=");
        builder.append(this.getFileSize());
        builder.append(", filled=");
        builder.append(this.getFilledUpTo());
        builder.append(", max=");
        builder.append(this.maxSize);
        builder.append("");
        return builder.toString();
    }

    public File getOsFile() {
        this.acquireReadLock();
        try {
            File file = this.osFile;
            return file;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAbstractFile init(String iFileName, String iMode) {
        this.acquireWriteLock();
        try {
            this.mode = iMode;
            this.osFile = new File(iFileName);
            OAbstractFile oAbstractFile = this;
            return oAbstractFile;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openChannel(long newSize) throws IOException {
        this.acquireWriteLock();
        try {
            OLogManager.instance().debug((Object)this, "[OFile.openChannel] opening channel for file '%s' of size: %d", new Object[]{this.osFile, this.osFile.length()});
            for (int i = 0; i < 10; ++i) {
                try {
                    this.accessFile = new RandomAccessFile(this.osFile, this.mode);
                    break;
                }
                catch (FileNotFoundException e) {
                    if (i == 100) {
                        throw e;
                    }
                    this.osFile.getParentFile().mkdirs();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
            }
            if (this.accessFile == null) {
                throw new FileNotFoundException(this.osFile.getAbsolutePath());
            }
            if (this.accessFile.length() != newSize) {
                this.accessFile.setLength(newSize);
            }
            this.accessFile.seek(48L);
            this.version = this.accessFile.read();
            this.accessFile.seek(0L);
            this.channel = this.accessFile.getChannel();
            if (OGlobalConfiguration.FILE_LOCK.getValueAsBoolean()) {
                this.lock();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public long getMaxSize() {
        this.acquireReadLock();
        try {
            long l = this.maxSize;
            return l;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.acquireWriteLock();
        try {
            this.maxSize = maxSize;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public int getIncrementSize() {
        this.acquireReadLock();
        try {
            int n = this.incrementSize;
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public void setIncrementSize(int incrementSize) {
        this.acquireWriteLock();
        try {
            this.incrementSize = incrementSize;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public boolean isOpen() {
        this.acquireReadLock();
        try {
            boolean bl = this.accessFile != null;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public boolean exists() {
        this.acquireReadLock();
        try {
            boolean bl = this.osFile != null && this.osFile.exists();
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public boolean isFailCheck() {
        this.acquireReadLock();
        try {
            boolean bl = this.failCheck;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public void setFailCheck(boolean failCheck) {
        this.acquireWriteLock();
        try {
            this.failCheck = failCheck;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected void setDirty() {
        this.acquireWriteLock();
        try {
            if (!this.dirty) {
                this.dirty = true;
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected void setHeaderDirty() {
        this.acquireWriteLock();
        try {
            if (!this.headerDirty) {
                this.headerDirty = true;
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public String getName() {
        this.acquireReadLock();
        try {
            String string = this.osFile.getName();
            return string;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public String getPath() {
        this.acquireReadLock();
        try {
            String string = this.osFile.getPath();
            return string;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public String getAbsolutePath() {
        this.acquireReadLock();
        try {
            String string = this.osFile.getAbsolutePath();
            return string;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameTo(File newFile) throws IOException {
        this.acquireWriteLock();
        try {
            this.close();
            boolean renamed = OFileUtils.renameFile((File)this.osFile, (File)newFile);
            if (renamed) {
                this.osFile = newFile;
            }
            this.open();
            boolean bl = renamed;
            return bl;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected void acquireWriteLock() {
        this.lock.writeLock().lock();
    }

    protected void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    protected void acquireReadLock() {
        this.lock.readLock().lock();
    }

    protected void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    protected abstract void setVersion(int var1) throws IOException;

    protected abstract void setFilledUpTo(long var1, boolean var3);

    protected abstract void setSize(long var1, boolean var3) throws IOException;
}

