/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.lock.OModificationLock;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.IOException;

public interface OCluster {
    public void configure(OStorage var1, int var2, String var3, String var4, int var5, Object ... var6) throws IOException;

    public void configure(OStorage var1, OStorageClusterConfiguration var2) throws IOException;

    public void create(int var1) throws IOException;

    public void open() throws IOException;

    public void close() throws IOException;

    public void close(boolean var1) throws IOException;

    public void delete() throws IOException;

    public OModificationLock getExternalModificationLock();

    public void set(ATTRIBUTES var1, Object var2) throws IOException;

    public void convertToTombstone(OClusterPosition var1) throws IOException;

    public long getTombstonesCount();

    public boolean hasTombstonesSupport();

    public void truncate() throws IOException;

    public String getType();

    public int getDataSegmentId();

    public OPhysicalPosition createRecord(byte[] var1, ORecordVersion var2, byte var3) throws IOException;

    public boolean deleteRecord(OClusterPosition var1) throws IOException;

    public void updateRecord(OClusterPosition var1, byte[] var2, ORecordVersion var3, byte var4) throws IOException;

    public ORawBuffer readRecord(OClusterPosition var1) throws IOException;

    public boolean exists();

    public boolean addPhysicalPosition(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition var1) throws IOException;

    public void updateDataSegmentPosition(OClusterPosition var1, int var2, long var3) throws IOException;

    public void removePhysicalPosition(OClusterPosition var1) throws IOException;

    public void updateRecordType(OClusterPosition var1, byte var2) throws IOException;

    public void updateVersion(OClusterPosition var1, ORecordVersion var2) throws IOException;

    public long getEntries();

    public OClusterPosition getFirstPosition() throws IOException;

    public OClusterPosition getLastPosition() throws IOException;

    public int getId();

    public void synch() throws IOException;

    public void setSoftlyClosed(boolean var1) throws IOException;

    public boolean wasSoftlyClosed() throws IOException;

    public String getName();

    public long getRecordsSize() throws IOException;

    public boolean useWal();

    public float recordGrowFactor();

    public float recordOverflowGrowFactor();

    public String compression();

    public boolean isHashBased();

    public OClusterEntryIterator absoluteIterator();

    public OPhysicalPosition[] higherPositions(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition[] lowerPositions(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition[] floorPositions(OPhysicalPosition var1) throws IOException;

    public boolean hideRecord(OClusterPosition var1) throws IOException;

    public static enum ATTRIBUTES {
        NAME,
        DATASEGMENT,
        USE_WAL,
        RECORD_GROW_FACTOR,
        RECORD_OVERFLOW_GROW_FACTOR,
        COMPRESSION;

    }
}

