/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;

public class OQueryOperatorAnd
extends OQueryOperator {
    public OQueryOperatorAnd() {
        super("AND", 4, false);
    }

    @Override
    public Object evaluateRecord(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        if (iLeft == null) {
            return false;
        }
        return (Boolean)iLeft != false && (Boolean)iRight != false;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (iLeft == null || iRight == null) {
            return OIndexReuseType.NO_INDEX;
        }
        return OIndexReuseType.INDEX_INTERSECTION;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        ORID leftRange = iLeft instanceof OSQLFilterCondition ? ((OSQLFilterCondition)iLeft).getBeginRidRange() : null;
        ORID rightRange = iRight instanceof OSQLFilterCondition ? ((OSQLFilterCondition)iRight).getBeginRidRange() : null;
        if (leftRange == null && rightRange == null) {
            return null;
        }
        if (leftRange == null) {
            return rightRange;
        }
        if (rightRange == null) {
            return leftRange;
        }
        return leftRange.compareTo(rightRange) <= 0 ? rightRange : leftRange;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        ORID leftRange = iLeft instanceof OSQLFilterCondition ? ((OSQLFilterCondition)iLeft).getEndRidRange() : null;
        ORID rightRange = iRight instanceof OSQLFilterCondition ? ((OSQLFilterCondition)iRight).getEndRidRange() : null;
        if (leftRange == null && rightRange == null) {
            return null;
        }
        if (leftRange == null) {
            return rightRange;
        }
        if (rightRange == null) {
            return leftRange;
        }
        return leftRange.compareTo(rightRange) >= 0 ? rightRange : leftRange;
    }
}

