/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;
import java.util.ArrayList;
import java.util.Map;

public class OSQLMethodExclude
extends OAbstractSQLMethod {
    public static final String NAME = "exclude";

    public OSQLMethodExclude() {
        super(NAME, 1, -1);
    }

    @Override
    public String getSyntax() {
        return "Syntax error: exclude([<field-name>][,]*)";
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, OCommandContext iContext, Object ioResult, Object[] iParams) {
        if (iThis != null) {
            if (iThis instanceof ODocument) {
                return this.copy((ODocument)iThis, iParams);
            }
            if (iThis instanceof Map) {
                return this.copy((Map)iThis, iParams);
            }
            if (OMultiValue.isMultiValue((Object)iThis)) {
                ArrayList<Object> result = new ArrayList<Object>(OMultiValue.getSize((Object)iThis));
                for (Object o : OMultiValue.getMultiValueIterable((Object)iThis)) {
                    if (!(o instanceof OIdentifiable)) continue;
                    result.add(this.copy((ODocument)((OIdentifiable)o).getRecord(), iParams));
                }
                return result;
            }
        }
        return null;
    }

    private Object copy(ODocument document, Object[] iFieldNames) {
        ODocument doc = document.copy();
        for (Object iFieldName : iFieldNames) {
            if (iFieldName == null) continue;
            String fieldName = iFieldName.toString();
            doc.removeField(fieldName);
        }
        return doc;
    }

    private Object copy(Map map, Object[] iFieldNames) {
        ODocument doc = new ODocument().fields(map);
        for (Object iFieldName : iFieldNames) {
            if (iFieldName == null) continue;
            String fieldName = iFieldName.toString();
            doc.removeField(fieldName);
        }
        return doc;
    }
}

