/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.traverse.OTraverseRecordProcess;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionConfigurableAbstract;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;

public class OSQLFunctionTraversedElement
extends OSQLFunctionConfigurableAbstract {
    public static final String NAME = "traversedElement";

    public OSQLFunctionTraversedElement(String name) {
        super(name, 1, 2);
    }

    @Override
    public boolean aggregateResults() {
        return false;
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public boolean filterResult() {
        return true;
    }

    @Override
    public String getSyntax() {
        return this.getName() + "(<beginIndex> [,<items>])";
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        return this.evaluate(iParams, iContext, null);
    }

    protected Object evaluate(Object[] iParams, OCommandContext iContext, String iClassName) {
        ArrayList<ODocument> result;
        int beginIndex = (Integer)iParams[0];
        int items = iParams.length > 1 ? (Integer)iParams[1] : 1;
        ArrayDeque stack = (ArrayDeque)iContext.getVariable("stack");
        if (stack == null) {
            throw new OCommandExecutionException("Cannot invoke " + this.getName() + "() against non traverse command");
        }
        ArrayList<ODocument> arrayList = result = items > 1 ? new ArrayList<ODocument>(items) : null;
        if (beginIndex < 0) {
            int i = -1;
            for (Object o : stack) {
                if (!(o instanceof OTraverseRecordProcess)) continue;
                ODocument record = (ODocument)((OTraverseRecordProcess)o).getTarget();
                if (iClassName != null && !record.getSchemaClass().isSubClassOf(iClassName)) continue;
                if (i <= beginIndex) {
                    if (items == 1) {
                        return record;
                    }
                    result.add(record);
                    if (result.size() >= items) break;
                }
                --i;
            }
        } else {
            int i = 0;
            Iterator it = stack.descendingIterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof OTraverseRecordProcess)) continue;
                ODocument record = (ODocument)((OTraverseRecordProcess)o).getTarget();
                if (iClassName != null && !record.getSchemaClass().isSubClassOf(iClassName)) continue;
                if (i >= beginIndex) {
                    if (items == 1) {
                        return record;
                    }
                    result.add(record);
                    if (result.size() >= items) break;
                }
                ++i;
            }
        }
        if (items > 0 && result != null && !result.isEmpty()) {
            return result;
        }
        return null;
    }
}

