/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.method.OSQLMethod;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodFunctionDelegate;
import com.orientechnologies.orient.core.sql.methods.OSQLMethodRuntime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class OSQLFilterItemAbstract
implements OSQLFilterItem {
    protected List<OPair<OSQLMethodRuntime, Object[]>> operationsChain = null;

    protected OSQLFilterItemAbstract() {
    }

    public OSQLFilterItemAbstract(OBaseParser iQueryToParse, String iText) {
        List<String> parts = OStringSerializerHelper.smartSplit(iText, new char[]{'.', '[', ']'}, new boolean[]{false, false, true}, new boolean[]{false, true, false}, 0, -1, false, true, false, false, new char[0]);
        this.setRoot(iQueryToParse, parts.get(0));
        if (parts.size() > 1) {
            this.operationsChain = new ArrayList<OPair<OSQLMethodRuntime, Object[]>>();
            for (int i = 1; i < parts.size(); ++i) {
                String part = parts.get(i);
                int pindex = part.indexOf(40);
                if (part.charAt(0) == '[') {
                    this.operationsChain.add((OPair<OSQLMethodRuntime, Object[]>)new OPair((Comparable)new OSQLMethodRuntime(OSQLEngine.getMethod("multivalue")), (Object)new Object[]{part}));
                    continue;
                }
                if (pindex > -1) {
                    Object[] arguments;
                    String methodName = part.substring(0, pindex).trim().toLowerCase(Locale.ENGLISH);
                    OSQLMethod method = OSQLEngine.getMethod(methodName);
                    if (method != null) {
                        if (method.getMaxParams() == -1 || method.getMaxParams() > 0) {
                            arguments = OStringSerializerHelper.getParameters(part).toArray();
                            if (arguments.length < method.getMinParams() || method.getMaxParams() > -1 && arguments.length > method.getMaxParams()) {
                                throw new OQueryParsingException(iQueryToParse.parserText, "Syntax error: field operator '" + method.getName() + "' needs " + (method.getMinParams() == method.getMaxParams() ? Integer.valueOf(method.getMinParams()) : method.getMinParams() + "-" + method.getMaxParams()) + " argument(s) while has been received " + arguments.length, 0);
                            }
                        } else {
                            arguments = null;
                        }
                    } else {
                        OSQLFunction f = OSQLEngine.getInstance().getFunction(methodName);
                        if (f == null) {
                            throw new OQueryParsingException(iQueryToParse.parserText, "Syntax error: function or field operator not recognized between the supported ones: " + OSQLEngine.getMethodNames(), 0);
                        }
                        if (f.getMaxParams() == -1 || f.getMaxParams() > 0) {
                            arguments = OStringSerializerHelper.getParameters(part).toArray();
                            if (arguments.length + 1 < f.getMinParams() || f.getMaxParams() > -1 && arguments.length + 1 > f.getMaxParams()) {
                                throw new OQueryParsingException(iQueryToParse.parserText, "Syntax error: function '" + f.getName() + "' needs " + (f.getMinParams() == f.getMaxParams() ? Integer.valueOf(f.getMinParams()) : f.getMinParams() + "-" + f.getMaxParams()) + " argument(s) while has been received " + arguments.length, 0);
                            }
                        } else {
                            arguments = null;
                        }
                        method = new OSQLMethodFunctionDelegate(f);
                    }
                    OSQLMethodRuntime runtimeMethod = new OSQLMethodRuntime(method);
                    this.operationsChain.add((OPair<OSQLMethodRuntime, Object[]>)new OPair((Comparable)runtimeMethod, (Object)arguments));
                    continue;
                }
                this.operationsChain.add((OPair<OSQLMethodRuntime, Object[]>)new OPair((Comparable)new OSQLMethodRuntime(OSQLEngine.getMethod("field")), (Object)new Object[]{part}));
            }
        }
    }

    public abstract String getRoot();

    protected abstract void setRoot(OBaseParser var1, String var2);

    public Object transformValue(OIdentifiable iRecord, OCommandContext iContext, Object ioResult) {
        if (ioResult != null && this.operationsChain != null) {
            OSQLMethodRuntime method = null;
            for (OPair<OSQLMethodRuntime, Object[]> op : this.operationsChain) {
                method = (OSQLMethodRuntime)op.getKey();
                method.setParameters((Object[])op.getValue(), true);
                ioResult = method.execute(ioResult, iRecord, ioResult, iContext);
            }
        }
        return ioResult;
    }

    public boolean hasChainOperators() {
        return this.operationsChain != null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        String root = this.getRoot();
        if (root != null) {
            buffer.append(root);
        }
        if (this.operationsChain != null) {
            for (OPair<OSQLMethodRuntime, Object[]> op : this.operationsChain) {
                buffer.append('.');
                buffer.append(op.getKey());
                if (op.getValue() == null) continue;
                Object[] values = (Object[])op.getValue();
                buffer.append('(');
                int i = 0;
                for (Object v : values) {
                    if (i++ > 0) {
                        buffer.append(',');
                    }
                    buffer.append(v);
                }
                buffer.append(')');
            }
        }
        return buffer.toString();
    }

    protected OCollate getCollateForField(ODocument doc, String iFieldName) {
        OProperty p;
        if (doc.getSchemaClass() != null && (p = doc.getSchemaClass().getProperty(iFieldName)) != null) {
            return p.getCollate();
        }
        return null;
    }
}

