/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.orient.core.sql.OIndexSearchResult;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import java.util.Map;

public class OFilterOptimizer {
    public void optimize(OSQLFilter filter, OIndexSearchResult indexMatch) {
        filter.setRootCondition(this.optimize(filter.getRootCondition(), indexMatch));
    }

    private OSQLFilterCondition optimize(OSQLFilterCondition condition, OIndexSearchResult indexMatch) {
        OQueryOperator operator = condition.getOperator();
        while (operator == null) {
            if (condition.getRight() == null && condition.getLeft() instanceof OSQLFilterCondition) {
                condition = (OSQLFilterCondition)condition.getLeft();
                operator = condition.getOperator();
                continue;
            }
            return condition;
        }
        OIndexReuseType reuseType = operator.getIndexReuseType(condition.getLeft(), condition.getRight());
        switch (reuseType) {
            case INDEX_METHOD: {
                if (this.isCovered(indexMatch, operator, condition.getLeft(), condition.getRight()) || this.isCovered(indexMatch, operator, condition.getRight(), condition.getLeft())) {
                    return null;
                }
                return condition;
            }
            case INDEX_INTERSECTION: {
                if (condition.getLeft() instanceof OSQLFilterCondition) {
                    condition.setLeft(this.optimize((OSQLFilterCondition)condition.getLeft(), indexMatch));
                }
                if (condition.getRight() instanceof OSQLFilterCondition) {
                    condition.setRight(this.optimize((OSQLFilterCondition)condition.getRight(), indexMatch));
                }
                if (condition.getLeft() == null) {
                    return (OSQLFilterCondition)condition.getRight();
                }
                if (condition.getRight() == null) {
                    return (OSQLFilterCondition)condition.getLeft();
                }
                return condition;
            }
        }
        return condition;
    }

    private boolean isCovered(OIndexSearchResult indexMatch, OQueryOperator operator, Object fieldCandidate, Object valueCandidate) {
        if (fieldCandidate instanceof OSQLFilterItemField) {
            OSQLFilterItemField field = (OSQLFilterItemField)fieldCandidate;
            if (operator instanceof OQueryOperatorEquals) {
                for (Map.Entry<String, Object> e : indexMatch.fieldValuePairs.entrySet()) {
                    if (!this.isSameField(field, e.getKey()) || !this.isSameValue(valueCandidate, e.getValue())) continue;
                    return true;
                }
            }
            return operator.equals(indexMatch.lastOperator) && this.isSameField(field, indexMatch.lastField) && this.isSameValue(valueCandidate, indexMatch.lastValue);
        }
        return false;
    }

    private boolean isSameValue(Object valueCandidate, Object lastValue) {
        if (lastValue == null || valueCandidate == null) {
            return lastValue == null && valueCandidate == null;
        }
        return lastValue.equals(valueCandidate) || lastValue.equals(OSQLHelper.getValue(valueCandidate));
    }

    private boolean isSameField(OSQLFilterItemField field, OSQLFilterItemField.FieldChain fieldChain) {
        return fieldChain.belongsTo(field);
    }

    private boolean isSameField(OSQLFilterItemField field, String fieldName) {
        return !field.hasChainOperators() && fieldName.equals(field.name);
    }
}

