/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import java.util.List;

public class OOrderByOptimizer {
    boolean canBeUsedByOrderBy(OIndex<?> index, List<OPair<String, String>> orderedFields) {
        if (orderedFields.isEmpty()) {
            return false;
        }
        if (!index.supportsOrderedIterations()) {
            return false;
        }
        OIndexDefinition definition = index.getDefinition();
        List<String> fields = definition.getFields();
        int endIndex = Math.min(fields.size(), orderedFields.size());
        String firstOrder = (String)orderedFields.get(0).getValue();
        for (int i = 0; i < endIndex; ++i) {
            String indexFieldName;
            OPair<String, String> pair = orderedFields.get(i);
            if (!firstOrder.equals(pair.getValue())) {
                return false;
            }
            String orderFieldName = ((String)((Object)orderedFields.get(i).getKey())).toLowerCase();
            if (orderFieldName.equals(indexFieldName = fields.get(i).toLowerCase())) continue;
            return false;
        }
        return true;
    }
}

