/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.io.IOException;
import java.util.Map;

public class OCommandExecutorSQLTruncateClass
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_TRUNCATE = "TRUNCATE";
    public static final String KEYWORD_CLASS = "CLASS";
    private OClass schemaClass;

    public OCommandExecutorSQLTruncateClass parse(OCommandRequest iRequest) {
        ODatabaseRecord database = OCommandExecutorSQLTruncateClass.getDatabase();
        this.init((OCommandRequestText)iRequest);
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLTruncateClass.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true);
        if (pos == -1 || !word.toString().equals(KEYWORD_TRUNCATE)) {
            throw new OCommandSQLParsingException("Keyword TRUNCATE not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLTruncateClass.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
            throw new OCommandSQLParsingException("Keyword CLASS not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLTruncateClass.nextWord((String)this.parserText, (String)this.parserText, (int)oldPos, (StringBuilder)word, (boolean)true)) == -1) {
            throw new OCommandSQLParsingException("Expected class name. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        String className = word.toString();
        this.schemaClass = database.getMetadata().getSchema().getClass(className);
        if (this.schemaClass == null) {
            throw new OCommandSQLParsingException("Class '" + className + "' not found", this.parserText, oldPos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.schemaClass == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        long recs = this.schemaClass.count();
        try {
            this.schemaClass.truncate();
        }
        catch (IOException e) {
            throw new OCommandExecutionException("Error on executing command", e);
        }
        return recs;
    }

    public String getSyntax() {
        return "TRUNCATE CLASS <class-name>";
    }
}

