/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OCommandExecutorSQLCreateLink
extends OCommandExecutorSQLAbstract {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_LINK = "LINK";
    private static final String KEYWORD_FROM = "FROM";
    private static final String KEYWORD_TO = "TO";
    private static final String KEYWORD_TYPE = "TYPE";
    private String destClassName;
    private String destField;
    private String sourceClassName;
    private String sourceField;
    private String linkName;
    private OType linkType;
    private boolean inverse = false;

    public OCommandExecutorSQLCreateLink parse(OCommandRequest iRequest) {
        this.init((OCommandRequestText)iRequest);
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLCreateLink.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true);
        if (pos == -1 || !word.toString().equals(KEYWORD_CREATE)) {
            throw new OCommandSQLParsingException("Keyword CREATE not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateLink.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true)) == -1 || !word.toString().equals(KEYWORD_LINK)) {
            throw new OCommandSQLParsingException("Keyword LINK not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateLink.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)false)) == -1) {
            throw new OCommandSQLParsingException("Keyword FROM not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if (!word.toString().equalsIgnoreCase(KEYWORD_FROM)) {
            this.linkName = word.toString();
            if (OStringSerializerHelper.contains(this.linkName, ' ')) {
                throw new OCommandSQLParsingException("Link name '" + this.linkName + "' contains not valid characters", this.parserText, oldPos);
            }
            oldPos = pos;
            pos = OCommandExecutorSQLCreateLink.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true);
        }
        if (word.toString().equalsIgnoreCase(KEYWORD_TYPE)) {
            oldPos = pos;
            if ((pos = OCommandExecutorSQLCreateLink.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)true)) == -1) {
                throw new OCommandSQLParsingException("Link type missed. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            this.linkType = OType.valueOf(word.toString().toUpperCase(Locale.ENGLISH));
            oldPos = pos;
            pos = OCommandExecutorSQLCreateLink.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)true);
        }
        if (pos == -1 || !word.toString().equals(KEYWORD_FROM)) {
            throw new OCommandSQLParsingException("Keyword FROM not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if ((pos = OCommandExecutorSQLCreateLink.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.parserText, pos);
        }
        String[] parts = word.toString().split("\\.");
        if (parts.length != 2) {
            throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.parserText, pos);
        }
        this.sourceClassName = parts[0];
        if (this.sourceClassName == null) {
            throw new OCommandSQLParsingException("Class not found", this.parserText, pos);
        }
        this.sourceField = parts[1];
        if ((pos = OCommandExecutorSQLCreateLink.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)true)) == -1 || !word.toString().equals(KEYWORD_TO)) {
            throw new OCommandSQLParsingException("Keyword TO not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if ((pos = OCommandExecutorSQLCreateLink.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.parserText, pos);
        }
        parts = word.toString().split("\\.");
        if (parts.length != 2) {
            throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.parserText, pos);
        }
        this.destClassName = parts[0];
        if (this.destClassName == null) {
            throw new OCommandSQLParsingException("Class not found", this.parserText, pos);
        }
        this.destField = parts[1];
        if ((pos = OCommandExecutorSQLCreateLink.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)true)) == -1) {
            return this;
        }
        if (!word.toString().equalsIgnoreCase("INVERSE")) {
            throw new OCommandSQLParsingException("Missed 'INVERSE'. Use " + this.getSyntax(), this.parserText, pos);
        }
        this.inverse = true;
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.destField == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = OCommandExecutorSQLCreateLink.getDatabase();
        if (!(database.getDatabaseOwner() instanceof ODatabaseDocumentTx)) {
            throw new OCommandSQLParsingException("This command supports only the database type ODatabaseDocumentTx and type '" + database.getClass() + "' was found");
        }
        ODatabaseDocumentTx db = (ODatabaseDocumentTx)database.getDatabaseOwner();
        OClass sourceClass = database.getMetadata().getSchema().getClass(this.sourceClassName);
        if (sourceClass == null) {
            throw new OCommandExecutionException("Source class '" + this.sourceClassName + "' not found");
        }
        OClass destClass = database.getMetadata().getSchema().getClass(this.destClassName);
        if (destClass == null) {
            throw new OCommandExecutionException("Destination class '" + this.destClassName + "' not found");
        }
        String cmd = "select from ";
        if (!"@rid".equals(this.destField)) {
            cmd = "select from " + this.destClassName + " where " + this.destField + " = ";
        }
        long total = 0L;
        if (this.linkName == null) {
            this.linkName = this.sourceField;
        }
        boolean multipleRelationship = this.linkType != null ? this.linkType == OType.LINKSET || this.linkType == OType.LINKLIST : false;
        long totRecords = db.countClass(sourceClass.getName());
        long currRecord = 0L;
        if (this.progressListener != null) {
            this.progressListener.onBegin((Object)this, totRecords, (Object)false);
        }
        database.declareIntent(new OIntentMassiveInsert());
        try {
            for (ODocument doc : db.browseClass(sourceClass.getName())) {
                doc.unpin();
                Object value = doc.field(this.sourceField);
                if (!(value == null || value instanceof ODocument || value instanceof ORID || value instanceof Collection)) {
                    List result;
                    ODocument target = null;
                    if (!"@rid".equals(this.destField) && value instanceof String) {
                        value = ((String)value).length() == 0 ? null : "'" + value + "'";
                    }
                    if ((result = (List)database.command(new OSQLSynchQuery(cmd + value)).execute(new Object[0])) == null || result.size() == 0) {
                        value = null;
                    } else {
                        if (result.size() > 1) {
                            throw new OCommandExecutionException("Cannot create link because multiple records was found in class '" + destClass.getName() + "' with value " + value + " in field '" + this.destField + "'");
                        }
                        target = (ODocument)result.get(0);
                        value = target;
                    }
                    if (target != null && this.inverse) {
                        Object oldValue = target.field(this.linkName);
                        if (oldValue != null) {
                            ArrayList<ODocument> coll;
                            if (!multipleRelationship) {
                                multipleRelationship = true;
                            }
                            if (oldValue instanceof Collection) {
                                coll = (ArrayList<ODocument>)oldValue;
                                target.setDirty();
                            } else {
                                coll = new ArrayList<ODocument>(2);
                                target.field(this.linkName, coll);
                                coll.add((ODocument)oldValue);
                            }
                            coll.add(doc);
                        } else {
                            if (this.linkType != null) {
                                if (this.linkType == OType.LINKSET) {
                                    value = new OMVRBTreeRIDSet(target);
                                    ((OMVRBTreeRIDSet)value).add(doc);
                                } else if (this.linkType == OType.LINKLIST) {
                                    value = new ORecordLazyList(target);
                                    ((ORecordLazyList)value).add(doc);
                                } else {
                                    value = doc;
                                }
                            } else {
                                value = doc;
                            }
                            target.field(this.linkName, value);
                        }
                        target.save();
                    } else {
                        doc.field(this.linkName, value);
                        doc.save();
                    }
                    ++total;
                }
                if (this.progressListener == null) continue;
                this.progressListener.onProgress((Object)this, currRecord, (float)currRecord * 100.0f / (float)totRecords);
            }
            if (total > 0L) {
                OProperty prop;
                if (this.inverse) {
                    prop = destClass.getProperty(this.linkName);
                    if (prop != null) {
                        destClass.dropProperty(this.linkName);
                    }
                    if (this.linkType == null) {
                        this.linkType = multipleRelationship ? OType.LINKSET : OType.LINK;
                    }
                    destClass.createProperty(this.linkName, this.linkType, sourceClass);
                } else {
                    prop = sourceClass.getProperty(this.linkName);
                    if (prop != null) {
                        sourceClass.dropProperty(this.linkName);
                    }
                    sourceClass.createProperty(this.linkName, OType.LINK, destClass);
                }
            }
            if (this.progressListener != null) {
                this.progressListener.onCompletition((Object)this, true);
            }
        }
        catch (Exception e) {
            if (this.progressListener != null) {
                this.progressListener.onCompletition((Object)this, false);
            }
            throw new OCommandExecutionException("Error on creation of links", e);
        }
        finally {
            database.declareIntent(null);
        }
        return total;
    }

    public String getSyntax() {
        return "CREATE LINK <link-name> [TYPE <link-type>] FROM <source-class>.<source-property> TO <destination-class>.<destination-property> [INVERSE]";
    }
}

