/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.processor.block;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.processor.OComposableProcessor;
import com.orientechnologies.orient.core.processor.block.OAbstractBlock;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Map;

public class OLetBlock
extends OAbstractBlock {
    public static final String NAME = "let";

    @Override
    public Object processBlock(OComposableProcessor iManager, OCommandContext iContext, ODocument iConfig, ODocument iOutput, boolean iReadOnly) {
        Object value;
        Boolean copy = this.getFieldOfClass(iContext, iConfig, "copy", Boolean.class);
        Boolean flatMultivalues = this.getFieldOfClass(iContext, iConfig, "flatMultivalues", Boolean.class);
        Object target = this.getField(iContext, iConfig, "target");
        if (target != null && target.equals("null")) {
            target = new ODocument();
        }
        if ((value = this.getRawField(iConfig, "value")) != null) {
            if (value instanceof ODocument) {
                ODocument doc = (ODocument)value;
                for (String fieldName : doc.fieldNames()) {
                    Object v = this.resolveValue(iContext, doc.field(fieldName), true);
                    if (target != null) {
                        this.debug(iContext, "Set value %s in document field '%s'", v, fieldName);
                        ((ODocument)target).field(fieldName, v);
                        continue;
                    }
                    this.assignVariable(iContext, fieldName, v);
                }
            } else if (value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    Object v = this.resolveValue(iContext, this.getValue(entry.getValue(), copy), true);
                    if (target != null) {
                        this.debug(iContext, "Set value %s in document field '%s'", v, entry.getKey());
                        ((ODocument)target).field(entry.getKey().toString(), v);
                        continue;
                    }
                    this.assignVariable(iContext, entry.getKey().toString(), v);
                }
            } else {
                String name = this.getRequiredFieldOfClass(iContext, iConfig, "name", String.class);
                Object v = this.getValue(this.getRequiredField(iContext, iConfig, "value"), copy);
                v = this.flatMultivalues(iContext, copy, flatMultivalues, v);
                if (target != null) {
                    if (OMultiValue.isMultiValue((Object)v)) {
                        for (int i = 0; i < OMultiValue.getSize((Object)v); ++i) {
                            Object fieldName = OMultiValue.getValue((Object)v, (int)i);
                            if (fieldName == null || ((ODocument)target).containsField(fieldName.toString())) continue;
                            this.debug(iContext, "Set value %s in document field '%s'", null, fieldName);
                            ((ODocument)target).field(fieldName.toString(), (Object)null);
                        }
                    }
                    if (name != null) {
                        this.assignVariable(iContext, name, target);
                    }
                } else {
                    this.assignVariable(iContext, name, v);
                }
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

