/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.processor.block;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OVariableParser;
import com.orientechnologies.common.parser.OVariableParserListener;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.processor.OComposableProcessor;
import com.orientechnologies.orient.core.processor.OProcessException;
import com.orientechnologies.orient.core.processor.block.OProcessorBlock;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class OAbstractBlock
implements OProcessorBlock {
    protected OProcessorBlock parentBlock;

    protected abstract Object processBlock(OComposableProcessor var1, OCommandContext var2, ODocument var3, ODocument var4, boolean var5);

    @Override
    public Object process(OComposableProcessor iManager, OCommandContext iContext, ODocument iConfig, ODocument iOutput, boolean iReadOnly) {
        if (!this.checkForCondition(iContext, iConfig)) {
            return null;
        }
        Boolean enabled = this.getFieldOfClass(iContext, iConfig, "enabled", Boolean.class);
        if (enabled != null && !enabled.booleanValue()) {
            return null;
        }
        String returnVariable = this.getFieldOfClass(iContext, iConfig, "return", String.class);
        this.debug(iContext, "Executing {%s} block...", iConfig.field("type"));
        Object result = this.processBlock(iManager, iContext, iConfig, iOutput, iReadOnly);
        this.printReturn(iContext, result);
        if (returnVariable != null) {
            this.assignVariable(iContext, returnVariable, result);
        }
        return result;
    }

    protected void printReturn(OCommandContext iContext, Object result) {
        if (result != null && !(result instanceof OCommandRequest) && result instanceof Iterable) {
            this.debug(iContext, "Returned %s", OCollections.toString((Iterable)((Iterable)result)));
        } else {
            this.debug(iContext, "Returned %s", result);
        }
    }

    protected Object delegate(String iElementName, OComposableProcessor iManager, Object iContent, OCommandContext iContext, ODocument iOutput, boolean iReadOnly) {
        try {
            return iManager.process(this, iContent, iContext, iOutput, iReadOnly);
        }
        catch (Exception e) {
            throw new OProcessException("Error on processing '" + iElementName + "' field of '" + this.getName() + "' block", e);
        }
    }

    protected Object delegate(String iElementName, OComposableProcessor iManager, String iType, ODocument iContent, OCommandContext iContext, ODocument iOutput, boolean iReadOnly) {
        try {
            return iManager.process(this, iType, iContent, iContext, iOutput, iReadOnly);
        }
        catch (Exception e) {
            throw new OProcessException("Error on processing '" + iElementName + "' field of '" + this.getName() + "' block", e);
        }
    }

    public boolean checkForCondition(OCommandContext iContext, ODocument iConfig) {
        Object condition = this.getField(iContext, iConfig, "if");
        if (condition instanceof Boolean) {
            return (Boolean)condition;
        }
        if (condition != null) {
            Object result = this.evaluate(iContext, (String)condition);
            return result != null && (Boolean)result != false;
        }
        return true;
    }

    public Object evaluate(OCommandContext iContext, String iExpression) {
        if (iExpression == null) {
            throw new OProcessException("Null expression");
        }
        OSQLPredicate predicate = new OSQLPredicate((String)this.resolveValue(iContext, iExpression, true));
        Object result = predicate.evaluate(iContext);
        this.debug(iContext, "Evaluated expression '" + iExpression + "' = " + result, new Object[0]);
        return result;
    }

    public void assignVariable(OCommandContext iContext, String iName, Object iValue) {
        if (iName != null) {
            iContext.setVariable(iName, iValue);
            this.debug(iContext, "Assigned context variable %s=%s", iName, iValue);
        }
    }

    protected void debug(OCommandContext iContext, String iText, Object ... iArgs) {
        if (this.isDebug(iContext)) {
            Integer depthLevel = (Integer)iContext.getVariable("depthLevel");
            StringBuilder text = new StringBuilder();
            for (int i = 0; i < depthLevel; ++i) {
                text.append('-');
            }
            text.append('>');
            text.append('{');
            text.append(this.getName());
            text.append("} ");
            text.append(iText);
            OLogManager.instance().info((Object)this, text.toString(), iArgs);
        }
    }

    protected <T> T getRawField(ODocument iConfig, String iFieldName) {
        return (T)iConfig.field(iFieldName);
    }

    protected <T> T getField(OCommandContext iContext, ODocument iConfig, String iFieldName) {
        return (T)this.resolveValue(iContext, iConfig.field(iFieldName), true);
    }

    protected <T> T getField(OCommandContext iContext, ODocument iConfig, String iFieldName, boolean iCopy) {
        return (T)this.resolveValue(iContext, iConfig.field(iFieldName), iCopy);
    }

    protected <T> T getFieldOrDefault(OCommandContext iContext, ODocument iConfig, String iFieldName, T iDefaultValue) {
        Object f = iConfig.field(iFieldName);
        if (f == null) {
            return iDefaultValue;
        }
        return (T)this.resolveValue(iContext, f, true);
    }

    protected <T> T getFieldOfClass(OCommandContext iContext, ODocument iConfig, String iFieldName, Class<? extends T> iExpectedClass) {
        return this.getFieldOfClass(iContext, iConfig, iFieldName, iExpectedClass, true);
    }

    protected <T> T getFieldOfClass(OCommandContext iContext, ODocument iConfig, String iFieldName, Class<? extends T> iExpectedClass, boolean iCopy) {
        Object f = this.resolveValue(iContext, iConfig.field(iFieldName), iCopy);
        if (f != null && !iExpectedClass.isAssignableFrom(f.getClass())) {
            throw new OProcessException("Block '" + this.getName() + "' defines the field '" + iFieldName + "' of type '" + f.getClass() + "' that is not compatible with the expected type '" + iExpectedClass + "'");
        }
        return (T)f;
    }

    protected <T> T getRequiredField(OCommandContext iContext, ODocument iConfig, String iFieldName) {
        Object f = iConfig.field(iFieldName);
        if (f == null) {
            throw new OProcessException("Block '" + this.getName() + "' must define the field '" + iFieldName + "'");
        }
        return (T)this.resolveValue(iContext, f, true);
    }

    protected <T> T getRequiredFieldOfClass(OCommandContext iContext, ODocument iConfig, String iFieldName, Class<? extends T> iExpectedClass) {
        T f = this.getFieldOfClass(iContext, iConfig, iFieldName, iExpectedClass);
        if (f == null) {
            throw new OProcessException("Block '" + this.getName() + "' must define the field '" + iFieldName + "'");
        }
        return (T)this.resolveValue(iContext, f, true);
    }

    public void checkForBlock(Object iValue) {
        if (!OAbstractBlock.isBlock(iValue)) {
            throw new OProcessException("Block '" + this.getName() + "' was expecting a block but found object of type " + iValue.getClass());
        }
    }

    public boolean isDebug(OCommandContext iContext) {
        Object debug = iContext.getVariable("debugMode");
        if (debug != null) {
            if (debug instanceof Boolean) {
                return (Boolean)debug;
            }
            return Boolean.parseBoolean((String)debug);
        }
        return false;
    }

    public static boolean isBlock(Object iValue) {
        return iValue instanceof ODocument && ((ODocument)iValue).containsField("type");
    }

    public static Object resolve(final OCommandContext iContext, Object iContent) {
        Object value = null;
        value = iContent instanceof String ? OVariableParser.resolveVariables((String)((String)iContent), (String)"${", (String)"}", (OVariableParserListener)new OVariableParserListener(){

            public Object resolve(String iVariable) {
                return iContext.getVariable(iVariable);
            }
        }) : iContent;
        if (value instanceof String) {
            value = OVariableParser.resolveVariables((String)((String)value), (String)"={", (String)"}", (OVariableParserListener)new OVariableParserListener(){

                public Object resolve(String iVariable) {
                    return new OSQLPredicate(iVariable).evaluate(iContext);
                }
            });
        }
        return value;
    }

    protected Object resolveValue(OCommandContext iContext, Object iValue, boolean iClone) {
        if (iValue == null) {
            return null;
        }
        if (iValue instanceof String) {
            return OAbstractBlock.resolve(iContext, iValue);
        }
        if (iValue instanceof ODocument) {
            ODocument sourceDoc = (ODocument)iValue;
            ODocument destDoc = iClone ? new ODocument().setOrdered(true) : sourceDoc;
            for (String fieldName : sourceDoc.fieldNames()) {
                Object fieldValue = this.resolveValue(iContext, sourceDoc.field(fieldName), iClone);
                destDoc.field(fieldName, fieldValue);
            }
            return destDoc;
        }
        if (iValue instanceof Map) {
            Map sourceMap = (Map)iValue;
            Map destMap = iClone ? new HashMap() : sourceMap;
            for (Map.Entry entry : sourceMap.entrySet()) {
                destMap.put(entry.getKey(), this.resolveValue(iContext, entry.getValue(), iClone));
            }
            return destMap;
        }
        if (iValue instanceof List) {
            List sourceList = (List)iValue;
            List destList = iClone ? new ArrayList() : sourceList;
            for (int i = 0; i < sourceList.size(); ++i) {
                if (iClone) {
                    destList.add(i, OAbstractBlock.resolve(iContext, sourceList.get(i)));
                    continue;
                }
                destList.set(i, OAbstractBlock.resolve(iContext, sourceList.get(i)));
            }
            return destList;
        }
        return iValue;
    }

    protected Object getValue(Object iValue, Boolean iCopy) {
        if (iValue != null && iCopy != null && iCopy.booleanValue()) {
            if (iValue instanceof ODocument) {
                return ((ODocument)iValue).copy();
            }
            if (iValue instanceof List) {
                return new ArrayList((Collection)iValue);
            }
            if (iValue instanceof Set) {
                return new HashSet((Collection)iValue);
            }
            if (iValue instanceof Map) {
                return new LinkedHashMap((Map)iValue);
            }
            throw new OProcessException("Copy of value '" + iValue + "' of class '" + iValue.getClass() + "' is not supported");
        }
        return iValue;
    }

    protected Object flatMultivalues(OCommandContext iContext, Boolean copy, Boolean flatMultivalues, Object value) {
        if (OMultiValue.isMultiValue((Object)value) && flatMultivalues != null && flatMultivalues.booleanValue()) {
            AbstractCollection newColl = value instanceof Set ? new HashSet() : new ArrayList();
            for (Object entry : OMultiValue.getMultiValueIterable((Object)value)) {
                if (entry instanceof ODocument) {
                    for (String fieldName : ((ODocument)entry).fieldNames()) {
                        newColl.add(((ODocument)entry).field(fieldName));
                    }
                    continue;
                }
                OMultiValue.add(newColl, (Object)this.resolveValue(iContext, this.getValue(entry, copy), false));
            }
            return newColl;
        }
        return value;
    }

    @Override
    public OProcessorBlock getParentBlock() {
        return this.parentBlock;
    }

    @Override
    public void setParentBlock(OProcessorBlock parentBlock) {
        this.parentBlock = parentBlock;
    }
}

