/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.ONullOutputListener;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.List;
import java.util.Set;

public class OSecurityShared
implements OSecurity,
OCloseable {
    public static final String RESTRICTED_CLASSNAME = "ORestricted";
    public static final String IDENTITY_CLASSNAME = "OIdentity";
    public static final String ALLOW_ALL_FIELD = "_allow";
    public static final String ALLOW_READ_FIELD = "_allowRead";
    public static final String ALLOW_UPDATE_FIELD = "_allowUpdate";
    public static final String ALLOW_DELETE_FIELD = "_allowDelete";
    public static final String ONCREATE_IDENTITY_TYPE = "onCreate.identityType";
    public static final String ONCREATE_FIELD = "onCreate.fields";

    @Override
    public OIdentifiable allowUser(ODocument iDocument, String iAllowFieldName, String iUserName) {
        OUser user = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSecurity().getUser(iUserName);
        if (user == null) {
            throw new IllegalArgumentException("User '" + iUserName + "' not found");
        }
        return this.allowIdentity(iDocument, iAllowFieldName, user.getDocument().getIdentity());
    }

    @Override
    public OIdentifiable allowRole(ODocument iDocument, String iAllowFieldName, String iRoleName) {
        ORole role = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSecurity().getRole(iRoleName);
        if (role == null) {
            throw new IllegalArgumentException("Role '" + iRoleName + "' not found");
        }
        return this.allowIdentity(iDocument, iAllowFieldName, role.getDocument().getIdentity());
    }

    @Override
    public OIdentifiable allowIdentity(ODocument iDocument, String iAllowFieldName, OIdentifiable iId) {
        Set field = (Set)iDocument.field(iAllowFieldName);
        if (field == null) {
            field = new OMVRBTreeRIDSet(iDocument);
            iDocument.field(iAllowFieldName, field);
        }
        field.add(iId);
        return iId;
    }

    @Override
    public OIdentifiable disallowUser(ODocument iDocument, String iAllowFieldName, String iUserName) {
        OUser user = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSecurity().getUser(iUserName);
        if (user == null) {
            throw new IllegalArgumentException("User '" + iUserName + "' not found");
        }
        return this.disallowIdentity(iDocument, iAllowFieldName, user.getDocument().getIdentity());
    }

    @Override
    public OIdentifiable disallowRole(ODocument iDocument, String iAllowFieldName, String iRoleName) {
        ORole role = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSecurity().getRole(iRoleName);
        if (role == null) {
            throw new IllegalArgumentException("Role '" + iRoleName + "' not found");
        }
        return this.disallowIdentity(iDocument, iAllowFieldName, role.getDocument().getIdentity());
    }

    @Override
    public OIdentifiable disallowIdentity(ODocument iDocument, String iAllowFieldName, OIdentifiable iId) {
        Set field = (Set)iDocument.field(iAllowFieldName);
        if (field != null) {
            field.remove(iId);
        }
        return iId;
    }

    @Override
    public boolean isAllowed(Set<OIdentifiable> iAllowAll, Set<OIdentifiable> iAllowOperation) {
        if (iAllowAll == null || iAllowAll.isEmpty()) {
            return true;
        }
        OUser currentUser = ODatabaseRecordThreadLocal.INSTANCE.get().getUser();
        if (currentUser != null && !iAllowAll.contains(currentUser.getDocument().getIdentity())) {
            if (iAllowOperation != null && iAllowOperation.contains(currentUser.getDocument().getIdentity())) {
                return true;
            }
            for (ORole r : currentUser.getRoles()) {
                if (iAllowAll.contains(r.getDocument().getIdentity())) {
                    return true;
                }
                if (iAllowOperation != null && iAllowOperation.contains(r.getDocument().getIdentity())) {
                    return true;
                }
                for (ORole parentRole = r.getParentRole(); parentRole != null; parentRole = parentRole.getParentRole()) {
                    if (iAllowAll.contains(parentRole.getDocument().getIdentity())) {
                        return true;
                    }
                    if (iAllowOperation == null || !iAllowOperation.contains(parentRole.getDocument().getIdentity())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public OUser authenticate(String iUserName, String iUserPassword) {
        String dbName = this.getDatabase().getName();
        OUser user = this.getUser(iUserName);
        if (user == null) {
            throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
        }
        if (user.getAccountStatus() != OUser.STATUSES.ACTIVE) {
            throw new OSecurityAccessException(dbName, "User '" + iUserName + "' is not active");
        }
        if (!(this.getDatabase().getStorage() instanceof OStorageProxy) && !user.checkPassword(iUserPassword)) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
        }
        return user;
    }

    @Override
    public OUser getUser(String iUserName) {
        return this.getUser(iUserName, true);
    }

    @Override
    public OUser createUser(String iUserName, String iUserPassword, String ... iRoles) {
        OUser user = new OUser(iUserName, iUserPassword);
        if (iRoles != null) {
            for (String r : iRoles) {
                user.addRole(r);
            }
        }
        return user.save();
    }

    @Override
    public OUser createUser(String userName, String userPassword, ORole ... roles) {
        OUser user = new OUser(userName, userPassword);
        if (roles != null) {
            for (ORole r : roles) {
                user.addRole(r);
            }
        }
        return user.save();
    }

    @Override
    public boolean dropUser(String iUserName) {
        Number removed = (Number)this.getDatabase().command(new OCommandSQL("delete from OUser where name = '" + iUserName + "'")).execute(new Object[0]);
        return removed != null && removed.intValue() > 0;
    }

    @Override
    public ORole getRole(OIdentifiable iRole) {
        ODocument doc = (ODocument)iRole.getRecord();
        if ("ORole".equals(doc.getClassName())) {
            return new ORole(doc);
        }
        return null;
    }

    @Override
    public ORole getRole(String roleName) {
        return this.getRole(roleName, true);
    }

    public ORole getRole(String roleName, boolean allowRepair) {
        List result = (List)this.getDatabase().command(new OSQLSynchQuery("select from ORole where name = '" + roleName + "' limit 1")).execute(new Object[0]);
        if (result != null && !result.isEmpty()) {
            return new ORole((ODocument)result.get(0));
        }
        return null;
    }

    @Override
    public ORole createRole(String iRoleName, ORole.ALLOW_MODES iAllowMode) {
        return this.createRole(iRoleName, null, iAllowMode);
    }

    @Override
    public ORole createRole(String iRoleName, ORole iParent, ORole.ALLOW_MODES iAllowMode) {
        ORole role = new ORole(iRoleName, iParent, iAllowMode);
        return role.save();
    }

    @Override
    public boolean dropRole(String iRoleName) {
        Number removed = (Number)this.getDatabase().command(new OCommandSQL("delete from ORole where name = '" + iRoleName + "'")).execute(new Object[0]);
        return removed != null && removed.intValue() > 0;
    }

    @Override
    public List<ODocument> getAllUsers() {
        return (List)this.getDatabase().command(new OSQLSynchQuery("select from OUser")).execute(new Object[0]);
    }

    @Override
    public List<ODocument> getAllRoles() {
        return (List)this.getDatabase().command(new OSQLSynchQuery("select from ORole")).execute(new Object[0]);
    }

    @Override
    public OUser create() {
        if (!this.getDatabase().getMetadata().getSchema().getClasses().isEmpty()) {
            return null;
        }
        OUser adminUser = this.createMetadata();
        ORole readerRole = this.createRole("reader", ORole.ALLOW_MODES.DENY_ALL_BUT);
        readerRole.addRule("database", ORole.PERMISSION_READ);
        readerRole.addRule("database.schema", ORole.PERMISSION_READ);
        readerRole.addRule("database.cluster.internal", ORole.PERMISSION_READ);
        readerRole.addRule("database.cluster.orole", ORole.PERMISSION_READ);
        readerRole.addRule("database.cluster.ouser", ORole.PERMISSION_READ);
        readerRole.addRule("database.class.*", ORole.PERMISSION_READ);
        readerRole.addRule("database.cluster.*", ORole.PERMISSION_READ);
        readerRole.addRule("database.command", ORole.PERMISSION_READ);
        readerRole.addRule("database.hook.record", ORole.PERMISSION_READ);
        readerRole.addRule("database.function.*", ORole.PERMISSION_READ);
        readerRole.save();
        this.createUser("reader", "reader", readerRole.getName());
        ORole writerRole = this.createRole("writer", ORole.ALLOW_MODES.DENY_ALL_BUT);
        writerRole.addRule("database", ORole.PERMISSION_READ);
        writerRole.addRule("database.schema", ORole.PERMISSION_READ + ORole.PERMISSION_CREATE + ORole.PERMISSION_UPDATE);
        writerRole.addRule("database.cluster.internal", ORole.PERMISSION_READ);
        writerRole.addRule("database.cluster.orole", ORole.PERMISSION_READ);
        writerRole.addRule("database.cluster.ouser", ORole.PERMISSION_READ);
        writerRole.addRule("database.class.*", ORole.PERMISSION_ALL);
        writerRole.addRule("database.cluster.*", ORole.PERMISSION_ALL);
        writerRole.addRule("database.command", ORole.PERMISSION_ALL);
        writerRole.addRule("database.hook.record", ORole.PERMISSION_ALL);
        readerRole.addRule("database.function.*", ORole.PERMISSION_READ);
        writerRole.save();
        this.createUser("writer", "writer", writerRole.getName());
        return adminUser;
    }

    public OUser createMetadata() {
        OClass restrictedClass;
        OUser adminUser;
        ORole adminRole;
        OClass userClass;
        OClass roleClass;
        ODatabaseRecord database = this.getDatabase();
        OClass identityClass = database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME);
        if (identityClass == null) {
            identityClass = database.getMetadata().getSchema().createAbstractClass(IDENTITY_CLASSNAME);
        }
        if ((roleClass = database.getMetadata().getSchema().getClass("ORole")) == null) {
            roleClass = database.getMetadata().getSchema().createClass("ORole", identityClass);
        } else if (roleClass.getSuperClass() == null) {
            roleClass.setSuperClass(identityClass);
        }
        if (!roleClass.existsProperty("name")) {
            roleClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true).setCollate("ci");
            roleClass.createIndex("ORole.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
        } else {
            Set<OIndex<?>> indexes = roleClass.getInvolvedIndexes("name");
            if (indexes.isEmpty()) {
                roleClass.createIndex("ORole.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
            }
        }
        if (!roleClass.existsProperty("mode")) {
            roleClass.createProperty("mode", OType.BYTE);
        }
        if (!roleClass.existsProperty("rules")) {
            roleClass.createProperty("rules", OType.EMBEDDEDMAP, OType.BYTE);
        }
        if (!roleClass.existsProperty("inheritedRole")) {
            roleClass.createProperty("inheritedRole", OType.LINK, roleClass);
        }
        if ((userClass = database.getMetadata().getSchema().getClass("OUser")) == null) {
            userClass = database.getMetadata().getSchema().createClass("OUser", identityClass);
        } else if (userClass.getSuperClass() == null) {
            userClass.setSuperClass(identityClass);
        }
        if (!userClass.existsProperty("name")) {
            userClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true).setCollate("ci");
            userClass.createIndex("OUser.name", OClass.INDEX_TYPE.UNIQUE, (OProgressListener)ONullOutputListener.INSTANCE, "name");
        }
        if (!userClass.existsProperty("password")) {
            userClass.createProperty("password", OType.STRING).setMandatory(true).setNotNull(true);
        }
        if (!userClass.existsProperty("roles")) {
            userClass.createProperty("roles", OType.LINKSET, roleClass);
        }
        if (!userClass.existsProperty("status")) {
            userClass.createProperty("status", OType.STRING).setMandatory(true).setNotNull(true);
        }
        if ((adminRole = this.getRole("admin", false)) == null) {
            adminRole = this.createRole("admin", ORole.ALLOW_MODES.ALLOW_ALL_BUT);
            adminRole.addRule("database.bypassRestricted", ORole.PERMISSION_ALL).save();
        }
        if ((adminUser = this.getUser("admin", false)) == null) {
            adminUser = this.createUser("admin", "admin", adminRole);
        }
        if ((restrictedClass = database.getMetadata().getSchema().getClass(RESTRICTED_CLASSNAME)) == null) {
            restrictedClass = database.getMetadata().getSchema().createAbstractClass(RESTRICTED_CLASSNAME);
        }
        if (!restrictedClass.existsProperty(ALLOW_ALL_FIELD)) {
            restrictedClass.createProperty(ALLOW_ALL_FIELD, OType.LINKSET, database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME));
        }
        if (!restrictedClass.existsProperty(ALLOW_READ_FIELD)) {
            restrictedClass.createProperty(ALLOW_READ_FIELD, OType.LINKSET, database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME));
        }
        if (!restrictedClass.existsProperty(ALLOW_UPDATE_FIELD)) {
            restrictedClass.createProperty(ALLOW_UPDATE_FIELD, OType.LINKSET, database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME));
        }
        if (!restrictedClass.existsProperty(ALLOW_DELETE_FIELD)) {
            restrictedClass.createProperty(ALLOW_DELETE_FIELD, OType.LINKSET, database.getMetadata().getSchema().getClass(IDENTITY_CLASSNAME));
        }
        OLevel2RecordCache cache = this.getDatabase().getLevel2Cache();
        for (int clusterId : userClass.getPolymorphicClusterIds()) {
            cache.addPinnedCluster(clusterId);
        }
        for (int clusterId : roleClass.getPolymorphicClusterIds()) {
            cache.addPinnedCluster(clusterId);
        }
        return adminUser;
    }

    @Override
    public void close(boolean onDelete) {
    }

    @Override
    public void load() {
        OLevel2RecordCache cache = this.getDatabase().getLevel2Cache();
        OClass userClass = this.getDatabase().getMetadata().getSchema().getClass("OUser");
        if (userClass != null) {
            OProperty p;
            for (int clusterId : userClass.getPolymorphicClusterIds()) {
                cache.addPinnedCluster(clusterId);
            }
            if (!userClass.existsProperty("status")) {
                userClass.createProperty("status", OType.STRING).setMandatory(true).setNotNull(true);
            }
            if ((p = userClass.getProperty("name")) == null) {
                p = userClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true);
            }
            if (userClass.getInvolvedIndexes("name") == null) {
                p.createIndex(OClass.INDEX_TYPE.UNIQUE);
            }
            OClass roleClass = this.getDatabase().getMetadata().getSchema().getClass("ORole");
            for (int clusterId : roleClass.getPolymorphicClusterIds()) {
                cache.addPinnedCluster(clusterId);
            }
            if (!roleClass.existsProperty("inheritedRole")) {
                roleClass.createProperty("inheritedRole", OType.LINK, roleClass);
            }
            if ((p = roleClass.getProperty("name")) == null) {
                p = roleClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true);
            }
            if (roleClass.getInvolvedIndexes("name") == null) {
                p.createIndex(OClass.INDEX_TYPE.UNIQUE);
            }
        }
    }

    @Override
    public void createClassTrigger() {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.get();
        OClass classTrigger = db.getMetadata().getSchema().getClass("OTriggered");
        if (classTrigger == null) {
            classTrigger = db.getMetadata().getSchema().createAbstractClass("OTriggered");
        }
    }

    @Override
    public OSecurity getUnderlying() {
        return this;
    }

    protected OUser getUser(String iUserName, boolean iAllowRepair) {
        if (iUserName == null) {
            return null;
        }
        List result = (List)this.getDatabase().command(new OSQLSynchQuery("select from OUser where name = '" + iUserName + "' limit 1").setFetchPlan("roles:1")).execute(new Object[0]);
        if (result != null && !result.isEmpty()) {
            return new OUser((ODocument)result.get(0));
        }
        return null;
    }

    private ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }
}

